/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.wrap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.henshin.wrap.WLink;
import org.eclipse.emf.henshin.wrap.WMember;
import org.eclipse.emf.henshin.wrap.WObject;
import org.eclipse.emf.henshin.wrap.WValue;
import org.eclipse.emf.henshin.wrap.WrapFactory;
import org.eclipse.emf.henshin.wrap.WrapPackage;
import org.eclipse.emf.henshin.wrap.impl.WLinkImpl;
import org.eclipse.emf.henshin.wrap.impl.WObjectImpl;
import org.eclipse.emf.henshin.wrap.impl.WValueImpl;

public class WrapFactoryImpl
extends EFactoryImpl
implements WrapFactory {
    public static WrapFactory init() {
        try {
            WrapFactory theWrapFactory = (WrapFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/2013/Henshin/Wrap");
            if (theWrapFactory != null) {
                return theWrapFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new WrapFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createWObject();
            }
            case 3: {
                return this.createWLink();
            }
            case 4: {
                return this.createWValue();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public WObject createWObject() {
        WObjectImpl wObject = new WObjectImpl();
        return wObject;
    }

    @Override
    public WLink createWLink() {
        WLinkImpl wLink = new WLinkImpl();
        return wLink;
    }

    @Override
    public WValue createWValue() {
        WValueImpl wValue = new WValueImpl();
        return wValue;
    }

    @Override
    public Map<EObject, WObject> createWModel(Collection<EObject> eObjects, boolean activateSync) {
        WObject wObject;
        LinkedHashMap<EObject, WObject> map = new LinkedHashMap<EObject, WObject>();
        for (EObject eObject : eObjects) {
            wObject = new WObjectImpl(false);
            wObject.setEObject(eObject);
            map.put(eObject, wObject);
        }
        for (EObject eObject : eObjects) {
            wObject = (WObject)map.get(eObject);
            for (EAttribute att : eObject.eClass().getEAllAttributes()) {
                if (att.isMany()) {
                    EList eValues = (EList)eObject.eGet((EStructuralFeature)att);
                    for (Object eValue : eValues) {
                        WValueImpl wValue = new WValueImpl(false);
                        wValue.setEStructuralFeature((EStructuralFeature)att);
                        wValue.setEValue(eValue);
                        wObject.getWMembers().add((Object)wValue);
                    }
                    continue;
                }
                Object eValue = eObject.eGet((EStructuralFeature)att);
                if (eValue == null) continue;
                WValueImpl wValue = new WValueImpl(false);
                wValue.setEStructuralFeature((EStructuralFeature)att);
                wValue.setEValue(eValue);
                wObject.getWMembers().add((Object)wValue);
            }
            for (EReference ref : eObject.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    EList eTargets = (EList)eObject.eGet((EStructuralFeature)ref);
                    for (EObject eTarget : eTargets) {
                        WLinkImpl wLink = new WLinkImpl(false);
                        wLink.setEStructuralFeature((EStructuralFeature)ref);
                        wLink.setWTarget((WObject)map.get(eTarget));
                        wObject.getWMembers().add((Object)wLink);
                    }
                    continue;
                }
                EObject eTarget = (EObject)eObject.eGet((EStructuralFeature)ref);
                if (eTarget == null) continue;
                WLinkImpl wLink = new WLinkImpl(false);
                wLink.setEStructuralFeature((EStructuralFeature)ref);
                wLink.setWTarget((WObject)map.get(eTarget));
                wObject.getWMembers().add((Object)wLink);
            }
        }
        if (activateSync) {
            for (WObject wObject2 : map.values()) {
                wObject2.setSynchronize(true);
                for (WMember wMember : wObject2.getWMembers()) {
                    wMember.setSynchronize(true);
                }
            }
        }
        return map;
    }

    @Override
    public Map<EObject, WObject> createWModelTree(Collection<EObject> eObjects, boolean activateSync) {
        return this.createWModel(WrapFactoryImpl.computeTransitiveClosure(eObjects, false), activateSync);
    }

    @Override
    public Map<EObject, WObject> createWModelGraph(Collection<EObject> eObjects, boolean activateSync) {
        return this.createWModel(WrapFactoryImpl.computeTransitiveClosure(eObjects, true), activateSync);
    }

    private static Collection<EObject> computeTransitiveClosure(Collection<EObject> eObjects, boolean includeNonContainment) {
        LinkedHashSet<EObject> allEObjects = new LinkedHashSet<EObject>();
        ArrayList<EObject> newEObjects = new ArrayList<EObject>(eObjects);
        while (!newEObjects.isEmpty()) {
            allEObjects.addAll(newEObjects);
            ArrayList<EObject> buffer = new ArrayList<EObject>();
            for (EObject obj : newEObjects) {
                for (EReference ref : includeNonContainment ? obj.eClass().getEAllReferences() : obj.eClass().getEAllContainments()) {
                    if (ref.isMany()) {
                        EList targets = (EList)obj.eGet((EStructuralFeature)ref);
                        for (EObject target : targets) {
                            if (allEObjects.contains(target)) continue;
                            buffer.add(target);
                        }
                        continue;
                    }
                    EObject target = (EObject)obj.eGet((EStructuralFeature)ref);
                    if (target == null || allEObjects.contains(target)) continue;
                    buffer.add(target);
                }
            }
            newEObjects = buffer;
        }
        return allEObjects;
    }

    @Override
    public WrapPackage getWrapPackage() {
        return (WrapPackage)this.getEPackage();
    }

    @Deprecated
    public static WrapPackage getPackage() {
        return WrapPackage.eINSTANCE;
    }
}

