/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomApplConstraint;
import agg.cons.EvalSet;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.util.Pair;
import agg.util.Triple;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Morphism;
import agg.xt_basis.NACStarMorphism;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.PACStarMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TestStep;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public final class MatchHelper {
    protected static String errorMsg = "";

    public static boolean isDomainOfApplCondEmpty(Match match, OrdinaryMorphism cond) {
        for (Node go : cond.getTarget().getNodesSet()) {
            HashSet<GraphObject> v;
            if (cond.getInverseImage(go).hasMoreElements() || (v = match.getTarget().getTypeObjectsMap().get(go.convertToKey())) != null && !v.isEmpty()) continue;
            return true;
        }
        for (Arc go : cond.getTarget().getArcsSet()) {
            if (cond.getInverseImage(go).hasMoreElements() || !go.isArc()) continue;
            String keystr = go.convertToKey();
            HashSet<GraphObject> v = match.getTarget().getTypeObjectsMap().get(keystr);
            if (v != null && !v.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static OrdinaryMorphism makeTestStep(Match m2, boolean allowVariables, boolean similarVariableName) {
        errorMsg = "";
        try {
            OrdinaryMorphism co_match = (OrdinaryMorphism)TestStep.execute(m2, allowVariables, similarVariableName);
            return co_match;
        }
        catch (TypeException e) {
            errorMsg = e.getMessage();
            return null;
        }
    }

    public static boolean isDanglingPoint(Match match, GraphObject obj, GraphObject img) {
        return match.getCompletionStrategy().getProperties().get(1) && obj.isNode() && match.getRule().getImage(obj) == null && ((Node)obj).getNumberOfArcs() != ((Node)img).getNumberOfArcs();
    }

    public static String isDanglingSatisfied(Match match) {
        errorMsg = "";
        if (match.getCompletionStrategy().getProperties().get(1)) {
            for (Node x : match.getRule().getSource().getNodesSet()) {
                Enumeration<GraphObject> en;
                Node y;
                if (match.getRule().getImage(x) != null || (y = (Node)match.getImage(x)) == null) continue;
                if (match.getCompletionStrategy().getProperties().get(0)) {
                    if (x.getNumberOfArcs() >= y.getNumberOfArcs()) continue;
                    errorMsg = "Dangling condition isn't satisfied! ( node: " + x.getType().getName() + " )";
                    return errorMsg;
                }
                Iterator<Arc> arcs = y.getIncomingArcs();
                while (arcs.hasNext()) {
                    en = match.getInverseImage(arcs.next());
                    if (en.hasMoreElements()) continue;
                    errorMsg = "Dangling condition isn't satisfied! ( node: " + x.getType().getName() + " )";
                    return errorMsg;
                }
                arcs = y.getOutgoingArcs();
                while (arcs.hasNext()) {
                    en = match.getInverseImage(arcs.next());
                    if (en.hasMoreElements()) continue;
                    errorMsg = "Dangling condition isn't satisfied! ( node: " + x.getType().getName() + " )";
                    return errorMsg;
                }
            }
        }
        return "";
    }

    public static String isIdentSatisfied(Match match) {
        errorMsg = "";
        if (!match.getCompletionStrategy().getProperties().get(0) && match.getCompletionStrategy().getProperties().get(2)) {
            Rule itsRule = match.getRule();
            Iterator<Node> nodes = itsRule.getOriginal().getNodesSet().iterator();
            while (nodes.hasNext()) {
                int k = 0;
                boolean preserved = true;
                Enumeration<GraphObject> en = match.getInverseImage(match.getImage(nodes.next()));
                int del = 0;
                while (en.hasMoreElements()) {
                    GraphObject xx = en.nextElement();
                    ++k;
                    if (itsRule.getImage(xx) != null) continue;
                    preserved = false;
                    ++del;
                }
                if (k <= true || preserved || k <= del) continue;
                errorMsg = "Identification condition isn't satisfied!";
                return errorMsg;
            }
            Iterator<Arc> arcs = itsRule.getOriginal().getArcsSet().iterator();
            while (arcs.hasNext()) {
                int k = 0;
                boolean preserved = true;
                Enumeration<GraphObject> en = match.getInverseImage(match.getImage(arcs.next()));
                int del = 0;
                while (en.hasMoreElements()) {
                    GraphObject xx = en.nextElement();
                    ++k;
                    if (itsRule.getImage(xx) != null) continue;
                    preserved = false;
                    ++del;
                }
                if (k <= true || preserved || k <= del) continue;
                errorMsg = "Identification condition isn't satisfied!";
                return errorMsg;
            }
        }
        return "";
    }

    public static String isConsistent(Rule rule, OrdinaryMorphism testComatch, OrdinaryMorphism testMatch) {
        errorMsg = "";
        Vector<Formula> constraints = rule.getConstraints();
        if (!constraints.isEmpty()) {
            boolean good = true;
            int i = 0;
            while (i < constraints.size()) {
                Formula f = constraints.get(i);
                if (f.isEnabled()) {
                    Vector<Evaluable> vec = new Vector<Evaluable>();
                    String form = f.getAsString(vec);
                    Vector<Evaluable> v = new Vector<Evaluable>();
                    int j = 0;
                    while (j < vec.size()) {
                        EvalSet evalset = (EvalSet)vec.get(j);
                        Vector<Object> set = evalset.getSet();
                        Vector<Object> v1 = new Vector<Object>();
                        int k = 0;
                        while (k < set.size()) {
                            Vector<Object> es = ((EvalSet)set.get(k)).getSet();
                            AtomApplConstraint aaConstr = new AtomApplConstraint(es);
                            v1.add(aaConstr);
                            ++k;
                        }
                        v.add(new EvalSet(v1));
                        ++j;
                    }
                    Formula f1 = new Formula(true);
                    f1.setFormula(v, form);
                    boolean b = f1.eval(new Pair<OrdinaryMorphism, OrdinaryMorphism>(testComatch, testMatch));
                    if (!(good &= b)) {
                        errorMsg = "Post application condition of the rule  " + rule.getName() + "  failed";
                        break;
                    }
                }
                ++i;
            }
            return errorMsg;
        }
        return "";
    }

    public static String attributesOfGlueObjectsCorrect(Match match) {
        errorMsg = "";
        if (!match.getCompletionStrategy().getProperties().get(0)) {
            MatchHelper.attrsOfGlueObjectsCorrect(match, match.getImage().getNodesSet().iterator());
            MatchHelper.attrsOfGlueObjectsCorrect(match, match.getImage().getArcsSet().iterator());
        }
        return errorMsg;
    }

    private static String attrsOfGlueObjectsCorrect(Match match, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject ruleImg;
            GraphObject go = (GraphObject)elems.next();
            if (go.getAttribute() == null) continue;
            Enumeration<GraphObject> invers = match.getInverseImage(go);
            Vector<GraphObject> origs = new Vector<GraphObject>(2);
            while (invers.hasMoreElements()) {
                origs.addElement(invers.nextElement());
            }
            if (origs.size() <= 1) continue;
            Vector<GraphObject> ruleImgs = new Vector<GraphObject>(2);
            int i = 0;
            while (i < origs.size()) {
                GraphObject ruleImg2 = match.getRule().getImage((GraphObject)origs.elementAt(i));
                if (ruleImg2 != null) {
                    ruleImgs.addElement(ruleImg2);
                }
                ++i;
            }
            if (ruleImgs.size() <= 1 || (ruleImg = (GraphObject)ruleImgs.elementAt(0)).getAttribute() == null) continue;
            ValueTuple imgAttrs = (ValueTuple)ruleImg.getAttribute();
            GraphObject ruleOrig = match.getRule().getInverseImage(ruleImg).nextElement();
            int i2 = 1;
            while (i2 < ruleImgs.size()) {
                GraphObject otherRuleImg = (GraphObject)ruleImgs.elementAt(i2);
                if (otherRuleImg.getAttribute() != null) {
                    boolean replace1 = true;
                    ValueTuple otherAttrs = (ValueTuple)otherRuleImg.getAttribute();
                    GraphObject otherOrig = match.getRule().getInverseImage(otherRuleImg).nextElement();
                    int j = 0;
                    while (j < imgAttrs.getNumberOfEntries()) {
                        String attrName;
                        ValueMember vmOtherImg;
                        ValueMember vmImg = imgAttrs.getValueMemberAt(j);
                        if (vmImg != null && (vmOtherImg = otherAttrs.getValueMemberAt(attrName = vmImg.getName())) != null && vmImg.getExpr() != null && vmOtherImg.getExpr() != null && !vmImg.getExprAsText().equals(vmOtherImg.getExprAsText())) {
                            boolean attrFailed;
                            boolean bl = attrFailed = vmImg.getExpr().isComplex() && vmOtherImg.getExpr().isComplex();
                            if (!attrFailed) {
                                boolean bl2 = attrFailed = vmImg.getExpr().isConstant() && vmOtherImg.getExpr().isConstant();
                                if (attrFailed) {
                                    ValueMember govm = ((ValueTuple)go.getAttribute()).getValueMemberAt(attrName);
                                    if (!vmImg.getExprAsText().equals(govm.getExprAsText())) {
                                        replace1 = false;
                                    } else {
                                        attrFailed = false;
                                    }
                                    if (attrFailed && !vmOtherImg.getExprAsText().equals(govm.getExprAsText())) {
                                        replace1 = true;
                                        attrFailed = true;
                                    } else {
                                        attrFailed = false;
                                    }
                                }
                            }
                            if (!attrFailed) {
                                ValueMember vmOtherOrig;
                                ValueTuple otherOrigAttrs;
                                ValueMember vmRuleOrig;
                                ValueTuple origAttrs;
                                boolean varchanged1 = false;
                                if (vmImg.getExpr().isVariable() && (origAttrs = (ValueTuple)ruleOrig.getAttribute()) != null && (vmRuleOrig = origAttrs.getValueMemberAt(attrName)) != null && vmRuleOrig.isSet() && vmRuleOrig.getExpr().isVariable() && !vmRuleOrig.getExprAsText().equals(vmImg.getExprAsText()) && !MatchHelper.isVariableUsed(vmImg, origs)) {
                                    varchanged1 = true;
                                    replace1 = true;
                                }
                                boolean varchanged2 = false;
                                if (vmOtherImg.getExpr().isVariable() && (otherOrigAttrs = (ValueTuple)otherOrig.getAttribute()) != null && (vmOtherOrig = otherOrigAttrs.getValueMemberAt(attrName)) != null && vmOtherOrig.isSet() && vmOtherOrig.getExpr().isVariable() && !vmOtherOrig.getExprAsText().equals(vmOtherImg.getExprAsText()) && !MatchHelper.isVariableUsed(vmOtherImg, origs)) {
                                    varchanged2 = true;
                                    replace1 = false;
                                }
                                boolean bl3 = attrFailed = varchanged1 && varchanged2;
                            }
                            if (attrFailed) {
                                errorMsg = "The rule  <" + match.getRule().getName() + ">  " + "can produce an attr. conflict \nfor objects of the type  " + "<" + ruleImg.getType().getName() + "> " + " and " + "<" + otherRuleImg.getType().getName() + "> " + "  \nwhich change the value of the same attribute.";
                                return errorMsg;
                            }
                        }
                        ++j;
                    }
                    if (i2 < ruleImgs.size() && replace1) {
                        ruleImg = otherRuleImg;
                        imgAttrs = (ValueTuple)ruleImg.getAttribute();
                        ruleOrig = match.getRule().getInverseImage(ruleImg).nextElement();
                    }
                }
                ++i2;
            }
        }
        return "";
    }

    private static boolean isVariableUsed(ValueMember vm, Vector<GraphObject> objs) {
        boolean varUsed = false;
        int i = 1;
        while (i < objs.size()) {
            ValueMember goAttrvm;
            GraphObject go = objs.elementAt(i);
            ValueTuple goAttr = (ValueTuple)go.getAttribute();
            if (go.getAttribute() != null && (goAttrvm = goAttr.getValueMemberAt(vm.getName())) != null && goAttrvm.isSet() && goAttrvm.getExprAsText().equals(vm.getExprAsText())) {
                varUsed = true;
                break;
            }
            ++i;
        }
        return varUsed;
    }

    public static String isTypeMultiplicitySatisfied(Match match) {
        int n;
        Node go;
        int n2;
        errorMsg = "";
        int tgchecklevel = match.getSource().getTypeSet().getLevelOfTypeGraphCheck();
        if (tgchecklevel <= 10) {
            return "";
        }
        Rule itsRule = match.getRule();
        match.clearErrorMsg();
        List<String> typesNeedMultiplicityCheck = itsRule.getTypesWhichNeedMultiplicityCheck();
        if (typesNeedMultiplicityCheck.isEmpty()) {
            return "";
        }
        Vector<Node> nodestodelete = new Vector<Node>();
        Vector<Node> nodestocreate = new Vector<Node>();
        Vector<Arc> arcstodelete = new Vector<Arc>();
        Vector<Arc> arcstocreate = new Vector<Arc>();
        Vector<Arc> insOfDelNode = new Vector<Arc>();
        Vector<Arc> outsOfDelNode = new Vector<Arc>();
        Vector<GraphObject> nodestoglue = new Vector<GraphObject>();
        for (Node node : itsRule.getLeft().getNodesSet()) {
            if (itsRule.getImage(node) != null) continue;
            nodestodelete.add(node);
            Node n3 = (Node)match.getImage(node);
            insOfDelNode.addAll(n3.getIncomingArcsSet());
            outsOfDelNode.addAll(n3.getOutgoingArcsSet());
        }
        for (Arc arc : itsRule.getLeft().getArcsSet()) {
            if (itsRule.getImage(arc) != null || itsRule.getImage(arc.getSource()) == null || itsRule.getImage(arc.getTarget()) == null) continue;
            arcstodelete.add(arc);
        }
        for (GraphObject graphObject : itsRule.getRight().getNodesSet()) {
            if (itsRule.getInverseImage(graphObject).hasMoreElements()) continue;
            nodestocreate.add((Node)graphObject);
        }
        for (Arc arc : itsRule.getRight().getArcsSet()) {
            if (itsRule.getInverseImage(arc).hasMoreElements() || !itsRule.getInverseImage(arc.getSource()).hasMoreElements() && !itsRule.getInverseImage(arc.getTarget()).hasMoreElements()) continue;
            arcstocreate.add(arc);
        }
        int n4 = nodestodelete.size();
        int i = 0;
        while (i < n2) {
            go = (Node)nodestodelete.get(i);
            if (go.isNode()) {
                if (!MatchHelper.checkNodeMultiplicity(typesNeedMultiplicityCheck, match, go, i + 1, nodestodelete, nodestocreate, nodestoglue, tgchecklevel)) {
                    return errorMsg;
                }
                n2 = nodestodelete.size();
            }
            ++i;
        }
        int n5 = nodestocreate.size();
        i = 0;
        while (i < n) {
            go = (Node)nodestocreate.get(i);
            if (!MatchHelper.checkNodeMaxMultiplicity(typesNeedMultiplicityCheck, match, go, i + 1, nodestocreate, nodestoglue, tgchecklevel)) {
                return errorMsg;
            }
            n = nodestocreate.size();
            ++i;
        }
        if (!MatchHelper.checkEdgeMultiplicityDueToEdgeToDelete(typesNeedMultiplicityCheck, match, insOfDelNode, outsOfDelNode, arcstodelete, arcstocreate, nodestoglue, tgchecklevel)) {
            return errorMsg;
        }
        if (!MatchHelper.checkEdgeTargetMaxMultiplicity(typesNeedMultiplicityCheck, match, arcstocreate, tgchecklevel)) {
            return errorMsg;
        }
        if (!MatchHelper.checkEdgeSourceMaxMultiplicity(typesNeedMultiplicityCheck, match, arcstocreate, tgchecklevel)) {
            return errorMsg;
        }
        return "";
    }

    private static boolean checkEdgeMultiplicityDueToEdgeToDelete(List<String> typesNeedMultiplicityCheck, Match match, List<Arc> incomsofnodetodelete, List<Arc> outcomsofnodetodelete, List<Arc> arcstodelete, List<Arc> arcstocreate, List<GraphObject> nodestoglue, int tgchecklevel) {
        List<Arc> list;
        String typekey;
        Hashtable<String, List<Arc>> type2newarcs = new Hashtable<String, List<Arc>>();
        int i = 0;
        while (i < arcstocreate.size()) {
            Arc a = arcstocreate.get(i);
            List<String> typekeys = a.convertToKeyParentExtended();
            int l = 0;
            while (l < typekeys.size()) {
                typekey = typekeys.get(l);
                list = (Vector<Arc>)type2newarcs.get(typekey);
                if (list == null) {
                    list = new Vector<Arc>();
                    type2newarcs.put(typekey, list);
                }
                list.add(a);
                ++l;
            }
            ++i;
        }
        Hashtable<String, List<Arc>> type2delarcs = new Hashtable<String, List<Arc>>();
        Hashtable<String, List<Arc>> type2delarcs2 = new Hashtable<String, List<Arc>>();
        int i2 = 0;
        while (i2 < arcstodelete.size()) {
            Arc da = arcstodelete.get(i2);
            typekey = da.convertToKey();
            Arc a = (Arc)match.getImage(da);
            if (typesNeedMultiplicityCheck.contains(typekey)) {
                Vector<Arc> list2 = (Vector<Arc>)type2delarcs.get(typekey);
                if (list2 == null) {
                    list2 = new Vector<Arc>();
                    type2delarcs.put(typekey, list2);
                }
                list2.add(a);
                Vector<Arc> list22 = (Vector<Arc>)type2delarcs2.get(typekey);
                if (list22 == null) {
                    list22 = new Vector<Arc>();
                    type2delarcs2.put(typekey, list22);
                }
                list22.add(a);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < incomsofnodetodelete.size()) {
            Arc a = incomsofnodetodelete.get(i2);
            typekey = a.convertToKey();
            if (typesNeedMultiplicityCheck.contains(typekey)) {
                list = (List)type2delarcs.get(typekey);
                if (list == null) {
                    list = new Vector();
                    type2delarcs.put(typekey, list);
                }
                list.add(a);
            }
            ++i2;
        }
        if (!MatchHelper.checkEdgeTargetMinMaxMultiplicity(match, type2delarcs, type2newarcs, arcstocreate, tgchecklevel)) {
            return false;
        }
        i2 = 0;
        while (i2 < outcomsofnodetodelete.size()) {
            Arc a = outcomsofnodetodelete.get(i2);
            typekey = a.convertToKey();
            if (typesNeedMultiplicityCheck.contains(typekey)) {
                list = (List)type2delarcs2.get(typekey);
                if (list == null) {
                    list = new Vector();
                    type2delarcs2.put(typekey, list);
                }
                list.add(a);
            }
            ++i2;
        }
        return MatchHelper.checkEdgeSourceMinMaxMultiplicity(match, type2delarcs2, type2newarcs, arcstocreate, tgchecklevel);
    }

    private static boolean checkEdgeTargetMinMaxMultiplicity(Match match, Map<String, List<Arc>> type2delarcs, Map<String, List<Arc>> type2newarcs, List<Arc> arcstocreate, int tgchecklevel) {
        errorMsg = "";
        Vector<Triple<Node, Type, Type>> srcNodes = new Vector<Triple<Node, Type, Type>>();
        Vector<Integer> ndel = new Vector<Integer>();
        Vector<Pair<Integer, Integer>> tarMinMax = new Vector<Pair<Integer, Integer>>();
        for (String typekey : type2delarcs.keySet()) {
            List<Arc> incoms = type2delarcs.get(typekey);
            int j = 0;
            while (j < incoms.size()) {
                Arc a = incoms.get(j);
                int indx = MatchHelper.getIndexOfNode(srcNodes, (Node)a.getSource(), a.getType(), a.getTargetType());
                if (indx >= 0) {
                    int nn = (Integer)ndel.get(indx) + 1;
                    ndel.add(indx, new Integer(nn));
                    ndel.remove(indx + 1);
                } else {
                    List<Arc> newarcs = type2newarcs.get(typekey);
                    int nn = 0;
                    if (newarcs != null && match.getInverseImage(a.getSource()).hasMoreElements()) {
                        nn = MatchHelper.getCountOfArcsWithTypeAndSource(typekey, match.getRule().getImage(match.getInverseImage(a.getSource()).nextElement()), newarcs, arcstocreate);
                    }
                    srcNodes.add(new Triple<Node, Type, Type>((Node)a.getSource(), a.getType(), a.getTargetType()));
                    indx = srcNodes.size() - 1;
                    nn = nn > 0 ? --nn : 1;
                    ndel.add(new Integer(nn));
                    int tarMin = a.getType().getTargetMin(a.getSource().getType(), a.getTarget().getType());
                    int tarMax = a.getType().getTargetMax(a.getSource().getType(), a.getTarget().getType());
                    tarMinMax.add(new Pair<Integer, Integer>(new Integer(tarMin), new Integer(tarMax)));
                }
                Type targetNodeType = a.getTarget().getType();
                Vector<Arc> vec = match.getTarget().getTypeSet().getTypeGraph().getArcs(a.getType());
                if (vec != null) {
                    if (vec.size() == 1) {
                        Arc typeArc = vec.get(0);
                        targetNodeType = typeArc.getTarget().getType();
                    } else {
                        int k = 0;
                        while (k < vec.size()) {
                            Arc typeArc = vec.get(k);
                            if (typeArc.getSourceType().isParentOf(a.getSourceType()) && typeArc.getTargetType().isParentOf(a.getTargetType())) {
                                targetNodeType = typeArc.getTarget().getType();
                                break;
                            }
                            ++k;
                        }
                    }
                }
                int nn = (Integer)ndel.get(indx);
                Node src = (Node)((Triple)srcNodes.get((int)indx)).first;
                int outs = src.getNumberOfOutgoingArcs(a.getType(), targetNodeType);
                if (tgchecklevel > 20 && (Integer)((Pair)tarMinMax.get((int)indx)).first > 0 && outs - nn < (Integer)((Pair)tarMinMax.get((int)indx)).first) {
                    if (match.getRule().getImage(match.getInverseImage(a.getSource()).nextElement()) != null) {
                        errorMsg = "Target multiplicity of edge type failed!\nType  \"" + a.getType().getName() + "\"" + " - target minimum failed.";
                        return false;
                    }
                } else if ((Integer)((Pair)tarMinMax.get((int)indx)).second != -1 && outs - nn > (Integer)((Pair)tarMinMax.get((int)indx)).second) {
                    errorMsg = "Target multiplicity of edge type failed!\nType  \"" + a.getType().getName() + "\"" + " - target maximum failed.";
                    return false;
                }
                ++j;
            }
            srcNodes.clear();
            ndel.clear();
            tarMinMax.clear();
        }
        return true;
    }

    private static boolean checkEdgeSourceMinMaxMultiplicity(Match match, Map<String, List<Arc>> type2delarcs, Map<String, List<Arc>> type2newarcs, List<Arc> arcstocreate, int tgchecklevel) {
        errorMsg = "";
        Vector<Triple<Node, Type, Type>> tarNodes = new Vector<Triple<Node, Type, Type>>();
        Vector<Integer> ndel = new Vector<Integer>();
        Vector<Pair<Integer, Integer>> srcMinMax = new Vector<Pair<Integer, Integer>>();
        for (String typekey : type2delarcs.keySet()) {
            List<Arc> outcoms = type2delarcs.get(typekey);
            int j = 0;
            while (j < outcoms.size()) {
                Arc a = outcoms.get(j);
                int indx = MatchHelper.getIndexOfNode(tarNodes, (Node)a.getTarget(), a.getType(), a.getSourceType());
                if (indx >= 0) {
                    int nn = (Integer)ndel.get(indx) + 1;
                    ndel.set(indx, new Integer(nn));
                } else {
                    List<Arc> newarcs = type2newarcs.get(typekey);
                    int nn = 0;
                    if (newarcs != null && newarcs.size() > 0 && match.getInverseImage(a.getTarget()).hasMoreElements()) {
                        nn = MatchHelper.getCountOfArcsWithTypeAndTarget(typekey, match.getRule().getImage(match.getInverseImage(a.getTarget()).nextElement()), newarcs, arcstocreate);
                    }
                    tarNodes.add(new Triple<Node, Type, Type>((Node)a.getTarget(), a.getType(), a.getSourceType()));
                    indx = tarNodes.size() - 1;
                    nn = nn > 0 ? --nn : 1;
                    ndel.add(new Integer(nn));
                    int srcMin = a.getType().getSourceMin(a.getSource().getType(), a.getTarget().getType());
                    int srcMax = a.getType().getSourceMax(a.getSource().getType(), a.getTarget().getType());
                    srcMinMax.add(new Pair<Integer, Integer>(new Integer(srcMin), new Integer(srcMax)));
                }
                Type sourceNodeType = a.getSource().getType();
                Vector<Arc> vec = match.getTarget().getTypeSet().getTypeGraph().getArcs(a.getType());
                if (vec != null) {
                    if (vec.size() == 1) {
                        Arc typeArc = vec.get(0);
                        sourceNodeType = typeArc.getSource().getType();
                    } else {
                        int k = 0;
                        while (k < vec.size()) {
                            Arc typeArc = vec.get(k);
                            if (typeArc.getSourceType().isParentOf(a.getSourceType()) && typeArc.getTargetType().isParentOf(a.getTargetType())) {
                                sourceNodeType = typeArc.getSource().getType();
                                break;
                            }
                            ++k;
                        }
                    }
                }
                int nn = (Integer)ndel.get(indx);
                Node tar = (Node)((Triple)tarNodes.get((int)indx)).first;
                int ins = tar.getNumberOfIncomingArcs(a.getType(), sourceNodeType);
                if (tgchecklevel > 20 && (Integer)((Pair)srcMinMax.get((int)indx)).first > 0 && ins - nn < (Integer)((Pair)srcMinMax.get((int)indx)).first) {
                    if (match.getRule().getImage(match.getInverseImage(a.getTarget()).nextElement()) != null) {
                        errorMsg = "Source multiplicity of edge type failed!\nType  \"" + a.getType().getName() + "\"" + " - source minimum failed.";
                        return false;
                    }
                } else if ((Integer)((Pair)srcMinMax.get((int)indx)).second != -1 && ins - nn > (Integer)((Pair)srcMinMax.get((int)indx)).second) {
                    errorMsg = "Source multiplicity of edge type failed!\nType  \"" + a.getType().getName() + "\"" + " - source maximum failed.";
                    return false;
                }
                ++j;
            }
            tarNodes.clear();
            ndel.clear();
            srcMinMax.clear();
        }
        return true;
    }

    private static int getCountOfArcsWithTypeAndSource(String typekey, GraphObject source, List<Arc> newarcs, List<Arc> allnewarcs) {
        int nn = 0;
        if (newarcs != null && source != null) {
            int k = 0;
            while (k < newarcs.size()) {
                Arc arc = newarcs.get(k);
                if (arc.getSource() == source && allnewarcs.contains(arc)) {
                    ++nn;
                }
                ++k;
            }
        }
        return nn;
    }

    private static int getCountOfArcsWithTypeAndTarget(String typekey, GraphObject target, List<Arc> newarcs, List<Arc> allnewarcs) {
        int nn = 0;
        if (newarcs != null && target != null) {
            int k = 0;
            while (k < newarcs.size()) {
                Arc arc = newarcs.get(k);
                if (arc.getTarget() == target && allnewarcs.contains(arc)) {
                    ++nn;
                }
                ++k;
            }
        }
        return nn;
    }

    private static boolean checkEdgeTargetMaxMultiplicity(List<String> typesNeedMultiplicityCheck, Match match, List<Arc> arcstocreate, int tgchecklevel) {
        Arc a;
        errorMsg = "";
        Vector<Triple<Node, Type, Type>> srcNodes = new Vector<Triple<Node, Type, Type>>();
        Vector<Integer> nnew = new Vector<Integer>();
        Vector<Integer> tarMax = new Vector<Integer>();
        Hashtable<String, Vector<Arc>> type2newarcs = new Hashtable<String, Vector<Arc>>();
        int i = 0;
        while (i < arcstocreate.size()) {
            a = arcstocreate.get(i);
            String typekey = a.convertToKey();
            Vector<Arc> list = (Vector<Arc>)type2newarcs.get(typekey);
            if (list == null) {
                list = new Vector<Arc>();
                type2newarcs.put(typekey, list);
            }
            list.add(a);
            ++i;
        }
        i = 0;
        while (i < arcstocreate.size()) {
            Node src;
            a = arcstocreate.get(i);
            if (match.getRule().getInverseImage(a.getSource()).hasMoreElements() && typesNeedMultiplicityCheck.contains(a.convertToKey()) && (src = (Node)match.getImage(match.getRule().getInverseImage(a.getSource()).nextElement())) != null) {
                int indx = MatchHelper.getIndexOfNode(srcNodes, src, a.getType(), a.getTargetType());
                if (indx >= 0) {
                    int nn = (Integer)nnew.get(indx) + 1;
                    nnew.set(indx, new Integer(nn));
                } else {
                    srcNodes.add(new Triple<Node, Type, Type>(src, a.getType(), a.getTargetType()));
                    indx = srcNodes.size() - 1;
                    nnew.add(new Integer(1));
                    int max = a.getType().getTargetMax(a.getSource().getType(), a.getTarget().getType());
                    tarMax.add(new Integer(max));
                }
                Type targetNodeType = a.getTarget().getType();
                Vector<Arc> vec = match.getTarget().getTypeSet().getTypeGraph().getArcs(a.getType());
                if (vec != null) {
                    if (vec.size() == 1) {
                        Arc typeArc = vec.get(0);
                        targetNodeType = typeArc.getTarget().getType();
                    } else {
                        int k = 0;
                        while (k < vec.size()) {
                            Arc typeArc = vec.get(k);
                            if (typeArc.getSourceType().isParentOf(a.getSourceType()) && typeArc.getTargetType().isParentOf(a.getTargetType())) {
                                targetNodeType = typeArc.getTarget().getType();
                                break;
                            }
                            ++k;
                        }
                    }
                }
                int nn = (Integer)nnew.get(indx);
                List<Arc> outarcs = src.getOutgoingArcs(a.getType(), targetNodeType);
                int outs = outarcs.size();
                int k = 0;
                while (k < outarcs.size()) {
                    Arc outarc = outarcs.get(k);
                    if (match.getInverseImage(outarc).hasMoreElements() && match.getRule().getImage(match.getInverseImage(outarc).nextElement()) == null) {
                        --outs;
                    } else if (match.getTarget().getTypeSet().isOutgoingArcOfClan(src.getType(), outarc.getType(), outarc.getTarget().getType()) && match.getInverseImage(outarc).hasMoreElements() && match.getRule().getImage(match.getInverseImage(outarc).nextElement()) == null) {
                        --outs;
                    }
                    ++k;
                }
                if ((Integer)tarMax.get(indx) != -1 && outs + nn > (Integer)tarMax.get(indx)) {
                    errorMsg = "Target multiplicity of edge type failed!\nType  \"" + a.getType().getName() + "\"" + " - target maximum failed.";
                    return false;
                }
                if (i < 0) break;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkEdgeSourceMaxMultiplicity(List<String> typesNeedMultiplicityCheck, Match match, List<Arc> arcstocreate, int tgchecklevel) {
        Arc a;
        errorMsg = "";
        Vector<Triple<Node, Type, Type>> tarNodes = new Vector<Triple<Node, Type, Type>>();
        Vector<Integer> nnew = new Vector<Integer>();
        Vector<Integer> srcMax = new Vector<Integer>();
        Hashtable<String, Vector<Arc>> type2newarcs = new Hashtable<String, Vector<Arc>>();
        int i = 0;
        while (i < arcstocreate.size()) {
            a = arcstocreate.get(i);
            String typekey = a.convertToKey();
            Vector<Arc> list = (Vector<Arc>)type2newarcs.get(typekey);
            if (list == null) {
                list = new Vector<Arc>();
                type2newarcs.put(typekey, list);
            }
            list.add(a);
            ++i;
        }
        i = 0;
        while (i < arcstocreate.size()) {
            Node tar;
            a = arcstocreate.get(i);
            if (match.getRule().getInverseImage(a.getTarget()).hasMoreElements() && typesNeedMultiplicityCheck.contains(a.convertToKey()) && (tar = (Node)match.getImage(match.getRule().getInverseImage(a.getTarget()).nextElement())) != null) {
                int indx = MatchHelper.getIndexOfNode(tarNodes, tar, a.getType(), a.getSourceType());
                if (indx >= 0) {
                    int nn = (Integer)nnew.get(indx) + 1;
                    nnew.set(indx, new Integer(nn));
                } else {
                    tarNodes.add(new Triple<Node, Type, Type>(tar, a.getType(), a.getSourceType()));
                    indx = tarNodes.size() - 1;
                    nnew.add(new Integer(1));
                    int max = a.getType().getSourceMax(a.getSource().getType(), a.getTarget().getType());
                    srcMax.add(new Integer(max));
                }
                Type sourceNodeType = a.getSource().getType();
                Vector<Arc> vec = match.getTarget().getTypeSet().getTypeGraph().getArcs(a.getType());
                if (vec != null) {
                    if (vec.size() == 1) {
                        Arc typeArc = vec.get(0);
                        sourceNodeType = typeArc.getSource().getType();
                    } else {
                        int k = 0;
                        while (k < vec.size()) {
                            Arc typeArc = vec.get(k);
                            if (typeArc.getSourceType().isParentOf(a.getSourceType()) && typeArc.getTargetType().isParentOf(a.getTargetType())) {
                                sourceNodeType = typeArc.getSource().getType();
                                break;
                            }
                            ++k;
                        }
                    }
                }
                int nn = (Integer)nnew.get(nnew.size() - 1);
                List<Arc> inarcs = tar.getIncomingArcs(a.getType(), sourceNodeType);
                int ins = inarcs.size();
                int k = 0;
                while (k < inarcs.size()) {
                    Arc inarc = inarcs.get(k);
                    if (match.getInverseImage(inarc).hasMoreElements() && match.getRule().getImage(match.getInverseImage(inarc).nextElement()) == null) {
                        --ins;
                    } else if (match.getTarget().getTypeSet().isIncomingArcOfClan(tar.getType(), inarc.getType(), inarc.getSource().getType()) && match.getInverseImage(inarc).hasMoreElements() && match.getRule().getImage(match.getInverseImage(inarc).nextElement()) == null) {
                        --ins;
                    }
                    ++k;
                }
                if ((Integer)srcMax.get(indx) != -1 && ins + nn > (Integer)srcMax.get(indx)) {
                    errorMsg = "Source multiplicity of edge type failed!\nType  \"" + a.getType().getName() + "\"" + " - source maximum failed.";
                    return false;
                }
                if (i < 0) break;
            }
            ++i;
        }
        return true;
    }

    private static int getIndexOfNode(List<Triple<Node, Type, Type>> list, Node nodeOfArc, Type arcType, Type otherType) {
        int i = 0;
        while (i < list.size()) {
            Triple<Node, Type, Type> p = list.get(i);
            if (p.first == nodeOfArc && p.second == arcType && ((Type)p.third).isInClanOf(otherType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean checkNodeMultiplicity(List<String> typesNeedMultiplicityCheck, Match match, Node go, int startindex, List<Node> todelete, List<Node> tocreate, List<GraphObject> nodestoglue, int tgchecklevel) {
        Node n;
        errorMsg = "";
        if (!typesNeedMultiplicityCheck.contains(go.getType().convertToKey())) {
            return true;
        }
        int min = go.getType().getSourceMin();
        int max = go.getType().getSourceMax();
        int count = 0;
        if (match.getTarget().getTypeObjectsMap().get(go.getType().convertToKey()) != null) {
            count = match.getTarget().getTypeObjectsMap().get(go.getType().convertToKey()).size();
        }
        --count;
        int j = startindex;
        while (j < todelete.size()) {
            n = todelete.get(j);
            if (go.getType().isRelatedTo(n.getType())) {
                --count;
                todelete.remove(n);
                --j;
            }
            ++j;
        }
        int i = 0;
        while (i < tocreate.size()) {
            n = tocreate.get(i);
            if (go.getType().isRelatedTo(n.getType())) {
                ++count;
                tocreate.remove(n);
                --i;
            }
            ++i;
        }
        if (max != -1 && count > max) {
            errorMsg = "Node type multiplicity failed!\nType  \"" + go.getType().getName() + "\"" + " - maximum failed.";
            return false;
        }
        if (tgchecklevel > 20 && min > 0 && count < min) {
            errorMsg = "Node type multiplicity failed!\nType  \"" + go.getType().getName() + "\"" + " - minimum failed.";
            return false;
        }
        return true;
    }

    private static boolean checkNodeMaxMultiplicity(List<String> typesNeedMultiplicityCheck, Match match, Node go, int startindex, List<Node> tocreate, List<GraphObject> nodesofglue, int tgchecklevel) {
        errorMsg = "";
        if (!typesNeedMultiplicityCheck.contains(go.getType().convertToKey())) {
            return true;
        }
        int max = go.getType().getSourceMax();
        if (max == -1) {
            return true;
        }
        int count = 0;
        if (match.getTarget().getTypeObjectsMap().get(go.getType().convertToKey()) != null) {
            count = match.getTarget().getTypeObjectsMap().get(go.getType().convertToKey()).size();
        }
        ++count;
        int c = startindex;
        while (c < tocreate.size()) {
            Node goc = tocreate.get(c);
            if (go.getType().isRelatedTo(goc.getType())) {
                ++count;
                tocreate.remove(goc);
                --c;
            }
            ++c;
        }
        if (count > max) {
            errorMsg = "Node type multiplicity failed!\nType  \"" + go.getType().getName() + "\"" + " - maximum failed.";
            return false;
        }
        return true;
    }

    private static boolean checkConstValueWhenLeftAttrUnset(OrdinaryMorphism match, OrdinaryMorphism cond) {
        boolean result = true;
        Enumeration<GraphObject> dom = cond.getDomain();
        block0: while (dom.hasMoreElements() && result) {
            GraphObject goL = dom.nextElement();
            GraphObject imgC = cond.getImage(goL);
            GraphObject imgG = match.getImage(goL);
            if (goL.getAttribute() == null || imgC.getAttribute() == null || imgG.getAttribute() == null) continue;
            ValueTuple vtL = (ValueTuple)goL.getAttribute();
            ValueTuple vtC = (ValueTuple)imgC.getAttribute();
            ValueTuple vtG = (ValueTuple)imgG.getAttribute();
            int i = 0;
            while (i < vtL.getNumberOfEntries()) {
                ValueMember vmL = vtL.getValueMemberAt(i);
                ValueMember vmC = vtC.getValueMemberAt(vmL.getName());
                ValueMember vmG = vtG.getValueMemberAt(vmL.getName());
                if (!vmL.isSet() && vmC.isSet() && vmC.getExpr().isConstant() && vmG.isSet() && vmG.getExpr().isConstant() && !vmG.getExprAsText().equals(vmC.getExprAsText())) {
                    result = false;
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    private static boolean checkConstantAttrValueFromSourceToTarget(OrdinaryMorphism morph) {
        boolean result = true;
        Enumeration<GraphObject> dom = morph.getDomain();
        block0: while (dom.hasMoreElements() && result) {
            GraphObject go = dom.nextElement();
            GraphObject img = morph.getImage(go);
            if (go.getAttribute() == null || img.getAttribute() == null) continue;
            ValueTuple vt1 = (ValueTuple)go.getAttribute();
            ValueTuple vt2 = (ValueTuple)img.getAttribute();
            int i = 0;
            while (i < vt1.getNumberOfEntries()) {
                ValueMember vm1 = vt1.getValueMemberAt(i);
                ValueMember vm2 = vt2.getValueMemberAt(vm1.getName());
                if (vm1.isSet() && vm1.getExpr().isConstant() && vm2 != null && vm2.isSet() && !vm1.getExprAsText().equals(vm2.getExprAsText())) {
                    result = false;
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean checkVariableToNullMappping(Match match) {
        VarMember var;
        Vector<String> exprVars;
        if (!match.getSource().isAttributed()) {
            return true;
        }
        Rule itsRule = match.getRule();
        Vector<ValueMember> varToNull = new Vector<ValueMember>(2);
        VarTuple vars = (VarTuple)match.getAttrContext().getVariables();
        Enumeration<GraphObject> en = match.getDomain();
        while (en.hasMoreElements()) {
            GraphObject obj = en.nextElement();
            if (obj.getAttribute() == null) continue;
            GraphObject graphObject = match.getImage(obj);
            ValueTuple valueTuple = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < valueTuple.getNumberOfEntries()) {
                ValueMember vmObj = valueTuple.getEntryAt(i);
                if (vmObj.isSet() && vmObj.getExpr().isVariable()) {
                    ValueMember vmImg = ((ValueTuple)graphObject.getAttribute()).getEntryAt(i);
                    String nullStr = "null";
                    if (vmImg.isSet() && vmImg.getExprAsText().equals(nullStr)) {
                        varToNull.add(vars.getEntryAt(vmObj.getExprAsText()));
                    }
                }
                ++i;
            }
        }
        for (GraphObject graphObject : itsRule.getRight().getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            ValueTuple valueTuple = (ValueTuple)graphObject.getAttribute();
            int j = 0;
            while (j < valueTuple.getNumberOfEntries()) {
                ValueMember vm = valueTuple.getEntryAt(j);
                if (vm.isSet() && vm.getExpr().isComplex()) {
                    exprVars = vm.getAllVariableNamesOfExpression();
                    int i = 0;
                    while (i < varToNull.size()) {
                        var = (VarMember)varToNull.get(i);
                        if (exprVars.contains(var.getName())) {
                            return false;
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        for (GraphObject graphObject : itsRule.getRight().getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            ValueTuple vt2 = (ValueTuple)graphObject.getAttribute();
            int j = 0;
            while (j < vt2.getNumberOfEntries()) {
                ValueMember vm = vt2.getEntryAt(j);
                if (vm.isSet() && vm.getExpr().isComplex()) {
                    Vector<String> exprVars2 = vm.getAllVariableNamesOfExpression();
                    int i = 0;
                    while (i < varToNull.size()) {
                        VarMember var2 = (VarMember)varToNull.get(i);
                        if (exprVars2.contains(var2.getName())) {
                            return false;
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        CondTuple condTuple = (CondTuple)match.getAttrContext().getConditions();
        int j = 0;
        while (j < condTuple.getNumberOfEntries()) {
            CondMember cm = (CondMember)condTuple.getEntryAt(j);
            exprVars = cm.getAllVariables();
            int i = 0;
            while (i < varToNull.size()) {
                var = (VarMember)varToNull.get(i);
                if (cm.getExprAsText().indexOf(String.valueOf(var.getName()) + "==null") == -1) {
                    exprVars.contains(var.getName());
                }
                ++i;
            }
            ++j;
        }
        return true;
    }

    public static void checkSourceTargetCompatibilityOfEdge(Match match, GraphObject orig, GraphObject image) throws BadMappingException {
        if (orig.isArc()) {
            MatchHelper.checkEdgeSourceTargetCompatibility(match, orig, image);
            if (match.getRule().getImage(orig) != null && match.getRule().getImage(((Arc)orig).getSource()) == match.getRule().getImage(((Arc)orig).getTarget()) && ((Arc)image).getSource() != ((Arc)image).getTarget()) {
                errorMsg = "Edge loop: rule- and match-mapping must be source and target compatible.";
                System.out.println(errorMsg);
                System.out.println("required: " + match.getRule().getImage(((Arc)orig).getSource()) + "  ==  " + match.getRule().getImage(((Arc)orig).getTarget()));
                System.out.println("required: " + ((Arc)image).getSource() + " == " + ((Arc)image).getTarget());
                throw new BadMappingException(errorMsg);
            }
        }
    }

    public static void checkEdgeSourceTargetCompatibility(OrdinaryMorphism morph, GraphObject orig, GraphObject image) throws BadMappingException {
        errorMsg = "";
        if (orig.isArc() && ((Arc)orig).isDirected()) {
            GraphObject aSrc = ((Arc)orig).getSource();
            GraphObject aTar = ((Arc)orig).getTarget();
            boolean mappingFailed = false;
            if (morph.getImage(aSrc) != null) {
                if (((Arc)image).getSource() != morph.getImage(aSrc)) {
                    errorMsg = "Edge mapping must be source compatible.";
                    throw new BadMappingException(errorMsg);
                }
            } else {
                mappingFailed = true;
            }
            if (morph.getImage(aTar) != null) {
                if (((Arc)image).getTarget() != morph.getImage(aTar)) {
                    errorMsg = "Edge mapping must be target compatible.";
                    throw new BadMappingException(errorMsg);
                }
            } else {
                mappingFailed = true;
            }
            if (mappingFailed) {
                errorMsg = "Edge mapping: source and target nodes of an edge must be mapped before.";
                throw new BadMappingException(errorMsg);
            }
        }
    }

    public boolean isParallelArcAllowed(Match m, Type arct, Node src, Node tar) {
        return m.getOriginal().getTypeSet().isArcParallel() || !(!src.hasArc(arct, tar) ? ((Node)m.getImage(src)).hasArc(arct, (Node)m.getImage(tar)) : !m.getRule().isArcDeleting(src, arct, tar));
    }

    public static Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(OrdinaryMorphism morph, Object other, boolean left, boolean union) {
        return MatchHelper.getOverlappingsVector(morph, other, left, union).elements();
    }

    public static Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappingsVector(OrdinaryMorphism morph, Object other, boolean left, boolean union) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        int minGraphSize = 1;
        if (union) {
            minGraphSize = 0;
        }
        Graph left2 = null;
        if (other instanceof OrdinaryMorphism && left) {
            left2 = ((OrdinaryMorphism)other).getSource();
        } else if (other instanceof OrdinaryMorphism && !left) {
            left2 = ((OrdinaryMorphism)other).getTarget();
        } else if (other instanceof Graph) {
            left2 = (Graph)other;
        }
        if (left2 != null) {
            int sizeOfInclusions = left2.getSize();
            while (sizeOfInclusions >= minGraphSize) {
                Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlapping = MatchHelper.getOverlappings(morph, other, left, sizeOfInclusions, union);
                while (overlapping.hasMoreElements()) {
                    oSet.addElement(overlapping.nextElement());
                }
                --sizeOfInclusions;
            }
        }
        return oSet;
    }

    public static Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(OrdinaryMorphism morph, Object other, boolean left, int sizeOfInclusions, boolean union) {
        return MatchHelper.getOverlappingsVector(morph, other, left, sizeOfInclusions, union).elements();
    }

    public static Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappingsVector(OrdinaryMorphism morph, Object otherObj, boolean left, int sizeOfInclusions, boolean union) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        Graph other = null;
        if (otherObj instanceof OrdinaryMorphism && left) {
            other = ((OrdinaryMorphism)otherObj).getSource();
        } else if (otherObj instanceof OrdinaryMorphism && !left) {
            other = ((OrdinaryMorphism)otherObj).getTarget();
        } else if (otherObj instanceof Graph) {
            other = (Graph)otherObj;
        }
        if (other == null) {
            return oSet;
        }
        Vector<OrdinaryMorphism> subs = new Vector<OrdinaryMorphism>();
        Enumeration<GraphObject> itsGOs = null;
        itsGOs = left ? morph.getSource().getElements() : morph.getTarget().getElements();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        boolean nextMatch = true;
        int minGraphSize = union ? 0 : 1;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement(itsGOs.nextElement());
        }
        if (sizeOfInclusions < minGraphSize) {
            itsGOSet.clear();
            return oSet;
        }
        boolean withIsomorphicInclusions = true;
        subs = BaseFactory.theFactory().generateAllSubgraphsWithInclusionsOfSize(morph.getSource(), sizeOfInclusions, itsGOSet, subs, withIsomorphicInclusions, null, false);
        Completion_InjCSP strategy = new Completion_InjCSP();
        int j = 0;
        while (j < subs.size()) {
            OrdinaryMorphism h = subs.elementAt(j);
            Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> rulePair = BaseFactory.theFactory().constructIsomorphicRule(h);
            Rule hr = (Rule)rulePair.first;
            OrdinaryMorphism isoRHShr = (OrdinaryMorphism)((Pair)rulePair.second).second;
            Completion_InjCSP localStrategy = new Completion_InjCSP();
            Match testm = BaseFactory.theFactory().createMatch(hr, other, true, "1");
            testm.getTarget().setCompleteGraph(false);
            testm.setCompletionStrategy(localStrategy, true);
            OrdinaryMorphism rStar = null;
            Match m = null;
            nextMatch = true;
            while (nextMatch) {
                nextMatch = testm.nextCompletion();
                if (!nextMatch || (rStar = other.isomorphicCopy()) == null) continue;
                m = BaseFactory.theFactory().createMatch(hr, rStar.getTarget());
                m.doCompose(testm, rStar);
                m.adaptAttrContextValues(testm.getAttrContext());
                try {
                    OrdinaryMorphism ms = (OrdinaryMorphism)TestStep.execute(m, true);
                    if (ms == null) continue;
                    ms.getTarget().setCompleteGraph(false);
                    OrdinaryMorphism mStar = isoRHShr.compose(ms);
                    ms.dispose();
                    ms = null;
                    if (mStar != null) {
                        boolean isIsomorphic;
                        Rule r1 = null;
                        Match m1 = null;
                        Pair<OrdinaryMorphism, OrdinaryMorphism> p = null;
                        if (morph instanceof Rule) {
                            r1 = (Rule)morph;
                            m1 = BaseFactory.theFactory().createMatch(r1, mStar.getTarget());
                            m1.setCompletionStrategy(strategy, true);
                            if (!m1.nextCompletion() || !m1.isValid(true)) {
                                BaseFactory.theFactory().destroyMorphism(m1);
                                m1 = null;
                            }
                        }
                        Rule r2 = null;
                        Match m2 = null;
                        if (otherObj instanceof Rule) {
                            r2 = (Rule)otherObj;
                            m2 = BaseFactory.theFactory().createMatch(r2, mStar.getTarget());
                            m2.setCompletionStrategy(strategy, true);
                            if (!m2.nextCompletion() || !m2.isValid(true)) {
                                BaseFactory.theFactory().destroyMorphism(m2);
                                m2 = null;
                            }
                        }
                        if (morph instanceof Rule && otherObj instanceof Rule) {
                            if (m1 != null && m2 != null) {
                                p = new Pair<OrdinaryMorphism, OrdinaryMorphism>(mStar, rStar);
                                isIsomorphic = false;
                                if (!MatchHelper.isIsomorphicOverlapping(oSet, p)) {
                                    oSet.addElement(p);
                                } else {
                                    isIsomorphic = true;
                                }
                                BaseFactory.theFactory().destroyMorphism(m1);
                                m1 = null;
                                BaseFactory.theFactory().destroyMorphism(m2);
                                m2 = null;
                                if (isIsomorphic) {
                                    p = null;
                                }
                            }
                        } else if (otherObj instanceof Rule) {
                            if (m2 != null) {
                                p = new Pair<OrdinaryMorphism, OrdinaryMorphism>(mStar, rStar);
                                isIsomorphic = false;
                                if (!MatchHelper.isIsomorphicOverlapping(oSet, p)) {
                                    oSet.addElement(p);
                                } else {
                                    isIsomorphic = true;
                                }
                                BaseFactory.theFactory().destroyMorphism(m2);
                                m2 = null;
                                if (isIsomorphic) {
                                    p = null;
                                }
                            }
                        } else if (morph instanceof Rule) {
                            if (m1 != null) {
                                p = new Pair<OrdinaryMorphism, OrdinaryMorphism>(mStar, rStar);
                                isIsomorphic = false;
                                if (!MatchHelper.isIsomorphicOverlapping(oSet, p)) {
                                    oSet.addElement(p);
                                } else {
                                    isIsomorphic = true;
                                }
                                BaseFactory.theFactory().destroyMorphism(m1);
                                m1 = null;
                                if (isIsomorphic) {
                                    p = null;
                                }
                            }
                        } else {
                            p = new Pair<OrdinaryMorphism, OrdinaryMorphism>(mStar, rStar);
                            if (!MatchHelper.isIsomorphicOverlapping(oSet, p)) {
                                oSet.addElement(p);
                            } else {
                                p = null;
                            }
                        }
                        if (p != null) continue;
                        BaseFactory.theFactory().destroyMorphism(mStar);
                        mStar = null;
                        BaseFactory.theFactory().destroyMorphism(rStar);
                        rStar = null;
                        continue;
                    }
                    BaseFactory.theFactory().destroyMorphism(rStar);
                    rStar = null;
                }
                catch (TypeException ms) {
                    // empty catch block
                }
            }
            subs.removeElement(h);
            --j;
            testm.dispose();
            testm = null;
            localStrategy = null;
            OrdinaryMorphism h1 = (OrdinaryMorphism)((Pair)rulePair.second).first;
            OrdinaryMorphism h2 = (OrdinaryMorphism)((Pair)rulePair.second).second;
            Graph tmp3 = h.getSource();
            h1.dispose();
            h2.dispose();
            hr.dispose();
            h.dispose();
            tmp3.dispose();
            tmp3 = null;
            hr = null;
            h = null;
            h1 = null;
            h2 = null;
            rulePair = null;
            ++j;
        }
        MatchHelper.deleteTransientContextVariables(morph, morph.getSource());
        MatchHelper.deleteTransientContextVariables(morph, morph.getTarget());
        return oSet;
    }

    private static boolean isIsomorphicOverlapping(Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlapGraphs, Pair<OrdinaryMorphism, OrdinaryMorphism> overlapPair) {
        Graph overlapGraph = ((OrdinaryMorphism)overlapPair.first).getTarget();
        int j = 0;
        while (j < overlapGraphs.size()) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> pj = overlapGraphs.elementAt(j);
            Graph gj = ((OrdinaryMorphism)pj.first).getTarget();
            if (gj.isIsomorphicTo(overlapGraph) && ((OrdinaryMorphism)pj.first).isIsomorphicTo((OrdinaryMorphism)overlapPair.first) && ((OrdinaryMorphism)pj.second).isIsomorphicTo((OrdinaryMorphism)overlapPair.second)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static void deleteTransientContextVariables(OrdinaryMorphism morph, Graph g) {
        ValueMember valuem;
        int i;
        ValueTuple value;
        VarTuple vars = (VarTuple)morph.getAttrContext().getVariables();
        for (GraphObject graphObject : g.getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            value = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < value.getNumberOfEntries()) {
                valuem = value.getValueMemberAt(i);
                if (valuem.isTransient()) {
                    vars.getTupleType().deleteMemberAt(valuem.getExprAsText());
                    valuem.setExpr(null);
                }
                ++i;
            }
        }
        for (GraphObject graphObject : g.getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            value = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < value.getNumberOfEntries()) {
                valuem = value.getValueMemberAt(i);
                if (valuem.isTransient()) {
                    vars.getTupleType().deleteMemberAt(valuem.getExprAsText());
                    valuem.setExpr(null);
                }
                ++i;
            }
        }
    }

    public static Vector<CondMember> getConditionsOfNAC(OrdinaryMorphism nacStar, OrdinaryMorphism nac) {
        Vector<CondMember> condsNAC = new Vector<CondMember>();
        VarTuple vart = (VarTuple)nacStar.getAttrContext().getVariables();
        if (vart.getSize() == 0) {
            return condsNAC;
        }
        CondTuple condt = (CondTuple)nacStar.getAttrContext().getConditions();
        Vector<String> varNames = nac.getImage().getVariableNamesOfAttributes();
        Vector<VarMember> varsOfNAC = new Vector<VarMember>();
        int k = 0;
        while (k < vart.getSize()) {
            VarMember vm = vart.getVarMemberAt(k);
            if (varNames.contains(vm.getName()) && !varsOfNAC.contains(vm)) {
                varsOfNAC.addElement(vm);
            }
            ++k;
        }
        k = 0;
        while (k < condt.getSize()) {
            CondMember cm = condt.getCondMemberAt(k);
            Vector<String> condVars = cm.getAllVariables();
            int l = 0;
            while (l < varsOfNAC.size()) {
                VarMember vm = (VarMember)varsOfNAC.elementAt(l);
                if ((cm.getMark() == 20 || cm.getMark() == 21) && condVars.contains(vm.getName()) && !condsNAC.contains(cm)) {
                    condsNAC.addElement(cm);
                }
                ++l;
            }
            ++k;
        }
        return condsNAC;
    }

    public static Vector<CondMember> getConditionsOfPAC(OrdinaryMorphism pacStar, OrdinaryMorphism pac) {
        Vector<CondMember> condsPAC = new Vector<CondMember>();
        VarTuple vart = (VarTuple)pacStar.getAttrContext().getVariables();
        if (vart.getSize() == 0) {
            return condsPAC;
        }
        CondTuple condt = (CondTuple)pacStar.getAttrContext().getConditions();
        Vector<String> varNames = pac.getImage().getVariableNamesOfAttributes();
        Vector<VarMember> varsOfPAC = new Vector<VarMember>();
        int k = 0;
        while (k < vart.getSize()) {
            VarMember vm = vart.getVarMemberAt(k);
            if (varNames.contains(vm.getName()) && !varsOfPAC.contains(vm)) {
                varsOfPAC.addElement(vm);
            }
            ++k;
        }
        k = 0;
        while (k < condt.getSize()) {
            CondMember cm = condt.getCondMemberAt(k);
            Vector<String> condVars = cm.getAllVariables();
            int l = 0;
            while (l < varsOfPAC.size()) {
                VarMember vm = (VarMember)varsOfPAC.elementAt(l);
                if ((cm.getMark() == 30 || cm.getMark() == 31) && condVars.contains(vm.getName()) && !condsPAC.contains(cm)) {
                    condsPAC.addElement(cm);
                }
                ++l;
            }
            ++k;
        }
        return condsPAC;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAttrConditionOfNACSatisfied(NACStarMorphism nacStar, OrdinaryMorphism nac, Vector<CondMember> condsNAC) {
        ((VarTuple)nacStar.getAttrContext().getVariables()).propagateValueFromParent();
        errorMsg = "NAC  \"" + nac.getName() + "\"  failed.";
        boolean nacCondTrue = false;
        int k = 0;
        while (k < condsNAC.size()) {
            block5: {
                CondMember cm = condsNAC.elementAt(k);
                if (cm.areVariablesSet()) {
                    if (cm.isEnabled() && cm.isTrue()) {
                        nacCondTrue = true;
                        errorMsg = String.valueOf(errorMsg) + "\n(Attribute condition  [ " + cm.getExprAsText() + " ]  is satisfied.)";
                        break block5;
                    } else {
                        nacCondTrue = false;
                        break;
                    }
                }
                nacCondTrue = true;
            }
            ++k;
        }
        if (!nacCondTrue) {
            errorMsg = "";
            return false;
        }
        return true;
    }

    public static boolean isAttrConditionOfPACSatisfied(PACStarMorphism pacStar, OrdinaryMorphism pac, Vector<CondMember> condsPAC) {
        ((VarTuple)pacStar.getAttrContext().getVariables()).propagateValueFromParent();
        errorMsg = "PAC  \"" + pac.getName() + "\"  failed.";
        boolean pacCondTrue = true;
        int k = 0;
        while (k < condsPAC.size()) {
            CondMember cm = condsPAC.elementAt(k);
            if (cm.areVariablesSet() && cm.isEnabled() && !cm.isTrue()) {
                pacCondTrue = false;
                errorMsg = String.valueOf(errorMsg) + "\n(Attribute condition  [ " + cm.getExprAsText() + " ]  is not satisfied.)";
                break;
            }
            ++k;
        }
        if (pacCondTrue) {
            errorMsg = "";
        }
        return pacCondTrue;
    }

    public static final Morphism checkNACStar(NACStarMorphism aNACstar, OrdinaryMorphism nac, Match match, boolean withVars) {
        if (!MatchHelper.makePartialNACStar(aNACstar, nac, match)) {
            return null;
        }
        Morphism result = null;
        if (aNACstar.tryToApplyAttrExpr()) {
            result = !withVars ? MatchHelper.makeNACStarCompletion(aNACstar, nac, match) : MatchHelper.makeNACStarCompletionWithVars(aNACstar, nac, match);
        } else {
            errorMsg = "NAC \"" + nac.getName() + "\"  cannot be checked.\n" + "An attribute expression of it is not avaluable.";
        }
        aNACstar.resetAttrValueAsExpr();
        return result;
    }

    private static boolean makePartialNACStar(NACStarMorphism aNACstar, OrdinaryMorphism nac, Match match) {
        ((VarTuple)aNACstar.getAttrContext().getVariables()).propagateValueFromParent();
        for (GraphObject graphObject : nac.getSource().getNodesSet()) {
            GraphObject graphObject2 = nac.getImage(graphObject);
            if (graphObject2 == null) continue;
            GraphObject nacObjImg = aNACstar.getImage(graphObject2);
            if (nacObjImg != null) {
                if (nacObjImg == match.getImage(graphObject)) continue;
                return false;
            }
            try {
                aNACstar.addMapping(graphObject2, match.getImage(graphObject));
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        for (GraphObject graphObject : nac.getSource().getArcsSet()) {
            GraphObject src = ((Arc)graphObject).getSource();
            GraphObject tar = ((Arc)graphObject).getTarget();
            GraphObject nacObj = nac.getImage(graphObject);
            if (nacObj == null) continue;
            GraphObject nacObjSrc = nac.getImage(src);
            GraphObject nacObjTar = nac.getImage(tar);
            if (nacObjSrc == null || nacObjTar == null) continue;
            GraphObject nacObjImg = aNACstar.getImage(nacObj);
            if (nacObjImg != null) {
                if (nacObjImg == match.getImage(graphObject)) continue;
                return false;
            }
            try {
                aNACstar.addMapping(nacObj, match.getImage(graphObject));
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        if (aNACstar.getSize() > 0) {
            if (!aNACstar.checkConstants()) {
                return false;
            }
            aNACstar.setPartialMorphismCompletion(true);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static Morphism makeNACStarCompletion(NACStarMorphism nacStar, OrdinaryMorphism nac, Match match) {
        MatchHelper.errorMsg = "";
        result = null;
        attrCondsExist = ((CondTuple)match.getAttrContext().getConditions()).isEmpty() == false;
        condsNAC = MatchHelper.getConditionsOfNAC(nacStar, nac);
        v0 = attrCondsNacExist = condsNAC.isEmpty() == false;
        if (!nacStar.isTotal()) ** GOTO lbl24
        if (!attrCondsExist) {
            if (MatchHelper.checkConstantAttrValueFromSourceToTarget(nacStar)) {
                result = nacStar;
            }
        } else if (!attrCondsNacExist || MatchHelper.isAttrConditionOfNACSatisfied(nacStar, nac, condsNAC)) {
            result = nacStar;
        }
        MatchHelper.unsetVariablesOfNAC(match.getAttrContext(), nac);
        MatchHelper.unsetVariablesOfNAC(nacStar.getAttrContext(), nac);
        nacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return result;
lbl-1000:
        // 1 sources

        {
            if (MatchHelper.checkNACStarCodomain(nacStar, nac, match)) {
                result = nacStar;
            }
            if (result != null) {
                if (!attrCondsExist || !attrCondsNacExist || MatchHelper.isAttrConditionOfNACSatisfied(nacStar, nac, condsNAC)) break;
                result = null;
            }
            MatchHelper.unsetVariablesOfNAC(match.getAttrContext(), nac);
            MatchHelper.unsetVariablesOfNAC(nacStar.getAttrContext(), nac);
lbl24:
            // 2 sources

            ** while (nacStar.nextCompletion())
        }
lbl25:
        // 2 sources

        MatchHelper.unsetVariablesOfNAC(match.getAttrContext(), nac);
        MatchHelper.unsetVariablesOfNAC(nacStar.getAttrContext(), nac);
        nacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static Morphism makeNACStarCompletionWithVars(NACStarMorphism nacStar, OrdinaryMorphism nac, Match match) {
        MatchHelper.errorMsg = "";
        result = null;
        attrCondsExist = ((CondTuple)match.getAttrContext().getConditions()).isEmpty() == false;
        condsNAC = MatchHelper.getConditionsOfNAC(nacStar, nac);
        v0 = attrCondsNacExist = condsNAC.isEmpty() == false;
        if (!nacStar.isTotal()) ** GOTO lbl25
        result = nacStar;
        if (!attrCondsExist) {
            if (MatchHelper.checkConstantAttrValueFromSourceToTarget(nacStar)) {
                result = nacStar;
            }
        } else if (!attrCondsNacExist || MatchHelper.isAttrConditionOfNACSatisfied(nacStar, nac, condsNAC)) {
            result = nacStar;
        }
        MatchHelper.unsetVariablesOfNAC(match.getAttrContext(), nac);
        MatchHelper.unsetVariablesOfNAC(nacStar.getAttrContext(), nac);
        nacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return result;
lbl-1000:
        // 1 sources

        {
            if (MatchHelper.checkNACStarCodomain(nacStar, nac, match)) {
                result = nacStar;
            }
            if (result != null) {
                if (!attrCondsExist || !attrCondsNacExist || MatchHelper.isAttrConditionOfNACSatisfied(nacStar, nac, condsNAC)) break;
                result = null;
            }
            MatchHelper.unsetVariablesOfNAC(match.getAttrContext(), nac);
            MatchHelper.unsetVariablesOfNAC(nacStar.getAttrContext(), nac);
lbl25:
            // 2 sources

            ** while (nacStar.nextCompletion())
        }
lbl26:
        // 2 sources

        MatchHelper.unsetVariablesOfNAC(match.getAttrContext(), nac);
        MatchHelper.unsetVariablesOfNAC(nacStar.getAttrContext(), nac);
        nacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return result;
    }

    private static boolean checkNACStarCodomain(NACStarMorphism aNACstar, OrdinaryMorphism nac, Match match) {
        GraphObject nacStarImgObj;
        GraphObject graphObj;
        GraphObject leftObj;
        for (GraphObject graphObject : aNACstar.getSource().getNodesSet()) {
            if (nac.hasInverseImage(graphObject)) {
                leftObj = nac.getInverseImage(graphObject).nextElement();
                GraphObject nacStarImgObj2 = aNACstar.getImage(graphObject);
                if (nacStarImgObj2 == (graphObj = match.getImage(leftObj))) continue;
                return false;
            }
            nacStarImgObj = aNACstar.getImage(graphObject);
            if (!match.hasInverseImage(nacStarImgObj)) continue;
            return false;
        }
        for (GraphObject graphObject : aNACstar.getSource().getArcsSet()) {
            if (nac.hasInverseImage(graphObject)) {
                leftObj = nac.getInverseImage(graphObject).nextElement();
                GraphObject nacStarImgObj2 = aNACstar.getImage(graphObject);
                if (nacStarImgObj2 == (graphObj = match.getImage(leftObj))) continue;
                return false;
            }
            nacStarImgObj = aNACstar.getImage(graphObject);
            if (!match.hasInverseImage(nacStarImgObj)) continue;
            return false;
        }
        return true;
    }

    public static final Morphism checkPACStar(PACStarMorphism aPACstar, OrdinaryMorphism pac, Match match, boolean withVars) {
        if (!MatchHelper.makePartialPACStar(aPACstar, pac, match)) {
            return null;
        }
        Morphism result = null;
        if (aPACstar.tryToApplyAttrExpr()) {
            result = !withVars ? MatchHelper.makePACStarCompletion(aPACstar, pac, match) : MatchHelper.makePACStarCompletionWithVars(aPACstar, pac, match);
        } else {
            errorMsg = "PAC \"" + pac.getName() + "\"  cannot be checked.\n" + "An attribute expression of it is not avaluable.";
        }
        aPACstar.resetAttrValueAsExpr();
        return result;
    }

    private static boolean checkPACStarCodomain(PACStarMorphism aPACstar, OrdinaryMorphism pac, Match match) {
        GraphObject pacStarImgObj;
        GraphObject graphObj;
        GraphObject leftObj;
        for (GraphObject graphObject : aPACstar.getSource().getNodesSet()) {
            if (pac.getInverseImage(graphObject).hasMoreElements()) {
                leftObj = pac.getInverseImage(graphObject).nextElement();
                GraphObject pacStarImgObj2 = aPACstar.getImage(graphObject);
                if (pacStarImgObj2 == (graphObj = match.getImage(leftObj))) continue;
                return false;
            }
            pacStarImgObj = aPACstar.getImage(graphObject);
            if (!match.getInverseImage(pacStarImgObj).hasMoreElements()) continue;
            return false;
        }
        for (GraphObject graphObject : aPACstar.getSource().getArcsSet()) {
            if (pac.getInverseImage(graphObject).hasMoreElements()) {
                leftObj = pac.getInverseImage(graphObject).nextElement();
                GraphObject pacStarImgObj2 = aPACstar.getImage(graphObject);
                if (pacStarImgObj2 == (graphObj = match.getImage(leftObj))) continue;
                return false;
            }
            pacStarImgObj = aPACstar.getImage(graphObject);
            if (!match.getInverseImage(pacStarImgObj).hasMoreElements()) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static Morphism makePACStarCompletion(PACStarMorphism pacStar, OrdinaryMorphism pac, Match match) {
        MatchHelper.errorMsg = "";
        result = null;
        attrCondsExist = ((CondTuple)match.getAttrContext().getConditions()).isEmpty() == false;
        condsPAC = MatchHelper.getConditionsOfPAC(pacStar, pac);
        v0 = attrCondsPacExist = condsPAC.isEmpty() == false;
        if (!pacStar.isTotal()) ** GOTO lbl24
        if (!attrCondsExist) {
            if (MatchHelper.checkConstantAttrValueFromSourceToTarget(pacStar)) {
                result = pacStar;
            }
        } else if (!attrCondsPacExist || MatchHelper.isAttrConditionOfPACSatisfied(pacStar, pac, condsPAC)) {
            result = pacStar;
        }
        MatchHelper.unsetVariablesOfPAC(match.getAttrContext(), pac);
        MatchHelper.unsetVariablesOfPAC(pacStar.getAttrContext(), pac);
        pacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return result;
lbl-1000:
        // 1 sources

        {
            if (MatchHelper.checkPACStarCodomain(pacStar, pac, match)) {
                result = pacStar;
            }
            if (result != null) {
                if (!attrCondsExist || !attrCondsPacExist || MatchHelper.isAttrConditionOfPACSatisfied(pacStar, pac, condsPAC)) break;
                result = null;
            }
            MatchHelper.unsetVariablesOfPAC(match.getAttrContext(), pac);
            MatchHelper.unsetVariablesOfPAC(pacStar.getAttrContext(), pac);
lbl24:
            // 2 sources

            ** while (pacStar.nextCompletion())
        }
lbl25:
        // 2 sources

        MatchHelper.unsetVariablesOfPAC(match.getAttrContext(), pac);
        MatchHelper.unsetVariablesOfPAC(pacStar.getAttrContext(), pac);
        pacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static Morphism makePACStarCompletionWithVars(PACStarMorphism pacStar, OrdinaryMorphism pac, Match match) {
        MatchHelper.errorMsg = "";
        result = null;
        attrCondsExist = ((CondTuple)match.getAttrContext().getConditions()).isEmpty() == false;
        condsPAC = MatchHelper.getConditionsOfPAC(pacStar, pac);
        v0 = attrCondsPacExist = condsPAC.isEmpty() == false;
        if (!pacStar.isTotal()) ** GOTO lbl25
        result = pacStar;
        if (!attrCondsExist) {
            if (MatchHelper.checkConstantAttrValueFromSourceToTarget(pacStar)) {
                result = pacStar;
            }
        } else if (!attrCondsPacExist || MatchHelper.isAttrConditionOfPACSatisfied(pacStar, pac, condsPAC)) {
            result = pacStar;
        }
        MatchHelper.unsetVariablesOfPAC(match.getAttrContext(), pac);
        MatchHelper.unsetVariablesOfPAC(pacStar.getAttrContext(), pac);
        pacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return null;
lbl-1000:
        // 1 sources

        {
            if (MatchHelper.checkPACStarCodomain(pacStar, pac, match)) {
                result = pacStar;
            }
            if (result != null) {
                if (!attrCondsExist || !attrCondsPacExist || MatchHelper.isAttrConditionOfPACSatisfied(pacStar, pac, condsPAC)) break;
                result = null;
            }
            MatchHelper.unsetVariablesOfPAC(match.getAttrContext(), pac);
            MatchHelper.unsetVariablesOfPAC(pacStar.getAttrContext(), pac);
lbl25:
            // 2 sources

            ** while (pacStar.nextCompletion())
        }
lbl26:
        // 2 sources

        MatchHelper.unsetVariablesOfPAC(match.getAttrContext(), pac);
        MatchHelper.unsetVariablesOfPAC(pacStar.getAttrContext(), pac);
        pacStar.propagateValueFromParentAsInputParameter((VarTuple)match.getAttrContext().getVariables(), false);
        return result;
    }

    private static boolean makePartialPACStar(PACStarMorphism aPACstar, OrdinaryMorphism pac, Match match) {
        ((VarTuple)aPACstar.getAttrContext().getVariables()).propagateValueFromParent();
        for (GraphObject graphObject : pac.getSource().getNodesSet()) {
            GraphObject graphObject2 = pac.getImage(graphObject);
            if (graphObject2 == null) continue;
            GraphObject pacObjImg = aPACstar.getImage(graphObject2);
            if (pacObjImg != null) {
                if (pacObjImg == match.getImage(graphObject)) continue;
                return false;
            }
            try {
                aPACstar.addMapping(graphObject2, match.getImage(graphObject));
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        for (GraphObject graphObject : pac.getSource().getArcsSet()) {
            GraphObject src = ((Arc)graphObject).getSource();
            GraphObject tar = ((Arc)graphObject).getTarget();
            GraphObject pacObj = pac.getImage(graphObject);
            if (pacObj == null) continue;
            GraphObject pacObjSrc = pac.getImage(src);
            GraphObject pacObjTar = pac.getImage(tar);
            if (pacObjSrc == null || pacObjTar == null) continue;
            GraphObject pacObjImg = aPACstar.getImage(pacObj);
            if (pacObjImg != null) {
                if (pacObjImg == match.getImage(graphObject)) continue;
                return false;
            }
            try {
                aPACstar.addMapping(pacObj, match.getImage(graphObject));
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        if (aPACstar.getSize() > 0) {
            if (!aPACstar.checkConstants()) {
                return false;
            }
            aPACstar.setPartialMorphismCompletion(true);
        }
        return true;
    }

    protected static void unsetVariablesOfNAC(AttrContext attrContext, OrdinaryMorphism nac) {
        VarTuple vars = (VarTuple)attrContext.getVariables();
        Vector<String> nacVars = nac.getTarget().getVariableNamesOfAttributes();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember vm = vars.getVarMemberAt(i);
            if (nacVars.contains(vm.getName()) && vm.getMark() == 2 && !vm.isInputParameter()) {
                ((ContextView)attrContext).removeValue(vm.getName());
            }
            ++i;
        }
    }

    protected static void unsetVariablesOfPAC(AttrContext attrContext, OrdinaryMorphism pac) {
        VarTuple vars = (VarTuple)attrContext.getVariables();
        Vector<String> pacVars = pac.getTarget().getVariableNamesOfAttributes();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember vm = vars.getVarMemberAt(i);
            if (pacVars.contains(vm.getName()) && vm.getMark() == 3 && !vm.isInputParameter()) {
                ((ContextView)attrContext).removeValue(vm.getName());
            }
            ++i;
        }
    }

    public static NACStarMorphism createNACstar(OrdinaryMorphism nac, Match match) {
        NACStarMorphism aNACstar = new NACStarMorphism(nac.getImage(), match.getImage(), match.getAttrManager().newContext(1, match.getAttrContext()), match);
        aNACstar.itsNAC = nac;
        aNACstar.setName("NACstar");
        Completion_InjCSP strat = new Completion_InjCSP();
        aNACstar.setCompletionStrategy(strat, true);
        return aNACstar;
    }

    public static NACStarMorphism createNACstar(OrdinaryMorphism nac, Match match, boolean withVars) {
        if (withVars) {
            ContextView attrcontxt = (ContextView)match.getAttrManager().newContext(0, match.getAttrContext());
            attrcontxt.setVariableContext(true);
            ((ContextView)((CondTuple)attrcontxt.getConditions()).getContext()).setVariableContext(true);
            NACStarMorphism aNACstar = new NACStarMorphism(nac.getImage(), match.getImage(), attrcontxt, match);
            aNACstar.itsNAC = nac;
            aNACstar.setName("NACstar");
            Completion_InjCSP strat = new Completion_InjCSP();
            aNACstar.setCompletionStrategy(strat, true);
            return aNACstar;
        }
        return MatchHelper.createNACstar(nac, match);
    }

    public static PACStarMorphism createPACstar(OrdinaryMorphism pac, Match match) {
        PACStarMorphism aPACstar = new PACStarMorphism(pac.getImage(), match.getImage(), match.getAttrManager().newContext(1, match.getAttrContext()), match);
        aPACstar.itsPAC = pac;
        aPACstar.setName("PACstar");
        Completion_InjCSP strat = new Completion_InjCSP();
        aPACstar.setCompletionStrategy(strat, true);
        return aPACstar;
    }

    public static PACStarMorphism createPACstar(OrdinaryMorphism pac, Match match, boolean withVars) {
        if (withVars) {
            ContextView attrcontxt = (ContextView)match.getAttrManager().newContext(0, match.getAttrContext());
            attrcontxt.setVariableContext(true);
            ((ContextView)((CondTuple)attrcontxt.getConditions()).getContext()).setVariableContext(true);
            PACStarMorphism aPACstar = new PACStarMorphism(pac.getImage(), match.getImage(), attrcontxt, match);
            aPACstar.itsPAC = pac;
            aPACstar.setName("PACstar");
            Completion_InjCSP strat = new Completion_InjCSP();
            aPACstar.setCompletionStrategy(strat, true);
            return aPACstar;
        }
        return MatchHelper.createPACstar(pac, match);
    }

    public static PACStarMorphism createNestedACstar(NestedApplCond ac, OrdinaryMorphism relMorph) {
        PACStarMorphism star = new PACStarMorphism(ac.getImage(), relMorph.getImage(), relMorph.getAttrManager().newContext(1, relMorph.getAttrContext()), relMorph);
        star.itsPAC = ac;
        star.setName("NestedACstar");
        Completion_InjCSP strat = new Completion_InjCSP();
        star.setCompletionStrategy(strat, true);
        return star;
    }

    public static final Morphism checkGACStar(PACStarMorphism acStar, NestedApplCond acMorph, OrdinaryMorphism relatedMorph, boolean withVars) {
        if (!MatchHelper.makePartialNestedACStar(acStar, acMorph, relatedMorph)) {
            return null;
        }
        Morphism result = null;
        if (acStar.tryToApplyAttrExpr()) {
            result = MatchHelper.makeGACStarCompletion(acStar, acMorph, relatedMorph);
        } else {
            errorMsg = "Appl Cond \"" + acMorph.getName() + "\"  cannot be checked.\n" + "An attribute expression of it is not avaluable.";
        }
        acStar.resetAttrValueAsExpr();
        return result;
    }

    private static boolean makePartialNestedACStar(PACStarMorphism acStar, OrdinaryMorphism ac, OrdinaryMorphism match) {
        ((VarTuple)acStar.getAttrContext().getVariables()).propagateValueFromParent();
        for (GraphObject graphObject : ac.getSource().getNodesSet()) {
            GraphObject graphObject2 = ac.getImage(graphObject);
            if (graphObject2 == null) continue;
            GraphObject pacObjImg = acStar.getImage(graphObject2);
            if (pacObjImg != null) {
                if (pacObjImg == match.getImage(graphObject)) continue;
                return false;
            }
            try {
                acStar.addMapping(graphObject2, match.getImage(graphObject));
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        for (GraphObject graphObject : ac.getSource().getArcsSet()) {
            GraphObject src = ((Arc)graphObject).getSource();
            GraphObject tar = ((Arc)graphObject).getTarget();
            GraphObject pacObj = ac.getImage(graphObject);
            if (pacObj == null) continue;
            GraphObject pacObjSrc = ac.getImage(src);
            GraphObject pacObjTar = ac.getImage(tar);
            if (pacObjSrc == null || pacObjTar == null) continue;
            GraphObject pacObjImg = acStar.getImage(pacObj);
            if (pacObjImg != null) {
                if (pacObjImg == match.getImage(graphObject)) continue;
                return false;
            }
            try {
                acStar.addMapping(pacObj, match.getImage(graphObject));
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        if (acStar.getSize() > 0) {
            if (!acStar.checkConstants()) {
                return false;
            }
            acStar.setPartialMorphismCompletion(true);
        }
        return true;
    }

    private static Morphism makeGACStarCompletion(PACStarMorphism acStar, NestedApplCond acMorph, OrdinaryMorphism relatedMorph) {
        boolean attrCondsACexist;
        errorMsg = "";
        PACStarMorphism result = null;
        Vector<CondMember> condsAC = MatchHelper.getConditionsOfNestedAC(acStar, acMorph);
        boolean bl = attrCondsACexist = !condsAC.isEmpty();
        if (acStar.isTotal()) {
            if (MatchHelper.checkConstantAttrValueFromSourceToTarget(acStar) && (!attrCondsACexist || MatchHelper.isAttrConditionOfNestedACSatisfied(acStar, acMorph, condsAC))) {
                acMorph.setCoMorphism(acStar);
                if (acMorph.evalFormula(relatedMorph.getTarget())) {
                    result = acStar;
                } else {
                    result = null;
                    acMorph.setCoMorphism(null);
                }
            }
            MatchHelper.unsetVariablesOfNestedAC(relatedMorph.getAttrContext(), acMorph);
            MatchHelper.unsetVariablesOfNestedAC(acStar.getAttrContext(), acMorph);
            acStar.propagateValueFromParentAsInputParameter((VarTuple)relatedMorph.getAttrContext().getVariables(), false);
            return result;
        }
        boolean complFound = false;
        while (acStar.nextCompletion()) {
            if (!MatchHelper.checkGACStarCodomain(acStar, acMorph)) continue;
            if (!attrCondsACexist || MatchHelper.isAttrConditionOfNestedACSatisfied(acStar, acMorph, condsAC)) {
                complFound = true;
                acMorph.setCoMorphism(acStar);
                if (acMorph.evalFormula(acStar.getTarget())) {
                    result = acStar;
                    acMorph.setCoMorphism(result);
                    if (!acMorph.forall) {
                        break;
                    }
                } else {
                    result = null;
                    acMorph.setCoMorphism(null);
                    if (acMorph.forall) break;
                }
            }
            MatchHelper.unsetVariablesOfNestedAC(relatedMorph.getAttrContext(), acMorph);
            MatchHelper.unsetVariablesOfNestedAC(acStar.getAttrContext(), acMorph);
        }
        MatchHelper.unsetVariablesOfNestedAC(relatedMorph.getAttrContext(), acMorph);
        MatchHelper.unsetVariablesOfNestedAC(acStar.getAttrContext(), acMorph);
        acStar.propagateValueFromParentAsInputParameter((VarTuple)relatedMorph.getAttrContext().getVariables(), false);
        if (!complFound && acMorph.forall) {
            result = acStar;
        }
        return result;
    }

    public static Vector<CondMember> getConditionsOfNestedAC(OrdinaryMorphism acStar, OrdinaryMorphism ac) {
        Vector<CondMember> condsAC = new Vector<CondMember>();
        VarTuple vart = (VarTuple)acStar.getAttrContext().getVariables();
        if (vart.getSize() == 0) {
            return condsAC;
        }
        CondTuple condt = (CondTuple)acStar.getAttrContext().getConditions();
        Vector<String> varNames = ac.getImage().getVariableNamesOfAttributes();
        Vector<VarMember> varsOfAC = new Vector<VarMember>();
        int k = 0;
        while (k < vart.getSize()) {
            VarMember vm = vart.getVarMemberAt(k);
            if (varNames.contains(vm.getName()) && !varsOfAC.contains(vm)) {
                varsOfAC.addElement(vm);
            }
            ++k;
        }
        k = 0;
        while (k < condt.getSize()) {
            CondMember cm = condt.getCondMemberAt(k);
            Vector<String> condVars = cm.getAllVariables();
            int l = 0;
            while (l < varsOfAC.size()) {
                VarMember vm = (VarMember)varsOfAC.elementAt(l);
                if ((cm.getMark() == 30 || cm.getMark() == 31 || cm.getMark() == 20 || cm.getMark() == 21) && condVars.contains(vm.getName()) && !condsAC.contains(cm)) {
                    condsAC.addElement(cm);
                }
                ++l;
            }
            ++k;
        }
        return condsAC;
    }

    public static boolean isAttrConditionOfNestedACSatisfied(PACStarMorphism acStar, OrdinaryMorphism ac, Vector<CondMember> condsAC) {
        ((VarTuple)acStar.getAttrContext().getVariables()).propagateValueFromParent();
        errorMsg = "Appl Cond  \"" + ac.getName() + "\"  failed.";
        boolean acCondTrue = true;
        int k = 0;
        while (k < condsAC.size()) {
            CondMember cm = condsAC.elementAt(k);
            if (cm.areVariablesSet() && cm.isEnabled() && !cm.isTrue()) {
                acCondTrue = false;
                errorMsg = String.valueOf(errorMsg) + "\n(Attribute condition  [ " + cm.getExprAsText() + " ]  is not satisfied.)";
                break;
            }
            ++k;
        }
        if (acCondTrue) {
            errorMsg = "";
        }
        return acCondTrue;
    }

    private static boolean checkACStarCodomain(PACStarMorphism acStar, OrdinaryMorphism acMorph, OrdinaryMorphism match) {
        GraphObject graphObj;
        GraphObject acStarImgObj;
        GraphObject leftObj;
        for (GraphObject graphObject : acStar.getSource().getNodesSet()) {
            if (acMorph.getInverseImage(graphObject).hasMoreElements()) {
                leftObj = acMorph.getInverseImage(graphObject).nextElement();
                acStarImgObj = acStar.getImage(graphObject);
                if (acStarImgObj == (graphObj = match.getImage(leftObj))) continue;
                return false;
            }
            GraphObject acStarImgObj2 = acStar.getImage(graphObject);
            if (!match.getInverseImage(acStarImgObj2).hasMoreElements()) continue;
            return false;
        }
        for (GraphObject graphObject : acStar.getSource().getArcsSet()) {
            if (!acMorph.getInverseImage(graphObject).hasMoreElements()) continue;
            leftObj = acMorph.getInverseImage(graphObject).nextElement();
            acStarImgObj = acStar.getImage(graphObject);
            if (acStarImgObj == (graphObj = match.getImage(leftObj))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkElemOfNestedCodomain(GraphObject go, NestedApplCond acMorph, PACStarMorphism acStar) {
        if (acMorph.getRelatedMorphism().getCodomainObjects().contains(acStar.getImage(go))) {
            return false;
        }
        NestedApplCond p = acMorph.getParent();
        while (p != null) {
            if (p.getRelatedMorphism().getCodomainObjects().contains(acStar.getImage(go))) {
                return false;
            }
            p = p.getParent();
        }
        return true;
    }

    private static boolean checkGACStarCodomain(PACStarMorphism acStar, NestedApplCond acMorph) {
        boolean result = true;
        Iterator<Node> elems = acMorph.getTarget().getNodesSet().iterator();
        while (elems.hasNext() && result) {
            GraphObject go = elems.next();
            if (acMorph.getInverseImage(go).hasMoreElements()) continue;
            result = MatchHelper.checkElemOfNestedCodomain(go, acMorph, acStar);
        }
        Iterator<Arc> elems1 = acMorph.getTarget().getArcsSet().iterator();
        while (elems1.hasNext() && result) {
            GraphObject go = elems1.next();
            if (acMorph.getInverseImage(go).hasMoreElements()) continue;
            result = MatchHelper.checkElemOfNestedCodomain(go, acMorph, acStar);
        }
        return result;
    }

    protected static void unsetVariablesOfNestedAC(AttrContext attrContext, OrdinaryMorphism ac) {
        VarTuple vars = (VarTuple)attrContext.getVariables();
        Vector<String> acVars = ac.getTarget().getVariableNamesOfAttributes();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember vm = vars.getVarMemberAt(i);
            if (acVars.contains(vm.getName()) && (vm.getMark() == 3 || vm.getMark() == 2) && !vm.isInputParameter()) {
                ((ContextView)attrContext).removeValue(vm.getName());
            }
            ++i;
        }
    }
}

