/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.OrderedSet;
import agg.util.csp.BinaryConstraint;
import agg.util.csp.BinaryPredicate;
import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SearchStrategy;
import agg.util.csp.SimpleVariableOrder;
import agg.util.csp.Variable;
import java.util.Enumeration;
import java.util.Vector;

public class Search_BreadthFirst
implements SearchStrategy {
    private static BinaryPredicate theirVariableOrder = new SimpleVariableOrder();

    @Override
    public final Vector<Query> execute(CSP csp) {
        Vector<Query> aQueryResult = new Vector<Query>();
        OrderedSet<Variable> allVarsLeft = new OrderedSet<Variable>(theirVariableOrder);
        Enumeration<Variable> anEnum = csp.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = anEnum.nextElement();
            if (aVar.getInstance() != null) continue;
            allVarsLeft.add(aVar);
        }
        Vector<Query> aQueryList = this.bfs(new OrderedSet<Variable>(theirVariableOrder), allVarsLeft);
        if (aQueryList != null) {
            for (Query aQuery : aQueryList) {
                if (aQuery == null || aQuery.getTarget() == null) continue;
                aQuery.getTarget().setInstance(null);
                aQueryResult.addElement(aQuery);
            }
        }
        return aQueryResult;
    }

    private final Vector<Query> bfs(OrderedSet<Variable> breadthvars, OrderedSet<Variable> varsleft) {
        if (!breadthvars.isEmpty()) {
            Vector<Query> aQueryList = new Vector<Query>();
            OrderedSet<Variable> aVarSet = new OrderedSet<Variable>(theirVariableOrder);
            Enumeration en = breadthvars.elements();
            while (en.hasMoreElements()) {
                Variable aVar = (Variable)en.nextElement();
                Query q = this.getBestQuery(aVar);
                aQueryList.add(q);
                varsleft.remove(aVar);
                aVar.setInstance(this);
                OrderedSet<Variable> vic = this.getVicinity(aVar, varsleft);
                if (vic == null) continue;
                aVarSet = aVarSet.union(vic);
            }
            Vector<Query> aVicQueryList = this.bfs(aVarSet, varsleft);
            if (aVicQueryList != null && !aVicQueryList.isEmpty()) {
                aQueryList.addAll(aVicQueryList);
            }
            return aQueryList;
        }
        if (varsleft.isEmpty()) {
            return null;
        }
        Variable aVar = this.getBestVar(varsleft);
        breadthvars.add(aVar);
        return this.bfs(breadthvars, varsleft);
    }

    /*
     * Unable to fully structure code
     */
    private final Query getBestQuery(Variable var) {
        anEnum = var.getIncomingQueries();
        aBestQuery = null;
        aBestSize = -1;
        while (anEnum.hasMoreElements()) {
            aBestQuery = (Query)anEnum.nextElement();
            if (!aBestQuery.isApplicable()) continue;
            aBestSize = aBestQuery.getSize();
            break;
        }
        if (aBestSize != -1) ** GOTO lbl16
        return null;
lbl-1000:
        // 1 sources

        {
            aQuery = (Query)anEnum.nextElement();
            aSize = aQuery.getSize();
            if (!aQuery.isApplicable() || aSize >= aBestSize) continue;
            aBestSize = aSize;
            aBestQuery = aQuery;
lbl16:
            // 3 sources

            ** while (anEnum.hasMoreElements())
        }
lbl17:
        // 1 sources

        return aBestQuery;
    }

    private final OrderedSet<Variable> getVicinity(Variable v, OrderedSet<Variable> varsleft) {
        OrderedSet<Variable> aVicinity = null;
        Enumeration<?> allConstraints = v.getConstraints();
        while (allConstraints.hasMoreElements()) {
            Variable aVar = this.getOtherVariable((BinaryConstraint)allConstraints.nextElement(), v);
            if (varsleft.indexOf(aVar, 0) == -1) continue;
            if (aVicinity == null) {
                aVicinity = new OrderedSet<Variable>(theirVariableOrder);
            }
            aVicinity.add(aVar);
        }
        return aVicinity;
    }

    private final Variable getBestVar(OrderedSet<Variable> vars) {
        vars.start();
        Variable v = vars.get();
        while (v.getKind() != 1 && vars.hasNext()) {
            v = vars.get();
        }
        return v;
    }

    private final Variable getOtherVariable(BinaryConstraint bc, Variable v) {
        return v.equals(bc.getVar1()) ? bc.getVar2() : bc.getVar1();
    }
}

