/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.editor.impl.EdRule;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import javax.swing.tree.DefaultMutableTreeNode;

public class MultiRuleTreeNodeData
extends GraGraTreeNodeDataAdapter {
    private Object data;
    private EdRule eRule;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public MultiRuleTreeNodeData(EdRule rule) {
        this.setRule(rule);
    }

    public MultiRuleTreeNodeData(String s) {
        this.data = s;
        this.string = s;
    }

    public MultiRuleTreeNodeData(Object obj) {
        if (obj instanceof EdRule) {
            this.setRule((EdRule)obj);
        } else if (obj instanceof String) {
            new MultiRuleTreeNodeData((String)obj);
        }
    }

    private void setRule(EdRule rule) {
        this.data = rule;
        this.string = !rule.getBasisRule().isEnabled() ? "[D]" + rule.getBasisRule().getName() : rule.getBasisRule().getName();
        this.eRule = rule;
    }

    @Override
    public void dispose() {
        this.data = null;
        this.eRule = null;
        this.string = null;
        this.treeNode = null;
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof EdRule) {
            this.setRule((EdRule)obj);
        } else if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
            this.eRule = null;
        } else {
            this.data = null;
            this.eRule = null;
            this.string = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        this.string = newString = str.replaceAll(" ", "");
        String newRuleName = "";
        String sD = "";
        if (!this.eRule.getBasisRule().isEnabled()) {
            sD = "[D]";
        }
        if (newString.indexOf("[D]") != -1) {
            newString = newString.substring(3, newString.length());
        }
        newRuleName = newString;
        if (!this.eRule.getBasisRule().getName().equals(newRuleName)) {
            this.eRule.getBasisRule().setName(newRuleName);
            this.eRule.getGraGra().setChanged(true);
        }
        this.string = String.valueOf(sD) + this.eRule.getBasisRule().getName();
    }

    @Override
    public void setString(String tag, String newString) {
        if (tag.equals("[]")) {
            tag = "";
        }
        this.string = String.valueOf(tag) + newString;
        if (!this.eRule.getBasisRule().getName().equals(newString)) {
            this.eRule.getBasisRule().setName(newString);
            this.eRule.getGraGra().setChanged(true);
        }
    }

    @Override
    public void setString(String tag, String tag1, String newString) {
        if (tag.equals("[]")) {
            tag = "";
        }
        if (tag1.equals("[]")) {
            tag1 = "";
        }
        this.string = String.valueOf(tag) + tag1 + newString;
        if (!this.eRule.getBasisRule().getName().equals(newString)) {
            this.eRule.getGraGra().setChanged(true);
        }
        this.eRule.getBasisRule().setName(newString);
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string();
    }

    @Override
    public EdRule getRule() {
        return this.eRule;
    }

    @Override
    public EdRule getMultiRule() {
        return this.eRule;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public boolean isMultiRule() {
        return true;
    }

    @Override
    public boolean isRule() {
        return true;
    }

    @Override
    public String getToolTipText() {
        String toolTipText = "Multi rule of rule scheme";
        if (!this.eRule.getBasisRule().getTextualComment().equals("")) {
            toolTipText = " " + this.eRule.getBasisRule().getTextualComment();
        }
        return toolTipText;
    }
}

