/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.icons;

import agg.editor.impl.Line;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColorDotLineIcon
implements Icon {
    Color color;
    boolean filled;

    public ColorDotLineIcon(Color c) {
        this.color = c;
    }

    public ColorDotLineIcon(Color c, boolean bold) {
        this.color = c;
        this.filled = bold;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        Line line = new Line(x, y + 7, x + 20, y + 7);
        line.setColor(this.color);
        if (this.filled) {
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            line.drawColorDotLine(g, 1, 3);
        } else {
            line.drawColorDotLine(g, 1, 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public int getIconWidth() {
        return 20;
    }

    @Override
    public int getIconHeight() {
        return 14;
    }
}

