/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrInstance;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.view.AttrViewEvent;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdType;
import agg.editor.impl.NodeReprData;
import agg.gui.editor.EditorConstants;
import agg.gui.editor.GraphPanel;
import agg.layout.evolutionary.LayoutNode;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.TypeException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.undo.StateEditable;

public class EdNode
extends EdGraphObject
implements AttrViewObserver,
XMLObject,
StateEditable {
    private Node bNode;
    private LayoutNode lNode;
    private int nodeid;
    private Vector<Integer> cluster;
    private Vector<Integer> oldcluster;
    private Color ownColor = null;

    public EdNode(Node bNode, EdType eType) {
        super(eType);
        this.bNode = bNode;
        if (this.bNode != null) {
            this.contextUsage = String.valueOf(this.hashCode());
            if (this.bNode.getAttribute() != null) {
                this.addToAttributeViewObserver();
            }
        }
        this.lNode = new LayoutNode(this);
        this.nodeid = -1;
        this.x = 100;
        this.y = 100;
        this.w = 20;
        this.h = 20;
    }

    public EdNode(Graph bGraph, EdType eType) throws TypeException {
        this(bGraph != null ? bGraph.createNode(eType.bType) : null, eType);
    }

    @Override
    public void dispose() {
        if (this.attrObserver) {
            this.removeFromAttributeViewObserver();
        }
        this.view = null;
        if (this.lNode != null) {
            this.lNode.dispose();
        }
        this.lNode = null;
        this.eGraph = null;
        this.eType = null;
        this.bNode = null;
        this.myGraphPanel = null;
    }

    public void finalize() {
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        NodeReprData data = new NodeReprData(this);
        state.put(this.hashCode(), data);
        state.put(data.hashCode(), data);
        this.itsUndoReprDataHC = data.hashCode();
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        NodeReprData data = (NodeReprData)state.get(this.hashCode());
        if (data == null) {
            data = (NodeReprData)state.get(this.itsUndoReprDataHC);
        }
        if (data != null) {
            data.restoreNodeFromNodeRepr(this);
            this.attrChanged = false;
        }
    }

    public void restoreState(Hashtable<?, ?> state, String hashCode) {
        NodeReprData data = (NodeReprData)state.get(Integer.valueOf(hashCode));
        if (data == null) {
            data = (NodeReprData)state.get(this.itsUndoReprDataHC);
        }
        if (data == null) {
            data = (NodeReprData)state.get(this.hashCode());
        }
        if (data != null) {
            data.restoreNodeFromNodeRepr(this);
            this.attrChanged = false;
        }
    }

    public void restoreState(NodeReprData data) {
        data.restoreNodeFromNodeRepr(this);
        this.attrChanged = false;
    }

    @Override
    protected AttrViewSetting getView() {
        if (!this.init || this.view == null) {
            this.view = ((AttrTupleManager)AttrTupleManager.getDefaultManager()).getDefaultOpenView();
            this.view.setVisible(this.bNode.getAttribute());
            this.init = true;
        }
        return this.view;
    }

    @Override
    public void setAttrViewSetting(AttrViewSetting aView) {
        this.view = aView;
        if (!this.attrObserver) {
            this.view.addObserver(this, this.bNode.getAttribute());
            this.attrObserver = true;
        }
        this.init = true;
    }

    public void addToAttributeViewObserver() {
        this.getView().addObserver(this, this.bNode.getAttribute());
        this.attrObserver = true;
    }

    @Override
    public void removeFromAttributeViewObserver() {
        if (this.view != null && this.bNode != null && this.bNode.getAttribute() != null) {
            this.view.removeObserver(this, this.bNode.getAttribute());
            this.view.getMaskedView().removeObserver(this, this.bNode.getAttribute());
        }
    }

    public void createAttributeInstance() {
        if (this.bNode != null && this.bNode.getAttribute() == null) {
            this.bNode.createAttributeInstance();
            this.addToAttributeViewObserver();
        }
    }

    @Override
    public void refreshAttributeInstance() {
        if (this.bNode != null && this.bNode.getAttribute() != null) {
            ((ValueTuple)this.bNode.getAttribute()).getTupleType().refreshParents();
            this.addToAttributeViewObserver();
        }
    }

    public LayoutNode getLNode() {
        return this.lNode;
    }

    public Node getBasisNode() {
        return this.bNode;
    }

    @Override
    public GraphObject getBasisObject() {
        return this.bNode;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isArc() {
        return false;
    }

    @Override
    public void setCritical(boolean b) {
        this.bNode.setCritical(b);
    }

    @Override
    public boolean isCritical() {
        return this.bNode.isCritical();
    }

    @Override
    public void setDrawingStyleOfCriticalObject(int criticalStyle) {
        this.criticalStyle = criticalStyle;
    }

    @Override
    public boolean isVisible() {
        if (this.bNode != null) {
            this.visible = this.bNode.isVisible();
            if (this.getContext().getBasisGraph().isCompleteGraph()) {
                this.visible = this.visible && this.getType().getBasisType().isObjectOfTypeGraphNodeVisible();
            }
            return this.visible;
        }
        return this.visible;
    }

    @Override
    public EdNode getNode() {
        return this;
    }

    @Override
    public EdArc getArc() {
        return null;
    }

    public int getInArcsCount() {
        return this.bNode.getIncomingArcsSet().size();
    }

    public int getOutArcsCount() {
        return this.bNode.getOutgoingArcsSet().size();
    }

    public int getInOutArcsCount() {
        return this.bNode.getOutgoingArcsSet().size() + this.bNode.getIncomingArcsSet().size();
    }

    public int getLoopArcsCount() {
        int c = 0;
        Iterator<Arc> e = this.bNode.getOutgoingArcsSet().iterator();
        while (e.hasNext()) {
            if (!e.next().isLoop()) continue;
            ++c;
        }
        return c;
    }

    @Override
    public Vector<Vector<String>> getAttributes() {
        Vector<Vector<String>> attrs = new Vector<Vector<String>>();
        if (this.bNode != null) {
            AttrInstance attributes = this.bNode.getAttribute();
            if (attributes != null && this.getView() != null) {
                AttrViewSetting mvs = this.view.getMaskedView();
                int number = mvs.getSize(attributes);
                int i = 0;
                while (i < number) {
                    Vector<String> tmpAttrVector = new Vector<String>(3);
                    int index = mvs.convertSlotToIndex(attributes, i);
                    DeclMember currentMember = (DeclMember)attributes.getType().getMemberAt(index);
                    if (!(this.elemOfTG && currentMember != null && currentMember.getHoldingTuple() != attributes.getType() || "".equals(attributes.getTypeAsString(index)) || "".equals(attributes.getNameAsString(index)))) {
                        tmpAttrVector.addElement(attributes.getTypeAsString(index));
                        tmpAttrVector.addElement(attributes.getNameAsString(index));
                        tmpAttrVector.addElement(attributes.getValueAsString(index));
                        attrs.addElement(tmpAttrVector);
                    }
                    ++i;
                }
            } else {
                attrs = this.setAttributes(this.bNode);
            }
        }
        return attrs;
    }

    public Vector<Vector<String>> setAttributes(Node bNode) {
        Vector<Vector<String>> attrs = new Vector<Vector<String>>();
        if (bNode == null) {
            return attrs;
        }
        if (bNode.getAttribute() == null) {
            return attrs;
        }
        int nattrs = bNode.getAttribute().getNumberOfEntries();
        if (nattrs != 0) {
            int i = 0;
            while (i < nattrs) {
                Vector<String> attr = new Vector<String>();
                attr.addElement(bNode.getAttribute().getTypeAsString(i));
                attr.addElement(bNode.getAttribute().getNameAsString(i));
                attr.addElement(bNode.getAttribute().getValueAsString(i));
                attrs.addElement(attr);
                ++i;
            }
        }
        return attrs;
    }

    @Override
    public Vector<Vector<String>> setAttributes(GraphObject obj) {
        return this.setAttributes((Node)obj);
    }

    public void setBasisNode(Node bNode) {
        this.bNode = bNode;
    }

    public void changeBasisNode(Node newNode) {
        this.bNode = newNode;
    }

    public void setReps(int nX, int nY, boolean nVisible, boolean nSelect) {
        this.setXY(nX, nY);
        this.setVisible(nVisible);
        this.setSelected(nSelect);
    }

    public EdNode copy() {
        EdNode newNode = new EdNode(this.bNode, this.eType);
        newNode.myGraphPanel = this.myGraphPanel;
        newNode.x = this.x;
        newNode.y = this.y;
        newNode.w = this.w;
        newNode.h = this.h;
        return newNode;
    }

    @Override
    public boolean inside(int X, int Y) {
        Rectangle r = new Rectangle(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
        return r.contains(X, Y);
    }

    public void applyScale(double scale) {
        if (scale != this.itsScale) {
            this.setX((int)((double)this.x / this.itsScale * scale));
            this.setY((int)((double)this.y / this.itsScale * scale));
            this.itsScale = scale;
        }
    }

    public void drawShadowGraphic(Graphics grs) {
        if (this.visible) {
            Graphics2D g = (Graphics2D)grs;
            Color lastColor = g.getColor();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(Color.LIGHT_GRAY);
            g.setStroke(EditorConstants.defaultStroke);
            g.draw(new Rectangle2D.Double(this.x - 10, this.y - 10, 20.0, 20.0));
            g.setFont(EditorConstants.defaultFont);
            g.setPaint(lastColor);
        }
    }

    @Override
    public void drawGraphic(Graphics grs) {
        if (!this.visible || this.bNode == null || this.bNode.getType() == null) {
            return;
        }
        this.criticalStyle = this.eGraph.criticalStyle;
        Graphics2D g = (Graphics2D)grs;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(EditorConstants.defaultStroke);
        Color lastColor = g.getColor();
        this.myUpdate(g.getFontMetrics());
        if (this.getType().isIconable()) {
            String fname = this.getType().imageFileName;
            URL url = ClassLoader.getSystemClassLoader().getResource(fname);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                if (this.selected) {
                    g.setPaint(EditorConstants.selectColor);
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2 - 2, this.y - this.h / 2 - 2, this.w + 4, this.h + 4));
                } else if (this.isCritical()) {
                    if (this.criticalStyle == 0) {
                        g.setPaint(EditorConstants.criticalColor);
                        g.setStroke(EditorConstants.criticalStroke);
                        g.draw(new Rectangle2D.Double(this.x - this.w / 2 - 2, this.y - this.h / 2 - 2, this.w + 4, this.h + 4));
                    } else {
                        g.setPaint(Color.BLACK);
                        g.setStroke(EditorConstants.criticalStroke);
                        g.draw(new Rectangle2D.Double(this.x - this.w / 2 - 2, this.y - this.h / 2 - 2, this.w + 4, this.h + 4));
                    }
                }
                g.setPaint(this.getColor());
                g.drawImage(icon.getImage(), this.x - this.w / 2, this.y - this.h / 2, null);
                return;
            }
        }
        if (this.backgroundColor != null && this.backgroundColor != Color.white) {
            g.setPaint(this.backgroundColor);
            g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w + 6, this.h + 6));
        }
        int sh = this.getShape();
        boolean hiddenObjOfType = this.eGraph.isTypeGraph() && !this.eType.getBasisType().isObjectOfTypeGraphNodeVisible();
        switch (sh) {
            case 51: {
                if (this.selected) {
                    g.setPaint(EditorConstants.selectColor);
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    g.setPaint(this.getColor());
                    g.draw(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    break;
                }
                if (this.weakselected) {
                    g.setPaint(Color.white);
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    g.setPaint(EditorConstants.weakselectColor);
                    g.draw(new Rectangle2D.Double(this.x - this.w / 2 - 1, this.y - this.h / 2 - 1, this.w + 2, this.h + 2));
                    g.draw(new Rectangle2D.Double(this.x - this.w / 2 + 1, this.y - this.h / 2 + 1, this.w - 2, this.h - 2));
                    g.setPaint(this.getColor());
                    g.draw(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    break;
                }
                if (hiddenObjOfType) {
                    g.setPaint(EditorConstants.hideColor);
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    g.setPaint(this.getColor());
                    g.draw(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    break;
                }
                if (this.isCritical()) {
                    if (this.criticalStyle == 0) {
                        if (this.eType.filled) {
                            g.setPaint(this.getColor());
                        } else {
                            g.setPaint(Color.white);
                        }
                        g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                        g.setPaint(EditorConstants.criticalColor);
                        g.setStroke(EditorConstants.criticalStroke);
                        g.setFont(EditorConstants.criticalFont);
                        g.draw(new Rectangle2D.Double(this.x - this.w / 2 - 4, this.y - this.h / 2 - 4, this.w + 8, this.h + 8));
                        if (!this.eType.filled) break;
                        g.setPaint(Color.white);
                        break;
                    }
                    g.setPaint(Color.BLACK);
                    g.setStroke(EditorConstants.criticalStroke);
                    g.draw(new Rectangle2D.Double(this.x - this.w / 2 - 2, this.y - this.h / 2 - 2, this.w + 4, this.h + 4));
                    break;
                }
                if (this.ownColor != null) {
                    g.setPaint(this.ownColor);
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    g.setPaint(Color.white);
                    break;
                }
                if (this.eType.filled) {
                    g.setPaint(this.getColor());
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                    g.setPaint(Color.white);
                    break;
                }
                g.setPaint(Color.white);
                g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                g.setPaint(this.getColor());
                g.draw(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                break;
            }
            case 54: {
                if (this.selected) {
                    g.setPaint(EditorConstants.selectColor);
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    g.setPaint(this.getColor());
                    g.drawRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    break;
                }
                if (this.weakselected) {
                    g.setPaint(Color.white);
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    g.setPaint(EditorConstants.weakselectColor);
                    g.drawRoundRect(this.x - this.w / 2 - 1, this.y - this.h / 2 - 1, this.w + 2, this.h + 2, 10, 10);
                    g.drawRoundRect(this.x - this.w / 2 + 1, this.y - this.h / 2 + 1, this.w - 2, this.h - 2, 10, 10);
                    g.setPaint(this.getColor());
                    g.drawRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    break;
                }
                if (hiddenObjOfType) {
                    g.setPaint(EditorConstants.hideColor);
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    g.setPaint(this.getColor());
                    g.drawRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    break;
                }
                if (this.isCritical()) {
                    if (this.criticalStyle == 0) {
                        if (this.eType.filled) {
                            g.setPaint(this.getColor());
                        } else {
                            g.setPaint(Color.white);
                        }
                        g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                        g.setPaint(EditorConstants.criticalColor);
                        g.setStroke(EditorConstants.criticalStroke);
                        g.setFont(EditorConstants.criticalFont);
                        g.drawRoundRect(this.x - this.w / 2 - 4, this.y - this.h / 2 - 4, this.w + 8, this.h + 8, 10, 10);
                        if (!this.eType.filled) break;
                        g.setPaint(Color.white);
                        break;
                    }
                    g.setStroke(EditorConstants.criticalStroke);
                    g.setPaint(Color.BLACK);
                    g.drawRoundRect(this.x - this.w / 2 - 2, this.y - this.h / 2 - 2, this.w + 4, this.h + 4, 10, 10);
                    break;
                }
                if (this.ownColor != null) {
                    g.setPaint(this.ownColor);
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    g.setPaint(Color.white);
                    break;
                }
                if (this.eType.filled) {
                    g.setPaint(this.getColor());
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                    g.setPaint(Color.white);
                    break;
                }
                g.setPaint(Color.white);
                g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                g.setPaint(this.getColor());
                g.drawRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                break;
            }
            case 52: {
                int d = this.w - 2;
                if (this.selected) {
                    g.setPaint(EditorConstants.selectColor);
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                    g.setPaint(this.getColor());
                    g.drawOval(this.x - d / 2, this.y - d / 2, d, d);
                    break;
                }
                if (this.weakselected) {
                    g.setPaint(Color.white);
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                    g.setPaint(EditorConstants.weakselectColor);
                    g.drawOval(this.x - d / 2 - 1, this.y - d / 2 - 1, d + 2, d + 2);
                    g.drawOval(this.x - d / 2 + 1, this.y - d / 2 + 1, d - 2, d - 2);
                    g.setPaint(this.getColor());
                    g.drawOval(this.x - d / 2, this.y - d / 2, d, d);
                    break;
                }
                if (hiddenObjOfType) {
                    g.setPaint(EditorConstants.hideColor);
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                    g.setPaint(this.getColor());
                    g.drawOval(this.x - d / 2, this.y - d / 2, d, d);
                    break;
                }
                if (this.isCritical()) {
                    if (this.criticalStyle == 0) {
                        if (this.eType.filled) {
                            g.setPaint(this.getColor());
                        } else {
                            g.setPaint(Color.white);
                        }
                        g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                        g.setPaint(EditorConstants.criticalColor);
                        g.setStroke(EditorConstants.criticalStroke);
                        g.setFont(EditorConstants.criticalFont);
                        g.drawOval(this.x - d / 2 - 4, this.y - d / 2 - 4, d + 8, d + 8);
                        if (!this.eType.filled) break;
                        g.setPaint(Color.white);
                        break;
                    }
                    g.setStroke(EditorConstants.criticalStroke);
                    g.setPaint(Color.BLACK);
                    g.drawOval(this.x - d / 2 - 2, this.y - d / 2 - 2, d + 4, d + 4);
                    break;
                }
                if (this.ownColor != null) {
                    g.setPaint(this.ownColor);
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                    g.setPaint(Color.white);
                    break;
                }
                if (this.eType.filled) {
                    g.setPaint(this.getColor());
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                    g.setPaint(Color.white);
                    break;
                }
                g.setPaint(Color.white);
                g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                g.setPaint(this.getColor());
                g.drawOval(this.x - d / 2, this.y - d / 2, d, d);
                break;
            }
            case 53: {
                int d = this.w - 2;
                if (this.selected) {
                    g.setPaint(EditorConstants.selectColor);
                    g.fillOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    g.setPaint(this.getColor());
                    g.drawOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    break;
                }
                if (this.weakselected) {
                    g.setPaint(Color.white);
                    g.fillOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    g.setPaint(EditorConstants.weakselectColor);
                    g.drawOval(this.x - d / 2 - 1, this.y - this.h / 2 - 1, d + 2, this.h + 2);
                    g.drawOval(this.x - d / 2 + 1, this.y - this.h / 2 + 1, d - 2, this.h - 2);
                    g.setPaint(this.getColor());
                    g.drawOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    break;
                }
                if (hiddenObjOfType) {
                    g.setPaint(EditorConstants.hideColor);
                    g.fillOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    g.setPaint(this.getColor());
                    g.drawOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    break;
                }
                if (this.isCritical()) {
                    if (this.criticalStyle == 0) {
                        if (this.eType.filled) {
                            g.setPaint(this.getColor());
                        } else {
                            g.setPaint(Color.white);
                        }
                        g.fillOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                        g.setPaint(EditorConstants.criticalColor);
                        g.setStroke(EditorConstants.criticalStroke);
                        g.setFont(EditorConstants.criticalFont);
                        g.drawOval(this.x - d / 2 - 4, this.y - this.h / 2 - 4, d + 8, this.h + 8);
                        if (!this.eType.filled) break;
                        g.setPaint(Color.white);
                        break;
                    }
                    if (this.criticalStyle != 1) break;
                    g.setStroke(EditorConstants.criticalStroke);
                    g.setPaint(Color.BLACK);
                    g.drawOval(this.x - d / 2 - 2, this.y - this.h / 2 - 2, d + 4, this.h + 4);
                    break;
                }
                if (this.ownColor != null) {
                    g.setPaint(this.ownColor);
                    g.fillOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    g.setPaint(Color.white);
                    break;
                }
                if (this.eType.filled) {
                    g.setPaint(this.getColor());
                    g.fillOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                    g.setPaint(Color.white);
                    break;
                }
                g.setPaint(Color.white);
                g.fillOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                g.setPaint(this.getColor());
                g.drawOval(this.x - d / 2, this.y - this.h / 2, d, this.h);
                break;
            }
        }
        if (this.errorMode) {
            g.setPaint(Color.green);
        }
        if (this.bNode.getType().isAbstract()) {
            g.setFont(new Font("Dialog", 2, g.getFont().getSize()));
        }
        g.setStroke(EditorConstants.defaultStroke);
        this.drawText(g, this.x, this.y);
        g.setFont(EditorConstants.defaultFont);
        g.setPaint(lastColor);
    }

    public void myUpdate(FontMetrics fm) {
        this.prepareGraphics(fm);
    }

    public void eraseGraphic(Graphics grs) {
        Color c = grs.getColor();
        grs.setColor(Color.white);
        grs.fillRect(this.x - this.w / 2 - 1, this.y - this.h / 2 - 1, this.w + 2, this.h + 2);
        grs.setColor(c);
    }

    @Override
    public void attributeChanged(AttrViewEvent ev) {
        if (ev.getID() == 0 || ev.getID() == 60 || ev.getID() == 50 || ev.getID() == 20 || ev.getID() == 220 || ev.getID() == 210) {
            if (ev.getSource().getTupleType().isValid()) {
                this.attrChanged = true;
            }
        } else if (ev.getID() == 80 || ev.getID() == 70) {
            if (ev.getSource().isValid()) {
                ValueMember val;
                this.attrChanged = true;
                if (this.myGraphPanel != null && this.myGraphPanel.isAttrEditorActivated() && this.bNode.getContext().getAttrContext() != null && (val = ((ValueTuple)this.bNode.getAttribute()).getValueMemberAt(ev.getIndex())).isSet() && val.getExpr().isVariable()) {
                    ContextView viewContext = (ContextView)((ValueTuple)val.getHoldingTuple()).getContext();
                    VarTuple variable = (VarTuple)viewContext.getVariables();
                    VarMember var = variable.getVarMemberAt(val.getExprAsText());
                    if (var == null) {
                        return;
                    }
                    if (this.bNode.getContext().isNacGraph()) {
                        var.setMark(2);
                    } else if (this.bNode.getContext().isPacGraph()) {
                        var.setMark(3);
                    } else if (viewContext.doesAllowComplexExpressions()) {
                        var.setMark(1);
                    } else {
                        var.setMark(0);
                    }
                }
            } else {
                ValueTuple attr = (ValueTuple)this.bNode.getAttribute();
                int i = 0;
                while (i < attr.getSize()) {
                    ValueMember am = (ValueMember)attr.getMemberAt(i);
                    if (!am.isValid()) break;
                    ++i;
                }
            }
        }
    }

    @Override
    public void setGraphPanel(GraphPanel gp) {
        this.myGraphPanel = gp;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.getX() - this.getWidth() / 2, this.getY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
    }

    private void prepareGraphics(FontMetrics fm) {
        int w1;
        int h1 = this.getTextHeight(fm) + 4;
        if (h1 < 20) {
            h1 = 20;
        }
        if ((w1 = this.getTextWidth(fm) + 6) < 20) {
            w1 = h1;
        }
        this.setWidth(w1);
        this.setHeight(h1);
        if (this.getType().isIconable()) {
            String fname = this.getType().imageFileName;
            URL url = ClassLoader.getSystemClassLoader().getResource(fname);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                h1 = icon.getIconHeight();
                w1 = icon.getIconWidth();
                this.setWidth(w1);
                this.setHeight(h1);
                return;
            }
        }
        int sh = this.getShape();
        switch (sh) {
            case 51: {
                break;
            }
            case 54: {
                break;
            }
            case 52: {
                int d1 = (int)Math.sqrt((double)(this.w * this.w) + (double)(this.h * this.h));
                int d2 = this.w;
                if (this.h > this.w) {
                    d2 = this.h;
                }
                int d = (d1 + d2) / 2;
                this.setWidth(d);
                this.setHeight(d);
                break;
            }
            case 53: {
                int hor = 0;
                int ver = 0;
                hor = (int)Math.sqrt((double)(this.w * this.w) + (double)(this.h * this.h));
                if (this.w == this.h) {
                    ver = hor - hor / 4;
                } else if (this.h > this.w) {
                    ver = hor;
                    hor = ver + ver / 4;
                } else if (this.w > this.h) {
                    ver = hor - hor / 4;
                }
                this.setWidth(hor);
                this.setHeight(ver);
                break;
            }
        }
    }

    protected String getMultiplicityString() {
        String s = "";
        int min = this.bNode.getType().getSourceMin();
        int max = this.bNode.getType().getSourceMax();
        if (min != -1) {
            s = s.concat(String.valueOf(min));
            s = s.concat("..");
            if (max == -1) {
                s = s.concat("*");
            }
        } else {
            s = max != -1 ? s.concat("0..") : "*";
        }
        if (max != -1) {
            s = min != max ? s.concat(String.valueOf(max)) : String.valueOf(max);
        }
        return s;
    }

    private void drawText(Graphics grs, int centerX, int centerY) {
        int ty1;
        int tx1;
        Graphics2D g = (Graphics2D)grs;
        boolean underlined = false;
        FontMetrics fm = g.getFontMetrics();
        int tw = this.getTextWidth(fm);
        int th = this.getTextHeight(fm);
        int tx = centerX - tw / 2;
        int ty = centerY - th / 2;
        String typeStr = this.getTypeString();
        if (this.elemOfTG) {
            String multiplicityStr;
            if (this.bNode.getType().isAbstract()) {
                typeStr = !typeStr.equals("") ? "{" + typeStr + "}" : "{ }";
            }
            if (!(multiplicityStr = this.getMultiplicityString()).equals("")) {
                tx1 = centerX + tw / 2 - fm.stringWidth(multiplicityStr);
                ty1 = ty + fm.getHeight() / 2 + fm.getDescent() / 2;
                g.drawString(multiplicityStr, tx1, ty1);
            }
        }
        if (!typeStr.equals("")) {
            tx1 = tx;
            ty1 = ty + (fm.getHeight() - fm.getDescent());
            g.drawString(typeStr, tx1, ty1);
            ty += fm.getHeight();
        } else {
            ty = ty + fm.getHeight() + fm.getDescent() / 4;
        }
        if (g.getFont().getSize() < 8 || !this.attrVisible) {
            return;
        }
        Vector<Vector<String>> attrs = this.getAttributes();
        if (attrs != null && !attrs.isEmpty()) {
            int i = 0;
            while (i < attrs.size()) {
                String attrStr;
                Vector<String> attr = attrs.elementAt(i);
                if (!this.elemOfTG && attr.elementAt(2).length() != 0) {
                    attrStr = attr.elementAt(1);
                    attrStr = String.valueOf(attr.elementAt(1)) + "=";
                    attrStr = String.valueOf(attrStr) + attr.elementAt(2);
                    if (!underlined) {
                        g.drawLine(tx, ty, tx + tw, ty);
                        underlined = true;
                    }
                    ty1 = ty + (fm.getHeight() - fm.getDescent());
                    g.drawString(attrStr, tx, ty1);
                    ty += fm.getHeight();
                } else if (this.elemOfTG && attr.elementAt(1) != null) {
                    attrStr = attr.elementAt(0);
                    attrStr = String.valueOf(attrStr) + "  ";
                    attrStr = String.valueOf(attrStr) + attr.elementAt(1);
                    if (attr.elementAt(2).length() != 0) {
                        attrStr = String.valueOf(attrStr) + "=" + attr.elementAt(2);
                    }
                    if (!underlined) {
                        g.drawLine(tx, ty, tx + tw, ty);
                        underlined = true;
                    }
                    ty1 = ty + (fm.getHeight() - fm.getDescent());
                    g.drawString(attrStr, tx, ty1);
                    ty += fm.getHeight();
                }
                ++i;
            }
        }
    }

    public void drawNameAttrOnly(Graphics grs) {
        if (!this.visible) {
            return;
        }
        this.criticalStyle = this.eGraph.criticalStyle;
        Graphics2D g = (Graphics2D)grs;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(2.0f));
        this.updateNameAttrOnly(g.getFontMetrics());
        g.setPaint(Color.white);
        g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
        g.setPaint(this.getColor());
        g.drawRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
        this.showNameAttrOnly(g, this.x, this.y);
        g.setStroke(EditorConstants.defaultStroke);
    }

    public void updateNameAttrOnly(FontMetrics fm) {
        Vector<Vector<String>> attrs = this.getAttributes();
        int nn = 1;
        int h1 = 0;
        h1 = fm == null ? 17 : fm.getHeight();
        if (h1 < 20) {
            h1 = 30;
        }
        nn = 6;
        int w1 = 0;
        if (attrs != null) {
            int i = 0;
            while (i < attrs.size()) {
                Vector<String> attr = attrs.elementAt(i);
                if (attr.elementAt(1).equals("name") && attr.elementAt(2).length() != 0) {
                    String tstStr = attr.elementAt(2);
                    w1 = fm == null ? nn * tstStr.length() + 6 : fm.stringWidth(tstStr) + 6;
                }
                ++i;
            }
        }
        if (w1 < 20) {
            w1 = h1;
        }
        this.setWidth(w1);
        this.setHeight(h1);
    }

    private void showNameAttrOnly(Graphics grs, int centerX, int centerY) {
        Graphics2D g = (Graphics2D)grs;
        g.setStroke(new BasicStroke(2.0f));
        FontMetrics fm = g.getFontMetrics();
        Vector<Vector<String>> attrs = this.getAttributes();
        int th = this.getHeight();
        int tw = this.getWidth();
        int tx = centerX - tw / 2 + 9;
        int ty = centerY - th / 2 + 5;
        ty += fm.getHeight();
        if (attrs != null && !attrs.isEmpty()) {
            int i = 0;
            while (i < attrs.size()) {
                Vector<String> attr = attrs.elementAt(i);
                if (attr.elementAt(1).equals("name") && attr.elementAt(2).length() != 0) {
                    String attrStr = attr.elementAt(2);
                    g.drawString(attrStr.substring(1, attrStr.length() - 1), tx, ty);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void XwriteObject(XMLHelper xmlh) {
        if (xmlh.openObject(this.bNode, this)) {
            xmlh.openSubTag("NodeLayout");
            int outX = (int)((double)this.x / this.itsScale);
            int outY = (int)((double)this.y / this.itsScale);
            xmlh.addAttr("X", outX);
            xmlh.addAttr("Y", outY);
            xmlh.close();
            if (this.lNode != null) {
                xmlh.addObject("", this.lNode, true);
            }
            xmlh.close();
        }
    }

    @Override
    public void XreadObject(XMLHelper xmlh) {
        xmlh.peekObject(this.bNode, this);
        if (xmlh.readSubTag("NodeLayout")) {
            this.hasDefaultLayout = true;
            String s = xmlh.readAttr("X");
            this.x = s.length() == 0 ? 20 : new Integer(s);
            s = xmlh.readAttr("Y");
            this.y = s.length() == 0 ? 20 : new Integer(s);
            xmlh.close();
        } else {
            this.x = 20;
            this.y = 20;
        }
        xmlh.enrichObject(this.lNode);
        xmlh.close();
        if (this.bNode.xyAttr && this.getContext().getBasisGraph().isCompleteGraph()) {
            ValueMember yattr;
            ValueMember xattr = ((ValueTuple)this.bNode.getAttribute()).getValueMemberAt("thisX");
            if (!xattr.isSet()) {
                ((ValueTuple)this.bNode.getAttribute()).getValueMemberAt("thisX").setExprAsObject(this.x);
            }
            if (!(yattr = ((ValueTuple)this.bNode.getAttribute()).getValueMemberAt("thisY")).isSet()) {
                ((ValueTuple)this.bNode.getAttribute()).getValueMemberAt("thisY").setExprAsObject(this.y);
            }
        }
        this.attrVisible = true;
        this.attrChanged = false;
    }

    public boolean equalByBasisNode(EdNode enode) {
        return this.getBasisNode().equals(enode.getBasisNode());
    }

    public int isInVectorByBasisNode(List<EdNode> enodes) {
        int ret = -1;
        int i = 0;
        while (i < enodes.size()) {
            EdNode node = enodes.get(i);
            if (this.getNodeID() == node.getNodeID()) {
                ret = i;
                break;
            }
            ++i;
        }
        return ret;
    }

    public void setNodeID(int id) {
        this.nodeid = id;
    }

    public void setOwnColor(Color c) {
        this.ownColor = c;
    }

    public Color getOwnColor() {
        return this.ownColor;
    }

    public int getNodeID() {
        return this.nodeid;
    }

    public void setCluster(Vector<Integer> clus) {
        this.cluster = new Vector<Integer>(clus);
    }

    public Vector<Integer> getCluster() {
        return this.cluster;
    }

    public void calculateCluster(int epsilon, List<EdNode> nodes) {
        this.oldcluster = this.cluster;
        this.cluster = new Vector();
        int i = 0;
        while (i < nodes.size()) {
            int ydist;
            int xdist;
            int dist;
            EdNode node = nodes.get(i);
            if (!this.equals(node) && (dist = (int)Math.round(Math.sqrt((xdist = Math.abs(node.getX() - this.getX())) * xdist + (ydist = Math.abs(node.getY() - this.getY())) * ydist))) <= epsilon) {
                this.cluster.addElement(new Integer(node.getNodeID()));
            }
            ++i;
        }
    }

    public Vector<Integer> getOldCluster() {
        return this.oldcluster;
    }
}

