/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.cons.Formula;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ConstraintLayer {
    private Hashtable<Object, Object> constraintLayer;
    private Enumeration<Formula> constraints;
    private Vector<Formula> constraintsVec;

    public ConstraintLayer(Enumeration<Formula> constraints) {
        this.constraints = constraints;
        this.constraintsVec = new Vector(0);
        while (this.constraints.hasMoreElements()) {
            this.constraintsVec.addElement(constraints.nextElement());
        }
        this.initConstraintLayer();
    }

    public ConstraintLayer(List<Formula> constraints) {
        this.constraintsVec = new Vector(0);
        int i = 0;
        while (i < constraints.size()) {
            this.constraintsVec.add(constraints.get(i));
            ++i;
        }
        this.constraints = this.constraintsVec.elements();
        this.initConstraintLayer();
    }

    public ConstraintLayer(Vector<Formula> constraints) {
        this.constraintsVec = constraints;
        this.constraints = this.constraintsVec.elements();
        this.initConstraintLayer();
    }

    public void addLayer(Formula constraint, int layer) {
        constraint.addLayer(layer);
        this.constraintLayer.put(constraint, constraint.getLayer());
    }

    private void initConstraintLayer() {
        this.constraintLayer = new Hashtable();
        int i = 0;
        while (i < this.constraintsVec.size()) {
            Formula constraint = this.constraintsVec.elementAt(i);
            if (constraint instanceof Formula) {
                Vector<Integer> layer = constraint.getLayer();
                if (layer != null) {
                    this.constraintLayer.put(constraint, layer);
                }
            } else if (constraint instanceof String) {
                this.constraintLayer.put(constraint, 0);
            }
            ++i;
        }
    }

    public Hashtable<Object, Object> getConstraintLayer() {
        return this.constraintLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration<Object> keys = this.getConstraintLayer().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Vector layer = (Vector)this.getConstraintLayer().get(key);
            if (layer == null) continue;
            if (layer.isEmpty()) {
                startLayer = 0;
                result = 0;
                continue;
            }
            Integer l = (Integer)layer.get(0);
            if (l >= startLayer) continue;
            startLayer = l;
            result = l;
        }
        return result;
    }

    public Hashtable<Integer, HashSet<Object>> invertLayer() {
        Hashtable<Integer, HashSet<Object>> inverted = new Hashtable<Integer, HashSet<Object>>();
        Enumeration<Object> keys = this.constraintLayer.keys();
        while (keys.hasMoreElements()) {
            HashSet<Object> invertedValue;
            Object key = keys.nextElement();
            Vector layer = (Vector)this.constraintLayer.get(key);
            if (layer == null) continue;
            Integer l = 0;
            if (!layer.isEmpty()) {
                l = (Integer)layer.get(0);
            }
            if ((invertedValue = inverted.get(l)) == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(l, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Formula:\t\tLayer:\n";
        Enumeration<Object> keys = this.constraintLayer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            resultString = String.valueOf(resultString) + ((Formula)key).getName() + "\t\t";
            Vector valueVec = (Vector)this.constraintLayer.get(key);
            int i = 0;
            while (i < valueVec.size()) {
                Integer value = (Integer)valueVec.get(i);
                resultString = String.valueOf(resultString) + value.toString() + "  ";
                ++i;
            }
            resultString = String.valueOf(resultString) + "\n";
        }
        return resultString;
    }
}

