/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrInstanceMember;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.SymbolTable;
import agg.attribute.handler.impl.javaExpr.JexExpr;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.parser.javaExpr.ASTExpression;
import agg.attribute.parser.javaExpr.ASTPrimaryExpression;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.cons.AtomConstraint;
import agg.cons.Evaluable;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.TypeException;
import agg.xt_basis.csp.Completion_CSP;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AtomApplCond
implements Evaluable {
    private int old_tick;
    private boolean old_val;
    private AtomConstraint itsAtomConstraint;
    private OrdinaryMorphism cond;
    private OrdinaryMorphism po_t;
    private OrdinaryMorphism po_q;
    private Vector<AtomApplCond> equivalents;
    private int n;
    private final BaseFactory bf = BaseFactory.theFactory();

    public AtomApplCond() {
        this.init(null, null, null);
    }

    public AtomApplCond(AtomConstraint itsSource, OrdinaryMorphism x, OrdinaryMorphism pot, OrdinaryMorphism poq) {
        this.itsAtomConstraint = itsSource;
        this.init(x, pot, poq);
        this.equivalents = this.createEquivalents();
    }

    private void init(OrdinaryMorphism x, OrdinaryMorphism pot, OrdinaryMorphism poq) {
        this.cond = x;
        this.po_t = pot;
        this.po_q = poq;
        this.old_tick = -1;
        this.old_val = false;
    }

    @Override
    public boolean eval(Object o) {
        return this.eval(o, -1);
    }

    @Override
    public boolean eval(Object o, int tick) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = this.eval((Pair)o);
        return this.old_val;
    }

    @Override
    public boolean eval(Object o, boolean negation) {
        return this.eval(o, -1, negation);
    }

    @Override
    public boolean eval(Object o, int tick, boolean negation) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = this.eval((Pair)o, negation);
        return this.old_val;
    }

    public Graph getBase() {
        if (this.cond == null) {
            return null;
        }
        return this.cond.getOriginal();
    }

    public Graph getPre() {
        if (this.cond == null) {
            return null;
        }
        return this.cond.getImage();
    }

    public void setPreCondition(OrdinaryMorphism x) {
        this.cond = x;
    }

    public void setPoMorphs(OrdinaryMorphism pot, OrdinaryMorphism poq) {
        this.po_t = pot;
        this.po_q = poq;
    }

    public OrdinaryMorphism getPreCondition() {
        return this.cond;
    }

    public OrdinaryMorphism getT() {
        return this.po_t;
    }

    public OrdinaryMorphism getQ() {
        return this.po_q;
    }

    public AtomConstraint getSourceAtomConstraint() {
        return this.itsAtomConstraint;
    }

    public Vector<AtomApplCond> getEquivalents() {
        return this.equivalents;
    }

    public boolean isValid() {
        return this.cond != null && this.po_t != null && this.po_q != null && this.cond.isTotal() && this.getPre() == this.po_t.getOriginal() && this.po_t.getImage() == this.po_q.getImage();
    }

    private boolean isEvaluable(VarTuple vars, CondMember condMem, Graph g) {
        boolean result = true;
        Vector<String> varnames = g.getVariableNamesOfAttributes();
        if (condMem.isEnabled() && !condMem.isEvaluable(vars)) {
            Vector<String> condVars = condMem.getAllVariables();
            int j = 0;
            while (j < condVars.size()) {
                String vn = condVars.elementAt(j);
                if (!vars.getVarMemberAt(vn).isSet() && varnames.contains(vn)) {
                    result = false;
                    break;
                }
                ++j;
            }
        }
        return result;
    }

    private boolean eval(Pair<?, ?> pair) {
        return this.eval(pair, false);
    }

    private boolean eval(Pair<?, ?> pair, boolean negation) {
        OrdinaryMorphism co_match = (OrdinaryMorphism)pair.first;
        Match orig_match = (Match)((OrdinaryMorphism)pair.second);
        if (co_match == null || orig_match == null || !this.getBase().equals(co_match.getOriginal())) {
            return false;
        }
        Graph H = co_match.getImage();
        Graph S = this.getPre();
        AttrContext ac = orig_match.getAttrContext();
        this.declareVariables(ac, S);
        OrdinaryMorphism p_morph = this.bf.createMorphism(S, H, true);
        p_morph.unsetOriginalAttrsIfExpression();
        OrdinaryMorphism p = this.bf.createMatchfromMorph(p_morph, ac);
        Completion_InjCSP strategy1 = new Completion_InjCSP();
        p.setCompletionStrategy(strategy1, true);
        this.declareConditions(p.getAttrContext(), this.getT().getAttrContext().getConditions());
        p.removeUnusedVariableOfAttrContext();
        p.disableUnusedAttrCondition();
        OrdinaryMorphism f = null;
        OrdinaryMorphism fmatch = null;
        OrdinaryMorphism check = null;
        boolean premiseOK = false;
        boolean conclusionOK = false;
        boolean found = false;
        this.n = 0;
        while (!found && p.nextCompletionWithConstantsChecking()) {
            Vector<String> testVars;
            check = this.cond.compose(p);
            premiseOK = check.isIsomorphicTo(co_match);
            this.bf.destroyMorphism(check);
            if (!premiseOK) continue;
            this.renameVariableInCondition(p);
            premiseOK = this.checkAttrCondition(p);
            if (!premiseOK) continue;
            ++this.n;
            found = false;
            conclusionOK = false;
            if (f == null) {
                f = p.completeDiagram(this.po_t);
            } else {
                f.clear();
                f.setSource(this.po_t.getImage());
                if (!p.completeDiagram(this.po_t, f)) {
                    f = null;
                }
            }
            if (f == null) continue;
            Completion_CSP strategy2 = new Completion_CSP(true);
            if (fmatch == null) {
                fmatch = this.bf.createMorphfromMorph(f, orig_match.getAttrContext());
                fmatch.setCompletionStrategy(strategy2, true);
            } else {
                fmatch.clear();
                if (this.bf.createMatchfromMorph(f, fmatch, orig_match.getAttrContext())) {
                    fmatch.getCompletionStrategy().initialize(fmatch);
                } else {
                    fmatch = null;
                }
            }
            if (fmatch == null) continue;
            ac = fmatch.getAttrContext();
            if (!fmatch.isTotal()) {
                while (fmatch.nextCompletionWithConstantsChecking()) {
                    conclusionOK = this.checkConclusionMatchStructure(fmatch);
                    if (!conclusionOK) continue;
                    this.renameVariableInCondition(fmatch);
                    Vector<String> helpVars = new Vector<String>();
                    testVars = new Vector();
                    this.setValueToVariable(fmatch, this.getT().getImage(), helpVars, testVars);
                    this.declareConditions(fmatch.getAttrContext(), this.getT().getAttrContext().getConditions());
                    this.markUsedVariables(fmatch);
                    this.markAttrConditions(fmatch.getAttrContext());
                    conclusionOK = this.checkAttrCondition(fmatch);
                    this.unsetVariable((VarTuple)fmatch.getAttrContext().getVariables(), helpVars, testVars);
                    found = conclusionOK;
                    if (!found) {
                        continue;
                    }
                    break;
                }
            } else {
                conclusionOK = this.checkConclusionMatchStructure(fmatch);
                conclusionOK = fmatch.checkConstants();
                if (conclusionOK) {
                    Vector<String> helpVars = new Vector<String>();
                    testVars = new Vector<String>();
                    this.setValueToVariable(fmatch, this.getT().getImage(), helpVars, testVars);
                    this.declareConditions(fmatch.getAttrContext(), this.getT().getAttrContext().getConditions());
                    this.markUsedVariables(fmatch);
                    this.markAttrConditions(fmatch.getAttrContext());
                    conclusionOK = this.checkAttrCondition(fmatch);
                    this.unsetVariable((VarTuple)fmatch.getAttrContext().getVariables(), helpVars, testVars);
                    found = conclusionOK;
                }
            }
            f.clear();
            fmatch.clear();
            if (found) continue;
            int l = 0;
            while (l < this.equivalents.size() && !found) {
                AtomApplCond eq = this.equivalents.elementAt(l);
                if (eq.eval(pair, negation)) {
                    found = true;
                }
                ++l;
            }
        }
        p.enableUnusedAttrCondition();
        if (this.n == 0) {
            found = true;
        }
        this.bf.destroyMorphism(p);
        this.bf.destroyMorphism(p_morph);
        this.bf.destroyMorphism(f);
        this.bf.destroyMorphism(fmatch);
        this.bf.destroyMorphism(check);
        return found;
    }

    private boolean checkAttrCondition(OrdinaryMorphism morph) {
        boolean result = true;
        VarTuple vars = (VarTuple)morph.getAttrContext().getVariables();
        AttrConditionTuple condTuple = morph.getAttrContext().getConditions();
        int k = 0;
        while (k < condTuple.getNumberOfEntries()) {
            CondMember condMem = (CondMember)condTuple.getMemberAt(k);
            if (condMem.isEnabled()) {
                if (!condMem.isDefinite() || condMem.isTrue() || !this.isEvaluable(vars, condMem, morph.getSource())) {
                    result = true;
                } else {
                    result = false;
                    break;
                }
            }
            ++k;
        }
        return result;
    }

    private boolean checkConclusionMatchStructure(OrdinaryMorphism conclMatch) {
        OrdinaryMorphism check1;
        boolean conclusionOK;
        if (!conclMatch.isInjective()) {
            boolean ok = true;
            Enumeration<GraphObject> conclMatchCodom = conclMatch.getCodomain();
            block0: while (conclMatchCodom.hasMoreElements()) {
                GraphObject o = conclMatchCodom.nextElement();
                Enumeration<GraphObject> oInverses = conclMatch.getInverseImage(o);
                GraphObject inv1 = oInverses.nextElement();
                GraphObject inv_q1 = null;
                if (this.po_q.getInverseImage(inv1).hasMoreElements()) {
                    inv_q1 = this.po_q.getInverseImage(inv1).nextElement();
                }
                if (inv_q1 == null) continue;
                while (oInverses.hasMoreElements()) {
                    GraphObject inv = oInverses.nextElement();
                    GraphObject inv_q = null;
                    if (this.po_q.getInverseImage(inv).hasMoreElements()) {
                        inv_q = this.po_q.getInverseImage(inv).nextElement();
                    }
                    if (inv_q == null || this.itsAtomConstraint.getInverseImage(inv_q1).hasMoreElements() || this.itsAtomConstraint.getInverseImage(inv_q).hasMoreElements()) continue;
                    ok = false;
                    continue block0;
                }
            }
        }
        if (conclusionOK = (check1 = this.po_t.compose(conclMatch)).isInjective()) {
            OrdinaryMorphism check2 = this.po_q.compose(conclMatch);
            conclusionOK = check2.isInjective();
            this.bf.destroyMorphism(check1);
            this.bf.destroyMorphism(check2);
        }
        return conclusionOK;
    }

    public int getConditionMatchCounter() {
        return this.n;
    }

    public String getAsString() {
        return new String("");
    }

    private Vector<AtomApplCond> createEquivalents() {
        Vector<AtomApplCond> v = new Vector<AtomApplCond>(0);
        Enumeration<GraphObject> eq = this.po_q.getCodomain();
        while (eq.hasMoreElements()) {
            GraphObject objTq = eq.nextElement();
            if (this.po_t.getInverseImage(objTq).hasMoreElements() || !this.po_q.getInverseImage(objTq).hasMoreElements()) continue;
            Enumeration<GraphObject> et = this.po_t.getCodomain();
            while (et.hasMoreElements()) {
                GraphObject objTt = et.nextElement();
                if (this.po_q.getInverseImage(objTt).hasMoreElements()) continue;
                boolean canGlue = false;
                if (objTq.isNode() && objTt.isNode() && objTq.getType().isParentOf(objTt.getType())) {
                    canGlue = true;
                } else if (objTq.isArc() && objTt.isArc() && objTq.getType().compareTo(objTt.getType())) {
                    canGlue = this.canGlueArcs((Arc)objTt, (Arc)objTq);
                }
                if (!canGlue) continue;
                boolean shouldDestroy = false;
                OrdinaryMorphism isoT = this.po_t.getTarget().isomorphicCopy();
                if (isoT == null) continue;
                isoT.setCompletionStrategy(new Completion_CSP(true), true);
                OrdinaryMorphism equivalentT = this.bf.createMorphism(this.po_t.getSource(), isoT.getTarget(), true);
                try {
                    this.addMappings(equivalentT, this.po_t, isoT);
                }
                catch (BadMappingException ex) {
                    System.out.println(ex.getLocalizedMessage());
                }
                OrdinaryMorphism equivalentQ = this.bf.createMorphism(this.po_q.getSource(), isoT.getTarget(), true);
                try {
                    this.addMappings(equivalentQ, this.po_q, isoT);
                }
                catch (BadMappingException ex) {
                    System.out.println(ex.getLocalizedMessage());
                }
                if (equivalentT.isTotal() && equivalentQ.isTotal()) {
                    GraphObject glue = isoT.getImage(objTq);
                    GraphObject keep = isoT.getImage(objTt);
                    GraphObject obj_glue = equivalentQ.getInverseImage(glue).nextElement();
                    boolean mappingOK = true;
                    if (glue.getAttribute() == null && keep.getAttribute() == null) {
                        try {
                            mappingOK = isoT.getTarget().glue(keep, glue);
                        }
                        catch (TypeException e) {
                            mappingOK = false;
                        }
                    } else if (glue.getAttribute() != null && keep.getAttribute() != null) {
                        try {
                            if (isoT.getTarget().glue(keep, glue)) {
                                this.resetAttrsAfterGlue(keep, obj_glue);
                            } else {
                                mappingOK = false;
                            }
                        }
                        catch (TypeException e) {
                            mappingOK = false;
                        }
                    }
                    if (mappingOK) {
                        try {
                            if (obj_glue.isNode()) {
                                equivalentQ.addMapping(obj_glue, keep);
                            } else {
                                equivalentQ.addMapping(((Arc)obj_glue).getSource(), ((Arc)keep).getSource());
                                equivalentQ.addMapping(((Arc)obj_glue).getTarget(), ((Arc)keep).getTarget());
                                equivalentQ.addMapping(obj_glue, keep);
                            }
                        }
                        catch (BadMappingException e) {
                            mappingOK = false;
                        }
                    }
                    boolean allTotal = true;
                    if (mappingOK) {
                        if (!equivalentT.isTotal()) {
                            allTotal = equivalentT.nextCompletion();
                        }
                        if (!equivalentQ.isTotal()) {
                            allTotal = allTotal && equivalentQ.nextCompletion();
                        }
                    }
                    try {
                        isoT.addMapping(objTt, keep);
                    }
                    catch (BadMappingException e) {
                        mappingOK = false;
                    }
                    if (mappingOK) {
                        if (!isoT.isTotal()) {
                            allTotal = allTotal && isoT.nextCompletion();
                        }
                    } else {
                        allTotal = false;
                    }
                    if (allTotal) {
                        this.declareConditions(equivalentT.getAttrContext(), this.po_t.getAttrContext().getConditions());
                        this.declareConditions(equivalentQ.getAttrContext(), this.po_q.getAttrContext().getConditions());
                        v.add(new AtomApplCond(this.itsAtomConstraint, this.cond, equivalentT, equivalentQ));
                    } else {
                        shouldDestroy = true;
                    }
                } else {
                    shouldDestroy = true;
                }
                if (!shouldDestroy) continue;
                this.bf.destroyMorphism(equivalentQ);
                equivalentQ = null;
                this.bf.destroyMorphism(equivalentT);
                equivalentT = null;
                this.bf.destroyMorphism(isoT);
                isoT = null;
            }
        }
        return v;
    }

    private boolean canGlueArcs(Arc objTt, Arc objTq) {
        boolean canGlue = false;
        boolean srcOK = false;
        boolean tarOK = false;
        if (objTt.getSource() == objTq.getSource() && objTt.getTarget() == objTq.getTarget()) {
            canGlue = true;
        } else {
            if (!(this.po_t.getInverseImage(objTq.getSource()).hasMoreElements() || this.itsAtomConstraint.getInverseImage(this.po_q.getInverseImage(objTq.getSource()).nextElement()).hasMoreElements() || this.po_q.getInverseImage(objTt.getSource()).hasMoreElements())) {
                srcOK = true;
            }
            if (!(this.po_t.getInverseImage(objTq.getTarget()).hasMoreElements() || this.itsAtomConstraint.getInverseImage(this.po_q.getInverseImage(objTq.getTarget()).nextElement()).hasMoreElements() || this.po_q.getInverseImage(objTt.getTarget()).hasMoreElements())) {
                tarOK = true;
            }
            canGlue = srcOK || tarOK;
        }
        return canGlue;
    }

    private void resetAttrsAfterGlue(GraphObject keep, GraphObject obj_glue) {
        if (keep.isNode()) {
            this.resetAttribute((ValueTuple)obj_glue.getAttribute(), (ValueTuple)keep.getAttribute());
        } else {
            this.resetAttribute((ValueTuple)obj_glue.getAttribute(), (ValueTuple)keep.getAttribute());
            this.resetAttribute((ValueTuple)((Arc)obj_glue).getSource().getAttribute(), (ValueTuple)((Arc)keep).getSource().getAttribute());
            this.resetAttribute((ValueTuple)((Arc)obj_glue).getTarget().getAttribute(), (ValueTuple)((Arc)keep).getTarget().getAttribute());
        }
    }

    private void addMappings(OrdinaryMorphism tarMorph, OrdinaryMorphism srcMorph1, OrdinaryMorphism srcMorph2) throws BadMappingException {
        for (GraphObject graphObject : srcMorph1.getSource().getNodesSet()) {
            GraphObject i = srcMorph2.getImage(srcMorph1.getImage(graphObject));
            if (i == null) continue;
            tarMorph.addMapping(graphObject, i);
        }
        for (Arc o : srcMorph1.getSource().getArcsSet()) {
            Arc i = (Arc)srcMorph2.getImage(srcMorph1.getImage(o));
            if (i == null) continue;
            tarMorph.addMapping(o, i);
        }
    }

    private void resetAttribute(ValueTuple from, ValueTuple to) {
        if (to == null || from == null) {
            return;
        }
        int i = 0;
        while (i < to.getNumberOfEntries()) {
            ValueMember amTo = to.getValueMemberAt(i);
            ValueMember amFrom = from.getValueMemberAt(i);
            if ((!amTo.isSet() || amTo.getExpr().isVariable()) && amFrom.isSet() && amFrom.getExpr().isVariable()) {
                amTo.setExprAsText(amFrom.getExprAsText());
            }
            ++i;
        }
    }

    private void renameVariableInCondition(OrdinaryMorphism morph) {
        Graph C = this.po_q.getSource();
        CondTuple conds = (CondTuple)morph.getAttrContext().getConditions();
        Vector<String> condVars = conds.getAllVariables();
        int j = 0;
        while (j < condVars.size()) {
            this.doRenameVarInCond(conds, C.getNodesSet().iterator());
            this.doRenameVarInCond(conds, C.getArcsSet().iterator());
            ++j;
        }
    }

    private void doRenameVarInCond(CondTuple conds, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject goC = (GraphObject)elems.next();
            if (goC.getAttribute() == null) continue;
            ValueTuple valueC = (ValueTuple)goC.getAttribute();
            int i = 0;
            while (i < valueC.getSize()) {
                GraphObject goT;
                ValueMember valC = valueC.getValueMemberAt(i);
                if (valC.isSet() && valC.getExpr().isVariable() && (goT = this.po_q.getImage(goC)) != null) {
                    ValueTuple valueT = (ValueTuple)goT.getAttribute();
                    ValueMember valT = valueT.getValueMemberAt(i);
                    if (valT.isSet() && valT.getExpr().isVariable() && !valT.getExprAsText().equals(valC.getExprAsText())) {
                        this.renameVariableInCondition(conds, valC.getExprAsText(), valT.getExprAsText());
                    } else if (!valT.isSet()) {
                        valT.setExprAsText(valC.getExprAsText());
                    }
                }
                ++i;
            }
        }
    }

    private void renameVariableInCondition(CondTuple conds, String from, String to) {
        int j = 0;
        while (j < conds.getSize()) {
            CondMember cm = conds.getCondMemberAt(j);
            Vector<String> v1 = cm.getAllVariables();
            if (v1.contains(from)) {
                JexExpr oldExpr = (JexExpr)cm.getExpr();
                Vector<String> variables = new Vector<String>();
                oldExpr.getAllVariables(variables);
                this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, null);
            }
            ++j;
        }
    }

    private void findPrimaryAndReplace(SimpleNode node, String from, String to, VarTuple vars) {
        int j = 0;
        while (j < node.jjtGetNumChildren()) {
            SimpleNode snode = (SimpleNode)node.jjtGetChild(j);
            if (snode instanceof ASTPrimaryExpression) {
                int j1 = 0;
                while (j1 < snode.jjtGetNumChildren()) {
                    SimpleNode n1 = (SimpleNode)snode.jjtGetChild(j1);
                    if (n1 instanceof ASTExpression) {
                        this.findPrimaryAndReplace(n1, from, to, vars);
                    }
                    ++j1;
                }
                if (snode.getString().equals(from)) {
                    SimpleNode test;
                    HandlerExpr expression2;
                    HandlerType t;
                    VarMember vm;
                    SymbolTable symbs = SimpleNode.getSymbolTable();
                    boolean to_found = false;
                    ContextView context = (ContextView)symbs;
                    VarTuple vt = (VarTuple)context.getVariables();
                    int i = 0;
                    while (i < vt.getSize()) {
                        vm = vt.getVarMemberAt(i);
                        if (vm.getName().equals(to)) {
                            to_found = true;
                            t = vm.getDeclaration().getType();
                            try {
                                expression2 = vm.getHandler().newHandlerExpr(t, to);
                                test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                node.replaceChild(snode, test);
                            }
                            catch (AttrHandlerException expression2) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                    if (!to_found && vars != null) {
                        i = 0;
                        while (i < vars.getSize()) {
                            vm = vars.getVarMemberAt(i);
                            if (vm.getName().equals(to)) {
                                to_found = true;
                                t = vm.getDeclaration().getType();
                                try {
                                    expression2 = vm.getHandler().newHandlerExpr(t, to);
                                    test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                    node.replaceChild(snode, test);
                                }
                                catch (AttrHandlerException attrHandlerException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                    }
                }
            } else {
                this.findPrimaryAndReplace(snode, from, to, vars);
            }
            ++j;
        }
    }

    private void setValueToVariable(OrdinaryMorphism fmatch, Graph g, Vector<String> helpVars, Vector<String> testVars) {
        AttrContext ac = fmatch.getAttrContext();
        Vector<String> v = this.declareVariables(ac, g);
        while (v.elements().hasMoreElements()) {
            String vn = v.elements().nextElement();
            helpVars.add(vn);
            v.remove(vn);
        }
        this.doSetValueToVar(ac, fmatch, helpVars, testVars, fmatch.getSource().getNodesSet().iterator());
        this.doSetValueToVar(ac, fmatch, helpVars, testVars, fmatch.getSource().getArcsSet().iterator());
    }

    private void doSetValueToVar(AttrContext ac, OrdinaryMorphism fmatch, Vector<String> helpVars, Vector<String> testVars, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject go = (GraphObject)elems.next();
            if (go.getAttribute() == null) continue;
            GraphObject img = fmatch.getImage(go);
            AttrInstance ai = go.getAttribute();
            if (img == null) continue;
            int i = 0;
            while (i < ai.getNumberOfEntries()) {
                AttrInstanceMember am = (AttrInstanceMember)ai.getMemberAt(i);
                if (am.isSet() && am.getExpr().isVariable()) {
                    String varname = am.getExprAsText();
                    AttrInstance aimg = img.getAttribute();
                    String value = ((ValueTuple)aimg).getValueAsString(i);
                    if (value != null) {
                        if (!helpVars.contains(varname)) {
                            VarMember vm = ac.getVariables().getVarMemberAt(varname);
                            vm.setExprAsText(value);
                            testVars.addElement(varname);
                        }
                        int j = 0;
                        while (j < helpVars.size()) {
                            VarMember vm;
                            String vn = helpVars.get(j);
                            if (varname.equals(vn) && !(vm = ac.getVariables().getVarMemberAt(varname)).isSet()) {
                                vm.setExprAsText(value);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void unsetVariable(VarTuple varTuple, Vector<String> helpVars, Vector<String> testVars) {
        int k = 0;
        while (k < varTuple.getNumberOfEntries()) {
            VarMember varm = varTuple.getVarMemberAt(k);
            int j = 0;
            while (j < helpVars.size()) {
                if (varm.getName().equals(helpVars.get(j))) {
                    varm.setExpr(null);
                }
                ++j;
            }
            ++k;
        }
        int j = 0;
        while (j < testVars.size()) {
            varTuple.getVarMemberAt(testVars.get(j)).setExpr(null);
            ++j;
        }
    }

    private Vector<String> declareVariables(AttrContext ac, Graph g) {
        Vector<String> results = new Vector<String>();
        this.doDeclareVars(ac, g.getNodesSet().iterator(), results);
        this.doDeclareVars(ac, g.getArcsSet().iterator(), results);
        return results;
    }

    private void doDeclareVars(AttrContext ac, Iterator<?> elems, Vector<String> results) {
        ContextView cv = (ContextView)ac;
        while (elems.hasNext()) {
            GraphObject go = (GraphObject)elems.next();
            if (go.getAttribute() == null) continue;
            AttrInstance ai = go.getAttribute();
            int i = 0;
            while (i < ai.getNumberOfEntries()) {
                String varname;
                AttrInstanceMember am = (AttrInstanceMember)ai.getMemberAt(i);
                if (am.isSet() && am.getExpr().isVariable() && !cv.isDeclared(varname = am.getExprAsText())) {
                    DeclMember decl = (DeclMember)am.getDeclaration();
                    cv.addDecl(decl.getHandler(), decl.getTypeName(), varname);
                    results.add(varname);
                }
                ++i;
            }
        }
    }

    private void declareConditions(AttrContext ac, AttrConditionTuple conds) {
        AttrConditionTuple condTuple = ac.getConditions();
        int i = 0;
        while (i < conds.getNumberOfEntries()) {
            CondMember cm = (CondMember)conds.getMemberAt(i);
            boolean found = false;
            int i1 = 0;
            while (i1 < condTuple.getNumberOfEntries()) {
                CondMember cm0 = (CondMember)condTuple.getMemberAt(i1);
                if (cm0.getExprAsText().equals(cm.getExprAsText())) {
                    found = true;
                    break;
                }
                ++i1;
            }
            if (!found) {
                condTuple.addCondition(cm.getExprAsText());
            }
            ++i;
        }
    }

    private void markAttrConditions(AttrContext attrContext) {
        VarTuple avt = (VarTuple)attrContext.getVariables();
        CondTuple act = (CondTuple)attrContext.getConditions();
        int k = 0;
        while (k < act.getSize()) {
            CondMember cm = act.getCondMemberAt(k);
            cm.setMark(0);
            Vector<String> vars = cm.getAllVariables();
            if (!vars.isEmpty()) {
                int i = 0;
                while (i < vars.size()) {
                    VarMember var = avt.getVarMemberAt(vars.get(i));
                    if (var != null && var.getMark() == 1) {
                        cm.setMark(1);
                        break;
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private void markUsedVariables(OrdinaryMorphism m) {
        VarMember var;
        ValueMember vm;
        int k;
        ValueTuple vt;
        VarTuple avt = (VarTuple)m.getAttrContext().getVariables();
        for (GraphObject graphObject : m.getTarget().getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(1);
                }
                ++k;
            }
        }
        for (GraphObject graphObject : m.getTarget().getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(1);
                }
                ++k;
            }
        }
        for (GraphObject graphObject : m.getSource().getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(0);
                }
                ++k;
            }
        }
        for (GraphObject graphObject : m.getSource().getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(0);
                }
                ++k;
            }
        }
    }

    @Override
    public boolean evalForall(Object o, int tick) {
        return false;
    }

    public String getName() {
        return "Unnamed";
    }
}

