/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Scanner {
    public static final int EOF = -1;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int OTHER = 3;
    public static final int EXIST = 4;
    protected Hashtable<String, Integer> fgKeys = new Hashtable();
    protected StringBuffer fBuffer = new StringBuffer();
    protected String fDoc;
    protected int fPos;
    protected int fEnd;
    protected int fStartToken;
    protected boolean fEofSeen = false;
    private List<String> notValidName = new ArrayList<String>();
    private String[] fgKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    public Scanner() {
        this.initialize();
    }

    public final int getLength() {
        return this.fPos - this.fStartToken;
    }

    void initialize() {
        Integer k = new Integer(2);
        int i = 0;
        while (i < this.fgKeywords.length) {
            this.fgKeys.put(this.fgKeywords[i], k);
            ++i;
        }
    }

    public final int getStartOffset() {
        return this.fStartToken;
    }

    private int nextToken() {
        this.fStartToken = this.fPos;
        int c = this.read();
        switch (c) {
            case -1: {
                return -1;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return 3;
            }
        }
        if (Character.isWhitespace((char)c)) {
            while (Character.isWhitespace((char)(c = this.read()))) {
            }
            this.unread(c);
            return 1;
        }
        if (Character.isJavaIdentifierStart((char)c)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while (Character.isJavaIdentifierPart((char)(c = this.read())));
            this.unread(c);
            String word = this.fBuffer.toString();
            Integer i = this.fgKeys.get(word);
            if (i != null) {
                return i;
            }
            if (this.notValidName.contains(word)) {
                return 4;
            }
            return 0;
        }
        return 3;
    }

    private int read() {
        if (this.fPos <= this.fEnd) {
            return this.fDoc.charAt(this.fPos++);
        }
        return -1;
    }

    private void setRange(String text) {
        this.fDoc = text;
        this.fPos = 0;
        this.fEnd = this.fDoc.length() - 1;
    }

    private void unread(int c) {
        if (c != -1) {
            --this.fPos;
        }
    }

    public void setNotValidName(List<String> notValidName) {
        this.notValidName.clear();
        this.notValidName.addAll(notValidName);
    }

    public String checkWord(String text) {
        this.setRange(text);
        int token = this.nextToken();
        boolean valid = false;
        while (token != -1) {
            switch (token) {
                case 1: {
                    return "the value is not a valid name";
                }
                case 2: {
                    return "the value must not be a java key word";
                }
                case 3: {
                    return "the value is not a valid name";
                }
                case 4: {
                    return "the value is already exist";
                }
                case 0: {
                    valid = true;
                }
            }
            token = this.nextToken();
        }
        if (valid) {
            return null;
        }
        return "the value is not a valid name";
    }
}

