/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.henshin.HenshinModelExporter;
import org.eclipse.emf.henshin.HenshinModelImporter;
import org.eclipse.emf.henshin.HenshinModelPlugin;

class HenshinModelPluginInitializer {
    HenshinModelPluginInitializer() {
    }

    public static void loadAdapters() throws Throwable {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.henshin.model.adapters");
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("exporter".equals(element.getName())) {
                id = element.getAttribute("id");
                try {
                    HenshinModelExporter exporter = (HenshinModelExporter)element.createExecutableExtension("class");
                    HenshinModelPlugin.INSTANCE.getExporters().put(id, exporter);
                }
                catch (Throwable t) {
                    HenshinModelPlugin.INSTANCE.logError("Error loading exporter " + id, t);
                }
            }
            if ("importer".equals(element.getName())) {
                id = element.getAttribute("id");
                try {
                    HenshinModelImporter importer = (HenshinModelImporter)element.createExecutableExtension("class");
                    HenshinModelPlugin.INSTANCE.getImporters().put(id, importer);
                }
                catch (Throwable t) {
                    HenshinModelPlugin.INSTANCE.logError("Error loading importer " + id, t);
                }
            }
            ++n2;
        }
    }
}

