/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.impl.ValueTuple;
import agg.util.Change;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.TypeSet;
import agg.xt_basis.UndirectedArc;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;

public class UndirectedTypeGraph
extends TypeGraph {
    public UndirectedTypeGraph(TypeSet aTypeSet) {
        super(aTypeSet);
    }

    @Override
    public TypeError canCreateArc(Type edgeType, Node source, Node target, int currentTypeGraphLevel) {
        TypeError error = this.itsTypes.canCreateArc(this, edgeType, source, target, currentTypeGraphLevel);
        if (error != null) {
            error = this.itsTypes.canCreateArc(this, edgeType, target, source, currentTypeGraphLevel);
        }
        return error;
    }

    @Override
    public TypeError checkConnectValid(Type edgeType, Node source, Node target) {
        if (this.itsTypes.getTypeGraph() == null || this.itsTypes.getLevelOfTypeGraphCheck() == 0 || this.itsTypes.getLevelOfTypeGraphCheck() == 5) {
            return null;
        }
        Arc typearc = this.itsTypes.getTypeGraphArc(edgeType, source.getType(), target.getType());
        if (typearc == null) {
            typearc = this.itsTypes.getTypeGraphArc(edgeType, target.getType(), source.getType());
        }
        if (typearc != null) {
            return null;
        }
        return new TypeError(21, "The edge of the type \"" + edgeType.getName() + "\" is not allowed between node type \"" + source.getType().getName() + "\"  and  \"" + target.getType().getName() + "\".");
    }

    @Override
    public TypeError checkNodeRequiresArc(int actTypeGraphLevel) {
        if (this.itsTypes.getTypeGraph() == null || actTypeGraphLevel != 30) {
            return null;
        }
        for (Node n : this.itsNodes) {
            List<String> list = this.itsTypes.nodeRequiresArc(n);
            if (list == null || list.isEmpty()) continue;
            return new TypeError(23, "Node type  \"" + n.getType().getName() + "\" \n" + "requires edge(s) of type: \n" + list.toString(), n.getType());
        }
        return null;
    }

    @Override
    public Arc createArc(Type type, Node src, Node tar) throws TypeException {
        if (src == null || tar == null) {
            throw new TypeException("UndirectedGraph.createArc:: Cannot create an UndirectedArc of type : " + type.getStringRepr() + "   Source or target node is null!");
        }
        if (!this.isNode(src) || !this.isNode(tar)) {
            throw new TypeException("UndirectedGraph.createArc:: Cannot create an UndirectedArc of type : " + type.getStringRepr() + "  Source or target does not belong to this graph!");
        }
        Type t = null;
        if (this.itsTypes.containsType(type)) {
            t = type;
        }
        if (t == null && (t = this.itsTypes.getSimilarType(type)) == null) {
            t = this.itsTypes.addType(type);
        }
        Arc anArc = this.newArc(t, src, tar);
        return anArc;
    }

    @Override
    public Arc copyArc(Arc orig, Node src, Node tar) throws TypeException {
        UndirectedArc arc;
        block5: {
            arc = null;
            try {
                arc = (UndirectedArc)this.createArc(orig.getType(), src, tar);
                if (arc != null) {
                    arc.setObjectName(orig.getObjectName());
                    if (orig.getAttribute() != null) {
                        arc.createAttributeInstance();
                        ((ValueTuple)arc.getAttribute()).copyEntries(orig.getAttribute());
                    }
                    break block5;
                }
                throw new TypeException("Graph.copyArc:: Cannot create an UndirectedArc of type : " + orig.getType().getName());
            }
            catch (TypeException ex) {
                if (src != null && tar != null) {
                    throw new TypeException("   " + orig.getType().getName() + " from  " + src.getType().getName() + " to  " + tar.getType().getName() + "   " + ex.getLocalizedMessage());
                }
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
        return arc;
    }

    @Override
    protected Arc newArc(Type t, Node src, Node tar) throws TypeException {
        UndirectedArc anArc = new UndirectedArc(t, (GraphObject)src, (GraphObject)tar, (Graph)this);
        TypeError typeError = this.itsTypes.addTypeGraphObject(anArc);
        if (typeError != null) {
            anArc.dispose();
            throw new TypeException(typeError);
        }
        this.attributed = this.attributed || anArc.getAttribute() != null;
        this.itsArcs.add(anArc);
        this.addArcToTypeObjectsMap(anArc);
        this.changed = true;
        if (this.notificationRequired) {
            this.propagateChange(new Change(10, anArc));
        }
        return anArc;
    }

    @Override
    protected Arc newArcFast(Type t, Node src, Node tar) {
        try {
            return this.newArc(t, src, tar);
        }
        catch (TypeException ex) {
            return null;
        }
    }

    @Override
    public Arc getTypeGraphArc(Type t, Type source, Type target) {
        for (Arc a : this.itsArcs) {
            if (!a.getType().compareTo(t)) continue;
            if (a.getSource().getType().isParentOf(source) && a.getTarget().getType().isParentOf(target)) {
                return a;
            }
            if (!a.getSource().getType().isParentOf(target) || !a.getTarget().getType().isParentOf(source)) continue;
            return a;
        }
        return null;
    }

    @Override
    protected void removeArc(Arc a) {
        if (a.getContext() == this) {
            ((Node)a.getSource()).removeOut(a);
            ((Node)a.getTarget()).removeOut(a);
            int i = 0;
            while (i < this.itsUsingMorphs.size()) {
                ((OrdinaryMorphism)this.itsUsingMorphs.get(i)).removeMapping(a);
                ++i;
            }
            this.itsArcs.remove(a);
            this.removeArcFromTypeObjectsMap(a);
            this.changed = true;
        }
    }

    @Override
    protected void removeArcFromTypeObjectsMap(Arc arc) {
        if (arc.getSource() != null && arc.getTarget() != null) {
            if (arc.getSource().getType().hasParent() || arc.getTarget().getType().hasParent()) {
                Vector<Type> srcParents = arc.getSource().getType().getAllParents();
                Vector<Type> tarParents = arc.getTarget().getType().getAllParents();
                int i = 0;
                while (i < srcParents.size()) {
                    int j = 0;
                    while (j < tarParents.size()) {
                        String keystr = String.valueOf(srcParents.get(i).convertToKey()) + arc.getType().convertToKey() + tarParents.get(j).convertToKey();
                        String keystr2 = String.valueOf(tarParents.get(i).convertToKey()) + arc.getType().convertToKey() + srcParents.get(j).convertToKey();
                        HashSet objSet = (HashSet)this.itsTypeObjectsMap.get(keystr);
                        if (objSet == null) {
                            objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
                        }
                        if (objSet != null) {
                            objSet.remove(arc);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                String keystr = arc.convertToKey();
                String keystr2 = ((UndirectedArc)arc).convertToInverseKey();
                HashSet objSet = (HashSet)this.itsTypeObjectsMap.get(keystr);
                if (objSet == null) {
                    objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
                }
                if (objSet != null) {
                    objSet.remove(arc);
                }
            }
        }
    }

    @Override
    protected void extendTypeObjectsMapByArc(Arc arc) {
        if (this.itsTypes.hasInheritance() && arc.getSource().getType().hasParent() || arc.getTarget().getType().hasParent()) {
            Vector<Type> srcParents = arc.getSource().getType().getAllParents();
            Vector<Type> tarParents = arc.getTarget().getType().getAllParents();
            int i = 0;
            while (i < srcParents.size()) {
                int j = 0;
                while (j < tarParents.size()) {
                    String keystr = String.valueOf(srcParents.get(i).convertToKey()) + arc.getType().convertToKey() + tarParents.get(j).convertToKey();
                    String keystr2 = String.valueOf(tarParents.get(i).convertToKey()) + arc.getType().convertToKey() + srcParents.get(j).convertToKey();
                    LinkedHashSet<Arc> objSet = (LinkedHashSet<Arc>)this.itsTypeObjectsMap.get(keystr);
                    if (objSet == null) {
                        objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
                    }
                    if (objSet == null) {
                        objSet = new LinkedHashSet<Arc>();
                        this.itsTypeObjectsMap.put(keystr, objSet);
                    }
                    objSet.add(arc);
                    ++j;
                }
                ++i;
            }
        } else {
            String keystr = arc.convertToKey();
            String keystr2 = ((UndirectedArc)arc).convertToInverseKey();
            LinkedHashSet<Arc> objSet = (LinkedHashSet<Arc>)this.itsTypeObjectsMap.get(keystr);
            if (objSet == null) {
                objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
            }
            if (objSet == null) {
                objSet = new LinkedHashSet<Arc>();
                this.itsTypeObjectsMap.put(keystr, objSet);
            }
            objSet.add(arc);
        }
    }
}

