/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrVariableMember;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarTuple;
import java.util.Observable;

public class VarMember
extends ValueMember
implements AttrVariableMember {
    public static final int LHS = 0;
    public static final int RHS = 1;
    public static final int NAC = 2;
    public static final int PAC = 3;
    public static final int GAC = 4;
    protected int refCnt = 0;
    protected boolean isIn = false;
    protected boolean isOut = false;
    private int mark;
    private boolean enabled = true;
    public static final long serialVersionUID = 3905403576345689583L;

    public VarMember(VarTuple tuple, DeclMember decl) {
        super(tuple, decl);
        this.errorMsg = "";
        this.isTransient = false;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public void delete() {
        this.getDeclaration().delete();
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        this.fireChanged(90);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isInputParameter() {
        return this.isIn;
    }

    @Override
    public void setInputParameter(boolean in) {
        this.isIn = in;
    }

    @Override
    public boolean isOutputParameter() {
        return this.isOut;
    }

    @Override
    public void setOutputParameter(boolean out) {
        this.isOut = out;
    }

    public int getReferenceCount() {
        return this.refCnt;
    }

    public boolean isUnifiableWith(HandlerExpr srcExpr) {
        if (this.isEmpty() || this.getExpr().equals(srcExpr)) {
            return true;
        }
        this.errorMsg = this.getExpr() + "  is not unifiable with  " + srcExpr;
        return false;
    }

    public boolean unifyWith(HandlerExpr srcExpr) {
        if (!this.isUnifiableWith(srcExpr)) {
            return false;
        }
        if (this.isEmpty() && srcExpr != null) {
            this.setExpr(srcExpr.getCopy());
            this.incrementCount();
        }
        return true;
    }

    @Override
    public void copy(ValueMember fromInstance) {
        super.copy(fromInstance);
        VarMember fromVar = (VarMember)fromInstance;
        this.refCnt = fromVar.refCnt;
        this.isIn = fromVar.isIn;
        this.isOut = fromVar.isOut;
        this.setTransient(fromVar.isTransient());
        this.setMark(fromVar.getMark());
    }

    public void undoUnification() {
        this.decrementCount();
    }

    @Override
    public void setExpr(HandlerExpr expr) throws AttrImplException {
        super.setExpr(expr);
        this.refCnt = this.expression == null ? 0 : 1;
    }

    @Override
    public void setExprAsObject(Object value) throws AttrImplException {
        super.setExprAsObject(value);
        this.startCount();
    }

    @Override
    public void setExprAsText(String exprText) throws AttrImplException {
        super.setExprAsText(exprText);
        this.startCount();
        if (this.getExpr() != null && this.getExpr().isComplex() && exprText.indexOf("new ") == 0) {
            this.apply(this.getExpr());
        }
    }

    @Override
    public void setExprAsText(String exprText, boolean initialize) throws AttrImplException {
        super.setExprAsText(exprText);
        this.startCount();
        if (this.getExpr() != null && this.getExpr().isComplex() && initialize && exprText.indexOf("new ") == 0) {
            this.apply(this.getExpr());
        }
    }

    @Override
    public void setExprAsEvaluatedText(String exprText) {
        super.setExprAsEvaluatedText(exprText);
        this.startCount();
    }

    @Override
    public HandlerExpr getExpr() {
        return super.getExpr();
    }

    @Override
    public boolean isDefinite() {
        return this.getEvaluationResult() != null;
    }

    public void setMark(int m) {
        this.mark = m;
    }

    public int getMark() {
        return this.mark;
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    protected HandlerExpr getEvaluationResult() {
        if (!this.isValid() || this.getExpr() == null) {
            return null;
        }
        HandlerExpr ex = this.getExpr().getCopy();
        try {
            if (ex.isConstant()) {
                ex.evaluate(this.getContext());
            }
            return ex;
        }
        catch (AttrHandlerException ex1) {
            return null;
        }
    }

    protected void startCount() {
        this.refCnt = 1;
    }

    protected void incrementCount() {
        ++this.refCnt;
    }

    protected void decrementCount() {
        if (this.refCnt > 0) {
            --this.refCnt;
        }
        if (this.refCnt == 0) {
            this.expression = null;
        }
    }

    @Override
    public String toString() {
        return "VarMember " + this.getExprAsText() + " refCnt: " + this.refCnt + " IN: " + this.isIn + " OUT: " + this.isOut + " hash: " + this.hashCode();
    }
}

