/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.agt;

import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeSet;
import agg.xt_basis.agt.RuleScheme;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AmalgamatedRule
extends Rule {
    private RuleScheme itsRuleScheme;

    public AmalgamatedRule(Graph left, Graph right) {
        super(left, right);
    }

    public AmalgamatedRule(TypeSet types) {
        super(types);
    }

    public AmalgamatedRule(OrdinaryMorphism h) {
        super(h.getSource(), h.getTarget());
        this.makeRuleFromMorphism(h);
        this.unsetInputParameter();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.itsRuleScheme = null;
    }

    public void setRuleScheme(RuleScheme rs) {
        this.itsRuleScheme = rs;
    }

    @Override
    public RuleScheme getRuleScheme() {
        return this.itsRuleScheme;
    }

    private void makeRuleFromMorphism(OrdinaryMorphism h) {
        Vector<String> list = this.itsOrig.getVariableNamesOfAttributes();
        list.addAll(this.itsImag.getVariableNamesOfAttributes());
        VarTuple varsMorph = (VarTuple)h.getAttrContext().getVariables();
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        int j = 0;
        while (j < varsMorph.getSize()) {
            DeclMember dm;
            VarMember vm = varsMorph.getVarMemberAt(j);
            if (list.contains(vm.getName()) && !vars.isDeclared((dm = (DeclMember)vm.getDeclaration()).getTypeName(), dm.getName())) {
                vars.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
                if (vm.isSet()) {
                    vars.getVarMemberAt(dm.getName()).setExprAsText(vm.getExprAsText());
                }
            }
            ++j;
        }
        Enumeration<GraphObject> dom = h.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            try {
                GraphObject img = h.getImage(obj);
                this.applyAttrValue(obj, img, vars);
                this.addMapping(obj, img);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        this.applyVarValueToAttr(vars, this.getRight().getNodesSet().iterator());
        this.applyVarValueToAttr(vars, this.getRight().getArcsSet().iterator());
        this.removeUnusedVariableOfAttrContext();
    }

    private void applyVarValueToAttr(VarTuple vars, Iterator<?> objs) {
        while (objs.hasNext()) {
            GraphObject o = (GraphObject)objs.next();
            if (o.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)o.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                VarMember var;
                ValueMember vm = value.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = vars.getVarMemberAt(vm.getExprAsText())) != null && var.isSet()) {
                    vm.setExprAsText(var.getExprAsText());
                }
                ++i;
            }
        }
    }

    private void applyAttrValue(GraphObject from, GraphObject to, VarTuple vars) {
        if (from.getAttribute() == null || to.getAttribute() == null) {
            return;
        }
        ValueTuple valuefrom = (ValueTuple)from.getAttribute();
        ValueTuple value = (ValueTuple)to.getAttribute();
        int i = 0;
        while (i < value.getSize()) {
            VarMember var;
            ValueMember vm = value.getValueMemberAt(i);
            ValueMember vmfrom = valuefrom.getValueMemberAt(vm.getName());
            if (vmfrom != null && vm.isSet() && vm.getExpr().isVariable() && vmfrom.isSet() && vmfrom.getExpr().isConstant() && (var = vars.getVarMemberAt(vm.getExprAsText())) != null) {
                if (!var.isSet()) {
                    vm.setExpr(vmfrom.getExpr());
                    var.setExpr(vmfrom.getExpr());
                } else if (var.getExprAsText().equals(vmfrom.getExprAsText())) {
                    vm.setExpr(vmfrom.getExpr());
                }
            }
            ++i;
        }
    }
}

