/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.cons.AtomConstraint;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.util.Pair;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.Match;
import agg.xt_basis.Morphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.Type;
import agg.xt_basis.Version;
import agg.xt_basis.agt.RuleScheme;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class LayeredGraTraImpl
extends GraTra {
    Random ran = new Random();
    private boolean appliedOnce;
    private boolean stopLayerAndWait;
    private int layerToStop;
    private boolean breakLayerOpt;
    private boolean breakLayer;
    private boolean breakAllLayerOpt;
    private boolean breakAllLayer;
    private boolean applyContinue;
    private boolean nextLayerExists = true;
    private boolean waitAfterLayer;
    private boolean waitingAfterLayer;
    private boolean layeredLoop;
    private boolean resetGraphBeforeLoop;
    private Integer startLayer;
    private RuleLayer layer;
    private Hashtable<Integer, HashSet<Rule>> invertedRuleLayer;
    private OrderedSet<Integer> ruleLayer;
    private Integer currentLayer;
    private boolean startTransform;
    private boolean grammarChecked;
    private long time0;
    File f;
    FileOutputStream os;
    String protocolFileName = "";
    int i;

    @Override
    public void dispose() {
        if (this.layer != null) {
            this.layer.dispose();
        }
        if (this.invertedRuleLayer != null) {
            this.invertedRuleLayer.clear();
        }
        if (this.ruleLayer != null) {
            this.ruleLayer.clear();
        }
        super.dispose();
    }

    @Override
    public void setGraTraOptions(Vector<String> newOptions) {
        super.setGraTraOptions(newOptions);
        if (newOptions.contains("breakAllLayer")) {
            this.breakAllLayerOpt = true;
        } else if (newOptions.contains("breakLayer")) {
            this.breakLayerOpt = true;
        }
        if (newOptions.contains("layeredLoop")) {
            this.layeredLoop = true;
        }
        if (newOptions.contains("resetGraph")) {
            this.resetGraphBeforeLoop = true;
        }
    }

    @Override
    public void stop() {
        if (this.breakLayerOpt) {
            this.breakLayer = true;
            this.stopping = this.breakAllLayer = false;
            this.waitAfterLayer = false;
        } else if (this.breakAllLayerOpt) {
            this.stopping = this.breakAllLayer = true;
            this.breakLayer = false;
            this.waitAfterLayer = false;
        } else if (this.waitAfterLayer) {
            this.stopping = false;
            this.stoppingRule = true;
            this.pauseRule = false;
            this.breakLayer = true;
            this.breakAllLayer = false;
        }
    }

    @Override
    public void unsetStop() {
        super.unsetStop();
        this.breakLayer = false;
        this.breakAllLayer = false;
        this.waitAfterLayer = false;
    }

    public void nextLayer() {
        this.transformLayers(true);
    }

    public int getCurrentLayer() {
        if (this.currentLayer != null) {
            return this.currentLayer;
        }
        return -1;
    }

    public void waitAfterLayer(boolean b) {
        this.waitAfterLayer = b;
    }

    public boolean isWaitingAfterLayer() {
        return this.waitingAfterLayer;
    }

    @Override
    public Pair<Morphism, Morphism> derivation(Match m) {
        return null;
    }

    @Override
    public boolean apply() {
        if (this.currentRuleSet.isEmpty()) {
            return false;
        }
        boolean applied = false;
        String trigger = "";
        this.currentRule = (Rule)this.currentRuleSet.elementAt(0);
        if (this.currentRule.isTriggerOfLayer()) {
            if (this.currentRule.isEnabled()) {
                trigger = "(trigger of layer)";
                boolean bl = applied = this.currentRule.canMatch(this.hostgraph, this.strategy) && this.apply(this.currentRule);
                if (applied) {
                    System.out.println(String.valueOf(this.currentRule.getName()) + " \t applied:  " + applied);
                    this.appliedOnce = true;
                    if (!this.isGraphConsistent()) {
                        this.stopping = true;
                    }
                    this.currentRule.setEnabled(false);
                    this.currentRuleSet.removeElement(this.currentRule);
                    if (this.os != null) {
                        this.writeTransformProtocol(String.valueOf(this.currentRule.getName()) + " " + trigger + " \t applied:  " + applied);
                    }
                } else {
                    if (this.os != null) {
                        this.writeTransformProtocol(String.valueOf(this.currentRule.getName()) + " " + trigger + " \t applied:  " + applied);
                        this.writeTransformProtocol(this.getErrorMsg());
                        this.writeTransformProtocol("The trigger rule of the current layer failed. \nContinue with the next layer.");
                    }
                    this.currentRuleSet.removeAllElements();
                }
                applied = false;
            } else {
                this.currentRuleSet.removeElement(this.currentRule);
            }
        }
        while (!(this.stopping || this.breakLayer || applied || this.currentRuleSet.size() <= 0)) {
            int i = this.ran.nextInt(this.currentRuleSet.size());
            this.currentRule = (Rule)this.currentRuleSet.elementAt(i);
            if (this.currentRule instanceof RuleScheme) {
                applied = this.apply((RuleScheme)this.currentRule);
            } else {
                boolean bl = applied = this.currentRule.canMatch(this.hostgraph, this.strategy) && this.apply(this.currentRule);
            }
            if (this.os != null) {
                this.writeTransformProtocol(String.valueOf(this.currentRule.getName()) + " \t applied:  " + applied);
            }
            if (!applied) {
                this.currentRuleSet.remove(this.currentRule);
                if (this.os == null) continue;
                this.writeTransformProtocol(this.getErrorMsg());
                this.writeTransformProtocol(this.getRuleNames(this.currentRuleSet));
                continue;
            }
            this.appliedOnce = true;
            if (this.isGraphConsistent()) continue;
            this.stopping = true;
        }
        return applied;
    }

    @Override
    public void transform(List<Rule> ruleSet) {
        this.layer = new RuleLayer(ruleSet);
        this.startLayer = this.layer.getStartLayer();
        this.invertedRuleLayer = this.layer.invertLayer();
        this.ruleLayer = new OrderedSet(new IntComparator());
        Enumeration<Integer> en = this.invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            this.ruleLayer.add(en.nextElement());
        }
        this.startTransform = true;
        this.transformLayers(true);
    }

    public void transformContinue() {
        this.applyContinue = true;
        this.pauseRule = false;
        this.breakLayer = false;
        this.transformCurrentLayer();
        if (this.pauseRule) {
            return;
        }
        if (this.layeredLoop && !this.stopping && this.currentLayer == null && !this.resetGraphBeforeLoop) {
            this.startTransform = true;
        }
    }

    public void transformContinueWithNextLayer() {
        this.breakLayer = false;
        if (this.stoppingRule) {
            this.stoppingRule = false;
        }
        this.transformCurrentLayer();
        if (this.layeredLoop && !this.stopping) {
            if (this.currentLayer == null && !this.resetGraphBeforeLoop) {
                this.startTransform = true;
            }
        } else if (this.currentLayer == null || this.stopping) {
            this.stopping = true;
            this.writeFinishToProtocol(this.time0);
        }
    }

    public void transformContinueWithNextStep() {
        this.breakLayer = false;
        if (this.stoppingRule) {
            this.stoppingRule = false;
        }
        this.transformCurrentLayer();
        if (this.layeredLoop && !this.stopping) {
            if (this.currentLayer == null && !this.resetGraphBeforeLoop) {
                this.startTransform = true;
            }
        } else if (this.currentLayer == null || this.stopping) {
            this.writeFinishToProtocol(this.time0);
        }
    }

    public void setStartTransform(boolean b) {
        this.startTransform = b;
    }

    private void transformCurrentLayer() {
        boolean oneApplied = false;
        this.waitingAfterLayer = false;
        if (this.startTransform) {
            this.currentLayer = this.startLayer;
            this.i = 0;
        }
        this.startTransform = false;
        this.nextLayerExists = true;
        if (!this.stopping && this.nextLayerExists && this.currentLayer != null) {
            Vector rules = new Vector();
            if (!this.applyContinue) {
                HashSet<Rule> rulesForLayer = this.invertedRuleLayer.get(this.currentLayer);
                for (Rule rule : rulesForLayer) {
                    if (rule.isTriggerOfLayer()) {
                        rules.add(0, rule);
                        continue;
                    }
                    rules.add(rule);
                }
                this.writeTransformProtocol("\n");
                this.writeTransformProtocol("Layer: " + this.currentLayer.toString());
                System.out.println("Layer " + this.currentLayer.toString() + ":  " + this.getRuleNames(rules) + "{*}");
            } else {
                rules = this.currentRuleSet;
            }
            boolean applied = true;
            while (!this.stopping && applied) {
                if (this.breakLayer) break;
                if (!this.applyContinue) {
                    this.currentRuleSet.clear();
                    this.currentRuleSet.addAll(rules);
                }
                if (applied = this.apply()) {
                    oneApplied = true;
                }
                if (this.pauseRule) {
                    return;
                }
                if (this.breakLayer) break;
                if (!applied || !this.waitAfterStep) continue;
                return;
            }
            if (this.options.hasOption("consistencyCheckAfterGraphTrafo") && !this.checkGraphConsistencyForLayer(this.currentLayer)) {
                this.stopping = true;
            }
            if (!this.breakLayer) {
                System.out.println("Layer " + this.currentLayer.toString() + "  used time: " + (System.currentTimeMillis() - this.time0) + "ms");
            } else {
                System.out.println("Layer " + this.currentLayer.toString() + "   broken");
                this.breakLayer = false;
            }
            this.writeUsedTimeToProtocol("used time: ", this.time0);
            this.enableTriggerRuleOfLayer(rules);
            ++this.i;
            if (this.i < this.ruleLayer.size()) {
                this.currentLayer = (Integer)this.ruleLayer.get(this.i);
            } else {
                this.nextLayerExists = false;
            }
            this.breakLayer = false;
            this.waitingAfterLayer = true;
            if (this.nextLayerExists && this.currentLayer != null) {
                this.fireGraTra(new GraTraEvent(this, 16));
            } else if (this.layeredLoop && !this.resetGraphBeforeLoop && this.appliedOnce) {
                this.startTransform = true;
                this.fireGraTra(new GraTraEvent(this, 16));
            } else {
                this.writeFinishToProtocol(this.time0);
                this.fireGraTra(new GraTraEvent(this, 5));
            }
        }
    }

    private void transformLayers(boolean anApply) {
        boolean oneApplied = anApply;
        String layerStr = "";
        while (oneApplied) {
            if (this.startTransform) {
                this.fireGraTra(new GraTraEvent(this, 18));
                this.currentLayer = this.startLayer;
                this.i = 0;
                this.appliedOnce = false;
            }
            this.startTransform = false;
            oneApplied = false;
            this.nextLayerExists = true;
            while (!this.stopping && this.nextLayerExists && this.currentLayer != null) {
                layerStr = String.valueOf(this.currentLayer);
                HashSet<Rule> rulesForLayer = this.invertedRuleLayer.get(this.currentLayer);
                Vector<Rule> rules = new Vector<Rule>();
                for (Rule rule : rulesForLayer) {
                    if (rule.isTriggerOfLayer()) {
                        rules.add(0, rule);
                        continue;
                    }
                    rules.add(rule);
                }
                this.writeTransformProtocol("\n");
                this.writeTransformProtocol("Layer: " + this.currentLayer.toString());
                System.out.println("Layer " + this.currentLayer.toString() + ":  " + this.getRuleNames(rules) + "{*}");
                boolean applied = true;
                while (!this.stopping && applied) {
                    String s = this.getRuleNames(rules);
                    this.writeTransformProtocol(s);
                    this.currentRuleSet.clear();
                    this.currentRuleSet.addAll(rules);
                    applied = this.apply();
                    if (applied) {
                        oneApplied = true;
                    }
                    if (this.pauseRule) {
                        return;
                    }
                    if (this.breakLayer) break;
                }
                if (this.options.hasOption("consistencyCheckAfterGraphTrafo") && !this.checkGraphConsistencyForLayer(this.currentLayer)) {
                    this.stopping = true;
                }
                if (!this.breakLayer) {
                    System.out.println("Layer " + this.currentLayer.toString() + "  used time: " + (System.currentTimeMillis() - this.time0) + "ms");
                } else {
                    System.out.println("Layer " + this.currentLayer.toString() + "   broken");
                    this.breakLayer = false;
                }
                this.writeUsedTimeToProtocol("used time: ", this.time0);
                this.enableTriggerRuleOfLayer(rules);
                ++this.i;
                if (this.i < this.ruleLayer.size()) {
                    this.currentLayer = (Integer)this.ruleLayer.get(this.i);
                } else {
                    this.nextLayerExists = false;
                }
                if (!this.nextLayerExists || this.currentLayer == null) {
                    this.nextLayerExists = false;
                    if (this.layeredLoop) {
                        if (this.appliedOnce && !this.resetGraphBeforeLoop && !this.stopping) {
                            this.nextLayerExists = true;
                            this.startTransform = true;
                            break;
                        }
                        this.writeFinishToProtocol(this.time0);
                        this.fireGraTra(new GraTraEvent(this, 5));
                    }
                }
                if (this.stopLayerAndWait(Integer.valueOf(layerStr))) break;
            }
            if (!"".equals(layerStr) && this.stopLayerAndWait(Integer.valueOf(layerStr)) || !this.layeredLoop) break;
        }
        if (!"".equals(layerStr) && this.stopLayerAndWait(Integer.valueOf(layerStr)) && this.nextLayerExists && !this.stopping) {
            this.fireGraTra(new GraTraEvent((Object)this, 16, layerStr));
        } else if (!this.startTransform) {
            this.writeFinishToProtocol(this.time0);
            this.fireGraTra(new GraTraEvent(this, 5));
        }
    }

    private boolean stopLayerAndWait(int layerNm) {
        return this.stopLayerAndWait && (this.layerToStop == -1 || this.currentLayer != null && this.layerToStop == layerNm);
    }

    @Override
    public void transform() {
        long startTime;
        this.stopping = false;
        if (!this.grammar.getListOfRules().isEmpty() && this.currentRuleSet.isEmpty()) {
            this.setRuleSet();
        }
        if (this.time0 > 0L && this.options.hasOption("resetGraph") && this.options.hasOption("layeredLoop")) {
            this.transformWhenResetGraph();
            return;
        }
        if (this.writeLogFile) {
            String dirName = this.grammar.getDirName();
            String fileName = this.grammar.getFileName();
            if (fileName == null || fileName.equals("")) {
                fileName = this.grammar.getName();
            }
            this.openTransformProtocol(dirName, fileName);
            String version = "Version:  AGG " + Version.getID() + "\n";
            this.writeTransformProtocol(version);
            String s0 = "Layered graph transformation of : " + this.grammar.getName();
            String s1 = "on graph : " + this.grammar.getGraph().getName();
            String s2 = this.getRuleNames(this.currentRuleSet);
            this.writeTransformProtocol(s0);
            this.writeTransformProtocol(s1);
            this.writeTransformProtocol(s2);
        }
        if (!this.grammarChecked) {
            Pair<Object, String> checkpair = this.grammar.isReadyToTransform(true);
            if (checkpair != null) {
                Object test = checkpair.first;
                if (test != null) {
                    String s0 = String.valueOf((String)checkpair.second) + "\nTransformation stopped.";
                    if (test instanceof Type) {
                        this.fireGraTra(new GraTraEvent((Object)this, 15, s0));
                    } else if (test instanceof Rule) {
                        this.fireGraTra(new GraTraEvent((Object)this, 9, s0));
                    } else if (test instanceof AtomConstraint) {
                        this.fireGraTra(new GraTraEvent((Object)this, 14, s0));
                    }
                    this.transformFailed(s0);
                    return;
                }
            } else {
                if (!this.grammar.isGraphReadyForTransform()) {
                    String s0 = "Transformation stopped.\nThe graph  <" + this.grammar.getGraph().getName() + ">  isn't fine." + "\nPlease check attribute settings of nodes and edges.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s0));
                    this.transformFailed(s0);
                    return;
                }
                if (!this.checkGraphConsistency()) {
                    String s = "Graph consistency failed.\nPlease check the host graph against the graph constraints.\nTransformation is stopped.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s));
                    this.transformFailed(s);
                    return;
                }
            }
            this.grammarChecked = true;
        }
        this.time0 = startTime = System.currentTimeMillis();
        Vector<Rule> ruleSet = this.getEnabledRules(this.currentRuleSet);
        this.transform(ruleSet);
        if (this.options.hasOption("consistencyCheckAfterGraphTrafo")) {
            this.checkGraphConsistency();
        }
        System.out.println("Used time for graph transformation:  " + (System.currentTimeMillis() - startTime) + "ms");
        if (this.writeLogFile) {
            this.writeUsedTimeToProtocol("Used time for graph transformation: ", startTime);
            this.writeTransformProtocol("\nGraph transformation finished");
            this.closeTransformProtocol();
        }
    }

    private void transformWhenResetGraph() {
        long startTime;
        this.time0 = startTime = System.currentTimeMillis();
        Vector<Rule> ruleSet = this.getEnabledRules(this.currentRuleSet);
        this.transform(ruleSet);
        if (this.options.hasOption("consistencyCheckAfterGraphTrafo")) {
            this.checkGraphConsistency();
        }
        System.out.println("Used time for graph transformation:  " + (System.currentTimeMillis() - startTime) + "ms");
        if (this.writeLogFile) {
            this.writeUsedTimeToProtocol("Used time for graph transformation: ", startTime);
            this.writeTransformProtocol("\nGraph transformation finished");
            this.closeTransformProtocol();
        }
    }

    private Vector<Rule> getEnabledRules(Vector<Rule> ruleSet) {
        Vector<Rule> vec = new Vector<Rule>(ruleSet.size());
        int j = 0;
        while (j < ruleSet.size()) {
            if (ruleSet.elementAt(j).isEnabled()) {
                vec.add(ruleSet.elementAt(j));
            }
            ++j;
        }
        return vec;
    }

    private void transformFailed(String text) {
        System.out.println(text);
        this.writeTransformProtocol(text);
        this.writeTransformProtocol("\nGraph transformation failed");
        this.fireGraTra(new GraTraEvent((Object)this, 5, this.errorMsg));
        this.closeTransformProtocol();
    }

    private void writeUsedTimeToProtocol(String text, long beginTime) {
        this.writeTransformProtocol(String.valueOf(text) + (System.currentTimeMillis() - beginTime) + "ms");
        this.time0 = System.currentTimeMillis();
    }

    private void writeFinishToProtocol(long beginTime) {
        this.writeTransformProtocol("\nNo more layers.\nGraph transformation finished");
        this.closeTransformProtocol();
    }

    public void setLayeredLoop(boolean b) {
        this.layeredLoop = b;
    }

    public void setResetGraphBeforeLoop(boolean b) {
        this.resetGraphBeforeLoop = b;
    }

    public void setStopLayerAndWait(boolean b) {
        this.stopLayerAndWait = b;
        this.layerToStop = -1;
    }

    public void setLayerToStop(int l) {
        this.layerToStop = l;
    }

    public void setBreakLayer(boolean b) {
        this.breakLayerOpt = b;
    }

    public void setBreakAllLayer(boolean b) {
        this.breakAllLayerOpt = b;
    }

    @Override
    public boolean transformationDone() {
        return this.appliedOnce;
    }

    public String getProtocolName() {
        return this.protocolFileName;
    }

    private void enableTriggerRuleOfLayer(Vector<Rule> rules) {
        int j = 0;
        while (j < rules.size()) {
            Rule r = rules.elementAt(j);
            if (r.isTriggerOfLayer()) {
                r.setEnabled(true);
                break;
            }
            ++j;
        }
    }

    private String getRuleNames(List<Rule> rules) {
        String names = "[  ";
        int j = 0;
        while (j < rules.size()) {
            Rule r = rules.get(j);
            names = String.valueOf(names) + r.getName() + "  ";
            ++j;
        }
        names = String.valueOf(names) + "]";
        return names;
    }

    private void openTransformProtocol(String dirName, String fileName) {
        String dName = dirName;
        String fName = "LayeredGraTra.log";
        if (fileName != null && !fileName.equals("")) {
            fName = fileName.endsWith(".ggx") ? String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_GraTra.log" : String.valueOf(fileName) + "_GraTra.log";
        }
        if (dName != null && !dName.equals("")) {
            this.f = new File(dName);
            dName = this.f.exists() ? (this.f.isFile() ? (this.f.getParent() != null ? String.valueOf(this.f.getParent()) + File.separator : "." + File.separator) : (this.f.isDirectory() ? String.valueOf(this.f.getPath()) + File.separator : "." + File.separator)) : "." + File.separator;
            this.f = new File(String.valueOf(dirName) + fName);
        } else {
            this.f = new File(fName);
        }
        try {
            this.os = new FileOutputStream(this.f);
            this.protocolFileName = this.f.getName();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.writeTransformProtocol(new Date().toString());
    }

    private void writeTransformProtocol(String s) {
        if (this.os == null) {
            return;
        }
        if (!this.os.getChannel().isOpen()) {
            return;
        }
        try {
            if (!s.equals("\n")) {
                this.os.write(s.getBytes());
            }
            this.os.write(10);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void closeTransformProtocol() {
        if (this.os == null) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

