/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrEvent;
import agg.attribute.AttrInstance;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import java.util.List;
import java.util.Vector;

public class Arc
extends GraphObject
implements XMLObject {
    protected boolean inheritance = false;
    protected boolean directed = true;
    protected GraphObject itsSource;
    protected GraphObject itsTarget;
    protected String keyStr = null;

    protected Arc(Type type, GraphObject src, GraphObject tar, Graph context) {
        this.itsContext = context;
        this.itsType = type;
        this.itsSource = src;
        this.itsTarget = tar;
        this.addToSrcTar(this.itsSource, this.itsTarget);
        this.itsContextUsage = this.hashCode();
        if (!this.itsType.isAttrTypeEmpty()) {
            this.itsAttr = AttrTupleManager.getDefaultManager().newInstance(this.itsType.getAttrType(), context.getAttrContext());
        }
        if (this.itsAttr != null) {
            this.itsAttr.addObserver(this);
        }
        this.keyStr = this.itsSource.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsTarget.getType().convertToKey());
    }

    public Arc(AttrInstance attr, Type type, GraphObject src, GraphObject tar, Graph context) {
        this.itsContext = context;
        this.itsType = type;
        this.itsSource = src;
        this.itsTarget = tar;
        this.addToSrcTar(this.itsSource, this.itsTarget);
        this.itsContextUsage = this.hashCode();
        this.itsAttr = attr;
        if (this.itsAttr != null) {
            this.itsAttr.addObserver(this);
        }
        this.keyStr = this.itsSource.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsTarget.getType().convertToKey());
    }

    protected Arc(Arc orig, GraphObject src, GraphObject tar, Graph context) {
        this(orig.getType(), src, tar, context);
        if (orig.getAttribute() != null) {
            if (this.itsAttr == null) {
                this.createAttributeInstance();
            }
            ((ValueTuple)this.itsAttr).copyEntries(orig.getAttribute());
        }
        if (!"".equals(orig.getObjectName())) {
            this.setObjectName(orig.getObjectName());
        }
    }

    protected void addToSrcTar(GraphObject src, GraphObject tar) {
        if (src != null && tar != null) {
            ((Node)src).addOut(this);
            ((Node)tar).addIn(this);
        }
    }

    public void dispose() {
        ((Node)this.itsTarget).removeIn(this);
        ((Node)this.itsSource).removeOut(this);
        if (this.itsAttr != null) {
            this.itsAttr.removeObserver(this);
            ((ValueTuple)this.itsAttr).dispose();
            this.itsAttr = null;
        }
        this.itsType = null;
        this.itsContext = null;
        this.itsContextUsage = -1;
        this.itsTarget = null;
        this.itsSource = null;
    }

    public void finalize() {
    }

    protected void setInheritance(boolean inherit) {
        this.inheritance = inherit;
    }

    public boolean isInheritance() {
        return this.inheritance;
    }

    @Override
    public final boolean isArc() {
        return true;
    }

    @Override
    public final boolean isNode() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public final GraphObject getSource() {
        return this.itsSource;
    }

    public final GraphObject getTarget() {
        return this.itsTarget;
    }

    public void setSource(Node n) {
        ((Node)this.itsSource).removeOut(this);
        this.itsSource = n;
        n.addOut(this);
        this.keyStr = this.itsSource.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsTarget.getType().convertToKey());
    }

    public void setTarget(Node n) {
        ((Node)this.itsTarget).removeIn(this);
        this.itsTarget = n;
        n.addIn(this);
        this.keyStr = this.itsSource.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsTarget.getType().convertToKey());
    }

    public Type getSourceType() {
        return this.itsSource.getType();
    }

    public Type getTargetType() {
        return this.itsTarget.getType();
    }

    @Override
    public String convertToKey() {
        this.keyStr = this.itsSource.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsTarget.getType().convertToKey());
        return this.keyStr;
    }

    @Override
    public String resetTypeKey() {
        this.keyStr = this.itsSource.getType().resetKey().concat(this.itsType.resetKey()).concat(this.itsTarget.getType().resetKey());
        return this.keyStr;
    }

    public List<String> convertToKeyParentExtended() {
        Vector<String> list = new Vector<String>();
        Vector<Type> mySrcParents = this.getSource().getType().getAllParents();
        Vector<Type> myTarParents = this.getTarget().getType().getAllParents();
        int i = 0;
        while (i < mySrcParents.size()) {
            int j = 0;
            while (j < myTarParents.size()) {
                String keystr = String.valueOf(mySrcParents.get(i).convertToKey()) + this.getType().convertToKey() + myTarParents.get(j).convertToKey();
                list.add(keystr);
                ++j;
            }
            ++i;
        }
        return list;
    }

    public String getTypeMapKey() {
        return this.convertToKey();
    }

    public void setDirected(boolean b) {
        this.directed = b;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isLoop() {
        return this.itsSource == this.itsTarget;
    }

    @Override
    public boolean compareTo(GraphObject o) {
        if (o == null || !o.isArc()) {
            return false;
        }
        Arc a = (Arc)o;
        if (!this.itsType.isParentOf(a.getType())) {
            return false;
        }
        if (!(this.itsAttr == null && a.getAttribute() == null || this.attrExists() && a.attrExists() && this.itsAttr.compareTo(a.getAttribute()))) {
            return false;
        }
        if (!this.compareSrcTarTo(a)) {
            return false;
        }
        return this.compareMultiplicityTo(a);
    }

    protected boolean compareSrcTarTo(Arc a) {
        return ((Node)this.getSource()).compareTo(a.getSource()) && ((Node)this.getTarget()).compareTo(a.getTarget());
    }

    protected boolean compareMultiplicityTo(Arc a) {
        if (this.itsContext.isTypeGraph()) {
            int a_minmax;
            Type srcType = this.getSource().getType();
            Type tarType = this.getTarget().getType();
            Type a_srcType = a.getSource().getType();
            Type a_tarType = a.getTarget().getType();
            int minmax = this.itsType.getSourceMin(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getSourceMin(a_srcType, a_tarType))) {
                return false;
            }
            minmax = this.itsType.getTargetMin(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getTargetMin(a_srcType, a_tarType))) {
                return false;
            }
            minmax = this.itsType.getSourceMax(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getSourceMax(a_srcType, a_tarType))) {
                return false;
            }
            minmax = this.itsType.getTargetMax(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getTargetMax(a_srcType, a_tarType))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Edge", this);
        if (!this.directed) {
            h.addAttr("directed", "false");
        }
        if (!this.visible) {
            h.addAttr("visible", "false");
        }
        if (!this.getObjectName().equals("")) {
            h.addAttr("name", this.getObjectName());
        }
        h.addObject("type", this.itsType, false);
        h.addObject("source", this.getSource(), false);
        h.addObject("target", this.getTarget(), false);
        if (this.itsContext != null && this.itsContext.isTypeGraph()) {
            Type targetType;
            Type sourceType = this.getSource().getType();
            int minmax = this.itsType.getSourceMin(sourceType, targetType = this.getTarget().getType());
            if (minmax != -1) {
                h.addAttr("sourcemin", Integer.toString(minmax));
            }
            if ((minmax = this.itsType.getTargetMin(sourceType, targetType)) != -1) {
                h.addAttr("targetmin", Integer.toString(minmax));
            }
            if ((minmax = this.itsType.getSourceMax(sourceType, targetType)) != -1) {
                h.addAttr("sourcemax", Integer.toString(minmax));
            }
            if ((minmax = this.itsType.getTargetMax(sourceType, targetType)) != -1) {
                h.addAttr("targetmax", Integer.toString(minmax));
            }
        }
        h.addObject("", this.itsAttr, true);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Edge", this)) {
            AttrInstance attri;
            String str = h.readAttr("directed");
            this.directed = !str.equals("false");
            str = h.readAttr("visible");
            this.visible = !str.equals("false");
            str = h.readAttr("name");
            this.setObjectName(str);
            if (this.itsType.getAttrType() != null || this.itsType.hasInheritedAttribute()) {
                this.createAttributeInstance();
            }
            if ((attri = this.itsAttr) != null) {
                h.enrichObject(attri);
            }
            h.close();
            if (this.itsContext != null && this.itsContext.getAttrContext() != null && this.itsAttr != null) {
                ValueTuple value = (ValueTuple)this.itsAttr;
                int i = 0;
                while (i < value.getSize()) {
                    ValueMember val = value.getValueMemberAt(i);
                    if (val.isSet() && val.getExpr().isVariable()) {
                        ContextView viewContext = (ContextView)((ValueTuple)val.getHoldingTuple()).getContext();
                        VarTuple variable = (VarTuple)viewContext.getVariables();
                        VarMember var = variable.getVarMemberAt(val.getExprAsText());
                        if (this.getContext().isNacGraph()) {
                            var.setMark(2);
                        } else if (this.getContext().isPacGraph()) {
                            var.setMark(3);
                        } else if (viewContext.doesAllowComplexExpressions()) {
                            var.setMark(1);
                        } else {
                            var.setMark(0);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public String toString() {
        String tTrg;
        String tSrc;
        String result = "";
        String t = this.itsType.getStringRepr();
        if (t.equals("")) {
            t = "[unnamed]";
        }
        if ((tSrc = this.getSource().getType().getStringRepr()).equals("")) {
            tSrc = "[unnamed]";
        }
        if ((tTrg = this.getTarget().getType().getStringRepr()).equals("")) {
            tTrg = "[unnamed]";
        }
        result = " ([" + this.hashCode() + "] " + "Arc: " + tSrc + "---" + t + "--->" + tTrg + ") ";
        if (this.itsAttr != null) {
            result = String.valueOf(result) + this.itsAttr.toString();
        }
        return result;
    }

    @Override
    public void attributeChanged(AttrEvent ev) {
        if (this.itsContext != null) {
            Pair<Arc, AttrEvent> p = new Pair<Arc, AttrEvent>(this, ev);
            this.itsContext.propagateChange(new Change(11, p));
        }
    }
}

