/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SearchStrategy;
import agg.util.csp.Search_BreadthFirst;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Variable;
import agg.xt_basis.GraphObject;
import agg.xt_basis.csp.Query_Type;
import java.lang.ref.WeakReference;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class Solution_Backjump_PartialInj
implements SolutionStrategy {
    private CSP itsCSP;
    private boolean itsInjectiveFlag;
    private boolean parallel;
    private boolean startParallelbyFirst;
    private final Vector<Query> itsQueries = new Vector();
    private final Dictionary<Variable, Integer> itsVarIndexMap = new Hashtable<Variable, Integer>();
    private final Dictionary<Object, Variable> itsInstanceVarMap = new Hashtable<Object, Variable>();
    private Dictionary<Object, Variable> otherInstanceVarMap;
    private final SearchStrategy itsSearcher = new Search_BreadthFirst();
    private final HashSet<Variable> itsBackjumpTargets = new HashSet();
    private int itsDirection;
    private int itsCurrentIndex;
    private Variable itsCurrentVar;
    private Query itsCurrentQuery;
    private int itsState;
    private int allInstances = 0;
    private boolean solutionFound;
    private final HashMap<Variable, WeakReference<Object>> var2subcontext = new HashMap();
    private static final int START = 1;
    private static final int NEXT = 2;
    private static final int INSTANTIATE = 3;
    private static final int BACK = 4;
    private static final int SUCCESS = 5;
    private static final int NO_MORE_SOLUTIONS = 6;
    private static final int BACKJUMP = 7;

    public Solution_Backjump_PartialInj(boolean injective) {
        this.itsInjectiveFlag = injective;
    }

    @Override
    public void setRelatedInstanceVarMap(Dictionary<Object, Variable> relatedVarIndexMap) {
        this.otherInstanceVarMap = relatedVarIndexMap;
    }

    @Override
    public Dictionary<Object, Variable> getInstanceVarMap() {
        return this.itsInstanceVarMap;
    }

    public void setSubcontextOfVariable(Enumeration<Variable> vars, Object subcontext, List<GraphObject> objs) {
        while (vars.hasMoreElements()) {
            Variable var = vars.nextElement();
            int i = 0;
            while (i < objs.size()) {
                if (var.getGraphObject() == objs.get(i)) {
                    this.var2subcontext.put(var, new WeakReference<Object>(subcontext));
                }
                ++i;
            }
        }
    }

    @Override
    public void clear() {
        this.itsQueries.clear();
        ((Hashtable)this.itsInstanceVarMap).clear();
        ((Hashtable)this.itsVarIndexMap).clear();
        this.itsBackjumpTargets.clear();
    }

    private final synchronized boolean initialize(CSP csp) {
        this.itsCSP = csp;
        this.clear();
        this.itsQueries.addAll(this.itsSearcher.execute(this.itsCSP));
        this.itsQueries.trimToSize();
        int i = 0;
        while (i < this.itsQueries.size()) {
            this.itsVarIndexMap.put(this.itsQueries.elementAt(i).getTarget(), i);
            ++i;
        }
        Enumeration<Variable> anEnum = this.itsCSP.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = anEnum.nextElement();
            if (aVar.getInstance() == null) continue;
            if (aVar.checkConstraints().hasMoreElements()) {
                return false;
            }
            this.itsVarIndexMap.put(aVar, -1);
            this.itsInstanceVarMap.put(aVar.getInstance(), aVar);
        }
        return true;
    }

    @Override
    public final boolean reinitialize(boolean doUpdateQueries) {
        if (doUpdateQueries) {
            this.itsQueries.clear();
            this.itsQueries.addAll(this.itsSearcher.execute(this.itsCSP));
            this.itsQueries.trimToSize();
        }
        ((Hashtable)this.itsVarIndexMap).clear();
        ((Hashtable)this.itsInstanceVarMap).clear();
        this.itsBackjumpTargets.clear();
        int i = 0;
        while (i < this.itsQueries.size()) {
            Query q = this.itsQueries.elementAt(i);
            this.itsVarIndexMap.put(q.getTarget(), i);
            if (q instanceof Query_Type) {
                ((Query_Type)q).resetObjects();
            }
            ++i;
        }
        Enumeration<Variable> anEnum = this.itsCSP.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = anEnum.nextElement();
            if (aVar.getInstance() == null) continue;
            if (aVar.checkConstraints().hasMoreElements()) {
                return false;
            }
            this.itsVarIndexMap.put(aVar, -1);
            this.itsInstanceVarMap.put(aVar.getInstance(), aVar);
        }
        this.itsState = 1;
        return true;
    }

    @Override
    public void reinitialize(Variable var) {
        if (var.getInstance() != null) {
            this.itsInstanceVarMap.remove(var.getInstance());
        }
        boolean queryExists = false;
        int i = 0;
        while (i < this.itsQueries.size()) {
            if (var == this.itsQueries.elementAt(i).getTarget()) {
                this.itsVarIndexMap.put(var, i);
                this.itsState = 1;
                queryExists = true;
                break;
            }
            ++i;
        }
        if (!queryExists && var.getTypeQuery() != null) {
            this.itsQueries.add(0, var.getTypeQuery());
            i = 0;
            while (i < this.itsQueries.size()) {
                Variable v = this.itsQueries.elementAt(i).getTarget();
                this.itsVarIndexMap.put(v, i);
                ++i;
            }
            this.itsState = 1;
        }
    }

    @Override
    public Variable getStartVariable() {
        return this.itsQueries.get((int)0).itsTarget;
    }

    @Override
    public Query getQuery(Variable var) {
        return !this.itsQueries.isEmpty() ? this.itsQueries.get(this.itsVarIndexMap.get(var)) : null;
    }

    @Override
    public final void reset() {
        this.itsState = 1;
    }

    @Override
    public void resetQuery_Type() {
        int i = 0;
        while (i < this.itsQueries.size()) {
            if (this.itsQueries.elementAt(i) instanceof Query_Type) {
                ((Query_Type)this.itsQueries.elementAt(i)).resetObjects();
            }
            ++i;
        }
    }

    @Override
    public final synchronized boolean next(CSP csp) {
        this.solutionFound = false;
        if (!csp.equals(this.itsCSP)) {
            if (!this.initialize(csp)) {
                return false;
            }
            this.itsState = 1;
        }
        if (this.itsState == 5) {
            this.itsState = 4;
            ++this.itsCurrentIndex;
        }
        block9: while (true) {
            switch (this.itsState) {
                case 1: {
                    this.itsCurrentIndex = -1;
                    this.itsState = 2;
                    continue block9;
                }
                case 2: {
                    if (this.itsCurrentIndex >= this.itsQueries.size() - 1) {
                        this.itsState = 5;
                    } else {
                        this.itsCurrentQuery = this.itsQueries.elementAt(++this.itsCurrentIndex);
                        this.itsCurrentVar = this.itsCurrentQuery.getTarget();
                        if (this.itsCurrentQuery.isApplicable() && !this.itsCurrentQuery.isDomainEmpty()) {
                            this.itsCurrentVar.setDomainEnum(this.itsCurrentQuery.execute());
                            this.addToBackjumpTargets(this.itsCurrentQuery.getSources());
                            this.itsState = 3;
                        } else {
                            this.itsState = 6;
                        }
                    }
                    this.itsDirection = 2;
                    continue block9;
                }
                case 3: {
                    this.itsState = this.itsDirection == 2 ? 7 : 4;
                    this.itsCurrentQuery.deactivateCorrespondent();
                    while (this.itsCurrentVar.hasNext()) {
                        Object obj = this.itsCurrentVar.getNext();
                        if (((GraphObject)obj).getContext() == null) continue;
                        this.itsCurrentVar.setInstance(obj);
                        ++this.allInstances;
                        Variable aConflictVar = this.checkInjection(this.itsCurrentVar);
                        if (aConflictVar != null) {
                            this.itsCurrentVar.setInstance(null);
                            --this.allInstances;
                            if (this.itsVarIndexMap.get(aConflictVar) == null) continue;
                            this.itsBackjumpTargets.add(aConflictVar);
                            continue;
                        }
                        Enumeration<Variable> allConflictVars = this.itsCurrentVar.checkConstraints();
                        if (!allConflictVars.hasMoreElements()) {
                            this.itsState = 2;
                            this.addInjection(this.itsCurrentVar);
                            break;
                        }
                        if (this.itsState != 7) continue;
                        Variable conflictVar1 = this.getFirstOf(allConflictVars);
                        this.itsBackjumpTargets.add(conflictVar1);
                    }
                    this.itsCurrentQuery.activateCorrespondent();
                    continue block9;
                }
                case 4: {
                    if (this.itsCurrentIndex == 0) {
                        if (this.itsCurrentVar != null && this.itsCurrentVar.hasNext()) {
                            this.removeInjection(this.itsCurrentVar);
                            this.itsCurrentVar.setInstance(null);
                            --this.allInstances;
                            this.itsState = 3;
                            this.itsDirection = 2;
                            continue block9;
                        }
                        this.itsState = 6;
                        this.itsDirection = 4;
                        continue block9;
                    }
                    if (this.itsCurrentIndex > 0) {
                        this.removeInjection(this.itsCurrentVar);
                        this.itsCurrentVar.setInstance(null);
                        --this.allInstances;
                        this.itsCurrentVar = this.itsQueries.get(--this.itsCurrentIndex).getTarget();
                        this.removeInjection(this.itsCurrentVar);
                        this.itsState = 3;
                        this.itsDirection = 4;
                        continue block9;
                    }
                    this.itsState = 6;
                    this.itsDirection = 4;
                    continue block9;
                }
                case 7: {
                    this.itsState = 6;
                    while (this.itsCurrentIndex > 0) {
                        this.removeInjection(this.itsCurrentVar);
                        this.itsCurrentVar.setInstance(null);
                        --this.allInstances;
                        this.itsCurrentVar = this.itsQueries.elementAt(--this.itsCurrentIndex).getTarget();
                        this.removeInjection(this.itsCurrentVar);
                        this.itsState = 3;
                        if (!this.itsBackjumpTargets.contains(this.itsCurrentVar)) continue;
                        this.itsBackjumpTargets.remove(this.itsCurrentVar);
                        break;
                    }
                    this.itsDirection = 4;
                    continue block9;
                }
                case 5: {
                    if (this.parallel && this.startParallelbyFirst) {
                        this.removeUsedObjectFromDomain();
                    }
                    this.solutionFound = true;
                    return true;
                }
                case 6: {
                    return false;
                }
            }
            System.out.println("Should have never come here " + this.itsState);
        }
    }

    private void removeUsedObjectFromDomain() {
        int i = 0;
        while (i < this.itsQueries.size()) {
            Query q = this.itsQueries.get(i);
            if (q instanceof Query_Type) {
                ((Query_Type)q).removeObject((GraphObject)q.getTarget().getInstance());
            }
            ++i;
        }
        ((Hashtable)this.itsInstanceVarMap).clear();
        this.itsBackjumpTargets.clear();
    }

    @Override
    public boolean hasSolution() {
        return this.solutionFound;
    }

    @Override
    public boolean hasQueries() {
        return !this.itsQueries.isEmpty();
    }

    private final Variable getFirstOf(Enumeration<Variable> vars) {
        Variable aFirstVar = vars.nextElement();
        int aFirstIndex = this.itsQueries.size();
        while (vars.hasMoreElements()) {
            int aCurrentIndex;
            Variable aCurrentVar = vars.nextElement();
            if (this.itsVarIndexMap.get(aCurrentVar) == null || (aCurrentIndex = this.itsVarIndexMap.get(aCurrentVar).intValue()) >= aFirstIndex) continue;
            aFirstIndex = aCurrentIndex;
            aFirstVar = aCurrentVar;
        }
        return aFirstVar;
    }

    private final void addInjection(Variable var) {
        if (this.itsInjectiveFlag && var.getInstance() != null) {
            this.itsInstanceVarMap.put(var.getInstance(), var);
        }
    }

    private final void removeInjection(Variable var) {
        if (this.itsInjectiveFlag && var.getInstance() != null) {
            this.itsInstanceVarMap.remove(var.getInstance());
        }
    }

    private final Variable checkInjection(Variable var) {
        Variable other;
        if (this.otherInstanceVarMap != null && (other = this.otherInstanceVarMap.get(var.getInstance())) != null) {
            return other;
        }
        if (this.itsInjectiveFlag) {
            Variable v = this.itsInstanceVarMap.get(var.getInstance());
            if (v != null && this.var2subcontext.get(var) != this.var2subcontext.get(v)) {
                return null;
            }
            return v;
        }
        return null;
    }

    private final void addToBackjumpTargets(List<?> en) {
        int i = 0;
        while (i < en.size()) {
            this.itsBackjumpTargets.add((Variable)en.get(i));
            ++i;
        }
    }

    @Override
    public boolean parallelSearch() {
        return this.parallel;
    }

    @Override
    public void enableParallelSearch(boolean b) {
        this.parallel = b;
    }

    @Override
    public void setStartParallelSearchByFirst(boolean b) {
        this.startParallelbyFirst = b;
    }
}

