/*
 * Decompiled with CFR 0.152.
 */
package agg.layout.evolutionary;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.layout.evolutionary.LayoutArc;
import agg.layout.evolutionary.LayoutNode;
import agg.layout.evolutionary.LayoutPattern;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class LayoutMetrics {
    private int epsilon = 200;
    private int clusterplus = 0;
    private int clusterminus = 0;

    public int getArcArcIntersect(List<EdArc> arcs) {
        int ret = 0;
        int i = 0;
        while (i < arcs.size()) {
            arcs.get(i).getLArc().calcSourceTargetpos();
            ++i;
        }
        i = 0;
        while (i < arcs.size() - 1) {
            EdArc arc1 = arcs.get(i);
            if (arc1.isLine()) {
                int j = i + 1;
                while (j < arcs.size()) {
                    Line2D.Double line2;
                    Line2D.Double line1;
                    EdArc arc2 = arcs.get(j);
                    if (arc2.isLine() && !arc1.getSource().equals(arc2.getSource()) && !arc1.getSource().equals(arc2.getTarget()) && !arc1.getTarget().equals(arc2.getSource()) && !arc1.getTarget().equals(arc2.getTarget()) && (line1 = new Line2D.Double(arc1.getLArc().getSourcepos(), arc1.getLArc().getTargetpos())).intersectsLine(line2 = new Line2D.Double(arc2.getLArc().getSourcepos(), arc2.getLArc().getTargetpos()))) {
                        ++ret;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    public int getArcNodeIntersect(List<EdNode> nodes, List<EdArc> arcs) {
        int ret = 0;
        int i = 0;
        while (i < arcs.size()) {
            EdArc arc = arcs.get(i);
            if (arc.isLine()) {
                arc.getLArc().calcSourceTargetpos();
                int j = 0;
                while (j < nodes.size()) {
                    Rectangle2D.Double rect;
                    Line2D.Double line;
                    EdNode node = nodes.get(j);
                    if (!arc.getSource().equals(node) && !arc.getTarget().equals(node) && (line = new Line2D.Double(arc.getLArc().getSourcepos(), arc.getLArc().getTargetpos())).intersects(rect = new Rectangle2D.Double(node.getX(), node.getY(), node.getWidth(), node.getHeight()))) {
                        ++ret;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    public int getNodeIntersect(List<EdNode> nodes, boolean mark) {
        Hashtable<EdNode, EdNode> intersect = new Hashtable<EdNode, EdNode>();
        int ret = 0;
        int i = 0;
        while (i < nodes.size() - 1) {
            EdNode node1 = nodes.get(i);
            int j = i + 1;
            while (j < nodes.size()) {
                EdNode node2 = nodes.get(j);
                if (intersect.get(node2) == null && this.nodesIntersect(node1, node2)) {
                    intersect.put(node2, node1);
                    ++ret;
                    if (mark) {
                        node1.getLNode().setOverlap();
                        node2.getLNode().setOverlap();
                    }
                }
                ++j;
            }
            ++i;
        }
        intersect.clear();
        return ret;
    }

    private boolean nodesIntersect(EdNode n1, EdNode n2) {
        int h2;
        int y2;
        int w2;
        int x2;
        Rectangle2D.Double rect2;
        int h1;
        int y1;
        boolean ret = false;
        int w1 = n1.getWidth();
        int x1 = n1.getLNode().getAkt().x - (w1 + 1) / 2;
        Rectangle2D.Double rect1 = new Rectangle2D.Double(x1, y1 = n1.getLNode().getAkt().y - ((h1 = n1.getHeight()) + 1) / 2, w1, h1);
        if (rect1.intersects(rect2 = new Rectangle2D.Double(x2 = n2.getLNode().getAkt().x - ((w2 = n2.getWidth()) + 1) / 2, y2 = n2.getLNode().getAkt().y - ((h2 = n2.getHeight()) + 1) / 2, w2, h2))) {
            ret = true;
        }
        return ret;
    }

    public int getOverlappingNode(Vector<LayoutNode> lnodes, int index) {
        int ret = -1;
        LayoutNode node1 = lnodes.get(index);
        int i = 0;
        while (i < lnodes.size()) {
            if (i != index) {
                LayoutNode node2 = lnodes.get(i);
                if (this.nodesIntersect(node1.getEdNode(), node2.getEdNode())) {
                    ret = i;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public int getOverallIntersect(List<EdNode> nodes, List<EdArc> arcs) {
        int ret = 0;
        ret += this.getArcArcIntersect(arcs);
        ret += this.getArcNodeIntersect(nodes, arcs) * 2;
        return ret += this.getNodeIntersect(nodes, false) * 3;
    }

    public int getAverageArcLengthDeviation(List<EdArc> arcs) {
        int ret = 0;
        int sum = 0;
        int i = 0;
        while (i < arcs.size()) {
            LayoutArc larc = arcs.get(i).getLArc();
            larc.calcAktLength();
            sum += Math.abs(larc.getPrefLength() - larc.getAktLength());
            ++i;
        }
        if (arcs.size() != 0) {
            ret = sum / arcs.size();
        }
        return ret;
    }

    public int getAverageNodeMove(List<EdNode> oldednodes, List<EdNode> newednodes) {
        int ret = 0;
        int sum = 0;
        int i = 0;
        while (i < newednodes.size()) {
            EdNode newednode = newednodes.get(i);
            LayoutNode newlnode = newednode.getLNode();
            int oldindex = newednode.isInVectorByBasisNode(oldednodes);
            if (oldindex != -1) {
                EdNode oldednode = oldednodes.get(oldindex);
                sum += Math.abs(newlnode.getAkt().x - oldednode.getX());
                sum += Math.abs(newlnode.getAkt().y - oldednode.getY());
            }
            ++i;
        }
        ret = sum / newednodes.size();
        return ret;
    }

    public float getSingleDistance(int nodes, int arcs, int nodeOverlapping, int arcNodeOverlapping, int arcArcOverlapping) {
        float B = nodes;
        float C = arcs;
        float D = nodeOverlapping;
        float E = arcNodeOverlapping;
        float F = arcArcOverlapping;
        float singleDistance = B / (D + 1.0f) + (B + C) / (E + 1.0f) + C / (F + 1.0f);
        return singleDistance;
    }

    public float getMentalDistance(int nodes, int arcs, int movementsOfNodes, int movementsOfArcs) {
        float B = nodes;
        float C = arcs;
        float H = movementsOfNodes;
        float G = movementsOfArcs;
        float mentalDistance = H / B + G / C;
        return mentalDistance;
    }

    public float getLayoutQuality(float singleDistance, float mentalDistance) {
        float lquality = singleDistance - mentalDistance;
        return lquality;
    }

    public void calcClusterDiffs(EdGraph eg) {
        Vector<EdNode> nodes = eg.getNodes();
        int sumplus = 0;
        int summinus = 0;
        int i = 0;
        while (i < nodes.size()) {
            EdNode node = nodes.get(i);
            Vector<Integer> oldcluster = node.getOldCluster();
            Vector<Integer> newcluster = node.getCluster();
            if (oldcluster == null) {
                sumplus += newcluster.size();
            } else {
                int j = 0;
                while (j < oldcluster.size()) {
                    if (newcluster.indexOf(oldcluster.get(j)) == -1) {
                        ++summinus;
                    }
                    ++j;
                }
                j = 0;
                while (j < newcluster.size()) {
                    if (oldcluster.indexOf(newcluster.get(j)) == -1) {
                        ++sumplus;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.clusterminus = summinus / nodes.size();
        this.clusterplus = sumplus / nodes.size();
    }

    public int getClusterMinus() {
        return this.clusterminus;
    }

    public int getClusterPlus() {
        return this.clusterplus;
    }

    public int getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(int e) {
        this.epsilon = e;
    }

    public int getPatternMistakes(EdGraph eg) {
        if (eg.getGraGra() == null) {
            return 0;
        }
        int ret = 0;
        EdGraGra edgra = eg.getGraGra();
        Vector<EdArc> arcs = eg.getArcs();
        int sum = 0;
        int diff = 0;
        int i = 0;
        while (i < arcs.size()) {
            EdArc arc = arcs.get(i);
            Vector<LayoutPattern> paterns = edgra.getLayoutPatternsForType(arc.getType().getBasisType());
            int j = 0;
            while (j < paterns.size()) {
                LayoutPattern lp = paterns.get(j);
                if (lp != null && lp.isEdgePattern()) {
                    EdNode source = (EdNode)arc.getSource();
                    EdNode target = (EdNode)arc.getTarget();
                    if (lp.isXOffset()) {
                        diff = target.getLNode().getAkt().x - source.getLNode().getAkt().x;
                        if (lp.getOffset() > 0) {
                            if (diff <= 0) {
                                ++sum;
                            }
                        } else if (diff > 0) {
                            ++sum;
                        }
                    } else {
                        diff = target.getLNode().getAkt().y - source.getLNode().getAkt().y;
                        if (lp.getOffset() > 0) {
                            if (diff <= 0) {
                                ++sum;
                            }
                        } else if (diff > 0) {
                            ++sum;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        ret = sum;
        return ret;
    }
}

