/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.typeeditor;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.EditUndoManager;
import agg.gui.editor.GraGraEditor;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.gui.typeeditor.ArcTypePropertyEditor;
import agg.gui.typeeditor.NodeTypePropertyEditor;
import agg.gui.typeeditor.TypePalette;
import agg.util.Pair;
import agg.xt_basis.TypeException;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class TypeEditor
implements TypeEventListener,
StateEditable {
    private final JFrame applFrame;
    private final GraGraEditor gragraEditor;
    private EdGraGra gragra;
    private final Vector<TypeEventListener> typeEventListeners;
    private final TypePalette typePalette;
    private final NodeTypePropertyEditor nodeTypePropertyEditor;
    private final ArcTypePropertyEditor arcTypePropertyEditor;
    private EditUndoManager undoManager;
    private Pair<String, Vector<?>> undoObj;

    public TypeEditor(JFrame aggappl, GraGraEditor gragraEditor) {
        this.applFrame = aggappl;
        this.gragraEditor = gragraEditor;
        this.typePalette = new TypePalette(this);
        this.nodeTypePropertyEditor = new NodeTypePropertyEditor(this.applFrame, this, this.typePalette);
        this.arcTypePropertyEditor = new ArcTypePropertyEditor(this.applFrame, this, this.typePalette);
        this.typeEventListeners = new Vector();
    }

    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
        this.nodeTypePropertyEditor.setUndoManager(anUndoManager);
        this.arcTypePropertyEditor.setUndoManager(anUndoManager);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        if (this.undoObj.first != null && this.undoObj.second != null) {
            state.put(this, this.undoObj);
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        if (this.undoManager == null) {
            return;
        }
        Object obj = state.get(this);
        if (obj == null || !(obj instanceof Pair)) {
            return;
        }
        String op = (String)((Pair)obj).first;
        if (op.equals("COMMON_DELETE_CREATE")) {
            Vector vec = (Vector)((Pair)obj).second;
            int i = vec.size() - 1;
            while (i >= 0) {
                EdGraph g = (EdGraph)vec.get(i);
                g.restoreState(state);
                --i;
            }
        }
    }

    private void undoManagerAddDeleteEdit(Hashtable<EdGraph, Vector<EdGraphObject>> graph2typeObservers, String undoKind) {
        if (this.undoManager == null || !this.undoManager.isEnabled()) {
            return;
        }
        Vector<EdGraph> vec = new Vector<EdGraph>();
        Enumeration<EdGraph> keys = graph2typeObservers.keys();
        while (keys.hasMoreElements()) {
            EdGraph g = keys.nextElement();
            Vector<EdGraphObject> gos = graph2typeObservers.get(g);
            if (gos == null || gos.isEmpty()) continue;
            g.addCommonDeletedToUndo(gos);
            if (this.gragra.getTypeGraph() == g) {
                vec.add(0, g);
                continue;
            }
            vec.add(g);
        }
        if (!vec.isEmpty()) {
            this.undoObj = new Pair("COMMON_DELETE_CREATE", vec);
        }
    }

    public void setEnabled(boolean b) {
        this.typePalette.setEnabled(b);
    }

    public TypePalette getTypePalette() {
        return this.typePalette;
    }

    public NodeTypePropertyEditor getNodeTypePropertyEditor() {
        return this.nodeTypePropertyEditor;
    }

    public ArcTypePropertyEditor getArcTypePropertyEditor() {
        return this.arcTypePropertyEditor;
    }

    public void showNodeTypePropertyEditorl(int x, int y) {
        this.nodeTypePropertyEditor.invoke(x, y);
    }

    public void showArcTypePropertyEditorl(int x, int y) {
        this.arcTypePropertyEditor.invoke(x, y);
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.typePalette.clear();
        this.nodeTypePropertyEditor.setNewTypeDefaultProperty();
        this.arcTypePropertyEditor.setNewTypeDefaultProperty();
        if (this.gragra == null) {
            this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 0, 151));
            this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 1, 152));
            return;
        }
        this.gragra.getTypeSet().addTypeEventListener(this);
        this.initializeTypes();
    }

    public GraGraEditor getGraGraEditor() {
        return this.gragraEditor;
    }

    public EdGraGra getGraGra() {
        return this.gragra;
    }

    public EdTypeSet getTypeSet() {
        if (this.gragra != null) {
            return this.gragra.getTypeSet();
        }
        return null;
    }

    public Vector<EdType> getNodeTypes() {
        if (this.gragra != null) {
            return this.gragra.getTypeSet().getNodeTypes();
        }
        return null;
    }

    public Vector<EdType> getArcTypes() {
        if (this.gragra != null) {
            return this.gragra.getTypeSet().getArcTypes();
        }
        return null;
    }

    public EdType getSelectedNodeType() {
        return this.gragra.getSelectedNodeType();
    }

    public EdType getSelectedArcType() {
        return this.gragra.getSelectedArcType();
    }

    public EdType selectNodeTypeAtIndex(int index) {
        if (index >= 0) {
            this.gragra.setSelectedNodeType(this.gragra.getNodeTypes().elementAt(index));
            this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedNodeTypeLabel(), 0, 15));
            return this.gragra.getSelectedNodeType();
        }
        this.gragra.setSelectedNodeType(null);
        return null;
    }

    public EdType selectArcTypeAtIndex(int index) {
        if (index >= 0) {
            this.gragra.setSelectedArcType(this.gragra.getArcTypes().elementAt(index));
            this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedArcTypeLabel(), 1, 15));
            return this.gragra.getSelectedArcType();
        }
        this.gragra.setSelectedArcType(null);
        return null;
    }

    public int getNodeTypeIndex(EdType t) {
        return this.gragra.getTypeSet().getNodeTypes().indexOf(t);
    }

    public int getArcTypeIndex(EdType t) {
        return this.gragra.getTypeSet().getArcTypes().indexOf(t);
    }

    public void refreshTypes() {
        this.typePalette.clear();
        this.initializeTypes();
    }

    public EdType addNodeType(EdType et) {
        if (et != null) {
            this.gragra.getTypeSet().addNodeType(et);
            this.gragra.setChanged(true);
            int index = this.gragra.getTypeSet().getNodeTypes().indexOf(et);
            Icon typeIcon = NodeTypePropertyEditor.getNodeTypeIcon(et.getShape(), et.getColor(), et.hasFilledShape());
            JLabel l = this.makeTypeLabel(et.getName(), typeIcon, et.getColor());
            this.typePalette.addNodeType(l, index);
            this.fireTypeEvent(new TypeEvent(this.nodeTypePropertyEditor, et, index, 13));
            this.typePalette.setSelectedNodeTypeIndex(index);
            this.selectNodeTypeAtIndex(index);
        }
        return et;
    }

    public EdType addNodeType(String tname, Color tcolor, int tshape, boolean filledshape, String tresourcespath, String timage, String tcomment, boolean tanimated) {
        EdType et = this.gragra.getTypeSet().createNodeType(tname, tshape, tcolor, filledshape, timage);
        if (et != null) {
            this.gragra.setChanged(true);
            et.setAnimated(tanimated);
            et.getBasisType().setTextualComment(tcomment);
            int index = this.gragra.getTypeSet().getNodeTypes().indexOf(et);
            Icon typeIcon = NodeTypePropertyEditor.getNodeTypeIcon(tshape, tcolor, filledshape);
            JLabel l = this.makeTypeLabel(tname, typeIcon, tcolor);
            this.typePalette.addNodeType(l, index);
            this.typePalette.setSelectedNodeTypeIndex(index);
            this.selectNodeTypeAtIndex(index);
            this.nodeTypePropertyEditor.undoManagerAddEdit("CREATE_DELETE");
            this.nodeTypePropertyEditor.undoManagerEndEdit(et);
            this.gragraEditor.updateUndoButton();
            this.fireTypeEvent(new TypeEvent(this.nodeTypePropertyEditor, et, index, 13));
        }
        return et;
    }

    public EdType addArcType(EdType et) {
        if (et != null) {
            this.gragra.getTypeSet().addArcType(et);
            this.gragra.setChanged(true);
            int index = this.gragra.getTypeSet().getArcTypes().indexOf(et);
            Icon typeIcon = this.arcTypePropertyEditor.getArcTypeIcon(et.shape, et.color, et.filled);
            JLabel l = this.makeTypeLabel(et.getName(), typeIcon, et.getColor());
            this.typePalette.addArcType(l, index);
            this.fireTypeEvent(new TypeEvent(this.arcTypePropertyEditor, et, index, 13));
            this.typePalette.setSelectedArcTypeIndex(index);
            this.selectArcTypeAtIndex(index);
        }
        return et;
    }

    public EdType addArcType(String tname, Color tcolor, int tshape, boolean filledshape, String tcomment) {
        EdType et = this.gragra.getTypeSet().createArcType(tname, tshape, tcolor, filledshape);
        if (et != null) {
            this.gragra.setChanged(true);
            et.getBasisType().setTextualComment(tcomment);
            int index = this.gragra.getTypeSet().getArcTypes().indexOf(et);
            Icon typeIcon = this.arcTypePropertyEditor.getArcTypeIcon(tshape, tcolor, filledshape);
            JLabel l = this.makeTypeLabel(tname, typeIcon, tcolor);
            this.typePalette.addArcType(l, index);
            this.typePalette.setSelectedArcTypeIndex(index);
            this.selectArcTypeAtIndex(index);
            this.arcTypePropertyEditor.undoManagerAddEdit("CREATE_DELETE");
            this.arcTypePropertyEditor.undoManagerEndEdit(et);
            this.gragraEditor.updateUndoButton();
            this.fireTypeEvent(new TypeEvent(this.arcTypePropertyEditor, et, index, 13));
        }
        return et;
    }

    public boolean changeSelectedNodeType(String tname, Color tcolor, int tshape, boolean tfilledshape, String tresourcespath, String timage, String tcomment, boolean tanimated) {
        EdType et;
        if (!this.gragra.getTypeSet().isNewType(this.gragra.getTypeSet().getNodeTypes(), tname, tshape, tcolor, tfilledshape) && (et = this.getSelectedNodeType()).getImageFileName().equals(timage)) {
            if (et.isAnimated() != tanimated) {
                et.setAnimated(tanimated);
            }
            return true;
        }
        et = this.getSelectedNodeType();
        int index = this.typePalette.getSelectedNodeTypeIndex();
        this.nodeTypePropertyEditor.undoManagerAddEdit("CHANGE");
        this.gragraEditor.updateUndoButton();
        if (this.gragra.getTypeSet().redefineType(et, tname, tshape, tcolor, tfilledshape, timage, tcomment)) {
            et.setAnimated(tanimated);
            JLabel tlabel = this.makeNodeTypeLabel(et);
            this.typePalette.changeNodeType(tlabel, index);
            this.nodeTypePropertyEditor.undoManagerEndEdit(et);
            this.fireTypeEvent(new TypeEvent(this.nodeTypePropertyEditor, et, index, 12));
            return true;
        }
        ((EditUndoManager)this.nodeTypePropertyEditor.getUndoManager()).lastEditDie();
        this.gragraEditor.updateUndoButton();
        return false;
    }

    public boolean changeSelectedArcType(String tname, Color tcolor, int tshape, boolean tfilledshape, String tcomment) {
        if (!this.gragra.getTypeSet().isNewType(this.gragra.getTypeSet().getArcTypes(), tname, tshape, tcolor, tfilledshape)) {
            return false;
        }
        int index = this.typePalette.getSelectedArcTypeIndex();
        EdType et = this.getSelectedArcType();
        this.arcTypePropertyEditor.undoManagerAddEdit("CHANGE");
        this.gragraEditor.updateUndoButton();
        if (this.gragra.getTypeSet().redefineType(et, tname, tshape, tcolor, tfilledshape, "", tcomment)) {
            JLabel tlabel = this.makeArcTypeLabel(et);
            this.typePalette.changeArcType(tlabel, index);
            this.arcTypePropertyEditor.undoManagerEndEdit(et);
            this.fireTypeEvent(new TypeEvent(this.arcTypePropertyEditor, et, index, 12));
            return true;
        }
        ((EditUndoManager)this.nodeTypePropertyEditor.getUndoManager()).lastEditDie();
        this.gragraEditor.updateUndoButton();
        return false;
    }

    protected boolean deleteNodeType(EdType et, boolean undoable) {
        int index = this.gragra.getTypeSet().getNodeTypes().indexOf(et);
        if (this.deleteType(et, index, this.nodeTypePropertyEditor, undoable)) {
            this.typePalette.deleteNodeTypeAt(index);
            int size = this.gragra.getTypeSet().getNodeTypes().size();
            if (size > 0) {
                if (index >= size) {
                    --index;
                }
                EdType type = this.selectNodeTypeAtIndex(index);
                this.typePalette.setSelectedNodeTypeIndex(index);
                this.nodeTypePropertyEditor.setSelectedTypeProperty(type);
                this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedNodeTypeLabel(), 0, 151));
            } else {
                this.typePalette.setSelectedNodeTypeIndex(-1);
                this.selectNodeTypeAtIndex(-1);
                this.nodeTypePropertyEditor.setNewTypeDefaultProperty();
                this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 0, 151));
            }
            if (undoable) {
                this.nodeTypePropertyEditor.undoManagerEndEdit(et);
            }
            this.gragraEditor.updateUndoButton();
            et.dispose();
            return true;
        }
        return false;
    }

    public boolean deleteSelectedNodeType(boolean undoable) {
        int index = this.typePalette.getSelectedNodeTypeIndex();
        EdType et = this.getSelectedNodeType();
        if (this.deleteType(et, index, this.nodeTypePropertyEditor, undoable)) {
            this.typePalette.deleteSelectedNodeType();
            int size = this.gragra.getTypeSet().getNodeTypes().size();
            if (size > 0) {
                if (index >= size) {
                    --index;
                }
                EdType type = this.selectNodeTypeAtIndex(index);
                this.typePalette.setSelectedNodeTypeIndex(index);
                this.nodeTypePropertyEditor.setSelectedTypeProperty(type);
                this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedNodeTypeLabel(), 0, 151));
            } else {
                this.typePalette.setSelectedNodeTypeIndex(-1);
                this.selectNodeTypeAtIndex(-1);
                this.nodeTypePropertyEditor.setNewTypeDefaultProperty();
                this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 0, 151));
            }
            this.nodeTypePropertyEditor.undoManagerEndEdit(et);
            this.gragraEditor.updateUndoButton();
            et.dispose();
            return true;
        }
        return false;
    }

    protected boolean deleteArcType(EdType et, boolean undoable) {
        int index = this.gragra.getTypeSet().getArcTypes().indexOf(et);
        if (this.deleteType(et, index, this.arcTypePropertyEditor, undoable)) {
            this.typePalette.deleteArcTypeAt(index);
            int size = this.gragra.getTypeSet().getArcTypes().size();
            if (size > 0) {
                if (index >= size) {
                    --index;
                }
                EdType type = this.selectArcTypeAtIndex(index);
                this.typePalette.setSelectedArcTypeIndex(index);
                this.arcTypePropertyEditor.setSelectedTypeProperty(type);
                this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedArcTypeLabel(), 1, 152));
            } else {
                this.typePalette.setSelectedArcTypeIndex(-1);
                this.selectArcTypeAtIndex(-1);
                this.arcTypePropertyEditor.setNewTypeDefaultProperty();
                this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 1, 152));
            }
            if (undoable) {
                this.arcTypePropertyEditor.undoManagerEndEdit(et);
            }
            this.gragraEditor.updateUndoButton();
            et.dispose();
            return true;
        }
        return false;
    }

    public boolean deleteSelectedArcType(boolean undoable) {
        int index = this.typePalette.getSelectedArcTypeIndex();
        EdType et = this.getSelectedArcType();
        if (this.deleteType(et, index, this.arcTypePropertyEditor, undoable)) {
            this.typePalette.deleteSelectedEdgeType();
            int size = this.gragra.getTypeSet().getArcTypes().size();
            if (size > 0) {
                if (index >= size) {
                    --index;
                }
                EdType type = this.selectArcTypeAtIndex(index);
                this.typePalette.setSelectedArcTypeIndex(index);
                this.arcTypePropertyEditor.setSelectedTypeProperty(type);
                this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedArcTypeLabel(), 1, 152));
            } else {
                this.typePalette.setSelectedArcTypeIndex(-1);
                this.selectArcTypeAtIndex(-1);
                this.arcTypePropertyEditor.setNewTypeDefaultProperty();
                this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 1, 152));
            }
            this.arcTypePropertyEditor.undoManagerEndEdit(et);
            this.gragraEditor.updateUndoButton();
            et.dispose();
            return true;
        }
        return false;
    }

    private boolean canDeleteNodeType(EdType t) {
        EdGraph typeGraph = this.gragra.getTypeSet().getTypeGraph();
        if (typeGraph != null) {
            EdNode n;
            Vector<EdNode> vec = typeGraph.getNodes(t);
            return vec.isEmpty() || !typeGraph.containsIncomingOutgoingArcsAt(n = vec.get(0));
        }
        return true;
    }

    private Hashtable<EdGraph, Vector<EdGraphObject>> getTypeContext(EdType et, boolean alsoFromTypeGraph) {
        Hashtable<EdGraph, Vector<EdGraphObject>> table = new Hashtable<EdGraph, Vector<EdGraphObject>>();
        Vector<EdGraphObject> vec = null;
        Vector<EdGraphObject> gos = this.gragra.getGraphObjectsOfType(et, alsoFromTypeGraph);
        EdGraph g = null;
        int i = 0;
        while (i < gos.size()) {
            EdGraphObject go = gos.get(i);
            if (go.getBasisObject() != null && go.getBasisObject().getContext() != null) {
                if (g != go.getContext() && (vec = table.get(g = go.getContext())) == null) {
                    vec = new Vector();
                    table.put(g, vec);
                }
                if (g != null && vec != null) {
                    if (go.isNode()) {
                        Vector<EdArc> vIn = g.getIncomingArcs((EdNode)go);
                        int j = 0;
                        while (j < vIn.size()) {
                            EdArc a = vIn.get(j);
                            if (!vec.contains(a)) {
                                vec.add(a);
                            }
                            ++j;
                        }
                        Vector<EdArc> vOut = g.getOutgoingArcs((EdNode)go);
                        int j2 = 0;
                        while (j2 < vOut.size()) {
                            EdArc a = vOut.get(j2);
                            if (!vec.contains(a)) {
                                vec.add(a);
                            }
                            ++j2;
                        }
                        vec.add(0, go);
                    } else if (!vec.contains(go)) {
                        vec.add(go);
                    }
                }
            }
            ++i;
        }
        return table;
    }

    protected boolean deleteType(EdType et, int index, JComponent source, boolean undoable) {
        Hashtable<EdGraph, Vector<EdGraphObject>> graph2typeObservers = this.getTypeContext(et, true);
        EdTypeSet typeSet = this.gragra.getTypeSet();
        int answer = 1;
        boolean used = false;
        if (typeSet.isTypeUsed(et)) {
            used = true;
            if (undoable) {
                if (typeSet.getBasisTypeSet().getLevelOfTypeGraphCheck() != 0) {
                    JOptionPane.showMessageDialog(this.applFrame, "Please disable the type graph before delete a type.", "Type graph enabled", 0);
                    return false;
                }
                Object[] options = new Object[]{"Delete", "Cancel"};
                answer = JOptionPane.showOptionDialog(source, "Are you sure you want to delete the type:  <" + et.getName() + "> ?" + "\nThere are objects of it.", "Delete Type", -1, 2, null, options, options[0]);
                if (answer == 0) {
                    String failStr = this.gragra.kernelRuleContainsObjsOfType(et);
                    if (failStr != null) {
                        String str = "The kernel rule:  " + failStr + "  \n" + "contains objects of type :  <" + et.getName() + ">  to delete.\n" + "Currently, AGG does not support Undo/Redo in this case.\n\n" + "Do you want to delete this type anyway?";
                        answer = JOptionPane.showConfirmDialog(this.applFrame, str, "Delete Type", 2);
                    }
                    undoable = failStr == null;
                }
            } else {
                answer = 0;
            }
            if (answer == 0) {
                if (!this.canDeleteNodeType(et)) {
                    JOptionPane.showMessageDialog(this.applFrame, "Cannot delete the node type:  <" + et.getName() + ">" + "\n Please delete its incoming | outgoing edge types, first.", "Type Graph Error", 0);
                    return false;
                }
                if (undoable) {
                    this.undoManagerAddDeleteEdit(graph2typeObservers, "COMMON_DELETE_CREATE");
                }
                List<String> failed = this.gragra.deleteGraphObjectsOfType(et, true, false);
                this.showDeleteMessageDialog(failed);
                if (failed != null && !failed.isEmpty()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!used || answer == 0) {
            try {
                if (undoable && source == this.nodeTypePropertyEditor) {
                    if (!graph2typeObservers.isEmpty()) {
                        this.nodeTypePropertyEditor.undoManagerAddEdit("COMMON_DELETE_CREATE");
                    } else {
                        this.nodeTypePropertyEditor.undoManagerAddEdit("DELETE_CREATE");
                    }
                } else if (undoable && source == this.arcTypePropertyEditor) {
                    if (!graph2typeObservers.isEmpty()) {
                        this.arcTypePropertyEditor.undoManagerAddEdit("COMMON_DELETE_CREATE");
                    } else {
                        this.arcTypePropertyEditor.undoManagerAddEdit("DELETE_CREATE");
                    }
                }
                this.gragra.setChanged(true);
                this.fireTypeEvent(new TypeEvent(source, et, index, 14));
                typeSet.removeType(et);
            }
            catch (TypeException e) {
                JOptionPane.showMessageDialog(this.applFrame, e.getMessage(), "Type Graph Error", 0);
                return false;
            }
        }
        return true;
    }

    private void showDeleteMessageDialog(List<String> failed) {
        if (failed != null && !failed.isEmpty()) {
            String str = "Cannot delete objects of this type from :\n";
            int i = 0;
            while (i < failed.size()) {
                String s = "\t" + failed.get(i) + "\n";
                str = String.valueOf(str) + s;
                ++i;
            }
            JOptionPane.showMessageDialog(this.applFrame, str);
        }
    }

    private void initializeTypes() {
        EdType et = null;
        Vector<JLabel> nodeTypeList = new Vector<JLabel>(this.gragra.getNodeTypes().size(), 5);
        if (this.gragra.getNodeTypes().size() != 0) {
            int i = 0;
            while (i < this.gragra.getNodeTypes().size()) {
                et = this.gragra.getNodeTypes().elementAt(i);
                JLabel tlabel = this.makeNodeTypeLabel(et);
                nodeTypeList.add(tlabel);
                ++i;
            }
            int indx = nodeTypeList.size() - 1;
            et = this.gragra.getNodeTypes().elementAt(indx);
            this.gragra.setSelectedNodeType(et);
            this.nodeTypePropertyEditor.setSelectedTypeProperty(et.getName(), et.color, et.shape, et.filled, "", et.imageFileName, et.getBasisType().getTextualComment(), et.isAnimated());
        }
        Vector<JLabel> arcTypeList = new Vector<JLabel>(this.gragra.getArcTypes().size(), 5);
        if (this.gragra.getArcTypes().size() != 0) {
            int i = 0;
            while (i < this.gragra.getArcTypes().size()) {
                et = this.gragra.getArcTypes().elementAt(i);
                JLabel tlabel = this.makeArcTypeLabel(et);
                arcTypeList.add(tlabel);
                ++i;
            }
            int indx = arcTypeList.size() - 1;
            et = this.gragra.getArcTypes().elementAt(indx);
            this.gragra.setSelectedArcType(et);
            this.arcTypePropertyEditor.setSelectedTypeProperty(et.getName(), et.color, et.shape, et.filled, et.getBasisType().getTextualComment());
        }
        this.typePalette.setTypes(nodeTypeList, arcTypeList);
        this.typePalette.setSelectedNodeTypeIndex(nodeTypeList.size() - 1);
        this.typePalette.setSelectedArcTypeIndex(arcTypeList.size() - 1);
        if (nodeTypeList.isEmpty()) {
            this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 0, 151));
        } else {
            this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedNodeTypeLabel(), 0, 151));
        }
        if (arcTypeList.isEmpty()) {
            this.fireTypeEvent(new TypeEvent(this, new JLabel(""), 1, 152));
        } else {
            this.fireTypeEvent(new TypeEvent(this, this.typePalette.getSelectedArcTypeLabel(), 1, 152));
        }
    }

    public JLabel makeNodeTypeLabel(EdType t) {
        Icon icon = NodeTypePropertyEditor.getNodeTypeIcon(t.shape, t.color, t.filled);
        JLabel l = new JLabel(t.getName(), icon, 2);
        l.setForeground(t.getColor());
        return l;
    }

    public JLabel makeArcTypeLabel(EdType t) {
        Icon icon = this.arcTypePropertyEditor.getArcTypeIcon(t.shape, t.color, t.filled);
        return this.makeTypeLabel(t.name, icon, t.color);
    }

    public JLabel makeTypeLabel(String name, Icon icon, Color color) {
        JLabel l = new JLabel(name, icon, 2);
        l.setForeground(color);
        return l;
    }

    public synchronized void addTypeEventListener(TypeEventListener l) {
        if (!this.typeEventListeners.contains(l)) {
            this.typeEventListeners.addElement(l);
        }
    }

    public synchronized void removeTypeEventListener(TypeEventListener l) {
        if (this.typeEventListeners.contains(l)) {
            this.typeEventListeners.removeElement(l);
        }
    }

    public void fireTypeEvent(TypeEvent e) {
        int i = 0;
        while (i < this.typeEventListeners.size()) {
            this.typeEventListeners.elementAt(i).typeEventOccurred(e);
            ++i;
        }
    }

    public void removeAll() {
        this.typePalette.clear();
        this.nodeTypePropertyEditor.setNewTypeDefaultProperty();
        this.arcTypePropertyEditor.setNewTypeDefaultProperty();
        this.gragra = null;
    }

    @Override
    public void typeEventOccurred(TypeEvent e) {
        if (e.getSource() instanceof EdTypeSet && (e.getMsg() == 3 || e.getMsg() == 11)) {
            this.refreshTypes();
        }
    }
}

