/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.path;

import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.cons.AtomApplCond;
import agg.cons.EvalSet;
import agg.cons.Formula;
import agg.editor.impl.EdAtomApplCond;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleConstraint;
import agg.editor.impl.EdRuleScheme;
import agg.gui.AGGAppl;
import agg.gui.event.TreeViewEvent;
import agg.gui.saveload.GraGraLoad;
import agg.gui.saveload.GraGraSave;
import agg.gui.treeview.GraGraTreeModel;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.AmalgamatedRuleTreeNodeData;
import agg.gui.treeview.nodedata.ApplFormulaTreeNodeData;
import agg.gui.treeview.nodedata.AtomicGraphConstraintTreeNodeData;
import agg.gui.treeview.nodedata.ConclusionAttrConditionTreeNodeData;
import agg.gui.treeview.nodedata.ConclusionTreeNodeData;
import agg.gui.treeview.nodedata.ConstraintTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import agg.gui.treeview.nodedata.GrammarTreeNodeData;
import agg.gui.treeview.nodedata.GraphTreeNodeData;
import agg.gui.treeview.nodedata.KernelRuleTreeNodeData;
import agg.gui.treeview.nodedata.MultiRuleTreeNodeData;
import agg.gui.treeview.nodedata.NACTreeNodeData;
import agg.gui.treeview.nodedata.NestedACTreeNodeData;
import agg.gui.treeview.nodedata.PACTreeNodeData;
import agg.gui.treeview.nodedata.RuleApplConstraintTreeNodeData;
import agg.gui.treeview.nodedata.RuleAtomicApplConstraintTreeNodeData;
import agg.gui.treeview.nodedata.RuleAttrCondTreeNodeData;
import agg.gui.treeview.nodedata.RuleSchemeTreeNodeData;
import agg.gui.treeview.nodedata.RuleSequenceTreeNodeData;
import agg.gui.treeview.nodedata.RuleTreeNodeData;
import agg.gui.treeview.nodedata.TypeGraphTreeNodeData;
import agg.ruleappl.RuleSequence;
import agg.xt_basis.BaseFactory;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GrammarTreeNode
extends DefaultMutableTreeNode {
    private final int KERNEL = 0;
    private final int MULTI = 1;
    private final int AMALGAMATED = 2;

    public GrammarTreeNode() {
    }

    public GrammarTreeNode(EdGraGra gragra) {
        super(new GrammarTreeNodeData(gragra));
        ((GrammarTreeNodeData)this.getUserObject()).setTreeNode(this);
    }

    public void saveGraGra(GraGraTreeView treeView, GraGraSave gragraSave, String directory, EdGraGra gragra) {
        treeView.fireTreeViewEvent(new TreeViewEvent(this, 1));
        if (gragra.getDirName().equals("")) {
            gragraSave.setDirName(directory);
        }
        gragraSave.setGraGra(gragra, gragra.getDirName(), gragra.getFileName());
        gragraSave.save();
        treeView.fireTreeViewEvent(new TreeViewEvent(this, 3));
    }

    public String saveAsGraGra(GraGraTreeView treeView, GraGraSave gragraSave, String directory, EdGraGra gragra) {
        treeView.fireTreeViewEvent(new TreeViewEvent(this, 1));
        gragraSave.setDirName(directory);
        gragraSave.setGraGra(gragra, gragra.getDirName(), gragra.getFileName());
        if (gragraSave.saveAs()) {
            ((AGGAppl)treeView.getFrame()).addToFrameTitle(gragra.getDirName(), gragra.getFileName());
        }
        treeView.fireTreeViewEvent(new TreeViewEvent(this, 3));
        return gragraSave.getDirName();
    }

    public void saveAsBaseGraGra(GraGraTreeView treeView, GraGraSave gragraSave, String directory, EdGraGra gragra) {
        treeView.fireTreeViewEvent(new TreeViewEvent(this, 1));
        gragraSave.setGraGra(gragra);
        gragraSave.setBaseGraGra(gragra.getBasisGraGra(), "", "");
        gragraSave.saveAsBase();
        treeView.fireTreeViewEvent(new TreeViewEvent(this, 3));
    }

    public EdGraGra reloadCurrentGraGra(GraGraTreeView treeView, TreePath selPath, GraGraLoad gragraLoad, EdGraGra gra) {
        gragraLoad.setGraGra(gra, gra.getDirName(), gra.getFileName());
        gragraLoad.reload();
        if (gragraLoad.getGraGra() != null) {
            EdGraGra gragra = gragraLoad.getGraGra();
            BaseFactory.theFactory().notify(gragra.getBasisGraGra());
            this.refreshCurrentGraGra(treeView, selPath, gragra);
            return gragra;
        }
        return null;
    }

    public void refreshCurrentGraGra(GraGraTreeView treeView, TreePath selPath, EdGraGra gra) {
        if (treeView.getTree().isExpanded(selPath)) {
            treeView.getTree().collapsePath(selPath);
        }
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        while (graNode.getChildCount() > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)graNode.getChildAt(0);
            treeView.getTreeModel().removeNodeFromParent(child);
            ((GraGraTreeNodeData)child.getUserObject()).dispose();
        }
        graNode.removeAllChildren();
        GrammarTreeNodeData graNodeData = new GrammarTreeNodeData(gra);
        graNode.setUserObject(graNodeData);
        graNodeData.setTreeNode(graNode);
        treeView.getTreeModel().nodeChanged(graNode);
        int graIndex = treeView.getTree().getRowForPath(selPath);
        this.updateTreeNodeData(treeView, graNode, gra);
        if (!treeView.getTree().isExpanded(treeView.getTree().getPathForRow(graIndex))) {
            treeView.getTree().expandPath(treeView.getTree().getPathForRow(graIndex));
        }
        gra.setChanged(false);
    }

    public void updateTreeNodeData(GraGraTreeView treeView, DefaultMutableTreeNode graNode, EdGraGra gragra) {
        this.insertGraGraDataIntoTree(treeView, graNode, gragra);
    }

    public int insertIntoTree(GraGraTreeView treeView) {
        GraGraTreeModel treeModel = treeView.getTreeModel();
        DefaultMutableTreeNode modelRoot = (DefaultMutableTreeNode)treeModel.getRoot();
        treeModel.insertNodeInto(this, modelRoot, modelRoot.getChildCount());
        if (!treeView.getTree().isExpanded(treeView.getTree().getPathForRow(0))) {
            treeView.getTree().expandPath(treeView.getTree().getPathForRow(0));
        }
        int graIndex = treeView.getTree().getRowCount() - 1;
        EdGraGra gragra = ((GrammarTreeNodeData)this.getUserObject()).getGraGra();
        this.insertGraGraDataIntoTree(treeView, this, gragra);
        if (!treeView.getTree().isExpanded(treeView.getTree().getPathForRow(graIndex))) {
            treeView.getTree().expandPath(treeView.getTree().getPathForRow(graIndex));
        }
        return graIndex;
    }

    public TreePath deleteTypeGraph(GraGraTreeView treeView, DefaultMutableTreeNode delNode, TreePath selPath, boolean withWarning) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (graData.getGraGra().getBasisGraGra().getLevelOfTypeGraphCheck() == 0) {
                if (data.isTypeGraph() && data.getGraph() != treeView.getCurrentGraph()) {
                    int answer = treeView.removeWarning("Type Graph");
                    if (answer == 0) {
                        int row = treeView.getTree().getRowForPath(selPath);
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                        treeView.getTreeModel().removeNodeFromParent(delNode);
                        treeView.getGraGraStore().storeTypeGraph(graData.getGraGra(), graData.getGraGra().getTypeGraph());
                        graData.getGraGra().removeTypeGraph();
                        treeView.setEditPath(row);
                        treeView.setFlagForNew();
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                        return treeView.getSelectedPath();
                    }
                } else {
                    int answer = treeView.removeCurrentObjectWarning("Type Graph");
                    if (answer == 0) {
                        int row = treeView.getTree().getRowForPath(selPath);
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                        treeView.getTreeModel().removeNodeFromParent(delNode);
                        treeView.getGraGraStore().storeTypeGraph(graData.getGraGra(), graData.getGraGra().getTypeGraph());
                        graData.getGraGra().removeTypeGraph();
                        treeView.setEditPath(row);
                        treeView.setFlagForNew();
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                        graData.getGraGra().setChanged(true);
                        return treeView.getSelectedPath();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(treeView.getFrame(), "Please disable the type graph first.", "", 2);
            }
        }
        return selPath;
    }

    public TreePath deleteGraph(GraGraTreeView treeView, DefaultMutableTreeNode delNode, TreePath selPath, boolean withWarning) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (graData.getGraGra().getGraphs().size() > 1) {
                if (data.getGraph() != treeView.getCurrentGraph()) {
                    int answer;
                    int n = answer = withWarning ? treeView.removeWarning("Host Graph") : 0;
                    if (answer == 0) {
                        int row = treeView.getTree().getRowForPath(selPath);
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                        treeView.getTreeModel().removeNodeFromParent(delNode);
                        treeView.getGraGraStore().storeGraph(graData.getGraGra(), data.getGraph());
                        graData.getGraGra().removeGraph(data.getGraph());
                        treeView.setEditPath(--row);
                        treeView.setFlagForNew();
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                        return treeView.getSelectedPath();
                    }
                } else {
                    int answer;
                    int n = answer = withWarning ? treeView.removeCurrentObjectWarning("Host Graph") : 0;
                    if (answer == 0) {
                        int row = treeView.getTree().getRowForPath(selPath);
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                        treeView.getTreeModel().removeNodeFromParent(delNode);
                        treeView.getGraGraStore().storeGraph(graData.getGraGra(), data.getGraph());
                        graData.getGraGra().removeGraph(data.getGraph());
                        treeView.setEditPath(--row);
                        treeView.setFlagForNew();
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                        return treeView.getSelectedPath();
                    }
                }
            }
            graData.getGraGra().setChanged(true);
        }
        return selPath;
    }

    public TreePath deleteRule(GraGraTreeView treeView, DefaultMutableTreeNode delNode, TreePath selPath, boolean withWarning) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getRule() != treeView.getCurrentRule()) {
                int answer;
                int n = answer = withWarning ? treeView.removeWarning("Rule") : 0;
                if (answer == 0 && delNode.getParent() != null) {
                    int row = treeView.getTree().getRowForPath(selPath);
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                    treeView.getTreeModel().removeNodeFromParent(delNode);
                    EdRule r = data.getRule();
                    treeView.getGraGraStore().storeRule(r.getGraGra(), r);
                    graData.getGraGra().removeRule(r);
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 72, selPath));
                    treeView.setEditPath(--row);
                    treeView.setFlagForNew();
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                    return treeView.getSelectedPath();
                }
            } else {
                int answer;
                int n = answer = withWarning ? treeView.removeCurrentObjectWarning("Rule") : 0;
                if (answer == 0 && delNode.getParent() != null) {
                    int row = treeView.getTree().getRowForPath(selPath);
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                    treeView.getTreeModel().removeNodeFromParent(delNode);
                    EdRule r = data.getRule();
                    treeView.getGraGraStore().storeRule(r.getGraGra(), r);
                    graData.getGraGra().removeRule(r);
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 72, selPath));
                    treeView.setEditPath(--row);
                    treeView.setFlagForNew();
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                    if (((GraGraTreeNodeData)((DefaultMutableTreeNode)treeView.getSelectedPath().getLastPathComponent()).getUserObject()).isGraph() && !treeView.getCurrentGraGra().getRules().isEmpty()) {
                        treeView.setEditPath(++row);
                        treeView.setFlagForNew();
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                    }
                    return treeView.getSelectedPath();
                }
            }
        }
        return selPath;
    }

    public TreePath deleteRuleScheme(GraGraTreeView treeView, DefaultMutableTreeNode delNode, TreePath selPath, boolean withWarning) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getRuleScheme() != treeView.getCurrentRuleScheme()) {
                int answer;
                int n = answer = withWarning ? treeView.removeWarning("RuleScheme") : 0;
                if (answer == 0) {
                    int row = treeView.getTree().getRowForPath(selPath);
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                    treeView.getTreeModel().removeNodeFromParent(delNode);
                    EdRuleScheme rs = data.getRuleScheme();
                    treeView.getGraGraStore().storeRuleScheme(rs.getGraGra(), rs);
                    graData.getGraGra().removeRule(rs);
                    treeView.setEditPath(--row);
                    treeView.setFlagForNew();
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.editorPath));
                    return treeView.getSelectedPath();
                }
            } else {
                int answer;
                int n = answer = withWarning ? treeView.removeCurrentObjectWarning("RuleScheme") : 0;
                if (answer == 0) {
                    int row = treeView.getTree().getRowForPath(selPath);
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, selPath));
                    treeView.getTreeModel().removeNodeFromParent(delNode);
                    EdRule rs = data.getRule();
                    treeView.getGraGraStore().storeRuleScheme(rs.getGraGra(), (EdRuleScheme)rs);
                    graData.getGraGra().removeRule(rs);
                    treeView.setEditPath(--row);
                    treeView.setFlagForNew();
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.editorPath));
                    if (((GraGraTreeNodeData)((DefaultMutableTreeNode)treeView.selPath.getLastPathComponent()).getUserObject()).isGraph() && !treeView.getCurrentGraGra().getRules().isEmpty()) {
                        treeView.setEditPath(++row);
                        treeView.setFlagForNew();
                        treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.editorPath));
                    }
                    return treeView.getSelectedPath();
                }
            }
        }
        return selPath;
    }

    public TreePath deleteRuleSequence(GraGraTreeView treeView, DefaultMutableTreeNode delNode, TreePath selPath, boolean withWarning) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getRuleSequence() == treeView.getCurrentRuleSequence()) {
                int answer;
                int row = treeView.getTree().getRowForPath(selPath);
                int n = answer = withWarning ? treeView.removeCurrentObjectWarning("Rule Sequence") : 0;
                if (answer == 0) {
                    treeView.getTreeModel().removeNodeFromParent(delNode);
                    graData.getGraGra().getBasisGraGra().removeRuleSequence(data.getRuleSequence());
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 32, selPath));
                    treeView.setEditPath(--row);
                    treeView.setFlagForNew();
                    treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, treeView.getEditorPath()));
                    return treeView.getSelectedPath();
                }
            }
        }
        return selPath;
    }

    private void insertGraGraDataIntoTree(GraGraTreeView treeView, DefaultMutableTreeNode graNode, EdGraGra gragra) {
        EdGraph typeGraph = gragra.getTypeSet().getTypeGraph();
        if (typeGraph != null) {
            this.insertTypeGraphIntoTree(treeView.getTreeModel(), graNode, typeGraph);
        }
        int i = 0;
        while (i < gragra.getGraphs().size()) {
            EdGraph g = gragra.getGraphs().get(i);
            this.insertGraphIntoTree(treeView.getTreeModel(), graNode, g);
            ++i;
        }
        i = 0;
        while (i < gragra.getRules().size()) {
            EdRule r = gragra.getRules().elementAt(i);
            if (r instanceof EdRuleScheme) {
                this.insertRuleSchemeIntoTree(treeView, graNode, (EdRuleScheme)r);
            } else {
                this.insertRuleIntoTree(treeView, graNode, r);
            }
            ++i;
        }
        i = 0;
        while (i < gragra.getAtomics().size()) {
            EdAtomic a = gragra.getAtomics().elementAt(i);
            this.insertAtomicGraphConstraintIntoTree(treeView.getTreeModel(), graNode, a);
            ++i;
        }
        i = 0;
        while (i < gragra.getConstraints().size()) {
            EdConstraint c = gragra.getConstraints().get(i);
            this.insertFormulaIntoTree(treeView.getTreeModel(), graNode, c);
            ++i;
        }
        if (gragra.getBasisGraGra().trafoByRuleSequence()) {
            i = 0;
            while (i < gragra.getBasisGraGra().getRuleSequences().size()) {
                RuleSequence rs = gragra.getBasisGraGra().getRuleSequences().get(i);
                this.insertRuleSequenceIntoTree(treeView.getTreeModel(), graNode, rs);
                ++i;
            }
        }
        if (gragra.getBasisGraGra().isLayered()) {
            treeView.getTreeModel().ruleNameChanged(gragra, true);
            treeView.getTreeModel().constraintNameChanged(gragra, true);
        } else if (gragra.getBasisGraGra().trafoByPriority()) {
            treeView.getTreeModel().ruleNameChanged(gragra, false, true);
            treeView.getTreeModel().constraintNameChanged(gragra, false, true);
        }
    }

    private void insertTypeGraphIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode graNode, EdGraph typeGraph) {
        EdGraGra gragra = ((GrammarTreeNodeData)graNode.getUserObject()).getGraGra();
        TypeGraphTreeNodeData sd = new TypeGraphTreeNodeData(typeGraph);
        DefaultMutableTreeNode typeGraphNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(typeGraphNode);
        String mode = "";
        switch (gragra.getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck()) {
            case 0: {
                mode = "[D]";
                break;
            }
            case 10: {
                mode = "[E]";
                break;
            }
            case 20: {
                mode = "[Em]";
                break;
            }
            case 30: {
                mode = "[Emm]";
                break;
            }
            default: {
                mode = "[?]";
            }
        }
        String name = String.valueOf(mode) + typeGraph.getBasisGraph().getName();
        sd.setString(name);
        treeModel.insertNodeInto(typeGraphNode, graNode, graNode.getChildCount());
    }

    private void insertGraphIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode graNode, EdGraph graph) {
        GraphTreeNodeData sd = new GraphTreeNodeData(graph);
        DefaultMutableTreeNode graphNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(graphNode);
        sd.setString(graph.getBasisGraph().getName());
        treeModel.insertNodeInto(graphNode, graNode, graNode.getChildCount());
    }

    public void insertRuleIntoTree(GraGraTreeView treeView, DefaultMutableTreeNode graNode, EdRule rule) {
        RuleTreeNodeData sd = new RuleTreeNodeData(rule);
        DefaultMutableTreeNode ruleNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(ruleNode);
        treeView.getTreeModel().insertNodeInto(ruleNode, graNode, graNode.getChildCount());
        this.insertRuleFormulaIntoTree(treeView, ruleNode, rule.getBasisRule().getFormulaStr());
        int j = 0;
        while (j < rule.getNestedACs().size()) {
            EdNestedApplCond ac = (EdNestedApplCond)rule.getNestedACs().get(j);
            this.insertNestedACIntoTree(treeView, ruleNode, ac);
            ++j;
        }
        j = 0;
        while (j < rule.getNACs().size()) {
            EdNAC nac = rule.getNACs().elementAt(j);
            this.insertNACIntoTree(treeView.getTreeModel(), ruleNode, nac);
            ++j;
        }
        j = 0;
        while (j < rule.getPACs().size()) {
            EdPAC pac = rule.getPACs().elementAt(j);
            this.insertPACIntoTree(treeView.getTreeModel(), ruleNode, pac);
            ++j;
        }
        CondTuple conds = (CondTuple)rule.getBasisRule().getAttrContext().getConditions();
        int c = 0;
        while (c < conds.getSize()) {
            CondMember cond = (CondMember)conds.getMemberAt(c);
            this.insertRuleAttrConditionIntoTree(treeView.getTreeModel(), ruleNode, cond);
            ++c;
        }
        this.insertRuleConstraintsIntoTree(treeView.getTreeModel(), ruleNode);
    }

    private void insertRuleSchemeIntoTree(GraGraTreeView treeView, DefaultMutableTreeNode graNode, EdRuleScheme ruleScheme) {
        RuleSchemeTreeNodeData sd = new RuleSchemeTreeNodeData(ruleScheme);
        DefaultMutableTreeNode ruleSchemeNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(ruleSchemeNode);
        treeView.getTreeModel().insertNodeInto(ruleSchemeNode, graNode, graNode.getChildCount());
        this.insertSchemeRuleIntoTree(treeView, ruleSchemeNode, ruleScheme.getKernelRule(), 0);
        int i = 0;
        while (i < ruleScheme.getMultiRules().size()) {
            EdRule multiRule = ruleScheme.getMultiRules().get(i);
            this.insertSchemeRuleIntoTree(treeView, ruleSchemeNode, multiRule, 1);
            ++i;
        }
        if (ruleScheme.getAmalgamatedRule() != null) {
            this.insertSchemeRuleIntoTree(treeView, ruleSchemeNode, ruleScheme.getAmalgamatedRule(), 2);
        }
    }

    private void insertSchemeRuleIntoTree(GraGraTreeView treeView, DefaultMutableTreeNode ruleSchemeNode, EdRule schemeRule, int kind) {
        GraGraTreeNodeDataAdapter sdRule = null;
        if (kind == 0) {
            sdRule = new KernelRuleTreeNodeData(schemeRule);
        } else if (kind == 1) {
            sdRule = new MultiRuleTreeNodeData(schemeRule);
        } else if (kind == 2) {
            sdRule = new AmalgamatedRuleTreeNodeData(schemeRule);
        }
        if (sdRule != null) {
            DefaultMutableTreeNode ruleNode = new DefaultMutableTreeNode(sdRule);
            sdRule.setTreeNode(ruleNode);
            treeView.getTreeModel().insertNodeInto(ruleNode, ruleSchemeNode, ruleSchemeNode.getChildCount());
            this.insertRuleFormulaIntoTree(treeView, ruleNode, schemeRule.getBasisRule().getFormulaStr());
            int j = 0;
            while (j < schemeRule.getNestedACs().size()) {
                EdNestedApplCond ac = (EdNestedApplCond)schemeRule.getNestedACs().get(j);
                this.insertNestedACIntoTree(treeView, ruleNode, ac);
                ++j;
            }
            j = 0;
            while (j < schemeRule.getNACs().size()) {
                EdNAC nac = schemeRule.getNACs().get(j);
                this.insertNACIntoTree(treeView.getTreeModel(), ruleNode, nac);
                ++j;
            }
            j = 0;
            while (j < schemeRule.getPACs().size()) {
                EdPAC pac = schemeRule.getPACs().get(j);
                this.insertPACIntoTree(treeView.getTreeModel(), ruleNode, pac);
                ++j;
            }
            CondTuple conds = (CondTuple)schemeRule.getBasisRule().getAttrContext().getConditions();
            int c = 0;
            while (c < conds.getSize()) {
                CondMember cond = (CondMember)conds.getMemberAt(c);
                this.insertRuleAttrConditionIntoTree(treeView.getTreeModel(), ruleNode, cond);
                ++c;
            }
        }
    }

    private void insertNestedACIntoTree(GraGraTreeView treeView, DefaultMutableTreeNode parNode, EdNestedApplCond ac) {
        NestedACTreeNodeData acsd = new NestedACTreeNodeData(ac);
        DefaultMutableTreeNode acNode = new DefaultMutableTreeNode(acsd);
        acsd.setTreeNode(acNode);
        treeView.getTreeModel().insertNodeInto(acNode, parNode, parNode.getChildCount());
        int i = 0;
        while (i < ac.getNestedACs().size()) {
            EdNestedApplCond acCh = ac.getNestedACs().get(i);
            this.insertNestedACIntoTree(treeView, acNode, acCh);
            ++i;
        }
        this.insertNestedACFormulaIntoTree(treeView, acNode, ac.getNestedMorphism().getFormulaText());
    }

    private void insertNACIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode ruleNode, EdNAC nac) {
        NACTreeNodeData nacsd = new NACTreeNodeData(nac);
        DefaultMutableTreeNode nacNode = new DefaultMutableTreeNode(nacsd);
        nacsd.setTreeNode(nacNode);
        treeModel.insertNodeInto(nacNode, ruleNode, ruleNode.getChildCount());
    }

    private void insertPACIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode ruleNode, EdPAC pac) {
        PACTreeNodeData pacsd = new PACTreeNodeData(pac);
        DefaultMutableTreeNode pacNode = new DefaultMutableTreeNode(pacsd);
        pacsd.setTreeNode(pacNode);
        treeModel.insertNodeInto(pacNode, ruleNode, ruleNode.getChildCount());
    }

    private void insertRuleAttrConditionIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode ruleNode, CondMember condition) {
        EdRule rule = null;
        if (ruleNode.getUserObject() instanceof RuleTreeNodeData) {
            rule = ((RuleTreeNodeData)ruleNode.getUserObject()).getRule();
        } else if (ruleNode.getUserObject() instanceof KernelRuleTreeNodeData) {
            rule = ((KernelRuleTreeNodeData)ruleNode.getUserObject()).getRule();
        } else if (ruleNode.getUserObject() instanceof MultiRuleTreeNodeData) {
            rule = ((MultiRuleTreeNodeData)ruleNode.getUserObject()).getRule();
        }
        if (rule != null) {
            String condStr = condition.getExprAsText();
            RuleAttrCondTreeNodeData conddata = new RuleAttrCondTreeNodeData(condition, rule);
            conddata.setString(condStr);
            DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
            conddata.setTreeNode(condchild);
            treeModel.insertNodeInto(condchild, ruleNode, ruleNode.getChildCount());
        }
    }

    private void insertRuleFormulaIntoTree(GraGraTreeView treeView, DefaultMutableTreeNode ruleNode, String formula) {
        EdRule rule = null;
        if (ruleNode.getUserObject() instanceof RuleTreeNodeData) {
            rule = ((RuleTreeNodeData)ruleNode.getUserObject()).getRule();
        } else if (ruleNode.getUserObject() instanceof KernelRuleTreeNodeData) {
            rule = ((KernelRuleTreeNodeData)ruleNode.getUserObject()).getRule();
        } else if (ruleNode.getUserObject() instanceof MultiRuleTreeNodeData) {
            rule = ((MultiRuleTreeNodeData)ruleNode.getUserObject()).getRule();
        }
        if (rule != null && !"true".equals(formula)) {
            List<String> allVars = rule.getBasisRule().getNameOfEnabledACs();
            Formula.getFromStringAboveList(formula, allVars);
            ApplFormulaTreeNodeData conddata = new ApplFormulaTreeNodeData(formula, true, rule);
            DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
            conddata.setTreeNode(condchild);
            treeView.getTreeModel().insertNodeInto(condchild, ruleNode, 0);
        }
    }

    private void insertNestedACFormulaIntoTree(GraGraTreeView treeView, DefaultMutableTreeNode acNode, String formula) {
        EdNestedApplCond ac = null;
        if (acNode.getUserObject() instanceof NestedACTreeNodeData) {
            ac = ((NestedACTreeNodeData)acNode.getUserObject()).getNestedAC();
        }
        if (ac != null && !"true".equals(formula)) {
            List<String> allVars = ac.getNestedMorphism().getNameOfEnabledACs();
            Formula.getFromStringAboveList(formula, allVars);
            ApplFormulaTreeNodeData conddata = new ApplFormulaTreeNodeData(formula, true, ac);
            DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
            conddata.setTreeNode(condchild);
            treeView.getTreeModel().insertNodeInto(condchild, acNode, 0);
        }
    }

    private void insertRuleConstraintsIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode rnode) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)rnode.getUserObject();
        if (!sd.isRule()) {
            return;
        }
        EdRule er = sd.getRule();
        Vector<EvalSet> atoms = er.getBasisRule().getAtomApplConds();
        Vector<String> names = er.getBasisRule().getConstraintNames();
        int i = 0;
        while (i < atoms.size()) {
            EvalSet es = atoms.get(i);
            String name = "PAC_" + names.get(i);
            EdRuleConstraint rc = new EdRuleConstraint(name, er, es);
            RuleApplConstraintTreeNodeData subsd = new RuleApplConstraintTreeNodeData(rc);
            subsd.setString(name);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(subsd);
            subsd.setTreeNode(child);
            treeModel.insertNodeInto(child, rnode, rnode.getChildCount());
            int j = 0;
            while (j < es.getSet().size()) {
                Vector<Object> set = ((EvalSet)es.getSet().get(j)).getSet();
                int k = 0;
                while (k < set.size()) {
                    AtomApplCond cond = (AtomApplCond)set.elementAt(k);
                    String condName = cond.getSourceAtomConstraint().getName();
                    String n = String.valueOf(k + j * set.size() + 1) + "_" + condName;
                    EdAtomApplCond aac = new EdAtomApplCond(n, er, cond);
                    RuleAtomicApplConstraintTreeNodeData conddata = new RuleAtomicApplConstraintTreeNodeData(aac);
                    conddata.setString(n);
                    DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                    conddata.setTreeNode(condchild);
                    treeModel.insertNodeInto(condchild, child, child.getChildCount());
                    int l = 0;
                    while (l < cond.getEquivalents().size()) {
                        AtomApplCond eq = cond.getEquivalents().elementAt(l);
                        String eqn = String.valueOf(n) + "_Eq" + l;
                        EdAtomApplCond aacEq = new EdAtomApplCond(eqn, er, eq);
                        RuleAtomicApplConstraintTreeNodeData eqdata = new RuleAtomicApplConstraintTreeNodeData(aacEq);
                        eqdata.setString(eqn);
                        DefaultMutableTreeNode eqchild = new DefaultMutableTreeNode(eqdata);
                        eqdata.setTreeNode(eqchild);
                        treeModel.insertNodeInto(eqchild, child, child.getChildCount());
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void insertAtomicGraphConstraintIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode graNode, EdAtomic atomicGC) {
        AtomicGraphConstraintTreeNodeData sd = new AtomicGraphConstraintTreeNodeData(atomicGC);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(node);
        treeModel.insertNodeInto(node, graNode, graNode.getChildCount());
        int j = 0;
        while (j < atomicGC.getConclusions().size()) {
            EdAtomic concl = atomicGC.getConclusions().elementAt(j);
            ConclusionTreeNodeData conclsd = new ConclusionTreeNodeData(concl);
            DefaultMutableTreeNode conclNode = new DefaultMutableTreeNode(conclsd);
            conclsd.setTreeNode(conclNode);
            treeModel.insertNodeInto(conclNode, node, node.getChildCount());
            CondTuple conds = (CondTuple)concl.getBasisAtomic().getAttrContext().getConditions();
            int c = 0;
            while (c < conds.getSize()) {
                CondMember cond = (CondMember)conds.getMemberAt(c);
                this.insertAttrConditionOfAtomicGC(treeModel, conclNode, cond);
                ++c;
            }
            ++j;
        }
    }

    private void insertAttrConditionOfAtomicGC(GraGraTreeModel treeModel, DefaultMutableTreeNode conclusionNode, CondMember condition) {
        EdAtomic conclusion = ((ConclusionTreeNodeData)conclusionNode.getUserObject()).getConclusion();
        String condStr = condition.getExprAsText();
        ConclusionAttrConditionTreeNodeData conddata = new ConclusionAttrConditionTreeNodeData(condition, conclusion);
        conddata.setString(condStr);
        DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
        conddata.setTreeNode(condchild);
        treeModel.insertNodeInto(condchild, conclusionNode, conclusionNode.getChildCount());
    }

    private void insertFormulaIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode graNode, EdConstraint formula) {
        ConstraintTreeNodeData sd = new ConstraintTreeNodeData(formula);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(node);
        treeModel.insertNodeInto(node, graNode, graNode.getChildCount());
    }

    private void insertRuleSequenceIntoTree(GraGraTreeModel treeModel, DefaultMutableTreeNode graNode, RuleSequence ruleSequence) {
        RuleSequenceTreeNodeData sd = new RuleSequenceTreeNodeData(ruleSequence);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(node);
        treeModel.insertNodeInto(node, graNode, graNode.getChildCount());
    }

    public static void expand(GraGraTreeView treeView, TreeNode treenode, TreePath treepath) {
        treeView.getTree().expandPath(treepath);
        int row = treeView.getTree().getRowForPath(treepath);
        GrammarTreeNode.expandpath(treeView, treenode, row);
        treeView.getTree().treeDidChange();
    }

    static void expandpath(GraGraTreeView treeView, TreeNode treenode, int row) {
        int i = 0;
        while (i < treenode.getChildCount()) {
            TreeNode child = treenode.getChildAt(i);
            if (child.getChildCount() > 0) {
                treeView.getTree().expandRow(++row);
                GrammarTreeNode.expandpath(treeView, child, row);
            }
            ++i;
        }
    }
}

