/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.editor.impl.EdGraGra;
import agg.gui.help.HtmlBrowser;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.util.Pair;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GraGraTriggerRuleOfLayerDialog
extends JDialog
implements ActionListener,
MouseListener {
    JPanel contentPane;
    JPanel rulePanel;
    JPanel buttonPanel;
    JScrollPane ruleScrollPane;
    JTable ruleTable;
    JButton closeButton;
    JButton cancelButton;
    JButton helpButton;
    boolean isCancelled;
    RuleLayer layer;
    EdGraGra gragra;
    HtmlBrowser helpBrowser;

    public GraGraTriggerRuleOfLayerDialog(JFrame parent, RuleLayer layer) {
        super((Frame)parent, true);
        this.setTitle("Set Trigger Rule");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GraGraTriggerRuleOfLayerDialog.this.exitForm(evt);
            }
        });
        this.layer = layer;
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.rulePanel = new JPanel(new BorderLayout());
        this.rulePanel.setBackground(Color.orange);
        this.rulePanel.setBorder(new TitledBorder("Set Trigger Rule for Layer"));
        this.ruleTable = new JTable(new HashTableModel(this.layer, new String[]{"Rule", "Layer", "Trigger"}));
        this.ruleTable.getColumn("Layer").setMaxWidth(50);
        this.ruleTable.setRowSelectionAllowed(true);
        this.ruleTable.setColumnSelectionAllowed(false);
        this.ruleTable.setSelectionBackground(Color.WHITE);
        TableColumn triggerColumn = this.ruleTable.getColumn("Trigger");
        triggerColumn.setMaxWidth(50);
        TriggerCellRenderer tcr = new TriggerCellRenderer(this.ruleTable.getRowCount(), this.ruleTable);
        triggerColumn.setCellRenderer(tcr);
        this.ruleTable.getSelectionModel().setSelectionMode(2);
        int hght = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight()) + 10;
        this.ruleTable.doLayout();
        this.ruleScrollPane = new JScrollPane(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(300, hght));
        this.rulePanel.add(this.ruleScrollPane);
        this.buttonPanel = new JPanel(new GridLayout(0, 3, 5, 5));
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept entries and close dialog.");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCancelled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.closeButton.setToolTipText("Reject entries and close dialog.");
        this.cancelButton.addActionListener(this);
        this.helpButton = new JButton();
        this.helpButton.setActionCommand("help");
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.contentPane.add((Component)this.rulePanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    private void acceptValues() {
        Hashtable<Rule, Pair<Integer, String>> table = ((HashTableModel)this.ruleTable.getModel()).getTable();
        Enumeration<Rule> e = table.keys();
        while (e.hasMoreElements()) {
            Rule key = e.nextElement();
            Integer l = (Integer)table.get((Object)key).first;
            key.setLayer(l);
            String trigger = (String)table.get((Object)key).second;
            if (trigger.equals("")) {
                key.setTriggerForLayer(false);
                continue;
            }
            key.setTriggerForLayer(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.acceptValues();
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.helpButton) {
            if (this.isModal()) {
                this.setModal(false);
            }
            if (this.helpBrowser == null) {
                if (this.isModal()) {
                    this.setModal(false);
                    this.setAlwaysOnTop(true);
                }
                this.helpBrowser = new HtmlBrowser("TriggerRuleHelp.html");
                this.helpBrowser.setSize(500, 300);
                this.helpBrowser.setLocation(50, 50);
                this.helpBrowser.setVisible(true);
            } else {
                this.helpBrowser.setVisible(true);
            }
        }
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable<Rule, Pair<Integer, String>> table;
        RuleLayer ruleLayer;

        public HashTableModel(RuleLayer layer, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            Hashtable<Rule, Integer> layerTable = layer.getRuleLayer();
            this.table = new Hashtable(layerTable.size());
            Enumeration<Rule> e = layerTable.keys();
            while (e.hasMoreElements()) {
                Rule key = e.nextElement();
                String trigger = "";
                if (key.isTriggerOfLayer()) {
                    trigger = "trigger";
                }
                Pair<Integer, String> value = new Pair<Integer, String>(layerTable.get(key), trigger);
                this.table.put(key, value);
            }
            this.ruleLayer = layer;
            Integer startLayer = layer.getStartLayer();
            Hashtable<Integer, HashSet<Rule>> invertedRuleLayer = layer.invertLayer();
            OrderedSet<Integer> ruleLayerSet = new OrderedSet<Integer>(new IntComparator());
            Enumeration<Integer> en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayerSet.add(en.nextElement());
            }
            int i2 = 0;
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet<Rule> rulesForLayer = invertedRuleLayer.get(currentLayer);
                for (Rule rule : rulesForLayer) {
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(rule.getLayer());
                    String trigger = rule.isTriggerOfLayer() ? new String("trigger") : new String("");
                    tmpVector.addElement(trigger);
                    this.addRow(tmpVector);
                }
                if (++i2 < ruleLayerSet.size()) {
                    currentLayer = (Integer)ruleLayerSet.get(i2);
                    continue;
                }
                nextLayerExists = false;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            } else {
                Object key = super.getValueAt(row, 0);
                if (key instanceof Rule) {
                    Pair<Integer, String> p = this.table.get(key);
                    if (column == 1) {
                        result = p.first;
                    } else if (column == 2) {
                        result = p.second;
                    }
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                if (column == 1) {
                    Integer i = Integer.valueOf((String)aValue);
                    Pair<Integer, String> pold = this.table.get(key);
                    if (((Integer)pold.first).intValue() != i.intValue()) {
                        super.setValueAt(i, row, column);
                        Pair<Integer, String> pnew = new Pair<Integer, String>(i, new String(""));
                        this.table.put((Rule)key, pnew);
                        this.ruleLayer.getRuleLayer().put((Rule)key, i);
                    }
                } else if (column == 2) {
                    String trigger = (String)aValue;
                    if (key instanceof Rule) {
                        Pair<Integer, String> pold = this.table.get(key);
                        Pair<Integer, String> pnew = new Pair<Integer, String>((Integer)pold.first, trigger);
                        this.table.put((Rule)key, pnew);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void refreshTriggerEntries(Object value, int row) {
            Rule rule = (Rule)super.getValueAt(row, 0);
            Enumeration<Rule> e = this.table.keys();
            while (e.hasMoreElements()) {
                String triggerOfKey;
                int layerOfKey;
                int rlayer;
                int rowOfKey;
                Rule key = e.nextElement();
                if (key.equals(rule) || (rowOfKey = this.getRow(key)) == -1 || (rlayer = ((Integer)this.getValueAt(row, 1)).intValue()) != (layerOfKey = ((Integer)this.getValueAt(rowOfKey, 1)).intValue()) || !(triggerOfKey = (String)this.getValueAt(rowOfKey, 2)).equals("trigger")) continue;
                Pair<Integer, String> pold = this.table.get(key);
                Pair<Integer, String> pnew = new Pair<Integer, String>((Integer)pold.first, "");
                this.table.put(key, pnew);
                super.setValueAt("", rowOfKey, 2);
                break;
            }
        }

        public Hashtable<Rule, Pair<Integer, String>> getTable() {
            return this.table;
        }

        public Rule getRule(String name) {
            Enumeration<Rule> e = this.table.keys();
            while (e.hasMoreElements()) {
                Rule key = e.nextElement();
                if (!key.getName().equals(name)) continue;
                return key;
            }
            return null;
        }

        public int getRow(Rule rule) {
            int i = 0;
            while (i < this.getRowCount()) {
                String rname = (String)this.getValueAt(i, 0);
                Rule r = this.getRule(rname);
                if (r != null && r.equals(rule)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public class TriggerCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer,
    MouseListener {
        Vector<JCheckBox> checks;
        public final JTable jtable;

        public TriggerCellRenderer(int size, JTable table) {
            this.addMouseListener(this);
            this.jtable = table;
            this.jtable.addMouseListener(this);
            this.checks = new Vector(size);
            this.initTriggers(size);
        }

        private void initTriggers(int size) {
            int i = 0;
            while (i < size) {
                JCheckBox cb = new JCheckBox("", false);
                cb.addMouseListener(this);
                cb.setBackground(Color.WHITE);
                this.checks.addElement(cb);
                Object value = ((DefaultTableModel)this.jtable.getModel()).getValueAt(i, 2);
                if (((String)value).equals("trigger")) {
                    cb.setSelected(true);
                }
                ++i;
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object aValue;
            JCheckBox jcb = this.checks.get(row);
            if (!isSelected && (aValue = ((DefaultTableModel)this.jtable.getModel()).getValueAt(row, 2)).equals("") && jcb.isSelected()) {
                jcb.setSelected(false);
            }
            return jcb;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i = 0;
            while (i < this.checks.size()) {
                JCheckBox cb = this.checks.get(i);
                if (this.jtable.isCellSelected(i, 2)) {
                    cb.setSelected(!cb.isSelected());
                    this.jtable.updateUI();
                    if (cb.isSelected()) {
                        cb.setBackground(this.jtable.getSelectionBackground());
                        ((DefaultTableModel)this.jtable.getModel()).setValueAt("trigger", i, 2);
                    } else {
                        ((DefaultTableModel)this.jtable.getModel()).setValueAt("", i, 2);
                    }
                    Object newValue = ((DefaultTableModel)this.jtable.getModel()).getValueAt(i, 2);
                    if (cb.isSelected()) {
                        ((HashTableModel)this.jtable.getModel()).refreshTriggerEntries(newValue, i);
                    }
                }
                ++i;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public Vector<JCheckBox> getChecks() {
            return this.checks;
        }
    }
}

