/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.cons.AtomConstraint;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.gui.AGGAppl;
import agg.gui.editor.GraphEditor;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.layout.ZestGraphLayout;
import agg.util.Pair;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.TypeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class FormulaGraphGUI
extends JDialog
implements ActionListener,
MouseListener {
    static final int OP = 0;
    static final int OPRND = 1;
    static final int TRUE = 2;
    static final int FALSE = 2;
    final JButton apply;
    final JButton cancel;
    final JButton clear;
    final JButton layout;
    final JPanel dialogPanel;
    JScrollPane scrollPane;
    JFrame parFrame;
    boolean changed;
    boolean canceled;
    String formula;
    String f;
    Formula tmpF;
    final List<Object> objs = new Vector<Object>(5, 1);
    final HashMap<String, Integer> name2indx = new HashMap();
    final GraphEditor gege;
    final EdGraph fgraph;
    final List<EdNode> subNodes = new Vector<EdNode>(5, 1);
    final List<EdType> op2type = new Vector<EdType>();
    final Hashtable<JMenuItem, EdType> oprnd2type = new Hashtable(5, 0.3f);
    final Hashtable<EdType, Object> type2obj = new Hashtable(5, 0.3f);
    final JPopupMenu commonMenu = new JPopupMenu("");
    final JPopupMenu oprndMenu = new JPopupMenu("");
    final JPopupMenu delMenu = new JPopupMenu("");
    final JPopupMenu layoutMenu = new JPopupMenu("");
    JMenuItem miDel;
    JMenuItem miRefGraph;
    boolean forallDisabled = false;
    JMenuItem miForall;
    EdNode topNode;
    EdNode node;
    EdType edgeType;
    EdType refEdgeType;
    boolean refined;

    public FormulaGraphGUI(JFrame parent, String nameOfOwner, String title, String helpStr, boolean modal) {
        super(parent, title, modal);
        this.parFrame = parent;
        this.formula = "";
        this.f = "";
        JPanel info = new JPanel(new GridLayout(3, 0));
        if (nameOfOwner != null && !"".equals(nameOfOwner)) {
            JLabel l1 = new JLabel(" The owner of this formula is the " + nameOfOwner);
            l1.setForeground(Color.BLUE);
            info.add(l1);
        }
        JLabel l2 = new JLabel(" Use the bg and node pop-up menus to edit the binary tree graph of the formula.");
        info.add(l2);
        JLabel l3 = new JLabel(helpStr);
        info.add(l3);
        this.gege = new GraphEditor();
        this.gege.getGraphPanel().getCanvas().addMouseListener(this);
        this.gege.setEditMode(13);
        this.gege.getGraphPanel().getCanvas().setEdgeAnchorVisible(false);
        this.gege.setTitle("   ");
        this.fgraph = new EdGraph(new Graph());
        this.fgraph.getBasisGraph().setName("    ");
        this.createOpTypes(this.fgraph.getTypeSet());
        this.createEdgeTypes(this.fgraph.getTypeSet());
        this.miDel = this.addDelete(this.delMenu);
        this.addLayout(this.layoutMenu);
        JPanel buttons = new JPanel(new GridBagLayout());
        this.layout = new JButton("Layout");
        this.layout.setToolTipText("Tree Graph Layout");
        this.layout.addActionListener(this);
        this.clear = new JButton("Clear");
        this.clear.addActionListener(this);
        this.apply = new JButton("Apply");
        this.apply.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.constrainBuild(buttons, this.clear, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 10, 5, 15);
        this.constrainBuild(buttons, this.apply, 2, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 15, 5, 15);
        this.constrainBuild(buttons, this.cancel, 3, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 15, 5, 10);
        this.dialogPanel = new JPanel(new GridBagLayout());
        this.dialogPanel.setPreferredSize(new Dimension(200, 200));
        this.constrainBuild(this.dialogPanel, info, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this.dialogPanel, this.gege, 0, 1, 1, 1, 1, 10, 1.0, 1.0, 5, 5, 5, 5);
        this.constrainBuild(this.dialogPanel, buttons, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.getContentPane().setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.dialogPanel);
        this.scrollPane.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        this.doZestTreeLayout(this.fgraph);
        super.setVisible(b);
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        if (this.gege != null) {
            this.gege.setExportJPEG(jpg);
        }
    }

    public void disableFORALL(boolean b) {
        this.forallDisabled = b;
    }

    public void doZestTreeLayout(EdGraph g) {
        ZestGraphLayout zestGL;
        String algorithm = "Tree (vertical)";
        if (this.parFrame != null && this.parFrame instanceof AGGAppl && (zestGL = ((AGGAppl)this.parFrame).getGraGraEditor().getZestGraphLayouter()) != null && !g.isEmpty()) {
            zestGL.setGraph(g);
            zestGL.setAlgorithm(algorithm);
            zestGL.setGraphDimension(new Dimension(this.gege.getGraphPanel().getCanvas().getSize().width - 20, this.gege.getGraphPanel().getCanvas().getSize().height - 20));
            if (zestGL.applyLayout()) {
                this.gege.updateGraphics(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Layout")) {
            this.doZestTreeLayout(this.fgraph);
        } else if (e.getActionCommand().equals("Clear")) {
            this.clear();
        } else if (e.getActionCommand().equals("Apply")) {
            this.setFormulaText();
            if ("".equals(this.formula)) {
                this.f = "";
            }
            this.changed = true;
            this.setVisible(false);
        } else if (e.getActionCommand().equals("Cancel")) {
            this.setVisible(false);
            this.canceled = true;
        }
    }

    public String getFormula() {
        if ("".equals(this.f)) {
            return "true";
        }
        return this.f;
    }

    public EdGraph getFormulaGraph() {
        return this.fgraph;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setVars(List<String> vars, List<Evaluable> varObjs, String formulaStr) {
        this.commonMenu.removeAll();
        this.oprndMenu.removeAll();
        Vector<String> s = new Vector<String>();
        int i = 0;
        while (i < vars.size()) {
            String name = vars.get(i);
            s.add(name);
            this.objs.add(name);
            EdType t = this.createOprndNodeType(this.fgraph.getTypeSet(), name);
            this.addOprndNodeType(this.commonMenu, t, i + 1);
            this.addOprndNodeType(this.oprndMenu, t, i + 1);
            this.name2indx.put(t.getTypeName(), i + 1);
            ++i;
        }
        this.commonMenu.addSeparator();
        this.commonMenu.addSeparator();
        this.addOpNodeTypes(this.commonMenu);
        this.commonMenu.addSeparator();
        this.commonMenu.addSeparator();
        this.addDelete(this.commonMenu);
        this.oprndMenu.addSeparator();
        this.oprndMenu.addSeparator();
        this.addDelete(this.oprndMenu);
        if (s.isEmpty()) {
            this.clear();
        } else {
            this.formula = formulaStr;
            this.fillFromString(formulaStr);
            Formula form = new Formula(varObjs, this.f);
            this.formula2graph(form, this.fgraph);
        }
        this.gege.setGraph(this.fgraph);
    }

    public void setVarsAsObjs(List<?> objList, String formulaStr) {
        this.commonMenu.removeAll();
        this.oprndMenu.removeAll();
        boolean allowRefGraph = false;
        Vector<Evaluable> vec = new Vector<Evaluable>();
        Vector<String> s = new Vector<String>();
        int i = 0;
        while (i < objList.size()) {
            EdType t;
            XMLObject obj;
            if (objList.get(i) instanceof EdNestedApplCond) {
                allowRefGraph = true;
                obj = (EdNestedApplCond)objList.get(i);
                vec.add(((EdNestedApplCond)obj).getNestedMorphism());
                s.add(((EdNestedApplCond)obj).getNestedMorphism().getName());
                this.objs.add(((EdNestedApplCond)obj).getNestedMorphism());
                t = this.createOprndNodeType(this.fgraph.getTypeSet(), ((EdNestedApplCond)obj).getNestedMorphism().getName());
                if (t != null) {
                    this.addOprndNodeType(this.commonMenu, t, i + 1);
                    this.addOprndNodeType(this.oprndMenu, t, i + 1);
                    this.name2indx.put(t.getTypeName(), i + 1);
                    this.type2obj.put(t, ((EdNestedApplCond)obj).getNestedMorphism());
                }
            } else if (objList.get(i) instanceof EdAtomic) {
                obj = (EdAtomic)objList.get(i);
                vec.add(((EdAtomic)obj).getBasisAtomic());
                s.add(((EdAtomic)obj).getBasisAtomic().getAtomicName());
                this.objs.add(((EdAtomic)obj).getBasisAtomic());
                t = this.createOprndNodeType(this.fgraph.getTypeSet(), ((EdAtomic)obj).getBasisAtomic().getAtomicName());
                if (t != null) {
                    this.addOprndNodeType(this.commonMenu, t, i + 1);
                    this.addOprndNodeType(this.oprndMenu, t, i + 1);
                    this.name2indx.put(t.getTypeName(), i + 1);
                    this.type2obj.put(t, ((EdAtomic)obj).getBasisAtomic());
                }
            }
            ++i;
        }
        this.commonMenu.addSeparator();
        this.commonMenu.addSeparator();
        this.addOpNodeTypes(this.commonMenu);
        this.commonMenu.addSeparator();
        this.commonMenu.addSeparator();
        this.addDelete(this.commonMenu);
        this.oprndMenu.addSeparator();
        this.oprndMenu.addSeparator();
        this.addDelete(this.oprndMenu);
        if (allowRefGraph) {
            this.miRefGraph(this.delMenu);
        }
        if (s.isEmpty()) {
            this.clear();
        } else {
            this.formula = formulaStr;
            this.fillFromString(formulaStr);
            Formula form = new Formula(vec, this.f);
            this.formula2graph(form, this.fgraph);
        }
        this.gege.setGraph(this.fgraph);
    }

    private List<EdNode> addRefGraphOf(Formula form, EdNode refNode) {
        Vector<EdNode> list = new Vector<EdNode>(5, 1);
        EdGraph refGraph = new EdGraph(new Graph());
        this.createOpTypes(refGraph.getTypeSet());
        refGraph.getTypeSet().createArcType("", 61, Color.BLACK);
        this.formula2graph(form, refGraph);
        Hashtable<EdNode, EdNode> go2go = new Hashtable<EdNode, EdNode>();
        int x = refNode.getX();
        int y = refNode.getY() + 40;
        Vector<EdNode> v = refGraph.getNodes();
        int i = 0;
        while (i < v.size()) {
            EdNode go = v.get(i);
            EdType t = this.fgraph.getTypeSet().getTypeForName(go.getTypeName());
            if (t == null) {
                t = this.fgraph.getTypeSet().createNodeType(go.getTypeName(), 51, Color.BLUE);
            }
            try {
                EdNode n1 = this.fgraph.addNode(x, y, t, true);
                n1.getBasisNode().setContextUsage(go.getBasisNode().getContextUsage());
                this.subNodes.add(n1);
                if (this.type2obj.get(go.getType()) != null) {
                    this.type2obj.put(t, this.type2obj.get(go.getType()));
                }
                if (go.getInArcsCount() == 0) {
                    EdArc ref = this.fgraph.addArc(this.refEdgeType, refNode, n1, null, true);
                    ref.getBasisArc().setContextUsage(-1);
                    this.refined = true;
                }
                if (go.getOutArcsCount() == 0) {
                    list.add(n1);
                }
                go2go.put(go, n1);
            }
            catch (TypeException n1) {
                // empty catch block
            }
            ++i;
        }
        Vector<EdArc> v1 = refGraph.getArcs();
        int i2 = 0;
        while (i2 < v1.size()) {
            EdArc go = v1.get(i2);
            EdNode src = (EdNode)go2go.get(go.getSource());
            EdNode tar = (EdNode)go2go.get(go.getTarget());
            int dx = go.getTarget().getX() - go.getSource().getX();
            int dy = go.getTarget().getY() - go.getSource().getY();
            tar.setXY(src.getX() + dx, src.getY() + dy);
            try {
                this.fgraph.addArc(this.edgeType, src, tar, null, true);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            ++i2;
        }
        return list;
    }

    private void formula2graph(Formula form, EdGraph graph) {
        String tname = null;
        EdNode n = null;
        EdType t = null;
        int op = form.getOperation();
        switch (op) {
            case 0: {
                if (form.getFirst() == null) break;
                if (form.getFirst() instanceof Formula) {
                    this.formula2graph((Formula)form.getFirst(), graph);
                    break;
                }
                if (form.getFirst() instanceof NestedApplCond) {
                    tname = ((NestedApplCond)form.getFirst()).getName();
                    t = graph.getTypeSet().getNodeTypeForName(tname);
                    if (t == null) {
                        t = this.createOprndNodeType(graph.getTypeSet(), tname);
                        this.objs.add(form.getFirst());
                        this.type2obj.put(t, form.getFirst());
                    }
                    n = this.addNode(graph, t, 1);
                    this.type2obj.put(t, form.getFirst());
                    break;
                }
                if (!(form.getFirst() instanceof AtomConstraint)) break;
                tname = ((AtomConstraint)form.getFirst()).getAtomicName();
                t = graph.getTypeSet().getNodeTypeForName(tname);
                if (t == null) {
                    t = this.createOprndNodeType(graph.getTypeSet(), tname);
                    this.objs.add(form.getFirst());
                    this.type2obj.put(t, form.getFirst());
                }
                n = this.addNode(graph, t, 1);
                break;
            }
            case 3: {
                if (form.getFirst() == null || (n = this.addNode(graph, t = graph.getTypeSet().getNodeTypeForName("NOT"), 0)) == null) break;
                this.node = n;
                if (form.getFirst() instanceof Formula) {
                    this.formula2graph((Formula)form.getFirst(), graph);
                    break;
                }
                if (form.getFirst() instanceof NestedApplCond) {
                    tname = ((NestedApplCond)form.getFirst()).getName();
                    t = graph.getTypeSet().getNodeTypeForName(tname);
                    if (t == null) {
                        t = this.createOprndNodeType(graph.getTypeSet(), tname);
                    }
                    n = this.addNode(graph, t, 1);
                    break;
                }
                if (!(form.getFirst() instanceof AtomConstraint)) break;
                tname = ((AtomConstraint)form.getFirst()).getAtomicName();
                t = graph.getTypeSet().getNodeTypeForName(tname);
                if (t == null) {
                    t = this.createOprndNodeType(graph.getTypeSet(), tname);
                }
                n = this.addNode(graph, t, 1);
                break;
            }
            case 4: {
                t = graph.getTypeSet().getNodeTypeForName("AND");
                n = this.addNode(graph, t, 0);
                if (n == null) break;
                this.node = n;
                if (form.getFirst() != null) {
                    if (form.getFirst() instanceof Formula) {
                        this.formula2graph((Formula)form.getFirst(), graph);
                        this.node = n;
                    } else if (form.getFirst() instanceof NestedApplCond) {
                        tname = ((NestedApplCond)form.getFirst()).getName();
                        t = graph.getTypeSet().getNodeTypeForName(tname);
                        if (t == null) {
                            t = this.createOprndNodeType(graph.getTypeSet(), tname);
                        }
                        n = this.addNode(graph, t, 1);
                    } else if (form.getFirst() instanceof AtomConstraint) {
                        tname = ((AtomConstraint)form.getSecond()).getAtomicName();
                        t = graph.getTypeSet().getNodeTypeForName(tname);
                        if (t == null) {
                            t = this.createOprndNodeType(graph.getTypeSet(), tname);
                        }
                        n = this.addNode(graph, t, 1);
                    }
                }
                if (form.getSecond() == null) break;
                if (form.getSecond() instanceof Formula) {
                    this.formula2graph((Formula)form.getSecond(), graph);
                    break;
                }
                if (form.getSecond() instanceof NestedApplCond) {
                    tname = ((NestedApplCond)form.getSecond()).getName();
                    t = graph.getTypeSet().getNodeTypeForName(tname);
                    if (t == null) {
                        t = this.createOprndNodeType(graph.getTypeSet(), tname);
                    }
                    n = this.addNode(graph, t, 1);
                    break;
                }
                if (!(form.getSecond() instanceof AtomConstraint)) break;
                tname = ((AtomConstraint)form.getSecond()).getAtomicName();
                t = graph.getTypeSet().getNodeTypeForName(tname);
                if (t == null) {
                    t = this.createOprndNodeType(graph.getTypeSet(), tname);
                }
                n = this.addNode(graph, t, 1);
                break;
            }
            case 5: {
                t = graph.getTypeSet().getNodeTypeForName("OR");
                n = this.addNode(graph, t, 0);
                if (n == null) break;
                this.node = n;
                if (form.getFirst() != null) {
                    if (form.getFirst() instanceof Formula) {
                        this.formula2graph((Formula)form.getFirst(), graph);
                        this.node = n;
                    } else if (form.getFirst() instanceof NestedApplCond) {
                        tname = ((NestedApplCond)form.getFirst()).getName();
                        t = graph.getTypeSet().getNodeTypeForName(tname);
                        if (t == null) {
                            t = this.createOprndNodeType(graph.getTypeSet(), tname);
                        }
                        n = this.addNode(graph, t, 1);
                    } else if (form.getFirst() instanceof AtomConstraint) {
                        tname = ((AtomConstraint)form.getFirst()).getAtomicName();
                        t = graph.getTypeSet().getNodeTypeForName(tname);
                        if (t == null) {
                            t = this.createOprndNodeType(graph.getTypeSet(), tname);
                        }
                        n = this.addNode(graph, t, 1);
                    }
                }
                if (form.getSecond() == null) break;
                if (form.getFirst() instanceof Formula) {
                    this.formula2graph((Formula)form.getSecond(), graph);
                    break;
                }
                if (form.getSecond() instanceof NestedApplCond) {
                    tname = ((NestedApplCond)form.getSecond()).getName();
                    t = graph.getTypeSet().getNodeTypeForName(tname);
                    if (t == null) {
                        t = this.createOprndNodeType(graph.getTypeSet(), tname);
                    }
                    n = this.addNode(graph, t, 1);
                    break;
                }
                if (!(form.getSecond() instanceof AtomConstraint)) break;
                tname = ((AtomConstraint)form.getSecond()).getAtomicName();
                t = graph.getTypeSet().getNodeTypeForName(tname);
                if (t == null) {
                    t = this.createOprndNodeType(graph.getTypeSet(), tname);
                }
                n = this.addNode(graph, t, 1);
                break;
            }
            case 7: {
                if (form.getFirst() == null) break;
                t = graph.getTypeSet().getNodeTypeForName("FORALL");
                n = this.addNode(graph, t, 0);
                if (n != null) {
                    this.node = n;
                }
                if (form.getFirst() instanceof Formula) {
                    this.formula2graph((Formula)form.getFirst(), graph);
                    break;
                }
                if (form.getFirst() instanceof NestedApplCond) {
                    tname = ((NestedApplCond)form.getFirst()).getName();
                    t = graph.getTypeSet().getNodeTypeForName(tname);
                    if (t == null) {
                        t = this.createOprndNodeType(graph.getTypeSet(), tname);
                    }
                    n = this.addNode(graph, t, 1);
                    break;
                }
                if (!(form.getFirst() instanceof AtomConstraint)) break;
                tname = ((AtomConstraint)form.getFirst()).getAtomicName();
                t = graph.getTypeSet().getNodeTypeForName(tname);
                if (t == null) {
                    t = this.createOprndNodeType(graph.getTypeSet(), tname);
                }
                n = this.addNode(graph, t, 1);
                break;
            }
            case 1: {
                t = graph.getTypeSet().getNodeTypeForName(tname);
                if (t == null) {
                    String st = "true";
                    t = this.createOpNodeType(graph.getTypeSet(), st);
                }
                n = this.addNode(graph, t, 2);
                break;
            }
            case 2: {
                t = graph.getTypeSet().getNodeTypeForName(tname);
                if (t == null) {
                    String sf = "false";
                    t = this.createOpNodeType(graph.getTypeSet(), sf);
                }
                n = this.addNode(graph, t, 2);
            }
        }
    }

    private void add2formula(String s, int i) {
        this.f = i == -1 ? this.f.concat(s) : this.f.concat(String.valueOf(i));
    }

    void clear() {
        try {
            this.fgraph.deleteAll();
            this.gege.updateGraphics();
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        this.f = "";
        this.formula = "";
        this.topNode = null;
        this.node = null;
    }

    private void fillFromString(String str) {
        String s = str.replaceAll(" ", "");
        String s2 = s.replace("(T)", "T");
        while (s2.indexOf("(T)") >= 0) {
            String s3;
            s2 = s3 = s2.replace("(T)", "T");
        }
        s = s2;
        StringCharacterIterator i = new StringCharacterIterator(s);
        char c = i.current();
        while (c != '\uffff') {
            String cs;
            if (c == '&' || c == '|' || c == '!' || c == '$' || c == 'A' || c == 'E' || c == 'T' || c == 'F' || c == ' ' || c == ',' || c == '(' || c == ')') {
                this.add2formula(String.valueOf(c), -1);
                i.next();
            } else if (c >= '0' && c <= '9') {
                cs = "";
                int v = 0;
                while (c >= '0' && c <= '9') {
                    cs = cs.concat(String.valueOf(c));
                    v = v * 10 + (c - 48);
                    c = i.next();
                }
                if (--v < 0) {
                    return;
                }
                int num = Integer.valueOf(cs);
                if (this.objs.size() > 0 && num - 1 < this.objs.size()) {
                    Object obj = this.objs.get(num - 1);
                    if (obj instanceof String) {
                        this.add2formula((String)obj, num);
                    } else if (obj instanceof NestedApplCond) {
                        this.add2formula(((NestedApplCond)obj).getName(), num);
                    } else if (obj instanceof AtomConstraint) {
                        this.add2formula(((AtomConstraint)obj).getAtomicName(), num);
                    }
                }
            } else if (c == 'f' || c == 't') {
                cs = String.valueOf(c);
                char c1 = c;
                while (i.current() >= 'a' && i.current() <= 'z') {
                    c1 = i.next();
                    if (c1 == '\uffff') continue;
                    cs = cs.concat(String.valueOf(c1));
                }
                this.add2formula(String.valueOf(cs), -1);
            }
            c = i.current();
        }
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    private void createOpTypes(EdTypeSet types) {
        EdType t = types.createNodeType("NOT", 54, Color.RED);
        this.op2type.add(t);
        t = types.createNodeType("AND", 54, Color.BLACK);
        this.op2type.add(t);
        t = types.createNodeType("OR", 54, Color.BLACK);
        this.op2type.add(t);
        t = types.createNodeType("FORALL", 54, Color.BLACK);
        this.op2type.add(t);
    }

    private EdType createOpNodeType(EdTypeSet types, String name) {
        EdType t = types.createNodeType(name, 51, Color.BLACK);
        return t;
    }

    private void createEdgeTypes(EdTypeSet types) {
        if (this.edgeType == null) {
            this.edgeType = types.createArcType("", 61, Color.BLACK);
        }
        if (this.refEdgeType == null) {
            this.refEdgeType = types.createArcType("", 61, Color.BLUE);
        }
    }

    private EdType createOprndNodeType(EdTypeSet types, String name) {
        EdType t = types.createNodeType(name, 51, Color.BLUE);
        return t;
    }

    private JMenuItem addOprndNodeType(JPopupMenu m, EdType t, int indx) {
        JMenuItem mi = m.add(new JMenuItem(t.getName()));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Integer.valueOf(((JMenuItem)e.getSource()).getActionCommand()).intValue();
                    FormulaGraphGUI.this.addNode(FormulaGraphGUI.this.fgraph, FormulaGraphGUI.this.oprnd2type.get(e.getSource()), 1);
                }
                catch (NumberFormatException ex) {
                    FormulaGraphGUI.this.addNode(FormulaGraphGUI.this.fgraph, FormulaGraphGUI.this.oprnd2type.get(e.getSource()), 0);
                }
            }
        });
        if ("FORALL".equals(t.getName())) {
            this.miForall = mi;
        }
        if (indx == -1) {
            mi.setActionCommand(" ");
        } else {
            mi.setActionCommand(String.valueOf(indx));
        }
        this.oprnd2type.put(mi, t);
        return mi;
    }

    private void addOpNodeTypes(JPopupMenu m) {
        int i = 0;
        while (i < this.op2type.size()) {
            EdType t = this.op2type.get(i);
            this.addOprndNodeType(m, t, -1);
            ++i;
        }
    }

    private void miRefGraph(JPopupMenu m) {
        this.miRefGraph = new JMenuItem("Show View of Refinement Formula Graph");
        this.miRefGraph.setActionCommand("show");
        m.addSeparator();
        m.addSeparator();
        m.add(this.miRefGraph);
        this.miRefGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj;
                if (FormulaGraphGUI.this.node != null && (obj = FormulaGraphGUI.this.type2obj.get(FormulaGraphGUI.this.node.getType())) != null && obj instanceof NestedApplCond && ((NestedApplCond)obj).getName().equals(FormulaGraphGUI.this.node.getTypeName())) {
                    Node n;
                    EdNode go;
                    FormulaGraphGUI.this.tmpF = ((NestedApplCond)obj).getFormula();
                    if ("show".equals(FormulaGraphGUI.this.miRefGraph.getActionCommand())) {
                        FormulaGraphGUI.this.doRefine(FormulaGraphGUI.this.tmpF, FormulaGraphGUI.this.node);
                        FormulaGraphGUI.this.gege.updateGraphics(true);
                        FormulaGraphGUI.this.miRefGraph.setText("Hide View of Refinement Formula Graph");
                        FormulaGraphGUI.this.miRefGraph.setActionCommand("hide");
                    } else if ("hide".equals(FormulaGraphGUI.this.miRefGraph.getActionCommand()) && FormulaGraphGUI.this.node.getBasisNode().getOutgoingArcs().hasNext() && (go = FormulaGraphGUI.this.fgraph.findNode(n = (Node)FormulaGraphGUI.this.node.getBasisNode().getOutgoingArcs().next().getTarget())) != null) {
                        FormulaGraphGUI.this.deleteNode(go);
                        FormulaGraphGUI.this.gege.updateGraphics(true);
                        FormulaGraphGUI.this.miRefGraph.setText("Show View of Refinement Formula Graph");
                        FormulaGraphGUI.this.miRefGraph.setActionCommand("show");
                    }
                }
            }
        });
    }

    void doRefine(Formula form, EdNode refNode) {
        List<EdNode> list = this.addRefGraphOf(form, refNode);
        int i = 0;
        while (i < list.size()) {
            EdNode n = list.get(i);
            Object obj = this.type2obj.get(n.getType());
            if (obj != null && obj instanceof NestedApplCond && ((NestedApplCond)obj).getName().equals(n.getTypeName())) {
                Formula form1 = ((NestedApplCond)obj).getFormula();
                this.doRefine(form1, n);
            }
            ++i;
        }
    }

    private void enableRefGraph(boolean enable, String action) {
        if (this.miRefGraph == null) {
            return;
        }
        this.miRefGraph.setEnabled(enable);
        if ("show".equals(action)) {
            this.miRefGraph.setText("Show View of Refinement Formula Graph");
            this.miRefGraph.setActionCommand("show");
        } else if ("hide".equals(action)) {
            this.miRefGraph.setText("Hide View of Refinement Formula Graph");
            this.miRefGraph.setActionCommand("hide");
        }
    }

    private JMenuItem addDelete(JPopupMenu m) {
        JMenuItem mi = m.add(new JMenuItem("Delete"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FormulaGraphGUI.this.node != null) {
                    FormulaGraphGUI.this.deleteNode(FormulaGraphGUI.this.node);
                    FormulaGraphGUI.this.fgraph.updateGraph();
                    FormulaGraphGUI.this.gege.updateGraphics();
                }
            }
        });
        return mi;
    }

    private JMenuItem addLayout(JPopupMenu m) {
        JMenuItem mi = m.add(new JMenuItem("Graph Layout"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormulaGraphGUI.this.doZestTreeLayout(FormulaGraphGUI.this.fgraph);
            }
        });
        return mi;
    }

    private void deleteNode(EdNode n) {
        if (n.getInArcsCount() == 1) {
            try {
                this.fgraph.delSelectedArc(this.fgraph.getIncomingArcs(n).get(0));
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        Vector<EdArc> outs = this.fgraph.getOutgoingArcs(n);
        int i = 0;
        while (i < outs.size()) {
            EdNode n1 = (EdNode)outs.get(i).getTarget();
            this.deleteNode(n1);
            ++i;
        }
        try {
            this.subNodes.remove(n);
            this.fgraph.delSelectedNode(n);
        }
        catch (TypeException typeException) {
            // empty catch block
        }
    }

    private void deleteRefinement() {
        boolean del = true;
        block0: while (del) {
            Vector<EdNode> list = this.fgraph.getNodes();
            del = false;
            int i = 0;
            while (i < list.size()) {
                EdNode n = list.get(i);
                del = this.deleteRefOfNode(n);
                if (del) continue block0;
                ++i;
            }
        }
    }

    private boolean deleteRefOfNode(EdNode n) {
        boolean res = false;
        Vector<EdArc> outs = this.fgraph.getOutgoingArcs(n);
        int i = 0;
        while (i < outs.size()) {
            EdNode n1 = (EdNode)outs.get(i).getTarget();
            if (this.subNodes.contains(n1)) {
                this.deleteNode(n1);
                res = true;
            }
            ++i;
        }
        return res;
    }

    EdNode addNode(EdGraph graph, EdType t, int kind) {
        if (this.fgraph == graph && graph.isEmpty()) {
            return this.addTopNode(graph, t, kind);
        }
        if (this.node != null) {
            int y;
            int x;
            block9: {
                int dx = 50;
                int dy = 40;
                x = this.node.getX();
                y = this.node.getY() + dy;
                if (this.node.getOutArcsCount() == 0) {
                    if (this.node.getTypeName().equals("AND") || this.node.getTypeName().equals("OR")) {
                        x = x - 60 > 0 ? (x -= dx) : dx / 2;
                    }
                    break block9;
                }
                if (this.node.getOutArcsCount() == 1) {
                    x += dx;
                    break block9;
                }
                return null;
            }
            try {
                EdNode n = graph.addNode(x, y, t, true);
                n.getBasisNode().setContextUsage(kind);
                EdType arcType = this.edgeType;
                if (graph != this.fgraph) {
                    arcType = graph.getTypeSet().getArcTypeForName("");
                }
                graph.addArc(arcType, this.node, n, null, true);
                this.gege.updateGraphics();
                return n;
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return null;
    }

    private EdNode addTopNode(EdGraph graph, EdType t, int kind) {
        try {
            int x = this.gege.getGraphPanel().getWidth() / 2;
            int y = 50;
            EdNode n = graph.addNode(x, y, t, true);
            n.getBasisNode().setContextUsage(kind);
            this.topNode = n;
            this.gege.updateGraphics();
            return n;
        }
        catch (TypeException typeException) {
            return null;
        }
    }

    private void resetTopNode() {
        if (!this.fgraph.getNodes().isEmpty()) {
            Vector<EdNode> list = this.fgraph.getNodes();
            int i = 0;
            while (i < list.size()) {
                EdNode n = list.get(i);
                if (n.getBasisNode().getNumberOfIncomingArcs() == 0) {
                    this.topNode = n;
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        EdGraphObject go = this.gege.getGraph().getPicked(e.getX(), e.getY());
        this.node = go != null && go.isNode() ? (EdNode)go : null;
        if (this.fgraph.isEmpty() || e.isPopupTrigger()) {
            if (this.fgraph.hasSelection()) {
                this.fgraph.deselectAll();
            }
            if (e.getX() > this.getSize().width - 50 || e.getY() > this.getSize().height) {
                this.showPopupMenu(this.node, this.getSize().width / 3, this.getSize().height / 2);
            } else {
                this.showPopupMenu(this.node, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.fgraph.isEmpty() || e.isPopupTrigger()) {
            if (this.fgraph.hasSelection()) {
                this.fgraph.deselectAll();
            }
            if (e.getX() > this.getSize().width - 50 || e.getY() > this.getSize().height) {
                this.showPopupMenu(this.node, this.getSize().width / 3, this.getSize().height / 4);
            } else {
                this.showPopupMenu(this.node, e.getX(), e.getY());
            }
        }
    }

    private void showPopupMenu(EdNode n, int x, int y) {
        if (this.miForall != null) {
            this.miForall.setEnabled(!this.forallDisabled);
        }
        if (this.fgraph.isEmpty()) {
            this.commonMenu.show(this.gege.getGraphPanel(), x, y);
        } else if (n == null) {
            this.layoutMenu.show(this.gege.getGraphPanel(), x, y);
        } else {
            int c = n.getOutArcsCount();
            switch (c) {
                case 0: {
                    if (this.subNodes.contains(n)) {
                        this.miDel.setEnabled(false);
                    } else {
                        this.miDel.setEnabled(true);
                    }
                    if (n.getBasisNode().getContextUsage() == 0) {
                        if (n.getTypeName().equals("FORALL")) {
                            this.oprndMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                            break;
                        }
                        this.commonMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                        break;
                    }
                    if (n.getBasisNode().getContextUsage() == 1) {
                        if (this.hasRefGraph(n)) {
                            this.enableRefGraph(true, "show");
                        } else {
                            this.enableRefGraph(false, "show");
                        }
                        this.delMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                        break;
                    }
                    if (n.getBasisNode().getContextUsage() == 2) {
                        this.enableRefGraph(false, "");
                        this.delMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                        break;
                    }
                    if (n.getBasisNode().getContextUsage() != 2) break;
                    this.enableRefGraph(false, "");
                    this.delMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                    break;
                }
                case 1: {
                    if (this.subNodes.contains(n)) {
                        return;
                    }
                    if (n.getBasisNode().getContextUsage() == 1) {
                        if (n.getBasisNode().getOutgoingArcs().next().getType() == this.refEdgeType.getBasisType()) {
                            this.enableRefGraph(true, "hide");
                        } else {
                            this.enableRefGraph(false, "hide");
                        }
                    } else {
                        this.enableRefGraph(false, "show");
                    }
                    this.miDel.setEnabled(true);
                    if (n.getTypeName().equals("AND") || n.getTypeName().equals("OR")) {
                        this.commonMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                        break;
                    }
                    this.delMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                    break;
                }
                case 2: {
                    if (this.subNodes.contains(n)) {
                        return;
                    }
                    this.enableRefGraph(false, "show");
                    this.miDel.setEnabled(true);
                    this.delMenu.show(this.gege.getGraphPanel(), x + 5, y + 5);
                }
            }
        }
    }

    private boolean hasRefGraph(EdNode n) {
        Object obj = this.type2obj.get(n.getType());
        if (obj != null && obj instanceof NestedApplCond) {
            String fstr = ((NestedApplCond)obj).getFormulaText();
            return !"".equals(fstr) && !"true".equals(fstr) && !"false".equals(fstr);
        }
        return false;
    }

    private Pair<String, String> graph2text(Node n) {
        Node n1 = null;
        String s = "";
        String s1 = "";
        int c = n.getNumberOfOutgoingArcs();
        switch (c) {
            case 0: {
                s = n.getType().getName();
                if ("true".equals(s)) {
                    s = "T";
                    s1 = "T";
                    break;
                }
                if ("false".equals(s)) {
                    s = "F";
                    s1 = "F";
                    break;
                }
                if (this.name2indx.get(n.getType().getName()) != null) {
                    s1 = String.valueOf(this.name2indx.get(n.getType().getName()));
                    break;
                }
                s1 = n.getType().getName();
                break;
            }
            case 1: {
                if (n.getOutgoingArcs().next().getContextUsage() == -1) {
                    s = n.getType().getName();
                    if (this.name2indx.get(n.getType().getName()) != null) {
                        s1 = String.valueOf(this.name2indx.get(n.getType().getName()));
                        break;
                    }
                    s1 = n.getType().getName();
                    break;
                }
                n1 = (Node)n.getOutgoingArcs().next().getTarget();
                if (n.getType().getName().equals("NOT")) {
                    Pair<String, String> p = this.graph2text(n1);
                    s = " !" + (String)p.first;
                    s1 = " !" + (String)p.second;
                    break;
                }
                if (n.getType().getName().equals("FORALL")) {
                    Pair<String, String> p1 = this.graph2text(n1);
                    s = " FORALL(" + (String)p1.first + ")";
                    s1 = " A(" + (String)p1.second + ")";
                    break;
                }
                Pair<String, String> p = this.graph2text(n1);
                s = String.valueOf(n.getType().getName()) + "(" + (String)p.first + ")";
                s1 = String.valueOf(n.getType().getName()) + "(" + (String)p.second + ")";
                break;
            }
            case 2: {
                Iterator<Arc> outs = n.getOutgoingArcs();
                n1 = (Node)outs.next().getTarget();
                Node n2 = (Node)outs.next().getTarget();
                if (n.getType().getName().equals("AND")) {
                    Pair<String, String> p1 = this.graph2text(n1);
                    Pair<String, String> p2 = this.graph2text(n2);
                    s = "(" + (String)p1.first + " & " + (String)p2.first + ")";
                    s1 = "(" + (String)p1.second + " & " + (String)p2.second + ")";
                    break;
                }
                if (!n.getType().getName().equals("OR")) break;
                Pair<String, String> p1 = this.graph2text(n1);
                Pair<String, String> p2 = this.graph2text(n2);
                s = "(" + (String)p1.first + " | " + (String)p2.first + ")";
                s1 = "(" + (String)p1.second + " | " + (String)p2.second + ")";
            }
        }
        return new Pair<String, String>(s, s1);
    }

    private void setFormulaText() {
        if (this.topNode.getBasisNode().getNumberOfOutgoingArcs() == 0 && this.fgraph.getNodes().size() > 1) {
            this.resetTopNode();
        }
        if (this.topNode != null) {
            if (this.refined) {
                this.deleteRefinement();
                this.refined = false;
            }
            Pair<String, String> p = this.graph2text(this.topNode.getBasisNode());
            String s = (String)p.first;
            String s1 = (String)p.second;
            s = s.replaceAll("this", "$");
            s1 = s1.replaceAll("this", "$");
            this.formula = s;
            this.f = s1;
        }
    }
}

