/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrMember;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.AttrTypeMember;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.TupleEvent;
import agg.attribute.impl.TupleObject;
import agg.attribute.impl.ValueTuple;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.OpenViewSetting;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

public class DeclTuple
extends TupleObject
implements AttrType,
AttrMsgCode,
XMLObject {
    protected static AttrViewSetting fixedFormSetting;
    private OpenViewSetting view = null;
    protected final Vector<DeclTuple> parents = new Vector(5);
    private final Vector<DeclTuple> directParents = new Vector(5);
    protected boolean loneDeclaration = false;

    public DeclTuple(AttrTupleManager manager) {
        this(manager, null);
    }

    public DeclTuple(AttrTupleManager manager, DeclTuple parent) {
        super(manager, parent);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.view != null) {
            this.view.removeFormat(this);
        }
        this.view = null;
    }

    @Override
    protected void finalize() {
        super.finalize();
    }

    protected void removeParents() {
        int i = 0;
        while (i < this.parents.size()) {
            this.parents.get(i).removeObserver(this);
            ++i;
        }
        this.parents.clear();
    }

    protected Vector<DeclTuple> getParents() {
        return this.parents;
    }

    public Enumeration<DeclTuple> getAllParents() {
        return this.parents.elements();
    }

    protected DeclTuple getParent(int index) {
        if (index < this.directParents.size()) {
            return this.directParents.get(index);
        }
        return null;
    }

    public boolean hasParent(DeclTuple t) {
        return this.parents.contains(t);
    }

    public boolean hasChild(DeclTuple t) {
        return t.parents.contains(this);
    }

    public void setView(OpenViewSetting ovs) {
        this.view = ovs;
    }

    public OpenViewSetting getView() {
        return this.view;
    }

    @Override
    public int getSize() {
        return this.getParentsSize() + this.rawGetSize();
    }

    public int getParentSize(DeclTuple p) {
        if (this.parents.contains(p)) {
            return p.getSize();
        }
        return 0;
    }

    protected int getParentsSize() {
        int s = 0;
        if (this.parents.isEmpty()) {
            return 0;
        }
        int i = 0;
        while (i < this.parents.size()) {
            s += this.parents.get(i).rawGetSize();
            ++i;
        }
        return s;
    }

    public Vector<DeclTuple> getDirectParents() {
        return this.directParents;
    }

    protected int toLeafIndex(int rootIndex) {
        return rootIndex - this.getParentsSize();
    }

    protected int toRootIndex(int leafIndex) {
        return leafIndex + this.getParentsSize();
    }

    protected AttrMember getLeafMemberAt(int rootIndex) {
        return this.rawGetMemberAt(this.toLeafIndex(rootIndex));
    }

    protected DeclMember getDeclMemberAt(int index) {
        return (DeclMember)this.getMemberAt(index);
    }

    protected DeclMember getDeclMemberAt(String name) {
        return (DeclMember)this.getMemberAt(name);
    }

    protected DeclMember newMember() {
        return new DeclMember(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteLeafMemberAt(int rootIndex) {
        DeclTuple declTuple = this;
        synchronized (declTuple) {
            this.fireAttrChanged(21, rootIndex);
            this.rawDeleteMemberAt(this.toLeafIndex(rootIndex));
            this.fireAttrChanged(20, rootIndex);
        }
    }

    @Override
    protected AttrViewSetting getForm() {
        return fixedFormSetting;
    }

    @Override
    protected void setForm(AttrViewSetting formSetting) {
        fixedFormSetting = formSetting;
    }

    @Override
    public DeclTuple getTupleType() {
        return this;
    }

    public void checkNameValidity(String name) {
        if (name == null) {
            return;
        }
        int first = -1;
        boolean valid = true;
        int i = 0;
        while (i < this.getSize()) {
            if (this.getMemberAt(i) != null && name.equals(this.getMemberAt(i).getName())) {
                if (first == -1) {
                    first = i;
                } else {
                    this.getDeclMemberAt(i).setNameValid(false);
                }
            }
            ++i;
        }
        if (first != -1) {
            this.getDeclMemberAt(first).setNameValid(valid);
        }
    }

    public boolean isClassName(String name) {
        Boolean cache = ((AttrTupleManager)AttrTupleManager.getDefaultManager()).classNameLookupMap.get(name);
        if (cache != null) {
            return cache;
        }
        boolean isClass = false;
        try {
            Class.forName(name);
            isClass = true;
            if (cache == null) {
                ((AttrTupleManager)AttrTupleManager.getDefaultManager()).classNameLookupMap.put(name, Boolean.TRUE);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (!isClass) {
            AttrHandler[] attrHandlers = AttrTupleManager.getDefaultManager().getHandlers();
            int h = 0;
            while (h < attrHandlers.length) {
                AttrHandler attrh = attrHandlers[h];
                Vector<String> packs = ((JexHandler)attrh).getClassResolver().getPackages();
                int pi = 0;
                while (pi < packs.size()) {
                    String test = name;
                    String pack = packs.get(pi);
                    if (!test.startsWith(pack)) {
                        test = String.valueOf(pack) + "." + name;
                    }
                    try {
                        Class.forName(test);
                        isClass = true;
                        if (cache != null) break;
                        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).classNameLookupMap.put(test, Boolean.TRUE);
                        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).classNameLookupMap.put(name, Boolean.TRUE);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                    ++pi;
                }
                if (isClass) break;
                ++h;
            }
        }
        return isClass;
    }

    public boolean containsName(String name) {
        return this.getIndexForName(name) > -1;
    }

    public boolean containsMember(DeclMember m) {
        return m.getHoldingTuple() == this;
    }

    public boolean isLeafMember(String name) {
        return this.getLeafMemberAt(this.getIndexForName(name)) != null;
    }

    @Override
    public DeclTuple getParentInCharge(int index) {
        int s = 0;
        int i = 0;
        while (i < this.parents.size()) {
            if (index < (s += this.parents.get(i).rawGetSize())) {
                return this.parents.get(i);
            }
            ++i;
        }
        return this;
    }

    public int getRelativeIndex(DeclTuple parent, int index) {
        int s = index;
        int i = 0;
        while (i < this.parents.size()) {
            if (s - this.parents.get(i).rawGetSize() < 0) {
                return parent.toRootIndex(s);
            }
            s -= this.parents.get(i).rawGetSize();
            ++i;
        }
        return parent.toRootIndex(s);
    }

    @Override
    public AttrMember getMemberAt(int index) {
        if (index == -1) {
            return null;
        }
        DeclTuple parent = this.getParentInCharge(index);
        return parent.getLeafMemberAt(this.getRelativeIndex(parent, index));
    }

    @Override
    public AttrMember getMemberAt(String name) {
        return this.getMemberAt(this.getIndexForName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttrTypeMember addMember() {
        DeclTuple declTuple = this;
        synchronized (declTuple) {
            DeclMember member = this.newMember();
            this.addMember(member);
            this.fireAttrChanged(10, this.getSize() - 1);
            return member;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttrTypeMember addMember(AttrHandler handler, String type, String name) {
        DeclTuple declTuple = this;
        synchronized (declTuple) {
            block4: {
                if (handler != null && type != null) break block4;
                return null;
            }
            DeclMember member = this.newMember();
            this.addMember(member);
            int newIndex = this.getSize() - 1;
            member.setName(name);
            member.retype(handler, type);
            this.fireAttrChanged(10, newIndex);
            return member;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttrTypeMember addMember(int index, AttrHandler handler, String type, String name) {
        DeclTuple declTuple = this;
        synchronized (declTuple) {
            block4: {
                if (handler != null && type != null) break block4;
                return null;
            }
            DeclMember member = this.newMember();
            this.addMember(index, member);
            member.setName(name);
            member.retype(handler, type);
            this.fireAttrChanged(10, index);
            return member;
        }
    }

    public DeclTuple getHoldingTupleOfMember(int index) {
        DeclMember mem = (DeclMember)this.rawGetMemberAt(index);
        DeclTuple holdTuple = (DeclTuple)mem.getHoldingTuple();
        return holdTuple;
    }

    @Override
    public void deleteMemberAt(int index) {
        this.getParentInCharge(index).deleteLeafMemberAt(index);
    }

    @Override
    public boolean isOwnMemberAt(AttrViewSetting viewSetting, int slot) {
        int indx = this.ensureNonNull(viewSetting).convertSlotToIndex(this, slot);
        return this.getParentInCharge(indx) == this;
    }

    @Override
    public void deleteMemberAt(AttrViewSetting viewSetting, int slot) {
        this.deleteMemberAt(this.ensureNonNull(viewSetting).convertSlotToIndex(this, slot));
    }

    @Override
    public void deleteMemberAt(String name) {
        int index = this.getIndexForName(name);
        if (index >= 0) {
            this.deleteMemberAt(index);
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        int num = this.getNumberOfEntries();
        int i = 0;
        while (i < num) {
            DeclMember mem = (DeclMember)this.getMemberAt(i);
            if (mem.getTypeName() != null && mem.getName() != null && mem.getTypeName().length() != 0 && mem.getName().length() != 0) {
                h.addObject("", mem, true);
            }
            ++i;
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        String handlerName = JexHandler.getLabelName();
        AttrHandler handler = this.getAttrManager().getHandler(handlerName);
        Enumeration<Element> en = h.getEnumeration("", null, true, "AttrType");
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            String t = h.readAttr("typename");
            String n = h.readAttr("attrname");
            String vis = h.readAttr("visible");
            if (t.length() != 0 && n.length() != 0) {
                AttrTypeMember mem = this.addMember(handler, t, n);
                if (vis.equals("true") || vis.equals("")) {
                    ((DeclMember)mem).setVisible(true);
                } else {
                    ((DeclMember)mem).setVisible(false);
                }
                h.loadObject(mem);
            }
            h.close();
        }
    }

    @Override
    public int getIndexForName(String name) {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            String n;
            DeclMember dm = this.getDeclMemberAt(i);
            if (dm != null && (n = dm.getName()) != null && n.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int isLegalType(AttrHandler handler, String typeName) {
        int msgCode = 0;
        try {
            if (handler.newHandlerType(typeName) == null) {
                msgCode = 1;
            }
        }
        catch (AttrHandlerException ex) {
            msgCode = 1;
        }
        return msgCode;
    }

    public int isLegalName(String text) {
        int msgCode = 0;
        if (this.containsName(text)) {
            msgCode = 2;
        }
        return msgCode;
    }

    public boolean isDefined() {
        int i = 0;
        while (i < this.getSize()) {
            if (this.getMemberAt(i) == null || !((DeclMember)this.getMemberAt(i)).isDefined()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void renameMemberAt(int index, String name) {
        DeclMember member = this.getDeclMemberAt(index);
        member.setName(name);
    }

    public void retypeMemberAt(int index, AttrHandler handler, String type) {
        DeclMember member = this.getDeclMemberAt(index);
        member.setHandler(handler);
        member.setType(type);
    }

    public void removeEntryAt(int index) {
        this.deleteMemberAt(index);
    }

    @Override
    public int getNumberOfEntries() {
        return this.getSize();
    }

    @Override
    public String getTypeAsString(int entryIndex) {
        HandlerType type = null;
        if (this.getDeclMemberAt(entryIndex) != null) {
            type = this.getDeclMemberAt(entryIndex).getType();
        }
        if (type == null) {
            return "";
        }
        return type.toString();
    }

    @Override
    public String getNameAsString(int entryIndex) {
        if (this.getDeclMemberAt(entryIndex) != null) {
            return this.getDeclMemberAt(entryIndex).getName();
        }
        return "";
    }

    @Override
    public String getValueAsString(int entryIndex) {
        return "";
    }

    @Override
    public void addObserver(AttrObserver attrObs) {
        if (attrObs instanceof AttrViewSetting) {
            super.addObserverAtPos(attrObs, 0);
        } else {
            super.addObserver(attrObs);
        }
    }

    @Override
    public void updateMemberAdded(TupleEvent e) {
        AttrTuple tuple = e.getSource();
        if (tuple != null && this.parents.contains(tuple)) {
            this.propagateEvent(e);
        }
    }

    @Override
    public void updateMemberDeleted(TupleEvent e) {
        AttrTuple tuple = e.getSource();
        if (tuple != null && this.parents.contains(tuple)) {
            this.propagateEvent(e);
        }
    }

    @Override
    public String toString() {
        String result = "\n-----------------------------------------------------\n";
        result = String.valueOf(result) + this.getClass().getName() + "@" + this.hashCode() + "\n";
        int size = this.getSize();
        result = size > 0 ? String.valueOf(result) + "Tuple enthaelt " + size + " Member" : String.valueOf(result) + "Tuple ist leer";
        result = String.valueOf(result) + "\n";
        int i = 0;
        while (i < size) {
            result = String.valueOf(result) + this.getMemberAt(i) + "\n";
            ++i;
        }
        int resulti = 0;
        int i2 = 0;
        while (i2 < this.getSize()) {
            resulti += this.getMemberAt(i2).hashCode();
            ++i2;
        }
        result = String.valueOf(result) + resulti + "\n";
        result = String.valueOf(result) + "-----------------------------------------------------";
        return result;
    }

    @Override
    public void addEntry(AttrHandler handler, String type, String name) {
        this.addMember(handler, type, name);
    }

    @Override
    public void deleteEntry(String name) {
        this.deleteMemberAt(name);
    }

    @Override
    public boolean compareTo(AttrType tuple) {
        int size = this.getNumberOfEntries();
        int n = 0;
        boolean isEqual = this.getClass().equals(tuple.getClass());
        while (n < size && isEqual) {
            DeclMember mem = (DeclMember)this.getMemberAt(n);
            if (mem != null) {
                isEqual = mem.compareTo((DeclMember)((DeclTuple)tuple).getMemberAt(mem.getName()));
            }
            ++n;
        }
        return isEqual;
    }

    public boolean weakcompareTo(AttrType tuple) {
        int size = this.getNumberOfEntries();
        int n = 0;
        boolean isEqual = this.getClass().equals(tuple.getClass());
        while (n < size && isEqual) {
            DeclMember mem = (DeclMember)this.getMemberAt(n);
            if (mem != null) {
                isEqual = mem.weakcompareTo((DeclMember)((DeclTuple)tuple).getMemberAt(mem.getName()));
            }
            ++n;
        }
        return isEqual;
    }

    public void setParent(DeclTuple newParent) {
        this.addParent(newParent);
        Enumeration<AttrObserver> en = this.getObservers();
        while (en.hasMoreElements()) {
            AttrObserver obs = en.nextElement();
            if (obs instanceof ValueTuple) {
                ValueTuple currentValueTuple = (ValueTuple)obs;
                currentValueTuple.refreshParents();
                continue;
            }
            if (!(obs instanceof OpenViewSetting)) continue;
            OpenViewSetting myOpenView = (OpenViewSetting)obs;
            myOpenView.resetTuple(this);
        }
    }

    public boolean addParent(DeclTuple p) {
        if (p != null && !this.parents.contains(p)) {
            p.addObserver(this);
            this.parent = p;
            int i = 0;
            while (i < p.getParents().size()) {
                DeclTuple pi = p.getParents().get(i);
                if (!this.parents.contains(pi)) {
                    this.parents.add(pi);
                    pi.addObserver(this);
                }
                ++i;
            }
            this.parents.add(p);
            this.directParents.add(p);
            this.refreshObservers();
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubclassOf(TupleObject maybeParent) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == maybeParent) {
            return true;
        }
        for (DeclTuple p : this.parents) {
            if (p == maybeParent) {
                return true;
            }
            p.isSubclassOf(maybeParent);
        }
        return false;
    }

    public void removeParent(DeclTuple p) {
        if (p != null && this.parents.contains(p)) {
            DeclTuple pi;
            if (this.directParents.contains(p)) {
                this.directParents.remove(p);
            }
            boolean canremove = true;
            int i = 0;
            while (i < this.directParents.size()) {
                pi = this.directParents.get(i);
                if (pi.getParents().contains(p)) {
                    canremove = false;
                    break;
                }
                ++i;
            }
            if (canremove) {
                p.removeObserver(this);
                this.parents.remove(p);
            }
            i = 0;
            while (i < p.getParents().size()) {
                pi = p.getParents().get(i);
                if (this.parents.contains(pi)) {
                    canremove = true;
                    int j = 0;
                    while (j < this.directParents.size()) {
                        DeclTuple itspj = this.directParents.get(j);
                        if (itspj.getParents().contains(pi)) {
                            canremove = false;
                            break;
                        }
                        ++j;
                    }
                    if (canremove) {
                        pi.removeObserver(this);
                        this.parents.remove(pi);
                    }
                }
                ++i;
            }
            if (this.parent == p) {
                this.parent = !this.directParents.isEmpty() ? (TupleObject)this.directParents.lastElement() : null;
            }
        }
        this.refreshObservers();
    }

    public void refreshParents() {
        this.refreshParentsAfterRemove();
    }

    public void refreshParentsAfterAdd() {
        int i = 0;
        while (i < this.directParents.size()) {
            DeclTuple pi = this.directParents.get(i);
            int j = 0;
            while (j < pi.getParents().size()) {
                DeclTuple pj = pi.getParents().get(j);
                int indx = this.parents.indexOf(pi);
                if (!this.parents.contains(pj)) {
                    this.parents.add(indx, pj);
                    pj.addObserver(this);
                } else {
                    int indx1 = this.parents.indexOf(pj);
                    if (indx1 > indx) {
                        this.parents.remove(indx1);
                        this.parents.add(indx, pj);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.refreshObservers();
    }

    public void refreshParentsAfterRemove() {
        DeclTuple pi;
        this.removeParents();
        int i = 0;
        while (i < this.directParents.size()) {
            pi = this.directParents.get(i);
            this.parents.add(pi);
            pi.addObserver(this);
            ++i;
        }
        i = 0;
        while (i < this.directParents.size()) {
            pi = this.directParents.get(i);
            int j = 0;
            while (j < pi.getParents().size()) {
                DeclTuple pj = pi.getParents().get(j);
                if (!this.parents.contains(pj)) {
                    int indx = this.parents.indexOf(pi);
                    this.parents.add(indx, pj);
                    pj.addObserver(this);
                }
                ++j;
            }
            ++i;
        }
        this.refreshObservers();
    }

    public void refreshObservers() {
        Enumeration<AttrObserver> en = this.getObservers();
        while (en.hasMoreElements()) {
            AttrObserver obs = en.nextElement();
            if (obs instanceof ValueTuple) {
                ValueTuple currentValueTuple = (ValueTuple)obs;
                currentValueTuple.refreshParents();
                this.fireAttrChanged(0, 0);
                continue;
            }
            if (!(obs instanceof OpenViewSetting)) continue;
            OpenViewSetting myOpenView = (OpenViewSetting)obs;
            myOpenView.resetTuple(this);
            this.fireAttrChanged(0, 0);
        }
    }
}

