/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ManagedObject;
import agg.attribute.impl.NoSuchVariableException;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Disposable;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ContextCore
extends ManagedObject
implements Serializable,
Disposable {
    static final long serialVersionUID = 4267479295340570839L;
    protected int mapStyle;
    protected ContextCore parent = null;
    protected Hashtable<ValueTuple, Vector<TupleMapping>> mappings = new Hashtable();
    protected CondTuple conditions;
    protected VarTuple variables;
    protected transient boolean isFrozen = false;
    protected transient Vector<TupleMapping> delayedMappingRemovals = null;
    private transient String errorMsg;
    private transient boolean variableContext = false;
    private transient boolean ignoreConstContext = false;

    public ContextCore(AttrTupleManager manager, int mapStyle) {
        this(manager, mapStyle, null);
    }

    public ContextCore(AttrTupleManager manager, int mapStyle, ContextCore parent) {
        super(manager);
        this.mapStyle = mapStyle;
        this.parent = parent;
        this.errorMsg = "";
        VarTuple parentVars = null;
        CondTuple parentCond = null;
        if (parent != null) {
            this.variableContext = parent.isVariableContext();
            parentVars = parent.getVariables();
            parentCond = parent.getConditions();
        }
        this.variables = new VarTuple(manager, new ContextView(manager, this), parentVars);
        this.conditions = new CondTuple(manager, new ContextView(manager, this), parentCond);
    }

    public void resetVariableTuple() {
        VarTuple parentVars = this.parent != null ? this.parent.getVariables() : null;
        this.variables = new VarTuple(this.manager, new ContextView(this.manager, this), parentVars);
    }

    public void resetConditionTuple() {
        CondTuple parentCond = this.parent != null ? this.parent.getConditions() : null;
        this.conditions = new CondTuple(this.manager, new ContextView(this.manager, this), parentCond);
    }

    public void makeCopyOf(ContextCore context) {
        this.mapStyle = context.mapStyle;
        this.errorMsg = "";
        this.variableContext = context.isVariableContext();
        this.variables = new VarTuple(this.manager, new ContextView(this.manager, this), null);
        this.variables.makeCopyOf(context.getVariables());
        this.conditions = new CondTuple(this.manager, new ContextView(this.manager, this), null);
        this.conditions.makeCopyOf(context.getConditions());
    }

    @Override
    public void dispose() {
        if (this.delayedMappingRemovals != null) {
            this.delayedMappingRemovals.removeAllElements();
        }
        this.delayedMappingRemovals = null;
        this.manager = null;
        this.parent = null;
        if (this.conditions != null) {
            this.conditions.dispose();
            this.conditions = null;
        }
        if (this.variables != null) {
            this.variables.dispose();
            this.variables = null;
        }
    }

    protected final void finalize() {
        if (this.delayedMappingRemovals != null || this.manager != null || this.parent != null || this.conditions != null || this.variables != null) {
            this.dispose();
        }
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void clearErrorMsg() {
        this.errorMsg = "";
    }

    public CondTuple getConditions() {
        return this.conditions;
    }

    public VarTuple getVariables() {
        return this.variables;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void freeze() {
        if (this.delayedMappingRemovals == null) {
            this.delayedMappingRemovals = new Vector(30);
        }
        this.isFrozen = true;
    }

    public void defreeze() {
        this.isFrozen = false;
        this.performDelayedRemove();
    }

    public void setVariableContext(boolean b) {
        this.variableContext = b;
        if (this.parent != null) {
            this.parent.setVariableContext(b);
        }
    }

    public boolean isVariableContext() {
        return this.variableContext;
    }

    public void setIgnoreOfConstContext(boolean b) {
        this.ignoreConstContext = b;
        if (this.parent != null) {
            this.parent.setVariableContext(b);
        }
    }

    public boolean isIgnoreOfConstContext() {
        return this.ignoreConstContext;
    }

    public int getAllowedMapping() {
        return this.mapStyle;
    }

    public void addMapping(TupleMapping mapping) {
        ValueTuple target = mapping.getTarget();
        Vector<TupleMapping> mappingsToTarget = this.mappings.get(target);
        if (mappingsToTarget == null) {
            mappingsToTarget = new Vector();
            this.mappings.put(target, mappingsToTarget);
        }
        mappingsToTarget.addElement(mapping);
    }

    protected Hashtable<ValueTuple, Vector<TupleMapping>> getMapping() {
        return this.mappings;
    }

    public Vector<TupleMapping> getMappingsToTarget(ValueTuple target) {
        Vector<TupleMapping> mappingsToValue = this.mappings.get(target);
        return mappingsToValue;
    }

    public boolean removeMapping(TupleMapping mapping) {
        ValueTuple target = mapping.getTarget();
        Vector<TupleMapping> mappingsToTarget = this.mappings.get(target);
        if (mappingsToTarget == null) {
            return false;
        }
        if (this.isFrozen()) {
            if (!mappingsToTarget.contains(mapping)) {
                return false;
            }
            this.delayedMappingRemovals.addElement(mapping);
        } else {
            mapping.removeNow();
        }
        return mappingsToTarget.removeElement(mapping);
    }

    public void removeAllMappings() {
        Enumeration<ValueTuple> keys = this.mappings.keys();
        while (keys.hasMoreElements()) {
            ValueTuple key = keys.nextElement();
            Vector<TupleMapping> mappingsToTarget = this.mappings.get(key);
            int i = 0;
            while (i < mappingsToTarget.size()) {
                TupleMapping mapping = mappingsToTarget.get(i);
                mapping.removeNow();
                ++i;
            }
            mappingsToTarget.clear();
        }
        this.mappings.clear();
    }

    private void performDelayedRemove() {
        if (this.delayedMappingRemovals != null) {
            int size = this.delayedMappingRemovals.size();
            int i = 0;
            while (i < size) {
                this.delayedMappingRemovals.elementAt(i).removeNow();
                ++i;
            }
            this.delayedMappingRemovals.removeAllElements();
        }
    }

    public boolean isDeclared(String name) {
        return this.getVariables() != null && this.getVariables().isDeclared(name);
    }

    public boolean addDecl(AttrHandler handler, String type, String name) {
        if (this.variables != null) {
            try {
                this.variables.declare(handler, type, name);
                return true;
            }
            catch (AttrImplException ex) {
                return false;
            }
        }
        return false;
    }

    public void removeDecl(String name) {
        this.getVariables().deleteLeafDeclaration(name);
    }

    public DeclMember getDecl(String name) throws NoSuchVariableException {
        DeclMember t = this.getVariables().getTupleType().getDeclMemberAt(name);
        return t;
    }

    public boolean canSetValue(String name, ValueMember value) {
        boolean doesBreakCondition = false;
        this.errorMsg = "";
        VarMember prevValue = this.getVariables().getVarMemberAt(name);
        if (prevValue == null) {
            if (this.variableContext) {
                return true;
            }
            this.errorMsg = "No such variable: " + name;
            return false;
        }
        if (((ValueMember)prevValue).getExpr() == null) {
            return !doesBreakCondition;
        }
        if (prevValue.equals(value)) {
            return true;
        }
        this.errorMsg = "Cannot set attribute value.";
        return false;
    }

    public void setValue(String name, ValueMember value) throws NoSuchVariableException {
        VarMember vm = this.getVariables().getVarMemberAt(name);
        if (vm == null) {
            throw new NoSuchVariableException(name);
        }
        HandlerExpr he = value.getExpr();
        vm.unifyWith(he);
        if (value.getExprAsText().equals("null")) {
            vm.setExprAsText("null");
        }
    }

    public void removeValue(String name) throws NoSuchVariableException {
        if (this.isDeclared(name)) {
            this.getVariables().getVarMemberAt(name).undoUnification();
        }
    }

    public ValueMember getValue(String name) {
        VarMember value = this.getVariables().getVarMemberAt(name);
        if (value == null) {
            throw new NoSuchVariableException(name);
        }
        return value;
    }
}

