/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrEvent;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ManagedObject;
import agg.attribute.impl.TupleEvent;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ChainedObserver
extends ManagedObject
implements AttrObserver,
AttrTuple {
    protected static final int MAX_SIZE_OF_EVENT_STACK = 100;
    protected static int sizeOfEventStack = 0;
    protected final transient Vector<WeakReference<AttrObserver>> observers = new Vector();

    public ChainedObserver(AttrTupleManager m) {
        super(m);
    }

    private synchronized void removeNullObserver() {
        int i = 0;
        while (i < this.observers.size()) {
            if (this.observers.get(i).get() == null) {
                this.observers.remove(i);
                --i;
            }
            ++i;
        }
    }

    public synchronized Enumeration<AttrObserver> getObservers() {
        Vector<AttrObserver> tmp = new Vector<AttrObserver>();
        int i = 0;
        while (i < this.observers.size()) {
            WeakReference<AttrObserver> wr = this.observers.get(i);
            if (wr.get() != null) {
                tmp.addElement((AttrObserver)wr.get());
            } else {
                this.observers.remove(i);
                --i;
            }
            ++i;
        }
        return tmp.elements();
    }

    @Override
    public void addObserver(AttrObserver attrObs) {
        if (attrObs != null) {
            boolean found = false;
            int i = 0;
            while (i < this.observers.size() && !found) {
                try {
                    found = attrObs == this.observers.get(i).get();
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    return;
                }
                ++i;
            }
            if (!found) {
                this.observers.addElement(new WeakReference<AttrObserver>(attrObs));
            }
        }
    }

    public void addObserverAtPos(AttrObserver attrObs, int pos) {
        if (attrObs != null) {
            boolean found = false;
            int i = 0;
            while (i < this.observers.size() && !found) {
                found = attrObs == this.observers.elementAt(i).get();
                ++i;
            }
            if (!found) {
                this.observers.insertElementAt(new WeakReference<AttrObserver>(attrObs), pos);
            }
        }
    }

    public boolean contains(AttrObserver attrObs) {
        if (attrObs == null || this.observers.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.observers.size()) {
            WeakReference<AttrObserver> wr = this.observers.elementAt(i);
            if (wr.get() != null && wr.get() == attrObs) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findObserver(AttrObserver obj) {
        if (obj == null || this.observers.isEmpty()) {
            return -1;
        }
        this.removeNullObserver();
        int i = 0;
        while (i < this.observers.size()) {
            WeakReference<AttrObserver> wr = this.observers.elementAt(i);
            if (wr.get() != null && wr.get() == obj) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public synchronized void removeObserver(AttrObserver attrObs) {
        if (attrObs == null || this.observers.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.observers.size()) {
            WeakReference<AttrObserver> wr = this.observers.elementAt(i);
            if (wr.get() == attrObs) {
                this.observers.remove(i);
                break;
            }
            ++i;
        }
    }

    protected void fireAttrChanged(int id, int index) {
        this.fireAttrChanged(id, index, index);
    }

    protected void fireAttrChanged(int id, int index0, int index1) {
        this.fireAttrChanged(new TupleEvent(this, id, index0, index1));
    }

    protected void fireAttrChanged(TupleEvent evt) {
        if (evt == null) {
            return;
        }
        Enumeration<WeakReference<AttrObserver>> en = this.observers.elements();
        while (en.hasMoreElements()) {
            TupleEvent childEvt;
            WeakReference<AttrObserver> wr = en.nextElement();
            if (wr.get() == null || (childEvt = this.filterEvent((AttrObserver)wr.get(), evt)) == null) continue;
            ((AttrObserver)wr.get()).attributeChanged(childEvt);
        }
    }

    protected abstract void propagateEvent(TupleEvent var1);

    protected TupleEvent filterEvent(AttrObserver obs, TupleEvent e) {
        return e;
    }

    @Override
    public boolean isPersistentFor(AttrTuple at) {
        return true;
    }

    @Override
    public void attributeChanged(AttrEvent evt) {
        if (++sizeOfEventStack > 100) {
            throw new RuntimeException("Infinite event recursion occured.");
        }
        TupleEvent event = (TupleEvent)evt;
        int msg = event.getID();
        if (msg == 0) {
            this.updateGeneralChange(event);
        } else if (msg == 10) {
            this.updateMemberAdded(event);
        } else if (msg == 20) {
            this.updateMemberDeleted(event);
        } else if (msg == 40) {
            this.updateMemberModified(event);
        } else if (msg == 50) {
            this.updateMemberRenamed(event);
        } else if (msg == 60) {
            this.updateMemberRetyped(event);
        } else if (msg == 70) {
            this.updateValueModified(event);
        } else if (msg == 80) {
            this.updateValueCorrectness(event);
        } else {
            this.updateUnknownChange(event);
        }
        --sizeOfEventStack;
    }

    protected void updateGeneralChange(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberAdded(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberDeleted(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberModified(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberRenamed(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberRetyped(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateValueModified(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateValueCorrectness(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateUnknownChange(TupleEvent event) {
        this.propagateEvent(event);
    }
}

