/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.csp.Variable;

public abstract class BinaryConstraint {
    protected Variable itsVar1;
    protected Variable itsVar2;
    protected int itsWeight;
    private boolean active = true;

    public BinaryConstraint(Variable v1, Variable v2, int weight) {
        this.itsVar1 = v1;
        this.itsVar2 = v2;
        this.itsWeight = weight;
        this.itsVar1.addConstraint(this);
        ++this.itsWeight;
        this.itsVar2.addConstraint(this);
        ++this.itsWeight;
    }

    public BinaryConstraint(Variable v, int weight) {
        this.itsVar1 = v;
        this.itsVar2 = v;
        this.itsWeight = weight;
        this.itsVar1.addConstraint(this);
        ++this.itsWeight;
    }

    public abstract void clear();

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isApplicable() {
        if (!this.active) {
            return false;
        }
        return this.itsVar1.getInstance() != null && this.itsVar2.getInstance() != null;
    }

    public abstract boolean execute();

    public Variable getCause(Variable rvar) {
        return rvar.equals(this.itsVar1) ? this.itsVar2 : this.itsVar1;
    }

    public Variable getVar1() {
        return this.itsVar1;
    }

    public Variable getVar2() {
        return this.itsVar2;
    }

    public int getWeight() {
        return this.itsWeight;
    }
}

