/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.provider.GraphItemProvider;
import org.eclipse.emf.henshin.provider.HenshinEditPlugin;
import org.eclipse.emf.henshin.provider.HenshinItemProviderAdapter;
import org.eclipse.emf.henshin.provider.descriptors.EdgeSourcePropertyDescriptor;
import org.eclipse.emf.henshin.provider.descriptors.EdgeTargetPropertyDescriptor;
import org.eclipse.emf.henshin.provider.descriptors.EdgeTypePropertyDescriptor;
import org.eclipse.emf.henshin.provider.util.IconUtil;

public class EdgeItemProvider
extends HenshinItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider {
    public EdgeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addActionPropertyDescriptor(object);
            this.addSourcePropertyDescriptor(object);
            this.addTargetPropertyDescriptor(object);
            this.addTypePropertyDescriptor(object);
            this.addIndexPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addActionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_GraphElement_action_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_GraphElement_action_feature", "_UI_GraphElement_type"), (EStructuralFeature)HenshinPackage.Literals.GRAPH_ELEMENT__ACTION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addSourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EdgeSourcePropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Edge_source_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Edge_source_feature", "_UI_Edge_type"), (EStructuralFeature)HenshinPackage.Literals.EDGE__SOURCE));
    }

    protected void addTargetPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EdgeTargetPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Edge_target_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Edge_target_feature", "_UI_Edge_type"), (EStructuralFeature)HenshinPackage.Literals.EDGE__TARGET));
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EdgeTypePropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Edge_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Edge_type_feature", "_UI_Edge_type"), (EStructuralFeature)HenshinPackage.Literals.EDGE__TYPE));
    }

    protected void addIndexPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Edge_index_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Edge_index_feature", "_UI_Edge_type"), (EStructuralFeature)HenshinPackage.Literals.EDGE__INDEX, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        Edge kernelEdge = this.getKernelEdge((Edge)object);
        if (kernelEdge != null) {
            return this.getImage(kernelEdge);
        }
        Edge edge = (Edge)object;
        if (edge.eContainer() == null) {
            return this.getResourceLocator().getImage("full/obj16/Edge");
        }
        Object edgeImage = null;
        boolean needsAttention = false;
        needsAttention |= edge.getType() == null;
        needsAttention |= edge.getSource() == null;
        edgeImage = edge.getType() != null && edge.getType().isContainment() ? this.getResourceLocator().getImage("full/obj16/ContainmentEdge.gif") : (edge.getType() != null && edge.getType().isMany() ? IconUtil.getCompositeImage(this.getResourceLocator().getImage("full/obj16/Edge"), this.getResourceLocator().getImage("full/obj16/Edge"), 1, 2) : this.getResourceLocator().getImage("full/obj16/Edge"));
        if (needsAttention |= edge.getTarget() == null) {
            Object attentionOverlay = this.getResourceLocator().getImage("full/ovr16/Attn_ovr.png");
            edgeImage = IconUtil.getCompositeImage(edgeImage, attentionOverlay);
        }
        return edgeImage;
    }

    public String getText(Object object) {
        return ((Edge)object).toString();
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 1) {
            Edge edge = (Edge)notification.getNotifier();
            ViewerNotification notif = new ViewerNotification(notification, (Object)edge, false, true);
            this.fireNotifyChanged((Notification)notif);
            Graph graph = edge.getGraph();
            if (graph != null) {
                GraphItemProvider gip = (GraphItemProvider)this.adapterFactory.adapt((Notifier)graph, Graph.class);
                gip.notifyCorrespondingEdges(graph, notification);
            }
        }
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinEditPlugin.INSTANCE;
    }

    private Edge getKernelEdge(Edge edge) {
        if (edge.getGraph() != null && (edge.getGraph().isLhs() || edge.getGraph().isRhs())) {
            Rule rule = edge.getGraph().getRule();
            return rule.getMultiMappings().getOrigin(edge);
        }
        return null;
    }
}

