/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.unit;

import java.util.ArrayList;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.tests.unit.AbstractCompareTest;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.junit.Assert;
import org.junit.Test;

public class MatchTest
extends AbstractCompareTest {
    @Test
    public void testSubmatches() {
        EReference feature = ComparePackage.eINSTANCE.getMatch_Submatches();
        Match match = CompareFactory.eINSTANCE.createMatch();
        match.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter(this));
        Match submatchesValue = CompareFactory.eINSTANCE.createMatch();
        ArrayList<Match> listSubmatches = new ArrayList<Match>(1);
        listSubmatches.add(submatchesValue);
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)match.getSubmatches().isEmpty());
        match.getSubmatches().add((Object)submatchesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)match.getSubmatches().contains((Object)submatchesValue));
        Assert.assertSame((Object)match.getSubmatches(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getSubmatches(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)match.getSubmatches().isEmpty());
        Assert.assertSame((Object)match.getSubmatches(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getSubmatches(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eSet((EStructuralFeature)feature, listSubmatches);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)match.getSubmatches().contains((Object)submatchesValue));
        Assert.assertSame((Object)match.getSubmatches(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getSubmatches(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testDifferences() {
        EReference feature = ComparePackage.eINSTANCE.getMatch_Differences();
        Match match = CompareFactory.eINSTANCE.createMatch();
        match.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter(this));
        Diff differencesValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listDifferences = new ArrayList<Diff>(1);
        listDifferences.add(differencesValue);
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)match.getDifferences().isEmpty());
        match.getDifferences().add((Object)differencesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)match.getDifferences().contains((Object)differencesValue));
        Assert.assertSame((Object)match.getDifferences(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getDifferences(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((differencesValue.getMatch() == match ? 1 : 0) != 0);
        match.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)match.getDifferences().isEmpty());
        Assert.assertSame((Object)match.getDifferences(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getDifferences(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((differencesValue.getMatch() == match ? 1 : 0) != 0);
        match.eSet((EStructuralFeature)feature, listDifferences);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)match.getDifferences().contains((Object)differencesValue));
        Assert.assertSame((Object)match.getDifferences(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getDifferences(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((differencesValue.getMatch() == match ? 1 : 0) != 0);
    }

    @Test
    public void testLeft() {
        EReference feature = ComparePackage.eINSTANCE.getMatch_Left();
        Match match = CompareFactory.eINSTANCE.createMatch();
        match.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter(this));
        EObject leftValue = EcoreFactory.eINSTANCE.createEObject();
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)match.getLeft());
        match.setLeft(leftValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)leftValue, (Object)match.getLeft());
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)match.getLeft());
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        match.setLeft(leftValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)leftValue, (Object)match.getLeft());
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eSet((EStructuralFeature)feature, (Object)leftValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)leftValue, (Object)match.getLeft());
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.setLeft(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)match.getLeft());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)match.getLeft());
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getLeft(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testRight() {
        EReference feature = ComparePackage.eINSTANCE.getMatch_Right();
        Match match = CompareFactory.eINSTANCE.createMatch();
        match.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter(this));
        EObject rightValue = EcoreFactory.eINSTANCE.createEObject();
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)match.getRight());
        match.setRight(rightValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)rightValue, (Object)match.getRight());
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)match.getRight());
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        match.setRight(rightValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)rightValue, (Object)match.getRight());
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eSet((EStructuralFeature)feature, (Object)rightValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)rightValue, (Object)match.getRight());
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.setRight(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)match.getRight());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)match.getRight());
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getRight(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testOrigin() {
        EReference feature = ComparePackage.eINSTANCE.getMatch_Origin();
        Match match = CompareFactory.eINSTANCE.createMatch();
        match.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter(this));
        EObject originValue = EcoreFactory.eINSTANCE.createEObject();
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)match.getOrigin());
        match.setOrigin(originValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)originValue, (Object)match.getOrigin());
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)match.getOrigin());
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
        match.setOrigin(originValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)originValue, (Object)match.getOrigin());
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.eSet((EStructuralFeature)feature, (Object)originValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)originValue, (Object)match.getOrigin());
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)match.eIsSet((EStructuralFeature)feature));
        match.setOrigin(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)match.getOrigin());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)match.getOrigin());
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)match.getOrigin(), (Object)match.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)match.eIsSet((EStructuralFeature)feature));
    }
}

