/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.tests.unit.AbstractURITest;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Assert;
import org.junit.Test;

public class ResourceUtilPathTest
extends AbstractURITest {
    @Test
    public void testFixedPath_git_straightRepo() throws Exception {
        this.setupStraightRepo();
        RevCommit masterTip = this.repository.findCommit("refs/heads/master");
        RevCommit branchTip = this.repository.findCommit("refs/heads/branch");
        RevCommit origin = masterTip.getParent(0);
        IStorageProviderAccessor accessor = this.createAccessorForComparison("refs/heads/master", "refs/heads/branch", false);
        String workspaceRelativePath = this.iFile1.getFullPath().toOSString();
        IStorageProvider provider = accessor.getStorageProvider((IResource)this.iFile1, IStorageProviderAccessor.DiffSide.ORIGIN);
        IStorage storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor());
        String storagePath = storage.getFullPath().toOSString();
        Assert.assertTrue((boolean)storagePath.contains(workspaceRelativePath));
        Assert.assertFalse((boolean)storagePath.startsWith(this.iFile1.getFullPath().toOSString()));
        Assert.assertTrue((boolean)storagePath.endsWith(origin.getId().abbreviate(6).name()));
        String fixedPath = ResourceUtil.getFixedPath((IStorage)storage).toOSString();
        Assert.assertEquals((Object)workspaceRelativePath, (Object)fixedPath);
        provider = accessor.getStorageProvider((IResource)this.iFile1, IStorageProviderAccessor.DiffSide.REMOTE);
        storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor());
        storagePath = storage.getFullPath().toOSString();
        Assert.assertTrue((boolean)storagePath.contains(workspaceRelativePath));
        Assert.assertFalse((boolean)storagePath.startsWith(this.iFile1.getFullPath().toOSString()));
        Assert.assertTrue((boolean)storagePath.endsWith(branchTip.getId().abbreviate(6).name()));
        fixedPath = ResourceUtil.getFixedPath((IStorage)storage).toOSString();
        Assert.assertEquals((Object)workspaceRelativePath, (Object)fixedPath);
        provider = accessor.getStorageProvider((IResource)this.iFile1, IStorageProviderAccessor.DiffSide.SOURCE);
        storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor());
        storagePath = storage.getFullPath().toOSString();
        Assert.assertTrue((boolean)storagePath.contains(workspaceRelativePath));
        Assert.assertFalse((boolean)storagePath.startsWith(this.iFile1.getFullPath().toOSString()));
        Assert.assertTrue((boolean)storagePath.endsWith(masterTip.getId().abbreviate(6).name()));
        fixedPath = ResourceUtil.getFixedPath((IStorage)storage).toOSString();
        Assert.assertEquals((Object)workspaceRelativePath, (Object)fixedPath);
    }

    @Test
    public void testFixedPath_git_multipleCommitsRepo() throws Exception {
        String branch1Name = "refs/heads/branch1";
        String branch2Name = "refs/heads/branch2";
        this.setupMultipleCommitsRepo(branch1Name, branch2Name);
        RevCommit masterTip = this.repository.findCommit("refs/heads/master");
        RevCommit branchTip = this.repository.findCommit(branch2Name);
        RevCommit masterCommit2 = masterTip.getParent(0);
        RevCommit origin = this.repository.findCommit(masterCommit2.getId().getName()).getParent(0);
        IStorageProviderAccessor accessor = this.createAccessorForComparison("refs/heads/master", branch2Name, false);
        String workspaceRelativePath = this.iFile1.getFullPath().toOSString();
        IStorageProvider provider = accessor.getStorageProvider((IResource)this.iFile1, IStorageProviderAccessor.DiffSide.ORIGIN);
        IStorage storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor());
        String storagePath = storage.getFullPath().toOSString();
        Assert.assertTrue((boolean)storagePath.contains(workspaceRelativePath));
        Assert.assertFalse((boolean)storagePath.startsWith(this.iFile1.getFullPath().toOSString()));
        Assert.assertTrue((boolean)storagePath.endsWith(origin.getId().abbreviate(6).name()));
        String fixedPath = ResourceUtil.getFixedPath((IStorage)storage).toOSString();
        Assert.assertEquals((Object)workspaceRelativePath, (Object)fixedPath);
        provider = accessor.getStorageProvider((IResource)this.iFile1, IStorageProviderAccessor.DiffSide.REMOTE);
        storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor());
        storagePath = storage.getFullPath().toOSString();
        Assert.assertTrue((boolean)storagePath.contains(workspaceRelativePath));
        Assert.assertFalse((boolean)storagePath.startsWith(this.iFile1.getFullPath().toOSString()));
        Assert.assertTrue((boolean)storagePath.endsWith(branchTip.getId().abbreviate(6).name()));
        fixedPath = ResourceUtil.getFixedPath((IStorage)storage).toOSString();
        Assert.assertEquals((Object)workspaceRelativePath, (Object)fixedPath);
        provider = accessor.getStorageProvider((IResource)this.iFile1, IStorageProviderAccessor.DiffSide.SOURCE);
        storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor());
        storagePath = storage.getFullPath().toOSString();
        Assert.assertTrue((boolean)storagePath.contains(workspaceRelativePath));
        Assert.assertFalse((boolean)storagePath.startsWith(this.iFile1.getFullPath().toOSString()));
        Assert.assertTrue((boolean)storagePath.endsWith(masterTip.getId().abbreviate(6).name()));
        fixedPath = ResourceUtil.getFixedPath((IStorage)storage).toOSString();
        Assert.assertEquals((Object)workspaceRelativePath, (Object)fixedPath);
    }
}

