/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class MergeNonConflictingRunnableTest {
    private Comparison comparison;
    private IMerger.Registry2 mergerRegistry;
    private IMerger2 merger;
    private Diff leftDelete;
    private Diff leftAdd;
    private Diff rightDelete;
    private Diff rightAdd;

    @Before
    public void setupMocks() {
        this.comparison = (Comparison)Mockito.mock(Comparison.class);
        this.mergerRegistry = (IMerger.Registry2)Mockito.mock(IMerger.Registry2.class);
        this.merger = (IMerger2)Mockito.mock(IMerger2.class);
        Mockito.when((Object)this.mergerRegistry.getHighestRankingMerger((Diff)Matchers.any(Diff.class))).thenReturn((Object)this.merger);
        Mockito.when((Object)this.mergerRegistry.getMergersByRankDescending((Diff)Matchers.any(Diff.class), (IMergeCriterion)Matchers.any(IMergeCriterion.class))).thenAnswer((Answer)new Answer<Iterator<IMerger>>(){

            public Iterator<IMerger> answer(InvocationOnMock invocation) throws Throwable {
                return Iterators.singletonIterator((Object)MergeNonConflictingRunnableTest.this.merger);
            }
        });
    }

    @Test
    public void testMergeAllLeftToRightWithConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeLeftToRightWithConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete, this.leftAdd), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeLeftToRightWithConflictsAndLimitedSetOfDifferences() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeAllLeftToRightWithoutConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete, this.leftAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeLeftToRightWithoutConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.leftAdd, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeAllRightToLeftWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.leftDelete, this.leftAdd);
        this.verifyStateIsUnchanged(this.rightDelete, this.leftDelete, this.leftAdd);
    }

    @Test
    public void testMergeRightToLeftWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete, this.rightAdd), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.leftAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete, this.leftAdd);
    }

    @Test
    public void testMergeRightToLeftWithConflictsAndLimitedSetOfDifferences() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeAllRightToLeftWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete, this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testMergeRightToLeftWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftAdd, this.leftDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.leftDelete, this.rightAdd);
    }

    @Test
    public void testAcceptAllWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete, this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftAdd, this.leftDelete);
    }

    @Test
    public void testAcceptWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftAdd, this.leftDelete, this.rightDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftAdd, this.leftDelete);
        this.verifyStateIsUnchanged(this.rightAdd);
    }

    @Test
    public void testRejectAllWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.leftAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.rightAdd);
        this.verifyHasBeenMarkedAsMerged(this.rightAdd, this.rightDelete);
    }

    @Test
    public void testRejectWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete, this.rightAdd), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.rightDelete, this.rightAdd);
        this.verifyHasBeenMarkedAsMerged(this.rightAdd, this.rightDelete);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testAcceptAllWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete);
    }

    @Test
    public void testRejectAllWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.leftDelete, this.rightAdd);
        this.verifyHasBeenMarkedAsMerged(this.rightAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete);
    }

    @Test
    public void testTwoWayMergeAllLeftToRight() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayMergeLeftToRight() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.leftAdd);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testTwoWayMergeAllRightToLeft() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayMergeRightToLeft() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.leftAdd);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testTwoWayAcceptAll() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayAccept() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftDelete);
        this.verifyHasBeenMarkedAsMerged(this.leftDelete);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testTwoWayRejectAll() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayReject() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftAdd), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.leftDelete);
    }

    private void addConflictsToMockComparison(Conflict ... conflicts) {
        Mockito.when((Object)this.comparison.getConflicts()).thenReturn(this.newEList(conflicts));
    }

    private void addDifferencesToMockComparison(Diff ... diffs) {
        Mockito.when((Object)this.comparison.getDifferences()).thenReturn(this.newEList(diffs));
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            Match match = (Match)Mockito.mock(Match.class);
            Mockito.when((Object)match.getComparison()).thenReturn((Object)this.comparison);
            Mockito.when((Object)diff.getMatch()).thenReturn((Object)match);
            ++n2;
        }
    }

    private ReferenceChange mockReferenceChange(DifferenceSource side, DifferenceKind kind, String name) {
        ReferenceChange diff = (ReferenceChange)Mockito.mock(ReferenceChange.class, (String)name);
        Mockito.when((Object)diff.getSource()).thenReturn((Object)side);
        Mockito.when((Object)diff.getKind()).thenReturn((Object)kind);
        Mockito.when((Object)diff.getRefinedBy()).thenReturn((Object)new BasicEList());
        Mockito.when((Object)diff.getRefines()).thenReturn((Object)new BasicEList());
        Mockito.when((Object)diff.getState()).thenReturn((Object)DifferenceState.UNRESOLVED);
        Mockito.when((Object)diff.eAdapters()).thenReturn((Object)new BasicEList());
        return diff;
    }

    private Conflict newConflict(Diff ... diffs) {
        Conflict conflict = (Conflict)Mockito.mock(Conflict.class);
        Mockito.when((Object)conflict.getKind()).thenReturn((Object)ConflictKind.REAL);
        Mockito.when((Object)conflict.getDifferences()).thenReturn(this.newEList(diffs));
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            Mockito.when((Object)diff.getConflict()).thenReturn((Object)conflict);
            ++n2;
        }
        return conflict;
    }

    private EList<Conflict> newEList(Conflict ... diffs) {
        BasicEList list = new BasicEList();
        Conflict[] conflictArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Conflict diff = conflictArray[n2];
            list.add((Object)diff);
            ++n2;
        }
        return list;
    }

    private EList<Diff> newEList(Diff ... diffs) {
        BasicEList list = new BasicEList();
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            list.add((Object)diff);
            ++n2;
        }
        return list;
    }

    private void setNoConflictsInMockComparison() {
        this.addConflictsToMockComparison(new Conflict[0]);
    }

    private void setThreeWayComparison() {
        Mockito.when((Object)this.comparison.isThreeWay()).thenReturn((Object)Boolean.TRUE);
    }

    private void setTwoWayComparison() {
        Mockito.when((Object)this.comparison.isThreeWay()).thenReturn((Object)Boolean.FALSE);
    }

    private void setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide() {
        this.leftDelete = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.DELETE, "leftDelete");
        this.leftAdd = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.ADD, "leftAdd");
        this.rightDelete = this.mockReferenceChange(DifferenceSource.RIGHT, DifferenceKind.DELETE, "rightDelete");
        this.rightAdd = this.mockReferenceChange(DifferenceSource.RIGHT, DifferenceKind.ADD, "rightAdd");
        this.addDifferencesToMockComparison(this.leftDelete, this.leftAdd, this.rightDelete, this.rightAdd);
        this.setThreeWayComparison();
    }

    private void setUpTwoWayComparisonWithOneAdditionAndOneDeletion() {
        this.leftDelete = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.DELETE, "leftDelete");
        this.leftAdd = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.ADD, "leftAdd");
        this.addDifferencesToMockComparison(this.leftDelete, this.leftAdd);
        this.setNoConflictsInMockComparison();
        this.setTwoWayComparison();
    }

    private void verifyHasBeenMarkedAsMerged(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasBeenMarkedAsMerged(diff);
            ++n2;
        }
    }

    private void verifyHasBeenMarkedAsMerged(Diff diff) {
        ((Diff)Mockito.verify((Object)diff)).setState((DifferenceState)Matchers.eq((Object)DifferenceState.MERGED));
    }

    private void verifyHasBeenMergedLeftToRightOnly(Diff diff) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.atLeastOnce())).copyLeftToRight((Diff)Matchers.same((Object)diff), (Monitor)Matchers.any(Monitor.class));
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyRightToLeft((Diff)Matchers.same((Object)diff), (Monitor)Matchers.any(Monitor.class));
    }

    private void verifyHasBeenMergedLeftToRightOnly(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasBeenMergedLeftToRightOnly(diff);
            ++n2;
        }
    }

    private void verifyHasBeenMergedRightToLeftOnly(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasBeenMergedRightToLeftOnly(diff);
            ++n2;
        }
    }

    private void verifyHasBeenMergedRightToLeftOnly(Diff diff) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.atLeastOnce())).copyRightToLeft((Diff)Matchers.same((Object)diff), (Monitor)Matchers.any(Monitor.class));
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyLeftToRight((Diff)Matchers.same((Object)diff), (Monitor)Matchers.any(Monitor.class));
    }

    private void verifyHasNotBeenMerged(Diff diff) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyLeftToRight((Diff)Matchers.same((Object)diff), (Monitor)Matchers.any(Monitor.class));
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyRightToLeft((Diff)Matchers.same((Object)diff), (Monitor)Matchers.any(Monitor.class));
    }

    private void verifyHasNotBeenMerged(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasNotBeenMerged(diff);
            ++n2;
        }
    }

    private void verifyStateIsUnchanged(Diff diff) {
        ((Diff)Mockito.verify((Object)diff, (VerificationMode)Mockito.never())).setState((DifferenceState)Matchers.any(DifferenceState.class));
    }

    private void verifyStateIsUnchanged(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyStateIsUnchanged(diff);
            ++n2;
        }
    }

    private MergeNonConflictingRunnable newMergeAllNonConflictingRunnable(MergeMode mergeMode) {
        boolean isRightEditable;
        boolean isLeftEditable;
        switch (mergeMode) {
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                isLeftEditable = true;
                isRightEditable = true;
                break;
            }
            case ACCEPT: 
            case REJECT: {
                isLeftEditable = true;
                isRightEditable = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer((IMerger.Registry)this.mergerRegistry)){

            protected void markAsMerged(Diff diff, MergeMode mode, boolean mergeRightToLeft, IMerger.Registry registry) {
                diff.setState(DifferenceState.MERGED);
            }
        };
    }
}

