/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.papyrus.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diagram.papyrus.util.ModelExtensionUtil;
import org.eclipse.emf.compare.merge.ResourceChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;

public final class PapyrusResourceChangeParticipant
implements ResourceChangeAdapter.IResourceChangeParticipant {
    private final ResourceChangeAdapter resourceChangeAdapter;

    public PapyrusResourceChangeParticipant(ResourceChangeAdapter adapter) {
        this.resourceChangeAdapter = (ResourceChangeAdapter)Preconditions.checkNotNull((Object)adapter);
    }

    public boolean interestedIn(Resource r) {
        return ModelExtensionUtil.getRegisteredFileExtensions().contains(r.getURI().fileExtension());
    }

    public Collection<URI> associatedResourceURIs(Resource r) {
        URI trimmedURI = r.getURI().trimFileExtension();
        ArrayList result = Lists.newArrayList();
        for (String fileExtension : ModelExtensionUtil.getRegisteredFileExtensions()) {
            result.add(trimmedURI.appendFileExtension(fileExtension));
        }
        return result;
    }

    protected Collection<Resource> associatedResources(Resource r) {
        URI trimmedURI = r.getURI().trimFileExtension();
        ArrayList result = Lists.newArrayList();
        for (String fileExtension : ModelExtensionUtil.getRegisteredFileExtensions()) {
            Resource other = r.getResourceSet().getResource(trimmedURI.appendFileExtension(fileExtension), false);
            if (other == null || other == r) continue;
            result.add(other);
        }
        return result;
    }

    public boolean acceptDelete(Resource r) {
        return Iterables.all(this.associatedResources(r), this.canBeDeleted());
    }

    private Predicate<Resource> canBeDeleted() {
        return new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return PapyrusResourceChangeParticipant.this.resourceChangeAdapter.isEmptyAndMissingOnOtherSide(input);
            }
        };
    }
}

