/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.ui.internal.mergeresolution;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.egit.ui.internal.mergeresolution.PostMergeDialog;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DefaultImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.mergeresolution.IMergeResolutionListener;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PostMergeStager
implements IMergeResolutionListener {
    private final DefaultImplicitDependencies dependencies = new DefaultImplicitDependencies();

    public void mergeResolutionCompleted(Comparison comparison) {
        EList matchResources = comparison.getMatchedResources();
        final ArrayList<IResource> resources = new ArrayList<IResource>();
        for (MatchResource matchResource : matchResources) {
            Resource left = matchResource.getLeft();
            if (left == null) continue;
            URI matchUri = left.getURI();
            Set dependencyUris = this.dependencies.of(matchUri, left.getResourceSet().getURIConverter());
            for (URI uri : dependencyUris) {
                IResource resource = this.getResourceFromURI(uri);
                if (resources.contains(resource)) continue;
                resources.add(resource);
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PostMergeStager.this.promptUser(resources.toArray(new IResource[resources.size()]));
            }
        });
    }

    private void promptUser(IResource[] resources) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        int result = new PostMergeDialog(shell, resources).open();
        if (result == 0) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    IResource resource = iResourceArray[n2];
                    RepositoryMapping repoMapping = RepositoryMapping.getMapping((IResource)resource);
                    Repository repo = repoMapping.getRepository();
                    Git git = new Git(repo);
                    AddCommand gitAdd = git.add();
                    String filepattern = repoMapping.getRepoRelativePath(resource);
                    if ("".equals(filepattern)) {
                        filepattern = ".";
                    }
                    gitAdd.addFilepattern(filepattern);
                    try {
                        gitAdd.call();
                    }
                    catch (NoFilepatternException e) {
                        e.printStackTrace();
                        git.close();
                        break block10;
                    }
                    catch (GitAPIException e) {
                        try {
                            e.printStackTrace();
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            git.close();
                        }
                    }
                    git.close();
                }
                ++n2;
            }
        }
    }

    private IResource getResourceFromURI(URI uri) {
        IFile targetFile;
        if (uri.isPlatform()) {
            Path platformString = new Path(uri.trimFragment().toPlatformString(true));
            targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformString);
        } else {
            targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.trimFragment().toString()));
        }
        return targetFile;
    }
}

