/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.IResourceContentsAccessor;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.impl.AbstractTypedElementAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.ResourceAttachmentChangeMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ResourceContentsAccessorImpl
extends AbstractTypedElementAdapter
implements IResourceContentsAccessor {
    private final Diff fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final Match fOwnerMatch;

    public ResourceContentsAccessorImpl(AdapterFactory adapterFactory, Diff diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory);
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatch = diff.getMatch();
    }

    @Override
    public Comparison getComparison() {
        return this.fOwnerMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        Match match;
        Diff initialDiff = this.fDiff;
        EObject diffValue = (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, this.getSide());
        if (AbstractMerger.isInTerminalState((Diff)initialDiff)) {
            boolean b8;
            Object left = MergeViewerUtil.getValueFromResourceAttachmentChange((ResourceAttachmentChange)initialDiff, this.getComparison(), IMergeViewer.MergeViewerSide.LEFT);
            Object right = MergeViewerUtil.getValueFromResourceAttachmentChange((ResourceAttachmentChange)initialDiff, this.getComparison(), IMergeViewer.MergeViewerSide.RIGHT);
            DifferenceSource source = initialDiff.getSource();
            DifferenceKind kind = initialDiff.getKind();
            boolean b5 = source == DifferenceSource.LEFT && kind == DifferenceKind.ADD && right == null;
            boolean b6 = source == DifferenceSource.LEFT && kind == DifferenceKind.DELETE && left == null;
            boolean b7 = source == DifferenceSource.RIGHT && kind == DifferenceKind.ADD && left == null;
            boolean bl = b8 = source == DifferenceSource.RIGHT && kind == DifferenceKind.DELETE && right == null;
            if (b5 || b8) {
                left = null;
            }
            if (b6 || b7) {
                right = null;
            }
            if (b5 || b8 || b6 || b7) {
                Object ancestor = MergeViewerUtil.getValueFromResourceAttachmentChange((ResourceAttachmentChange)initialDiff, this.getComparison(), IMergeViewer.MergeViewerSide.ANCESTOR);
                return new MergeViewerItem.Container(this.getComparison(), initialDiff, left, right, ancestor, this.getSide(), this.getRootAdapterFactory());
            }
        }
        if (diffValue == null && IMergeViewer.MergeViewerSide.ANCESTOR != this.getSide() && (diffValue = IMergeViewer.MergeViewerSide.LEFT == this.getSide() ? (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, IMergeViewer.MergeViewerSide.RIGHT) : (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, IMergeViewer.MergeViewerSide.LEFT)) == null) {
            diffValue = (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, IMergeViewer.MergeViewerSide.ANCESTOR);
        }
        if ((match = this.getComparison().getMatch(diffValue)) != null) {
            EObject left = match.getLeft();
            EObject right = match.getRight();
            EObject ancestor = match.getOrigin();
            if (MergeViewerUtil.getResource(this.getComparison(), IMergeViewer.MergeViewerSide.LEFT, initialDiff) == null) {
                left = null;
            }
            if (MergeViewerUtil.getResource(this.getComparison(), IMergeViewer.MergeViewerSide.RIGHT, initialDiff) == null) {
                right = null;
            }
            if (MergeViewerUtil.getResource(this.getComparison(), IMergeViewer.MergeViewerSide.ANCESTOR, initialDiff) == null) {
                ancestor = null;
            }
            return new MergeViewerItem.Container(this.getComparison(), initialDiff, left, right, ancestor, this.getSide(), this.getRootAdapterFactory());
        }
        return null;
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        ImmutableList ret = ImmutableList.of((Object)new ResourceAttachmentChangeMergeViewerItem(this.getComparison(), null, this.getResource(IMergeViewer.MergeViewerSide.LEFT), this.getResource(IMergeViewer.MergeViewerSide.RIGHT), this.getResource(IMergeViewer.MergeViewerSide.ANCESTOR), this.getSide(), this.getRootAdapterFactory()));
        return ret;
    }

    @Override
    public Resource getResource(IMergeViewer.MergeViewerSide side) {
        return MergeViewerUtil.getResource(this.fOwnerMatch.getComparison(), side, this.fDiff);
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    @Override
    public String getName() {
        return ResourceContentsAccessorImpl.class.getName();
    }

    @Override
    public Image getImage() {
        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.getPlugin().getImage("full/obj16/EObject"));
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eResourceDiff";
    }
}

