/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.unit;

import java.util.ArrayList;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.tests.unit.AbstractCompareTest;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Test;

public class DiffTest
extends AbstractCompareTest {
    @Test
    public void testRequires() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Requires();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff requiresValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRequires = new ArrayList<Diff>(1);
        listRequires.add(requiresValue);
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.getRequires().isEmpty());
        diff.getRequires().add((Object)requiresValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRequires().contains((Object)requiresValue));
        Assert.assertSame((Object)diff.getRequires(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRequires(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiresValue.getRequiredBy().contains((Object)diff));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRequires().isEmpty());
        Assert.assertSame((Object)diff.getRequires(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRequires(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)requiresValue.getRequiredBy().contains((Object)diff));
        diff.eSet((EStructuralFeature)feature, listRequires);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRequires().contains((Object)requiresValue));
        Assert.assertSame((Object)diff.getRequires(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRequires(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiresValue.getRequiredBy().contains((Object)diff));
    }

    @Test
    public void testRequiredBy() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_RequiredBy();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff requiredByValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRequiredBy = new ArrayList<Diff>(1);
        listRequiredBy.add(requiredByValue);
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.getRequiredBy().isEmpty());
        diff.getRequiredBy().add((Object)requiredByValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRequiredBy().contains((Object)requiredByValue));
        Assert.assertSame((Object)diff.getRequiredBy(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRequiredBy(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiredByValue.getRequires().contains((Object)diff));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRequiredBy().isEmpty());
        Assert.assertSame((Object)diff.getRequiredBy(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRequiredBy(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)requiredByValue.getRequires().contains((Object)diff));
        diff.eSet((EStructuralFeature)feature, listRequiredBy);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRequiredBy().contains((Object)requiredByValue));
        Assert.assertSame((Object)diff.getRequiredBy(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRequiredBy(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiredByValue.getRequires().contains((Object)diff));
    }

    @Test
    public void testRefines() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Refines();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff refinesValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRefines = new ArrayList<Diff>(1);
        listRefines.add(refinesValue);
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.getRefines().isEmpty());
        diff.getRefines().add((Object)refinesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRefines().contains((Object)refinesValue));
        Assert.assertSame((Object)diff.getRefines(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRefines(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinesValue.getRefinedBy().contains((Object)diff));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRefines().isEmpty());
        Assert.assertSame((Object)diff.getRefines(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRefines(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)refinesValue.getRefinedBy().contains((Object)diff));
        diff.eSet((EStructuralFeature)feature, listRefines);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRefines().contains((Object)refinesValue));
        Assert.assertSame((Object)diff.getRefines(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRefines(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinesValue.getRefinedBy().contains((Object)diff));
    }

    @Test
    public void testRefinedBy() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_RefinedBy();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff refinedByValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRefinedBy = new ArrayList<Diff>(1);
        listRefinedBy.add(refinedByValue);
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.getRefinedBy().isEmpty());
        diff.getRefinedBy().add((Object)refinedByValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRefinedBy().contains((Object)refinedByValue));
        Assert.assertSame((Object)diff.getRefinedBy(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRefinedBy(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinedByValue.getRefines().contains((Object)diff));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRefinedBy().isEmpty());
        Assert.assertSame((Object)diff.getRefinedBy(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRefinedBy(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)refinedByValue.getRefines().contains((Object)diff));
        diff.eSet((EStructuralFeature)feature, listRefinedBy);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)diff.getRefinedBy().contains((Object)refinedByValue));
        Assert.assertSame((Object)diff.getRefinedBy(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getRefinedBy(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinedByValue.getRefines().contains((Object)diff));
    }

    @Test
    public void testMatch() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Match();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Match matchValue = CompareFactory.eINSTANCE.createMatch();
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)diff.getMatch());
        diff.setMatch(matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)diff.getMatch());
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)diff));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)diff.getMatch());
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)matchValue.getDifferences().contains((Object)diff));
        diff.setMatch(matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)diff.getMatch());
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)diff));
        diff.eSet((EStructuralFeature)feature, (Object)matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)diff.getMatch());
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)diff));
        diff.setMatch(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)diff.getMatch());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)diff.getMatch());
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getMatch(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)matchValue.getDifferences().contains((Object)diff));
    }

    @Test
    public void testEquivalence() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Equivalence();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Equivalence equivalenceValue = CompareFactory.eINSTANCE.createEquivalence();
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)diff.getEquivalence());
        diff.setEquivalence(equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)diff.getEquivalence());
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)diff));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)diff.getEquivalence());
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)equivalenceValue.getDifferences().contains((Object)diff));
        diff.setEquivalence(equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)diff.getEquivalence());
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)diff));
        diff.eSet((EStructuralFeature)feature, (Object)equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)diff.getEquivalence());
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)diff));
        diff.setEquivalence(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)diff.getEquivalence());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)diff.getEquivalence());
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getEquivalence(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)equivalenceValue.getDifferences().contains((Object)diff));
    }

    @Test
    public void testConflict() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Conflict();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Conflict conflictValue = CompareFactory.eINSTANCE.createConflict();
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)diff.getConflict());
        diff.setConflict(conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)diff.getConflict());
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)diff));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)diff.getConflict());
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflictValue.getDifferences().contains((Object)diff));
        diff.setConflict(conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)diff.getConflict());
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)diff));
        diff.eSet((EStructuralFeature)feature, (Object)conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)diff.getConflict());
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)diff));
        diff.setConflict(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)diff.getConflict());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)diff.getConflict());
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)diff.getConflict(), (Object)diff.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflictValue.getDifferences().contains((Object)diff));
    }

    @Test
    public void testKind() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_Kind();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceKind kindValue = (DifferenceKind)feature.getDefaultValue();
        for (DifferenceKind aDifferenceKind : DifferenceKind.VALUES) {
            if (kindValue.getValue() == aDifferenceKind.getValue()) continue;
            kindValue = aDifferenceKind;
            break;
        }
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getKind());
        diff.setKind(kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)diff.getKind());
        Assert.assertEquals((Object)diff.getKind(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getKind());
        Assert.assertEquals((Object)diff.getKind(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.eSet((EStructuralFeature)feature, (Object)kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)diff.getKind());
        Assert.assertEquals((Object)diff.getKind(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.setKind(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getKind());
        Assert.assertEquals((Object)diff.getKind(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testSource() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_Source();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceSource sourceValue = (DifferenceSource)feature.getDefaultValue();
        for (DifferenceSource aDifferenceSource : DifferenceSource.VALUES) {
            if (sourceValue.getValue() == aDifferenceSource.getValue()) continue;
            sourceValue = aDifferenceSource;
            break;
        }
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getSource());
        diff.setSource(sourceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)sourceValue, (Object)diff.getSource());
        Assert.assertEquals((Object)diff.getSource(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getSource());
        Assert.assertEquals((Object)diff.getSource(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.eSet((EStructuralFeature)feature, (Object)sourceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)sourceValue, (Object)diff.getSource());
        Assert.assertEquals((Object)diff.getSource(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.setSource(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getSource());
        Assert.assertEquals((Object)diff.getSource(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testState() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_State();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        diff.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceState stateValue = (DifferenceState)feature.getDefaultValue();
        for (DifferenceState aDifferenceState : DifferenceState.VALUES) {
            if (stateValue.getValue() == aDifferenceState.getValue()) continue;
            stateValue = aDifferenceState;
            break;
        }
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getState());
        diff.setState(stateValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)stateValue, (Object)diff.getState());
        Assert.assertEquals((Object)diff.getState(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getState());
        Assert.assertEquals((Object)diff.getState(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.eSet((EStructuralFeature)feature, (Object)stateValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)stateValue, (Object)diff.getState());
        Assert.assertEquals((Object)diff.getState(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)diff.eIsSet((EStructuralFeature)feature));
        diff.setState(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)diff.getState());
        Assert.assertEquals((Object)diff.getState(), (Object)diff.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)diff.eIsSet((EStructuralFeature)feature));
    }
}

