/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.TwoWayMergeInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Test;

public class TwoWayBatchMergingTest {
    private TwoWayMergeInputData input = new TwoWayMergeInputData();
    private IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void mergingMoveToDifferentContainmentFeatureR2L() throws IOException {
        Resource left = this.input.getMoveToDifferentContainmentFeatureRTLLeft();
        Resource right = this.input.getMoveToDifferentContainmentFeatureRTLRight();
        this.batchMergeAndAssertEquality(left, right, Direction.RIGHT_TO_LEFT);
    }

    @Test
    public void mergingMoveToDifferentContainmentFeatureL2R() throws IOException {
        Resource left = this.input.getMoveToDifferentContainmentFeatureL2RLeft();
        Resource right = this.input.getMoveToDifferentContainmentFeatureL2RRight();
        this.batchMergeAndAssertEquality(left, right, Direction.LEFT_TO_RIGHT);
    }

    @Test
    public void mergingOppositeReferenceChangeWithoutMatchingOriginalL2R() throws IOException {
        Resource left = this.input.getOppositeReferenceChangeWithoutMatchingOrignalContainerL2RLeft();
        Resource right = this.input.getOppositeReferenceChangeWithoutMatchingOrignalContainerL2RRight();
        this.batchMergeAndAssertEquality(left, right, Direction.LEFT_TO_RIGHT);
    }

    @Test
    public void mergingOppositeReferenceChangeWithAddAndDeleteOnMultivaluedSideR2L() throws IOException {
        Resource left = this.input.getOppositeReferenceChangeWithAddAndDeleteOnMultivaluedSideLeft();
        Resource right = this.input.getOppositeReferenceChangeWithAddAndDeleteOnMultivaluedSideRight();
        this.batchMergeAndAssertEquality(left, right, Direction.RIGHT_TO_LEFT);
    }

    @Test
    public void mergingMoveFromSingleValueReferenceToMultiValueReferenceR2L() throws IOException {
        Resource left = this.input.getMoveFromSingleValueReferenceToMultiValueReferenceR2LLeft();
        Resource right = this.input.getMoveFromSingleValueReferenceToMultiValueReferenceR2LRight();
        this.batchMergeAndAssertEquality(left, right, Direction.RIGHT_TO_LEFT);
    }

    @Test
    public void mergingMoveToNewContainerInADifferentOrderR2L() throws IOException {
        Resource left = this.input.getMoveToNewContainerInADifferentOrderR2LLeft();
        Resource right = this.input.getMoveToNewContainerInADifferentOrderR2LRight();
        this.batchMergeAndAssertEquality(left, right, Direction.RIGHT_TO_LEFT);
    }

    @Test
    public void mergingManyToManyReferenceChangesR2L() throws IOException {
        Resource left = this.input.getManyToManyReferenceChangesR2LLeft();
        Resource right = this.input.getManyToManyReferenceChangesR2LRight();
        this.batchMergeAndAssertEquality(left, right, Direction.RIGHT_TO_LEFT);
    }

    @Test
    public void mergingMoveToFeatureMapL2R() throws IOException {
        Resource left = this.input.getMoveToFeatureMapL2RLeft();
        Resource right = this.input.getMoveToFeatureMapL2RRight();
        this.batchMergeAndAssertEquality(left, right, Direction.LEFT_TO_RIGHT);
    }

    @Test
    public void mergingFeatureMapKeyRemoveAndRefMoveL2R() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapKeyRemoveAndRefMoveL2RLeft((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapKeyRemoveAndRefMoveL2RRight((ResourceSet)resourceSet);
        this.batchMergeAndAssertEquality(left, right, Direction.LEFT_TO_RIGHT);
    }

    @Test
    public void mergingFeatureMapKeyAddAndRefMoveR2L() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapKeyAddAndRefMoveR2LLeft((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapKeyAddAndRefMoveR2LRight((ResourceSet)resourceSet);
        this.batchMergeAndAssertEquality(left, right, Direction.RIGHT_TO_LEFT);
    }

    @Test
    public void mergingDeleteFeatureMapNonContainmentsL2R() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getDeleteFeatureMapNonContainmentsL2RLeft((ResourceSet)resourceSet);
        Resource right = this.input.getDeleteFeatureMapNonContainmentsL2RRight((ResourceSet)resourceSet);
        this.batchMergeAndAssertEquality(left, right, Direction.LEFT_TO_RIGHT);
    }

    private void batchMergeAndAssertEquality(Resource left, Resource right, Direction direction) {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        switch (direction) {
            case LEFT_TO_RIGHT: {
                merger.copyAllLeftToRight((Iterable)differences, (Monitor)new BasicMonitor());
            }
            case RIGHT_TO_LEFT: {
                merger.copyAllRightToLeft((Iterable)differences, (Monitor)new BasicMonitor());
            }
        }
        Comparison assertionComparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList assertionDifferences = assertionComparison.getDifferences();
        Assert.assertEquals((long)0L, (long)assertionDifferences.size());
    }

    private static enum Direction {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

