/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.tests.merge.AbstractMergerTest;
import org.eclipse.emf.compare.tests.merge.data.bug485266.Bug485266InputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Bug485266_MoveDeleteConflict_Test
extends AbstractMergerTest {
    @Parameterized.Parameters
    public static Collection<Object[]> params() throws IOException {
        Bug485266InputData inputData = new Bug485266InputData();
        Object[] test1RightToLeft = new Object[]{inputData.getData1AncestorResource(), inputData.getData1LeftResource(), inputData.getData1RightResource(), true, inputData.getData1ResultResource()};
        Object[] test1LeftToRight = new Object[]{inputData.getData1AncestorResource(), inputData.getData1RightResource(), inputData.getData1LeftResource(), false, inputData.getData1ResultResource()};
        Object[] test2RightToLeft = new Object[]{inputData.getData2AncestorResource(), inputData.getData2LeftResource(), inputData.getData2RightResource(), true, inputData.getData2ResultResource()};
        Object[] test2LeftToRight = new Object[]{inputData.getData2AncestorResource(), inputData.getData2RightResource(), inputData.getData2LeftResource(), false, inputData.getData2ResultResource()};
        Object[] test3RightToLeft = new Object[]{inputData.getData3AncestorResource(), inputData.getData3LeftResource(), inputData.getData3RightResource(), true, inputData.getData3ResultResource()};
        Object[] test3LeftToRight = new Object[]{inputData.getData3AncestorResource(), inputData.getData3RightResource(), inputData.getData3LeftResource(), false, inputData.getData3ResultResource()};
        Object[] test4RightToLeft = new Object[]{inputData.getData4AncestorResource(), inputData.getData4LeftResource(), inputData.getData4RightResource(), true, inputData.getData4ResultResource()};
        Object[] test4LeftToRight = new Object[]{inputData.getData4AncestorResource(), inputData.getData4RightResource(), inputData.getData4LeftResource(), false, inputData.getData4ResultResource()};
        Object[] test5RightToLeft = new Object[]{inputData.getData5AncestorResource(), inputData.getData5LeftResource(), inputData.getData5RightResource(), true, inputData.getData5ResultResource()};
        Object[] test5LeftToRight = new Object[]{inputData.getData5AncestorResource(), inputData.getData5RightResource(), inputData.getData5LeftResource(), false, inputData.getData5ResultResource()};
        return Arrays.asList(test1RightToLeft, test1LeftToRight, test2RightToLeft, test2LeftToRight, test3RightToLeft, test3LeftToRight, test5RightToLeft, test5LeftToRight);
    }

    public Bug485266_MoveDeleteConflict_Test(Resource origin, Resource left, Resource right, boolean rightToLeft, Resource expected) {
        super(origin, left, right, rightToLeft, expected, IMerger.RegistryImpl.createStandaloneInstance());
    }

    @Override
    protected List<Diff> getDiffsToMerge() {
        ArrayList<Diff> diffsToMerge = new ArrayList<Diff>();
        EList conflicts = this.comparison.getConflicts();
        for (Conflict conflict : conflicts) {
            EList differences = conflict.getDifferences();
            Collection moveDiffs = Collections2.filter((Collection)differences, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE));
            Assert.assertEquals((long)1L, (long)moveDiffs.size());
            Diff move = (Diff)moveDiffs.iterator().next();
            diffsToMerge.add(move);
        }
        return diffsToMerge;
    }
}

