/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fullcomparison;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class ExtLibraryTest {
    private IdentifierMatchInputData inputData = new IdentifierMatchInputData();

    @Test
    public void testConflicts() throws IOException {
        Resource left = this.inputData.getExtlibraryLeft();
        Resource origin = this.inputData.getExtlibraryOrigin();
        Resource right = this.inputData.getExtlibraryRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Predicate rightAudiovisualName = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"extlibrary.AudioVisualItem.length", (String)"name", (Object)"minutesLength", (Object)"minutes"));
        Predicate leftAudiovisualName = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"extlibrary.AudioVisualItem.length", (String)"name", (Object)"minutesLength", (Object)"length"));
        Diff rightAudiovisualNameDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightAudiovisualName);
        Diff leftAudiovisualNameDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftAudiovisualName);
        Conflict audiovisualNameConflict = rightAudiovisualNameDiff.getConflict();
        Assert.assertNotNull((Object)audiovisualNameConflict);
        Assert.assertEquals((long)2L, (long)audiovisualNameConflict.getDifferences().size());
        Assert.assertTrue((boolean)audiovisualNameConflict.getDifferences().contains((Object)rightAudiovisualNameDiff));
        Assert.assertTrue((boolean)audiovisualNameConflict.getDifferences().contains((Object)leftAudiovisualNameDiff));
        Assert.assertSame((Object)audiovisualNameConflict, (Object)leftAudiovisualNameDiff.getConflict());
        Assert.assertSame((Object)ConflictKind.REAL, (Object)audiovisualNameConflict.getKind());
        Predicate rightRemovedReader = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removed((String)"extlibrary.BookOnTape.reader"));
        Predicate rightUnsetReaderType = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"extlibrary.BookOnTape.reader", (String)"eType", (String)"extlibrary.Person", null));
        Predicate leftRemovedReader = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"extlibrary.BookOnTape.reader"));
        Predicate leftUnsetReaderType = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"extlibrary.BookOnTape.reader", (String)"eType", (String)"extlibrary.Person", null));
        Diff rightRemovedReaderDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightRemovedReader);
        Diff rightUnsetReaderTypeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightUnsetReaderType);
        Diff leftRemovedReaderDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftRemovedReader);
        Diff leftUnsetReaderTypeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftUnsetReaderType);
        Conflict readerConflict = rightRemovedReaderDiff.getConflict();
        Assert.assertNotNull((Object)readerConflict);
        Assert.assertEquals((long)2L, (long)readerConflict.getDifferences().size());
        Assert.assertTrue((boolean)readerConflict.getDifferences().contains((Object)rightRemovedReaderDiff));
        Assert.assertTrue((boolean)readerConflict.getDifferences().contains((Object)leftRemovedReaderDiff));
        Assert.assertSame((Object)readerConflict, (Object)leftRemovedReaderDiff.getConflict());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)readerConflict.getKind());
        Conflict readerETypeConflict = rightUnsetReaderTypeDiff.getConflict();
        Assert.assertNotNull((Object)readerETypeConflict);
        Assert.assertEquals((long)2L, (long)readerETypeConflict.getDifferences().size());
        Assert.assertTrue((boolean)readerETypeConflict.getDifferences().contains((Object)rightUnsetReaderTypeDiff));
        Assert.assertTrue((boolean)readerETypeConflict.getDifferences().contains((Object)leftUnsetReaderTypeDiff));
        Assert.assertSame((Object)readerETypeConflict, (Object)leftUnsetReaderTypeDiff.getConflict());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)readerETypeConflict.getKind());
        Predicate rightRenamedFamilyname = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"extlibrary.Person.familyName", (String)"name", (Object)"lastName", (Object)"familyName"));
        Predicate leftRemovedLastname = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"extlibrary.Person.lastName"));
        Diff rightRenamedFamilyNameDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightRenamedFamilyname);
        Diff leftRemovedLastNameDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftRemovedLastname);
        Conflict familyNameConflict = leftRemovedLastNameDiff.getConflict();
        Assert.assertNotNull((Object)familyNameConflict);
        Assert.assertEquals((long)2L, (long)familyNameConflict.getDifferences().size());
        Assert.assertTrue((boolean)familyNameConflict.getDifferences().contains((Object)leftRemovedLastNameDiff));
        Assert.assertTrue((boolean)familyNameConflict.getDifferences().contains((Object)rightRenamedFamilyNameDiff));
        Assert.assertSame((Object)familyNameConflict, (Object)rightRenamedFamilyNameDiff.getConflict());
        Assert.assertSame((Object)ConflictKind.REAL, (Object)familyNameConflict.getKind());
        Predicate rightSetPeriodicalSupertype = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToReference((String)"extlibrary.Magazine", (String)"eSuperTypes", (String)"extlibrary.Periodical"));
        Predicate rightSetTitledItemSupertype = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToReference((String)"extlibrary.Periodical", (String)"eSuperTypes", (String)"extlibrary.TitledItem"));
        Predicate leftRemovedPeriodical = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"extlibrary.Periodical"));
        Diff rightSetPeriodicalSupertypeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightSetPeriodicalSupertype);
        Diff rightSetTitledItemSupertypeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightSetTitledItemSupertype);
        Diff leftRemovedPeriodicalDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftRemovedPeriodical);
        Conflict periodicalConflict = rightSetPeriodicalSupertypeDiff.getConflict();
        Assert.assertNotNull((Object)periodicalConflict);
        Assert.assertEquals((long)3L, (long)periodicalConflict.getDifferences().size());
        Assert.assertTrue((boolean)periodicalConflict.getDifferences().contains((Object)leftRemovedPeriodicalDiff));
        Assert.assertTrue((boolean)periodicalConflict.getDifferences().contains((Object)rightSetPeriodicalSupertypeDiff));
        Assert.assertTrue((boolean)periodicalConflict.getDifferences().contains((Object)rightSetTitledItemSupertypeDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)periodicalConflict.getKind());
        Predicate leftRemovedTitle = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"extlibrary.Periodical.title"));
        Predicate leftUnsetTitleType = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"extlibrary.Periodical.title", (String)"eType", (String)"ecore.EString", null));
        Predicate rightRemovedTitle = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removed((String)"extlibrary.Periodical.title"));
        Predicate rightUnsetTitleType = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"extlibrary.Periodical.title", (String)"eType", (String)"ecore.EString", null));
        Diff leftRemovedTitleDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftRemovedTitle);
        Diff leftUnsetTitleTypeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftUnsetTitleType);
        Diff rightRemovedTitleDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightRemovedTitle);
        Diff rightUnsetTitleTypeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)rightUnsetTitleType);
        Conflict titleConflict = leftRemovedTitleDiff.getConflict();
        Assert.assertNotNull((Object)titleConflict);
        Assert.assertEquals((long)2L, (long)titleConflict.getDifferences().size());
        Assert.assertTrue((boolean)titleConflict.getDifferences().contains((Object)leftRemovedTitleDiff));
        Assert.assertTrue((boolean)titleConflict.getDifferences().contains((Object)rightRemovedTitleDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)titleConflict.getKind());
        Conflict titleETypeConflict = leftUnsetTitleTypeDiff.getConflict();
        Assert.assertNotNull((Object)titleETypeConflict);
        Assert.assertEquals((long)2L, (long)titleETypeConflict.getDifferences().size());
        Assert.assertTrue((boolean)titleETypeConflict.getDifferences().contains((Object)leftUnsetTitleTypeDiff));
        Assert.assertTrue((boolean)titleETypeConflict.getDifferences().contains((Object)rightUnsetTitleTypeDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)titleETypeConflict.getKind());
        Assert.assertEquals((long)7L, (long)comparison.getConflicts().size());
    }
}

