/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.diff.data.pseudoconflict.SingleValuedAttributePseudoConflictInputData;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class SingleValuedAttributePseudoConflictTest {
    private SingleValuedAttributePseudoConflictInputData input = new SingleValuedAttributePseudoConflictInputData();

    @Test
    public void testSingleValuedAttributePseudoConflict() throws IOException {
        Resource left = this.input.getSingleValueAttributePseudoConflictLeft();
        Resource right = this.input.getSingleValueAttributePseudoConflictRight();
        Resource origin = this.input.getSingleValueAttributePseudoConflictOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff1 = (Diff)differences.get(0);
        Diff diff2 = (Diff)differences.get(1);
        Assert.assertNotNull((Object)diff1.getConflict());
        Assert.assertEquals((Object)diff1.getConflict(), (Object)diff2.getConflict());
        Conflict conflict = diff1.getConflict();
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
        Assert.assertTrue((boolean)(diff1 instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)diff1.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff1.getSource());
        Assert.assertTrue((boolean)(diff2 instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)diff2.getKind());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff2.getSource());
        Match container = diff1.getMatch();
        Object leftValue = ReferenceUtil.safeEGet((EObject)container.getLeft(), (EStructuralFeature)((AttributeChange)diff1).getAttribute());
        Object rightValue = ReferenceUtil.safeEGet((EObject)container.getRight(), (EStructuralFeature)((AttributeChange)diff2).getAttribute());
        Assert.assertNotNull((Object)leftValue);
        Assert.assertEquals((Object)leftValue, (Object)rightValue);
        Assert.assertEquals((Object)leftValue, (Object)((AttributeChange)diff1).getValue());
        Assert.assertEquals((Object)rightValue, (Object)((AttributeChange)diff2).getValue());
    }
}

