/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.conflict;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.conflict.data.ConflictInputData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PseudoConflictDetectionTest {
    private final Notifier origin;
    private final Notifier left;
    private final Notifier right;
    private final int numberOfConflicts;

    @Parameterized.Parameters
    public static Collection<Object[]> params() throws IOException {
        ConflictInputData inputData = new ConflictInputData();
        Object[] test1 = new Object[]{inputData.getPseudoConflictCase1Ancestor(), inputData.getPseudoConflictCase1RightAndLeftModel(), inputData.getPseudoConflictCase1RightAndLeftModel(), new Integer(5)};
        Object[] test2 = new Object[]{inputData.getPseudoConflictCase2Ancestor(), inputData.getPseudoConflictCase2RightAndLeftModel(), inputData.getPseudoConflictCase2RightAndLeftModel(), new Integer(1)};
        Object[] test3 = new Object[]{inputData.getPseudoConflictCase3Ancestor(), inputData.getPseudoConflictCase3RightAndLeftModel(), inputData.getPseudoConflictCase3RightAndLeftModel(), new Integer(2)};
        Object[] test4 = new Object[]{inputData.getPseudoConflictCase4Ancestor(), inputData.getPseudoConflictCase4RightAndLeftModel(), inputData.getPseudoConflictCase4RightAndLeftModel(), new Integer(2)};
        return Arrays.asList(test1, test2, test3, test4);
    }

    public PseudoConflictDetectionTest(Notifier origin, Notifier left, Notifier right, Integer numberOfConflicts) {
        this.origin = (Notifier)Preconditions.checkNotNull((Object)origin);
        this.left = (Notifier)Preconditions.checkNotNull((Object)left);
        this.right = (Notifier)Preconditions.checkNotNull((Object)right);
        this.numberOfConflicts = (Integer)Preconditions.checkNotNull((Object)numberOfConflicts);
    }

    @Test
    public void verifyPseudoConflictDetection() throws IOException {
        DefaultComparisonScope scope = new DefaultComparisonScope(this.left, this.right, this.origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)this.numberOfConflicts, (long)conflicts.size());
        for (Conflict conflict : conflicts) {
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
        }
    }
}

