/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.conflict;

import java.util.Arrays;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConflictSearchTest {
    private Diff diff;
    private Match match;
    private Comparison comparison;
    private ComparisonIndex index;
    private Diff other;
    private Diff equivToDiff;
    private Diff equivToOther;
    private Equivalence equivDiff;
    private Equivalence equivOther;

    @Test
    public void testEquivalentDiffsAreInSameConflict() {
        TestConflictSearch search = new TestConflictSearch(this.diff, this.index);
        search.conflict(this.other, ConflictKind.REAL);
        Assert.assertEquals((long)1L, (long)this.comparison.getConflicts().size());
        Conflict conflict = (Conflict)this.comparison.getConflicts().get(0);
        Assert.assertEquals((long)4L, (long)conflict.getDifferences().size());
        Assert.assertTrue((boolean)conflict.getDifferences().containsAll(Arrays.asList(this.diff, this.equivToDiff, this.other, this.equivToOther)));
    }

    @Before
    public void setUp() throws Exception {
        this.comparison = CompareFactory.eINSTANCE.createComparison();
        this.match = CompareFactory.eINSTANCE.createMatch();
        this.comparison.getMatches().add((Object)this.match);
        this.diff = CompareFactory.eINSTANCE.createDiff();
        this.diff.setMatch(this.match);
        this.other = CompareFactory.eINSTANCE.createDiff();
        this.other.setMatch(this.match);
        this.equivToDiff = CompareFactory.eINSTANCE.createDiff();
        this.equivToDiff.setMatch(this.match);
        this.equivToOther = CompareFactory.eINSTANCE.createDiff();
        this.equivToOther.setMatch(this.match);
        this.equivDiff = CompareFactory.eINSTANCE.createEquivalence();
        this.equivOther = CompareFactory.eINSTANCE.createEquivalence();
        this.equivDiff.getDifferences().addAll(Arrays.asList(this.diff, this.equivToDiff));
        this.equivOther.getDifferences().addAll(Arrays.asList(this.other, this.equivToOther));
        this.index = ComparisonIndex.index((Comparison)this.comparison, (Monitor)new BasicMonitor());
    }

    public static final class TestConflictSearch
    extends AbstractConflictSearch<Diff> {
        public TestConflictSearch(Diff diff, ComparisonIndex index) {
            super(diff, index, (Monitor)new BasicMonitor());
        }

        public void detectConflicts() {
        }

        public void conflict(Diff other, ConflictKind kind) {
            super.conflict(other, kind);
        }
    }
}

