/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.internal.editor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeEditorInput;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeInput;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBug506928 {
    private Resource left;
    private Resource right;
    private Resource origin;
    private ICompareEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private EMFCompare comparator;

    @Before
    public void setUp() throws IOException {
        Bug506928InputData inputData = new Bug506928InputData();
        this.left = inputData.getResource("left.nodes");
        this.right = inputData.getResource("right.nodes");
        this.origin = inputData.getResource("origin.nodes");
        this.editingDomain = EMFCompareEditingDomain.create((Notifier)this.left, (Notifier)this.right, (Notifier)this.origin);
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.comparator = EMFCompare.builder().build();
    }

    protected void testComparisonScopeEditorInput(boolean leftEditable, boolean rightEditable) {
        EMFCompareConfiguration configuration = new EMFCompareConfiguration(new CompareConfiguration());
        configuration.setLeftEditable(leftEditable);
        configuration.setRightEditable(rightEditable);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, (Notifier)this.origin);
        ComparisonScopeEditorInput input = new ComparisonScopeEditorInput(configuration, this.editingDomain, (AdapterFactory)this.adapterFactory, this.comparator, (IComparisonScope)scope);
        Assert.assertEquals((Object)input.getCompareResult(), null);
        try {
            input.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)(input.getCompareResult() instanceof ComparisonScopeInput));
        ComparisonScopeInput result = (ComparisonScopeInput)input.getCompareResult();
        Assert.assertEquals((Object)leftEditable, (Object)input.getCompareConfiguration().isLeftEditable());
        Assert.assertEquals((Object)rightEditable, (Object)input.getCompareConfiguration().isRightEditable());
        Assert.assertEquals((Object)input.getCompareConfiguration().isLeftEditable(), (Object)result.isLeftEditable());
        Assert.assertEquals((Object)input.getCompareConfiguration().isRightEditable(), (Object)result.isRightEditable());
    }

    @Test
    public void testComparisionScopeEditorInput_BothNotEditable() {
        this.testComparisonScopeEditorInput(false, false);
    }

    @Test
    public void testComparisionScopeEditorInput_LeftEditable() {
        this.testComparisonScopeEditorInput(true, false);
    }

    @Test
    public void testComparisionScopeEditorInput_RightEditable() {
        this.testComparisonScopeEditorInput(false, true);
    }

    @Test
    public void testComparisionScopeEditorInput_BothEditable() {
        this.testComparisonScopeEditorInput(true, true);
    }

    public class Bug506928InputData
    extends AbstractInputData {
        private static final String PATH_PREFIX = "data/_506928/";

        public Resource getResource(String resourceName) throws IOException {
            StringBuilder resourceURL = new StringBuilder(PATH_PREFIX);
            resourceURL.append(resourceName);
            return this.loadFromClassLoader(resourceURL.toString());
        }
    }
}

