/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.postprocess;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.nodes.NodesPackage;
import org.eclipse.emf.compare.tests.postprocess.data.PostProcessInputData;
import org.eclipse.emf.compare.tests.postprocess.data.TestPostProcessor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PostProcessorTest {
    private PostProcessInputData input = new PostProcessInputData();

    @BeforeClass
    public static void beforeClass() {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/compare/tests/nodes", (Object)NodesPackage.eINSTANCE);
    }

    @Test
    public void testNominalUseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testA1UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, Pattern.compile("http://www.eclipse.org/emf/compare/tests/nodes"), null);
        Assert.assertEquals((long)2L, (long)comparison.getMatches().size());
    }

    @Test
    public void testA2UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, Pattern.compile(".*/nodes"), null);
        Assert.assertEquals((long)2L, (long)comparison.getMatches().size());
    }

    @Test
    public void testA3UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, Pattern.compile(".*/nides"), null);
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testA4UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, null, null);
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testA5UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, Pattern.compile(""), null);
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testA6UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, Pattern.compile(" "), null);
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testB1UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, null, Pattern.compile(left.getURI().toString()));
        Assert.assertEquals((long)2L, (long)comparison.getMatches().size());
    }

    @Test
    public void testB2UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, null, Pattern.compile(".*.nodes"));
        Assert.assertEquals((long)2L, (long)comparison.getMatches().size());
    }

    @Test
    public void testB3UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, null, Pattern.compile(".*.nides"));
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testB4UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, null, Pattern.compile(""));
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testB5UseCase() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        Comparison comparison = this.compareWithPostProcessing(left, right, null, Pattern.compile(" "));
        Assert.assertEquals((long)1L, (long)comparison.getMatches().size());
    }

    @Test
    public void testOrderingPostProcessors() throws IOException {
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        PostProcessorDescriptorRegistryImpl registry = new PostProcessorDescriptorRegistryImpl();
        registry.put((Object)TestPostProcessor1.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile(""), null, new TestPostProcessor1(), 1));
        registry.put((Object)TestPostProcessor2.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/emf/compare/tests/nodes"), null, new TestPostProcessor2(), 10));
        registry.put((Object)TestPostProcessor3.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/emf/compare/tests/nodes"), null, new TestPostProcessor3(), 9));
        registry.put((Object)TestPostProcessor4.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/emf/compare/tests/nodes"), null, new TestPostProcessor4(), 11));
        EMFCompare.builder().setPostProcessorRegistry((IPostProcessor.Descriptor.Registry)registry).build().compare((IComparisonScope)scope);
        List postProcessors = registry.getPostProcessors((IComparisonScope)scope);
        Assert.assertEquals((long)3L, (long)postProcessors.size());
        Assert.assertTrue((boolean)(postProcessors.get(0) instanceof TestPostProcessor3));
        Assert.assertTrue((boolean)(postProcessors.get(1) instanceof TestPostProcessor2));
        Assert.assertTrue((boolean)(postProcessors.get(2) instanceof TestPostProcessor4));
    }

    private Comparison compareWithPostProcessing(Resource left, Resource right, Pattern nsURI, Pattern resourceURI) {
        PostProcessorDescriptorRegistryImpl registry = new PostProcessorDescriptorRegistryImpl();
        registry.put((Object)TestPostProcessor.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(nsURI, resourceURI, new TestPostProcessor(), 10));
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        return EMFCompare.builder().setPostProcessorRegistry((IPostProcessor.Descriptor.Registry)registry).build().compare((IComparisonScope)scope);
    }

    private class TestPostProcessor1
    extends TestPostProcessor {
        private TestPostProcessor1() {
        }
    }

    private class TestPostProcessor2
    extends TestPostProcessor {
        private TestPostProcessor2() {
        }
    }

    private class TestPostProcessor3
    extends TestPostProcessor {
        private TestPostProcessor3() {
        }
    }

    private class TestPostProcessor4
    extends TestPostProcessor {
        private TestPostProcessor4() {
        }
    }
}

