/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fullcomparison;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.EcoreWeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.match.eobject.internal.WeightProviderDescriptorImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.EMFCompareAssert;
import org.eclipse.emf.compare.tests.framework.EMFCompareTestBase;
import org.eclipse.emf.compare.tests.fullcomparison.data.distance.DistanceMatchInputData;
import org.eclipse.emf.compare.tests.suite.AllTests;
import org.eclipse.emf.compare.utils.EMFComparePrettyPrinter;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProximityComparisonTest
extends EMFCompareTestBase {
    private DistanceMatchInputData inputData = new DistanceMatchInputData();

    @Before
    public void setUp() throws Exception {
        AllTests.fillEMFRegistries();
    }

    @Test
    public void singleEObjectTest() throws Exception {
        EPackage v1 = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        EPackage v2 = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        v1.getEClassifiers().clear();
        v2.getEClassifiers().clear();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)v1, (Notifier)v2, null);
        Comparison result = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.assertAllMatched(Lists.newArrayList((Object[])new EPackage[]{v1}), result);
        Assert.assertEquals((String)"We are supposed to have zero diffs", (long)0L, (long)result.getDifferences().size());
    }

    @Test
    public void matchingSmallRenameChanges() throws Exception {
        Resource left = this.inputData.getCompareLeft();
        Resource right = this.inputData.getCompareRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        Assert.assertEquals((String)"We are supposed to have one rename diff", (long)1L, (long)result.getDifferences().size());
    }

    @Test
    public void matchingIndenticInstances() throws Exception {
        EPackage v1 = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        EPackage v2 = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)v1, (Notifier)v2, null);
        Comparison result = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.assertAllMatched(Lists.newArrayList((Object[])new EPackage[]{v1}), result);
        Assert.assertEquals((String)"We are supposed to have zero diffs", (long)0L, (long)result.getDifferences().size());
    }

    @Test
    public void smallChangeOnEPackage() throws Exception {
        EPackage v1 = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        EPackage v2 = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        v2.setName("renamed");
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)v1, (Notifier)v2, null);
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        this.assertAllMatched(Lists.newArrayList((Object[])new EPackage[]{v1}), result);
        Assert.assertEquals((String)"We are supposed to have a rename", (long)1L, (long)result.getDifferences().size());
    }

    @Test
    public void packageAddDelete() throws Exception {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.inputData.getPackageAddDeleteLeft(), (Notifier)this.inputData.getPackageAddDeleteRight(), null);
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        EMFComparePrettyPrinter.printComparison((Comparison)result, (PrintStream)System.out);
        EList differences = result.getDifferences();
        EMFCompareAssert.assertAddedToReference((List<Diff>)differences, "p1.p2", "eSubpackages", "p1.p2.subPackage", DifferenceSource.LEFT);
        EMFCompareAssert.assertRemovedFromReference((List<Diff>)differences, "p1", "eSubpackages", "p1.another", DifferenceSource.LEFT);
        Assert.assertEquals((String)"We are supposed to have zero diffs", (long)2L, (long)result.getDifferences().size());
    }

    @Test
    public void packageAddRemoveNoRename() throws Exception {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.inputData.getPackageAddRemoveNoRenameLeft(), (Notifier)this.inputData.getPackageAddRemoveNoRenameRight(), null);
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        EMFComparePrettyPrinter.printComparison((Comparison)result, (PrintStream)System.out);
        Assert.assertEquals((String)"We are supposed to have zero diffs", (long)2L, (long)result.getDifferences().size());
    }

    @Test
    public void alwaysTakeTheClosestNoMatterTheIterationOrder() throws Exception {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.inputData.getVerySmallLeft(), (Notifier)this.inputData.getVerySmallRight(), null);
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        Assert.assertEquals((String)"The Match took on element which is close enough (in the limits) preventing the next iteration to take it (it was closest)", (long)1L, (long)result.getDifferences().size());
    }

    @Test
    public void addRemoveAndNotRename() throws Exception {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.inputData.get391657Left(), (Notifier)this.inputData.get391657Right(), null);
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        WeightProviderDescriptorRegistryImpl weightProviderRegistry = new WeightProviderDescriptorRegistryImpl();
        EcoreWeightProvider weightProvider = new EcoreWeightProvider();
        WeightProviderDescriptorImpl descriptor = new WeightProviderDescriptorImpl((WeightProvider)weightProvider, 100, Pattern.compile(".*"));
        weightProviderRegistry.put(weightProvider.getClass().getName(), (WeightProvider.Descriptor)descriptor);
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER, (WeightProvider.Descriptor.Registry)weightProviderRegistry));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        UnmodifiableIterator attrChanges = Iterators.filter((Iterator)result.getDifferences().iterator(), AttributeChange.class);
        Assert.assertFalse((String)"We are supposed to detect an addition/remove (and not a rename if that's what we get)", (boolean)attrChanges.hasNext());
    }

    @Test
    public void resourceRootChange() throws Exception {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.inputData.get390666Left(), (Notifier)this.inputData.get390666Right(), (Notifier)this.inputData.get390666Ancestor());
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        UnmodifiableIterator attrChanges = Iterators.filter((Iterator)result.getDifferences().iterator(), ResourceAttachmentChange.class);
        Assert.assertTrue((String)"We are supposed to detect a new attachment to a resource", (boolean)attrChanges.hasNext());
    }

    @Test
    public void moveInAReferenceShouldNotAffectMatch() throws Exception {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.inputData.get391798Left(), (Notifier)this.inputData.get391798Right(), null);
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)new MatchEngineFactoryImpl(UseIdentifiers.NEVER));
        Comparison result = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineFactoryRegistry).build().compare((IComparisonScope)scope);
        for (Diff dif : result.getDifferences()) {
            if (dif instanceof ReferenceChange && dif.getKind() == DifferenceKind.MOVE) continue;
            Assert.fail((String)"We should only detect moves in the reference.");
        }
    }

    private void assertAllMatched(Iterable<? extends EObject> eObjects, Comparison comparison) {
        for (EObject eObject : eObjects) {
            Match match = comparison.getMatch(eObject);
            Assert.assertTrue((String)(eObject + " has no match"), (match != null ? 1 : 0) != 0);
        }
    }
}

