/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.tests.profile;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.postprocessor.BasicPostProcessorDescriptorImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.TechnicalitiesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.compare.uml2.internal.postprocessor.StereotypedElementChangePostProcessor;
import org.eclipse.emf.compare.uml2.internal.postprocessor.UMLPostProcessor;
import org.eclipse.emf.compare.uml2.internal.provider.custom.UMLCompareCustomItemProviderAdapterFactory;
import org.eclipse.emf.compare.uml2.internal.provider.decorator.UMLCompareItemProviderDecoratorAdapterFactory;
import org.eclipse.emf.compare.uml2.internal.provider.decorator.UMLProfileItemProviderAdapterFactoryDecorator;
import org.eclipse.emf.compare.uml2.internal.provider.profile.ProfiledUMLCompareItemProviderAdapterFactory;
import org.eclipse.emf.compare.uml2.rcp.ui.internal.structuremergeviewer.filters.UMLRefinedElementsFilter;
import org.eclipse.emf.compare.uml2.rcp.ui.tests.groups.AbstractDifferenceOrderTest;
import org.eclipse.emf.compare.uml2.rcp.ui.tests.groups.NotifierScopeProvider;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class DynamicProfileIntegrationDisplayTest
extends AbstractDifferenceOrderTest {
    static URI registeredURI;
    static Object registeredPackage;

    @BeforeClass
    public static void addProfilePathmap() {
        registeredURI = (URI)UMLPlugin.getEPackageNsURIToProfileLocationMap().remove("http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile");
        registeredPackage = EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile");
    }

    @AfterClass
    public static void resetProfilePathmap() {
        UMLPlugin.getEPackageNsURIToProfileLocationMap().put("http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile", registeredURI);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile", registeredPackage);
    }

    @Override
    protected IPostProcessor.Descriptor.Registry<?> getPostProcessorRegistry() {
        PostProcessorDescriptorRegistryImpl postProcessorRegistry = new PostProcessorDescriptorRegistryImpl();
        BasicPostProcessorDescriptorImpl umlPostProcessor = new BasicPostProcessorDescriptorImpl((IPostProcessor)new UMLPostProcessor(), Pattern.compile("http://www.eclipse.org/uml2/\\d.0.0/UML"), null);
        postProcessorRegistry.put((Object)UMLPostProcessor.class.getName(), (IPostProcessor.Descriptor)umlPostProcessor);
        BasicPostProcessorDescriptorImpl stereotypeElementPostProcessor = new BasicPostProcessorDescriptorImpl((IPostProcessor)new StereotypedElementChangePostProcessor(), Pattern.compile("http://www.eclipse.org/uml2/\\d.0.0/UML"), null);
        postProcessorRegistry.put((Object)StereotypedElementChangePostProcessor.class.getName(), (IPostProcessor.Descriptor)stereotypeElementPostProcessor);
        return postProcessorRegistry;
    }

    @Override
    protected List<AdapterFactory> getAdaptersFactory() {
        this.eventBus = new EventBus();
        return Lists.newArrayList((Object[])new AdapterFactory[]{new ProfiledUMLCompareItemProviderAdapterFactory(), new UMLProfileItemProviderAdapterFactoryDecorator(), new CompareItemProviderAdapterFactorySpec(), new TreeItemProviderAdapterFactorySpec(new StructureMergeViewerFilter(this.eventBus)), new UMLCompareCustomItemProviderAdapterFactory(), new UMLItemProviderAdapterFactory(), new UMLCompareItemProviderDecoratorAdapterFactory(), new ReflectiveItemProviderAdapterFactory()});
    }

    @Override
    protected NotifierScopeProvider getInput() {
        return new DataInput();
    }

    @Test
    public void testDynamicProfileElementDisplay() throws IOException {
        this.getFilter().addFilter((IDifferenceFilter)new UMLRefinedElementsFilter());
        this.getFilter().addFilter((IDifferenceFilter)new TechnicalitiesFilter());
        this.getFilter().addFilter((IDifferenceFilter)new CascadingDifferencesFilter());
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(this.getComparison(), Predicates.alwaysTrue(), this.getCrossReferenceAdapter());
        List roots = group.getChildren();
        this.compareTree(new ExpectedResult().getExpectedResult(), roots, true);
    }

    private static class DataInput
    extends AbstractUMLInputData
    implements NotifierScopeProvider {
        private DataInput() {
        }

        public Resource getLeft() throws IOException {
            return this.loadFromClassLoader("data/dynamic/left.uml");
        }

        public Resource getRight() throws IOException {
            return this.loadFromClassLoader("data/dynamic/right.uml");
        }

        @Override
        public Notifier getOrigin() throws IOException {
            return null;
        }
    }

    private static class ExpectedResult
    extends AbstractInputData {
        private ExpectedResult() {
        }

        public Resource getExpectedResult() throws IOException {
            return this.loadFromClassLoader("data/dynamic/expectedResult.nodes");
        }
    }
}

