/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.stereotypes;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.uml2.internal.ProfileApplicationChange;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.internal.StereotypeAttributeChange;
import org.eclipse.emf.compare.uml2.internal.StereotypeReferenceChange;
import org.eclipse.emf.compare.uml2.tests.AbstractStaticProfileTest;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.stereotypes.data.static_.StaticStereotypeInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.UMLPackage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StaticStereotypeTest
extends AbstractStaticProfileTest {
    private StaticStereotypeInputData input = new StaticStereotypeInputData();

    @BeforeClass
    public static void setupClass() {
        StaticStereotypeTest.fillRegistriesForStatic();
    }

    @AfterClass
    public static void teardownClass() {
        StaticStereotypeTest.resetRegistriesForStatic();
    }

    @Test
    public void testB10UseCase() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLB10UseCase() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRB10UseCase() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB11UseCase() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLB11UseCase() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testMergeLtRB11UseCase() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB10UseCase3way() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLB10UseCase3way() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRB10UseCase3way() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB11UseCase3way() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLB11UseCase3way() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testMergeLtRB11UseCase3way() throws IOException {
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB20UseCase() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB2(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLB20UseCase() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRB20UseCase() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB21UseCase() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB2(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLB21UseCase() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testMergeLtRB21UseCase() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB20UseCase3way() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB2(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLB20UseCase3way() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRB20UseCase3way() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB21UseCase3way() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB2(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLB21UseCase3way() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRB21UseCase3way() throws IOException {
        Resource left = this.input.getB2Left();
        Resource right = this.input.getB2Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB30UseCase() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB3(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLB30UseCase() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRB30UseCase() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB31UseCase() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB3(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLB31UseCase() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testMergeLtRB31UseCase() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB30UseCase3way() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB3(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLB30UseCase3way() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRB30UseCase3way() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB31UseCase3way() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB3(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLB31UseCase3way() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testMergeLtRB31UseCase3way() throws IOException {
        Resource left = this.input.getB3Left();
        Resource right = this.input.getB3Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB40UseCase() throws IOException {
        Resource left = this.input.getB4Left();
        Resource right = this.input.getB4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB4(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB41UseCase() throws IOException {
        Resource left = this.input.getB4Left();
        Resource right = this.input.getB4Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB4(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB40UseCase3way() throws IOException {
        Resource left = this.input.getB4Left();
        Resource right = this.input.getB4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB4(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB41UseCase3way() throws IOException {
        Resource left = this.input.getB4Left();
        Resource right = this.input.getB4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB4(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB50UseCase() throws IOException {
        Resource left = this.input.getB5Left();
        Resource right = this.input.getB5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB5(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB51UseCase() throws IOException {
        Resource left = this.input.getB5Left();
        Resource right = this.input.getB5Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB5(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB50UseCase3way() throws IOException {
        Resource left = this.input.getB5Left();
        Resource right = this.input.getB5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB5(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB51UseCase3way() throws IOException {
        Resource left = this.input.getB5Left();
        Resource right = this.input.getB5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB5(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB60UseCase() throws IOException {
        Resource left = this.input.getB6Left();
        Resource right = this.input.getB6Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB6(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB61UseCase() throws IOException {
        Resource left = this.input.getB6Left();
        Resource right = this.input.getB6Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB6(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB60UseCase3way() throws IOException {
        Resource left = this.input.getB6Left();
        Resource right = this.input.getB6Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB6(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB61UseCase3way() throws IOException {
        Resource left = this.input.getB6Left();
        Resource right = this.input.getB6Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB6(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB70UseCase() throws IOException {
        Resource left = this.input.getB7Left();
        Resource right = this.input.getB7Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB7(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB71UseCase() throws IOException {
        Resource left = this.input.getB7Left();
        Resource right = this.input.getB7Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB7(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB70UseCase3way() throws IOException {
        Resource left = this.input.getB7Left();
        Resource right = this.input.getB7Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB7(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB71UseCase3way() throws IOException {
        Resource left = this.input.getB7Left();
        Resource right = this.input.getB7Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB7(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB80UseCase() throws IOException {
        Resource left = this.input.getB8Left();
        Resource right = this.input.getB8Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB8(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB81UseCase() throws IOException {
        Resource left = this.input.getB8Left();
        Resource right = this.input.getB8Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB8(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB80UseCase3way() throws IOException {
        Resource left = this.input.getB8Left();
        Resource right = this.input.getB8Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB8(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB81UseCase3way() throws IOException {
        Resource left = this.input.getB8Left();
        Resource right = this.input.getB8Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB8(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB90UseCase() throws IOException {
        Resource left = this.input.getB9Left();
        Resource right = this.input.getB9Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB9(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB91UseCase() throws IOException {
        Resource left = this.input.getB9Left();
        Resource right = this.input.getB9Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB9(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB90UseCase3way() throws IOException {
        Resource left = this.input.getB9Left();
        Resource right = this.input.getB9Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB9(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB91UseCase3way() throws IOException {
        Resource left = this.input.getB9Left();
        Resource right = this.input.getB9Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB9(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testB100UseCase() throws IOException {
        Resource left = this.input.getB10Left();
        Resource right = this.input.getB10Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB10(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testB101UseCase() throws IOException {
        Resource left = this.input.getB10Left();
        Resource right = this.input.getB10Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB10(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testB100UseCase3way() throws IOException {
        Resource left = this.input.getB10Left();
        Resource right = this.input.getB10Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB10(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testB101UseCase3way() throws IOException {
        Resource left = this.input.getB10Left();
        Resource right = this.input.getB10Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB10(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)8L, (long)differences.size());
        Predicate addProfileApplicationDescription = null;
        Predicate addAppliedProfileInProfileApplicationDescription = null;
        Predicate addUMLAnnotationDescription = null;
        Predicate addReferencesInUMLAnnotationDescription = null;
        Predicate addStereotypeApplicationDescription = null;
        Predicate addRefBaseClassDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticStereotypeTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
        } else {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticStereotypeTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
        }
        addAppliedProfileInProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"appliedProfile")});
        addStereotypeApplicationDescription = Predicates.instanceOf(ResourceAttachmentChange.class);
        addRefBaseClassDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"base_Class")});
        Diff addProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addProfileApplicationDescription);
        Diff addAppliedProfileInProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addAppliedProfileInProfileApplicationDescription);
        Diff addUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addUMLAnnotationDescription);
        Diff addReferencesInUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addReferencesInUMLAnnotationDescription);
        Diff addStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addStereotypeApplicationDescription);
        Diff addRefBaseClass = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefBaseClassDescription);
        Assert.assertNotNull((Object)addProfileApplication);
        Assert.assertNotNull((Object)addAppliedProfileInProfileApplication);
        Assert.assertNotNull((Object)addUMLAnnotation);
        Assert.assertNotNull((Object)addReferencesInUMLAnnotation);
        Assert.assertNotNull((Object)addStereotypeApplication);
        Assert.assertNotNull((Object)addRefBaseClass);
        Assert.assertEquals((long)1L, (long)StaticStereotypeTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(ProfileApplicationChange.class)));
        Assert.assertEquals((long)1L, (long)StaticStereotypeTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(StereotypeApplicationChange.class)));
        Diff addUMLProfileApplication = null;
        Diff addUMLStereotypeApplication = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            addUMLProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
            addUMLStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        } else {
            addUMLProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
            addUMLStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        }
        Assert.assertNotNull((Object)addUMLProfileApplication);
        Assert.assertEquals((long)4L, (long)addUMLProfileApplication.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addReferencesInUMLAnnotation));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addAppliedProfileInProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addUMLAnnotation));
        Assert.assertNotNull((Object)addUMLStereotypeApplication);
        Assert.assertEquals((long)2L, (long)addUMLStereotypeApplication.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLStereotypeApplication.getRefinedBy().contains((Object)addStereotypeApplication));
        Assert.assertTrue((boolean)addUMLStereotypeApplication.getRefinedBy().contains((Object)addRefBaseClass));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addProfileApplication.getRequires().size());
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addProfileApplication));
            Assert.assertEquals((long)1L, (long)addReferencesInUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addReferencesInUMLAnnotation.getRequires().contains((Object)addUMLAnnotation));
            Assert.assertEquals((long)0L, (long)addUMLProfileApplication.getRequires().size());
            Assert.assertEquals((long)1L, (long)addUMLStereotypeApplication.getRequires().size());
            Assert.assertTrue((boolean)addUMLStereotypeApplication.getRequires().contains((Object)addUMLProfileApplication));
        } else {
            Assert.assertEquals((long)2L, (long)addProfileApplication.getRequires().size());
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addAppliedProfileInProfileApplication));
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addUMLAnnotation));
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addReferencesInUMLAnnotation));
            Assert.assertEquals((long)0L, (long)addReferencesInUMLAnnotation.getRequires().size());
            Assert.assertEquals((long)1L, (long)addUMLProfileApplication.getRequires().size());
            Assert.assertTrue((boolean)addUMLProfileApplication.getRequires().contains((Object)addUMLStereotypeApplication));
            Assert.assertEquals((long)0L, (long)addUMLStereotypeApplication.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        this.testIntersections(comparison);
    }

    private void testAB2(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate addAttributeDescription = null;
        addAttributeDescription = kind.equals((Object)AbstractUMLTest.TestKind.DELETE) ? Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onFeature((String)"manyValuedAttribute")}) : Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onFeature((String)"manyValuedAttribute")});
        Diff addAttribute = (Diff)Iterators.find(differences.iterator(), (Predicate)addAttributeDescription);
        Assert.assertNotNull((Object)addAttribute);
        this.testIntersections(comparison);
    }

    private void testAB3(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)10L, (long)differences.size());
        Predicate addProfileApplicationDescription = null;
        Predicate addAppliedProfileInProfileApplicationDescription = null;
        Predicate addUMLAnnotationDescription = null;
        Predicate addReferencesInUMLAnnotationDescription = null;
        Predicate addStereotypeApplicationDescription = null;
        Predicate addModelDescription = null;
        Predicate addClassDescription = null;
        Predicate addRefBaseClassDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticStereotypeTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
            addModelDescription = EMFComparePredicates.removed((String)"model.MyNiceModel");
            addClassDescription = EMFComparePredicates.removed((String)"model.MyNiceModel.Class1");
        } else {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticStereotypeTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticStereotypeTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
            addModelDescription = EMFComparePredicates.added((String)"model.MyNiceModel");
            addClassDescription = EMFComparePredicates.added((String)"model.MyNiceModel.Class1");
        }
        addAppliedProfileInProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"appliedProfile")});
        addStereotypeApplicationDescription = Predicates.instanceOf(ResourceAttachmentChange.class);
        addRefBaseClassDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"base_Class")});
        Diff addProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addProfileApplicationDescription);
        Diff addAppliedProfileInProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addAppliedProfileInProfileApplicationDescription);
        Diff addUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addUMLAnnotationDescription);
        Diff addReferencesInUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addReferencesInUMLAnnotationDescription);
        Diff addStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addStereotypeApplicationDescription);
        Diff addModel = (Diff)Iterators.find(differences.iterator(), (Predicate)addModelDescription);
        Diff addClass = (Diff)Iterators.find(differences.iterator(), (Predicate)addClassDescription);
        Diff addRefBaseClass = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefBaseClassDescription);
        Assert.assertNotNull((Object)addProfileApplication);
        Assert.assertNotNull((Object)addAppliedProfileInProfileApplication);
        Assert.assertNotNull((Object)addUMLAnnotation);
        Assert.assertNotNull((Object)addReferencesInUMLAnnotation);
        Assert.assertNotNull((Object)addStereotypeApplication);
        Assert.assertNotNull((Object)addModel);
        Assert.assertNotNull((Object)addClass);
        Assert.assertNotNull((Object)addRefBaseClass);
        Assert.assertEquals((long)1L, (long)StaticStereotypeTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(ProfileApplicationChange.class)));
        Assert.assertEquals((long)1L, (long)StaticStereotypeTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(StereotypeApplicationChange.class)));
        Diff addUMLProfileApplication = null;
        Diff addUMLStereotypeApplication = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            addUMLProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
            addUMLStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        } else {
            addUMLProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
            addUMLStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        }
        Assert.assertNotNull((Object)addUMLProfileApplication);
        Assert.assertEquals((long)4L, (long)addUMLProfileApplication.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addReferencesInUMLAnnotation));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addAppliedProfileInProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addUMLAnnotation));
        Assert.assertNotNull((Object)addUMLStereotypeApplication);
        Assert.assertEquals((long)2L, (long)addUMLStereotypeApplication.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLStereotypeApplication.getRefinedBy().contains((Object)addStereotypeApplication));
        Assert.assertTrue((boolean)addUMLStereotypeApplication.getRefinedBy().contains((Object)addRefBaseClass));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addProfileApplication.getRequires().size());
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addModel));
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addProfileApplication));
            Assert.assertEquals((long)1L, (long)addReferencesInUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addReferencesInUMLAnnotation.getRequires().contains((Object)addUMLAnnotation));
            Assert.assertEquals((long)1L, (long)addUMLProfileApplication.getRequires().size());
            Assert.assertEquals((long)2L, (long)addUMLStereotypeApplication.getRequires().size());
            Assert.assertTrue((boolean)addUMLStereotypeApplication.getRequires().contains((Object)addUMLProfileApplication));
        } else {
            Assert.assertEquals((long)2L, (long)addProfileApplication.getRequires().size());
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addAppliedProfileInProfileApplication));
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addUMLAnnotation));
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addReferencesInUMLAnnotation));
            Assert.assertEquals((long)0L, (long)addReferencesInUMLAnnotation.getRequires().size());
            Assert.assertEquals((long)1L, (long)addUMLProfileApplication.getRequires().size());
            Assert.assertTrue((boolean)addUMLProfileApplication.getRequires().contains((Object)addUMLStereotypeApplication));
            Assert.assertEquals((long)0L, (long)addUMLStereotypeApplication.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        this.testIntersections(comparison);
    }

    private void testAB4(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate addStereotypeApplicationDescription = null;
        Predicate addClassDescription = null;
        Diff addUMLStereotypeApplication = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addClassDescription = EMFComparePredicates.removed((String)"model.Class0");
            addUMLStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        } else {
            addClassDescription = EMFComparePredicates.added((String)"model.Class0");
            addUMLStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        }
        addStereotypeApplicationDescription = Predicates.instanceOf(ResourceAttachmentChange.class);
        Diff addClass = (Diff)Iterators.find(differences.iterator(), (Predicate)addClassDescription);
        Diff addStereotypeApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addStereotypeApplicationDescription);
        Assert.assertNotNull((Object)addClass);
        Assert.assertNotNull((Object)addStereotypeApplication);
        Assert.assertNotNull((Object)addUMLStereotypeApplication);
        this.testIntersections(comparison);
    }

    private void testAB5(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate changeAttributeDescription1 = null;
        Predicate changeAttributeDescription2 = null;
        changeAttributeDescription1 = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"xmlName"), EMFComparePredicates.valueIs((Object)"clazz")});
        changeAttributeDescription2 = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"className"), EMFComparePredicates.valueIs((Object)"theEClassName")});
        Diff changeAttribute1 = (Diff)Iterators.find(differences.iterator(), (Predicate)changeAttributeDescription1);
        Diff changeAttribute2 = (Diff)Iterators.find(differences.iterator(), (Predicate)changeAttributeDescription2);
        UnmodifiableIterator changeUMLStereotypeProperties = Iterators.filter(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeAttributeChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)));
        Assert.assertTrue((boolean)changeUMLStereotypeProperties.hasNext());
        Diff changeUMLStereotypeProperty1 = (Diff)changeUMLStereotypeProperties.next();
        Assert.assertTrue((boolean)changeUMLStereotypeProperties.hasNext());
        Diff changeUMLStereotypeProperty2 = (Diff)changeUMLStereotypeProperties.next();
        Assert.assertNotNull((Object)changeAttribute1);
        Assert.assertNotNull((Object)changeAttribute2);
        Assert.assertNotNull((Object)changeUMLStereotypeProperty1);
        Assert.assertNotNull((Object)changeUMLStereotypeProperty2);
        Assert.assertEquals((long)1L, (long)changeUMLStereotypeProperty1.getRefinedBy().size());
        Assert.assertTrue((boolean)changeUMLStereotypeProperty1.getRefinedBy().contains((Object)changeAttribute1));
        Assert.assertEquals((long)1L, (long)changeUMLStereotypeProperty2.getRefinedBy().size());
        Assert.assertTrue((boolean)changeUMLStereotypeProperty2.getRefinedBy().contains((Object)changeAttribute2));
        this.testIntersections(comparison);
    }

    private void testAB6(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate addStereotypeRefDescription = null;
        Predicate changeUMLStereotypeDescription = null;
        addStereotypeRefDescription = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onFeature((String)"manyValuedReference")}) : Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onFeature((String)"manyValuedReference")});
        changeUMLStereotypeDescription = Predicates.and((Predicate)Predicates.instanceOf(StereotypeReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
        Diff addStereotypeRef = (Diff)Iterators.find(differences.iterator(), (Predicate)addStereotypeRefDescription);
        Diff changeUMLStereotype = (Diff)Iterators.find(differences.iterator(), (Predicate)changeUMLStereotypeDescription);
        Assert.assertNotNull((Object)addStereotypeRef);
        Assert.assertNotNull((Object)changeUMLStereotype);
        Assert.assertEquals((long)1L, (long)changeUMLStereotype.getRefinedBy().size());
        Assert.assertTrue((boolean)changeUMLStereotype.getRefinedBy().contains((Object)addStereotypeRef));
        this.testIntersections(comparison);
    }

    private void testAB7(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate moveStereotypeRefDescription = null;
        Predicate changeUMLStereotypeDescription = null;
        moveStereotypeRefDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), EMFComparePredicates.onFeature((String)"manyValuedReference")});
        changeUMLStereotypeDescription = Predicates.and((Predicate)Predicates.instanceOf(StereotypeReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
        Diff moveStereotypeRef = (Diff)Iterators.find(differences.iterator(), (Predicate)moveStereotypeRefDescription);
        Diff changeUMLStereotype = (Diff)Iterators.find(differences.iterator(), (Predicate)changeUMLStereotypeDescription);
        Assert.assertNotNull((Object)moveStereotypeRef);
        Assert.assertNotNull((Object)changeUMLStereotype);
        Assert.assertEquals((long)1L, (long)changeUMLStereotype.getRefinedBy().size());
        Assert.assertTrue((boolean)changeUMLStereotype.getRefinedBy().contains((Object)moveStereotypeRef));
        this.testIntersections(comparison);
    }

    private void testAB8(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate changeStereotypeRefDescription = null;
        Predicate changeUMLStereotypeDescription = null;
        changeStereotypeRefDescription = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"singleValuedReference"), EMFComparePredicates.valueNameMatches((String)"class0")}) : Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"singleValuedReference"), EMFComparePredicates.valueNameMatches((String)"class1")});
        changeUMLStereotypeDescription = Predicates.and((Predicate)Predicates.instanceOf(StereotypeReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
        Diff changeStereotypeRef = (Diff)Iterators.find(differences.iterator(), (Predicate)changeStereotypeRefDescription);
        Diff changeUMLStereotype = (Diff)Iterators.find(differences.iterator(), (Predicate)changeUMLStereotypeDescription);
        Assert.assertNotNull((Object)changeStereotypeRef);
        Assert.assertNotNull((Object)changeUMLStereotype);
        Assert.assertEquals((long)1L, (long)changeUMLStereotype.getRefinedBy().size());
        Assert.assertTrue((boolean)changeUMLStereotype.getRefinedBy().contains((Object)changeStereotypeRef));
        this.testIntersections(comparison);
    }

    private void testAB9(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate changeStereotypeRefDescription = null;
        Predicate changeUMLStereotypeDescription = null;
        changeStereotypeRefDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"singleValuedReference"), EMFComparePredicates.valueNameMatches((String)"class0")});
        changeUMLStereotypeDescription = Predicates.and((Predicate)Predicates.instanceOf(StereotypeReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
        Diff changeStereotypeRef = (Diff)Iterators.find(differences.iterator(), (Predicate)changeStereotypeRefDescription);
        Diff changeUMLStereotype = (Diff)Iterators.find(differences.iterator(), (Predicate)changeUMLStereotypeDescription);
        Assert.assertNotNull((Object)changeStereotypeRef);
        Assert.assertNotNull((Object)changeUMLStereotype);
        Assert.assertEquals((long)1L, (long)changeUMLStereotype.getRefinedBy().size());
        Assert.assertTrue((boolean)changeUMLStereotype.getRefinedBy().contains((Object)changeStereotypeRef));
        this.testIntersections(comparison);
    }

    private void testAB10(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate changeStereotypeRefDescription = null;
        Predicate changeUMLStereotypeDescription = null;
        changeStereotypeRefDescription = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"singleValuedAttribute"), EMFComparePredicates.valueIs((Object)"myValue")}) : Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"singleValuedAttribute"), EMFComparePredicates.valueIs((Object)"oldValue")});
        changeUMLStereotypeDescription = Predicates.and((Predicate)Predicates.instanceOf(StereotypeAttributeChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
        Diff changeStereotypeRef = (Diff)Iterators.find(differences.iterator(), (Predicate)changeStereotypeRefDescription);
        Diff changeUMLStereotype = (Diff)Iterators.find(differences.iterator(), (Predicate)changeUMLStereotypeDescription);
        Assert.assertNotNull((Object)changeStereotypeRef);
        Assert.assertNotNull((Object)changeUMLStereotype);
        Assert.assertEquals((long)1L, (long)changeUMLStereotype.getRefinedBy().size());
        Assert.assertTrue((boolean)changeUMLStereotype.getRefinedBy().contains((Object)changeStereotypeRef));
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

