/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.dependency;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.dependency.data.DependencyInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChangeUsageTest
extends AbstractUMLTest {
    private DependencyInputData input = new DependencyInputData();

    @BeforeClass
    public static void setupClass() {
        ChangeUsageTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        ChangeUsageTest.resetRegistries();
    }

    @Test
    public void testA40UseCase() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA41UseCase() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA40UseCase3way() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA41UseCase3way() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Predicate addSupplierInDependencyDescription = null;
        addSupplierInDependencyDescription = kind.equals((Object)AbstractUMLTest.TestKind.DELETE) ? EMFComparePredicates.removedFromReference((String)"model.Usage0", (String)"supplier", (String)"model.Class1") : EMFComparePredicates.addedToReference((String)"model.Usage0", (String)"supplier", (String)"model.Class1");
        Diff addSupplierInDependency = (Diff)Iterators.find(differences.iterator(), (Predicate)addSupplierInDependencyDescription);
        Assert.assertNotNull((Object)addSupplierInDependency);
        Assert.assertEquals((long)0L, (long)ChangeUsageTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(DirectedRelationshipChange.class)));
        Diff changeUMLDependency = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)), null);
        Assert.assertNull((Object)changeUMLDependency);
        Assert.assertEquals((long)0L, (long)addSupplierInDependency.getRequires().size());
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

