/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TestBug459131
extends CompareTestCase {
    private IModelResolver resolver;
    private NullProgressMonitor monitor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor(null);
        this.monitor = new NullProgressMonitor();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testUpdateResource() throws Exception {
        IProject iProject = this.project.getProject();
        File leftFile1 = this.project.getOrCreateFile(iProject, "left" + File.separator + "R1.nodes");
        File leftFile2 = this.project.getOrCreateFile(iProject, "left" + File.separator + "R2.nodes");
        File leftFile3 = this.project.getOrCreateFile(iProject, "left" + File.separator + "R3.nodes");
        File rightFile1 = this.project.getOrCreateFile(iProject, "right" + File.separator + "R1.nodes");
        File rightFile2 = this.project.getOrCreateFile(iProject, "right" + File.separator + "R2.nodes");
        File rightFile3 = this.project.getOrCreateFile(iProject, "right" + File.separator + "R3.nodes");
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.ui.tests");
        URL entryLeftFile1 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/left/R1.nodes");
        URL entryLeftFile2 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/left/R2.nodes");
        URL entryLeftFile3 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/left/R3.nodes");
        URL entryRightFile1 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/right/R1.nodes");
        URL entryRightFile2 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/right/R2.nodes");
        URL entryRightFile3 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/right/R3.nodes");
        URL leftFile1URL = FileLocator.toFileURL((URL)entryLeftFile1);
        URL leftFile2URL = FileLocator.toFileURL((URL)entryLeftFile2);
        URL leftFile3URL = FileLocator.toFileURL((URL)entryLeftFile3);
        URL rightFile1URL = FileLocator.toFileURL((URL)entryRightFile1);
        URL rightFile2URL = FileLocator.toFileURL((URL)entryRightFile2);
        URL rightFile3URL = FileLocator.toFileURL((URL)entryRightFile3);
        TestBug459131.copyFile(new File(leftFile1URL.toURI()), leftFile1);
        TestBug459131.copyFile(new File(leftFile2URL.toURI()), leftFile2);
        TestBug459131.copyFile(new File(leftFile3URL.toURI()), leftFile3);
        TestBug459131.copyFile(new File(rightFile1URL.toURI()), rightFile1);
        TestBug459131.copyFile(new File(rightFile2URL.toURI()), rightFile2);
        TestBug459131.copyFile(new File(rightFile3URL.toURI()), rightFile3);
        IFile iLeftFile1 = this.project.getIFile(iProject, leftFile1);
        IFile iLeftFile2 = this.project.getIFile(iProject, leftFile2);
        IFile iLeftFile3 = this.project.getIFile(iProject, leftFile3);
        IFile iRightFile1 = this.project.getIFile(iProject, rightFile1);
        IFile iRightFile2 = this.project.getIFile(iProject, rightFile2);
        IFile iRightFile3 = this.project.getIFile(iProject, rightFile3);
        SynchronizationModel syncModel = this.resolver.resolveLocalModels((IResource)iLeftFile1, (IResource)iRightFile1, null, (IProgressMonitor)this.monitor);
        TestBug459131.assertContainsExclusively(syncModel.getLeftTraversal(), iLeftFile1, iLeftFile2, iLeftFile3);
        TestBug459131.assertContainsExclusively(syncModel.getRightTraversal(), iRightFile1, iRightFile2, iRightFile3);
        iRightFile3.setContents(iLeftFile3.getContents(), 1, (IProgressMonitor)this.monitor);
        syncModel = this.resolver.resolveLocalModels((IResource)iLeftFile1, (IResource)iRightFile1, null, (IProgressMonitor)this.monitor);
        TestBug459131.assertContainsExclusively(syncModel.getLeftTraversal(), iLeftFile1, iLeftFile2, iLeftFile3);
        TestBug459131.assertContainsExclusively(syncModel.getRightTraversal(), iRightFile1, iRightFile2, iRightFile3);
    }

    @Test
    public void testBrakeResourceDependency() throws Exception {
        IProject iProject = this.project.getProject();
        File leftFile4 = this.project.getOrCreateFile(iProject, "left" + File.separator + "R4.nodes");
        File leftFile5 = this.project.getOrCreateFile(iProject, "left" + File.separator + "R5.nodes");
        File leftFile6 = this.project.getOrCreateFile(iProject, "left" + File.separator + "R6.nodes");
        File rightFile4 = this.project.getOrCreateFile(iProject, "right" + File.separator + "R4.nodes");
        File rightFile5 = this.project.getOrCreateFile(iProject, "right" + File.separator + "R5.nodes");
        File newRightFile5 = this.project.getOrCreateFile(iProject, "right" + File.separator + "R5NEW.nodes");
        File rightFile6 = this.project.getOrCreateFile(iProject, "right" + File.separator + "R6.nodes");
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.ui.tests");
        URL entryLeftFile4 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/left/R4.nodes");
        URL entryLeftFile5 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/left/R5.nodes");
        URL entryLeftFile6 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/left/R6.nodes");
        URL entryRightFile4 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/right/R4.nodes");
        URL entryRightFile5 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/right/R5.nodes");
        URL newEntryRightFile5 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/right/R5NEW.nodes");
        URL entryRightFile6 = bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/_459131/right/R6.nodes");
        URL leftFile4URL = FileLocator.toFileURL((URL)entryLeftFile4);
        URL leftFile5URL = FileLocator.toFileURL((URL)entryLeftFile5);
        URL leftFile6URL = FileLocator.toFileURL((URL)entryLeftFile6);
        URL rightFile4URL = FileLocator.toFileURL((URL)entryRightFile4);
        URL rightFile5URL = FileLocator.toFileURL((URL)entryRightFile5);
        URL newRightFile5URL = FileLocator.toFileURL((URL)newEntryRightFile5);
        URL rightFile6URL = FileLocator.toFileURL((URL)entryRightFile6);
        TestBug459131.copyFile(new File(leftFile4URL.toURI()), leftFile4);
        TestBug459131.copyFile(new File(leftFile5URL.toURI()), leftFile5);
        TestBug459131.copyFile(new File(leftFile6URL.toURI()), leftFile6);
        TestBug459131.copyFile(new File(rightFile4URL.toURI()), rightFile4);
        TestBug459131.copyFile(new File(rightFile5URL.toURI()), rightFile5);
        TestBug459131.copyFile(new File(newRightFile5URL.toURI()), newRightFile5);
        TestBug459131.copyFile(new File(rightFile6URL.toURI()), rightFile6);
        IFile iLeftFile4 = this.project.getIFile(iProject, leftFile4);
        IFile iLeftFile5 = this.project.getIFile(iProject, leftFile5);
        IFile iLeftFile6 = this.project.getIFile(iProject, leftFile6);
        IFile iRightFile4 = this.project.getIFile(iProject, rightFile4);
        IFile iRightFile5 = this.project.getIFile(iProject, rightFile5);
        IFile newIRightFile5 = this.project.getIFile(iProject, newRightFile5);
        IFile iRightFile6 = this.project.getIFile(iProject, rightFile6);
        SynchronizationModel syncModel = this.resolver.resolveLocalModels((IResource)iLeftFile4, (IResource)iRightFile4, null, (IProgressMonitor)this.monitor);
        TestBug459131.assertContainsExclusively(syncModel.getLeftTraversal(), iLeftFile4, iLeftFile5, iLeftFile6);
        TestBug459131.assertContainsExclusively(syncModel.getRightTraversal(), iRightFile4, iRightFile5, iRightFile6);
        iRightFile5.setContents(newIRightFile5.getContents(), 1, (IProgressMonitor)this.monitor);
        syncModel = this.resolver.resolveLocalModels((IResource)iLeftFile4, (IResource)iRightFile4, null, (IProgressMonitor)this.monitor);
        TestBug459131.assertContainsExclusively(syncModel.getLeftTraversal(), iLeftFile4, iLeftFile5, iLeftFile6);
        TestBug459131.assertContainsExclusively(syncModel.getRightTraversal(), iRightFile4, iRightFile5);
    }
}

