/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DefaultResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyGraphUpdater;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelResourceListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class ThreadedModelResolverWithCustomDependencyProviderTest
extends CompareTestCase {
    private static final String TEST_BUNDLE = "org.eclipse.emf.compare.ide.ui.tests";
    private static final String TEST_DATA_PATH = "src/org/eclipse/emf/compare/ide/ui/tests/logical/resolver/data/case1/";
    private static final String MODEL_FILE1 = "file1.ecore";
    private static final String MODEL_FILE2 = "file2.ecore";
    private static final String MODEL_FILE3 = "file3.ecore";
    private IProgressMonitor monitor = new NullProgressMonitor();

    @Test
    public void testResolveLocalModelFromFile1WithoutDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet modelSet = this.createProjectWithModelSet();
        ThreadedModelResolver resolver = this.createModelResolver();
        StorageTraversal traversal = resolver.resolveLocalModel((IResource)modelSet.file1, this.monitor);
        Assert.assertEquals((long)1L, (long)traversal.getStorages().size());
        this.assertContainsFile(traversal, modelSet.file1);
    }

    @Test
    public void testResolveLocalModelFromFile2WithoutDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet modelSet = this.createProjectWithModelSet();
        ThreadedModelResolver resolver = this.createModelResolver();
        StorageTraversal traversal = resolver.resolveLocalModel((IResource)modelSet.file2, this.monitor);
        Assert.assertEquals((long)2L, (long)traversal.getStorages().size());
        this.assertContainsFile(traversal, modelSet.file2);
        this.assertContainsFile(traversal, modelSet.file3);
    }

    @Test
    public void testResolveLocalModelFromFile1WithDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet modelSet = this.createProjectWithModelSet();
        ThreadedModelResolver resolver = this.createModelResolverWithCustomImplicitDependencies();
        StorageTraversal traversal = resolver.resolveLocalModel((IResource)modelSet.file1, this.monitor);
        this.assertContainsAllFiles(traversal, modelSet);
    }

    @Test
    public void testResolveLocalModelFromFile2WithDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet modelSet = this.createProjectWithModelSet();
        ThreadedModelResolver resolver = this.createModelResolverWithCustomImplicitDependencies();
        StorageTraversal traversal = resolver.resolveLocalModel((IResource)modelSet.file2, this.monitor);
        this.assertContainsAllFiles(traversal, modelSet);
    }

    @Test
    public void testResolveLocalModelsTwoWayFromFile1WithoutDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet leftModelSet = this.createProjectWithModelSet("Left");
        ModelSet rightModelSet = this.createProjectWithModelSet("Right");
        ThreadedModelResolver resolver = this.createModelResolver();
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)leftModelSet.file1, (IResource)rightModelSet.file1, null, this.monitor);
        Assert.assertEquals((long)1L, (long)synchronizationModel.getLeftTraversal().getStorages().size());
        this.assertContainsFile(synchronizationModel.getLeftTraversal(), leftModelSet.file1);
        Assert.assertEquals((long)1L, (long)synchronizationModel.getRightTraversal().getStorages().size());
        this.assertContainsFile(synchronizationModel.getRightTraversal(), rightModelSet.file1);
        Assert.assertTrue((boolean)synchronizationModel.getOriginTraversal().getStorages().isEmpty());
    }

    @Test
    public void testResolveLocalModelsThreeWayFromFile1WithoutDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet leftModelSet = this.createProjectWithModelSet("Left");
        ModelSet rightModelSet = this.createProjectWithModelSet("Right");
        ModelSet originModelSet = this.createProjectWithModelSet("Origin");
        ThreadedModelResolver resolver = this.createModelResolver();
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)leftModelSet.file1, (IResource)rightModelSet.file1, (IResource)originModelSet.file1, this.monitor);
        Assert.assertEquals((long)1L, (long)synchronizationModel.getLeftTraversal().getStorages().size());
        this.assertContainsFile(synchronizationModel.getLeftTraversal(), leftModelSet.file1);
        Assert.assertEquals((long)1L, (long)synchronizationModel.getRightTraversal().getStorages().size());
        this.assertContainsFile(synchronizationModel.getRightTraversal(), rightModelSet.file1);
        Assert.assertEquals((long)1L, (long)synchronizationModel.getOriginTraversal().getStorages().size());
        this.assertContainsFile(synchronizationModel.getOriginTraversal(), originModelSet.file1);
    }

    @Test
    public void testResolveLocalModelsTwoWayFromFile1WithDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet leftModelSet = this.createProjectWithModelSet("Left");
        ModelSet rightModelSet = this.createProjectWithModelSet("Right");
        ThreadedModelResolver resolver = this.createModelResolverWithCustomImplicitDependencies();
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)leftModelSet.file1, (IResource)rightModelSet.file1, null, this.monitor);
        this.assertContainsAllFiles(synchronizationModel.getLeftTraversal(), leftModelSet);
        this.assertContainsAllFiles(synchronizationModel.getRightTraversal(), rightModelSet);
        Assert.assertTrue((boolean)synchronizationModel.getOriginTraversal().getStorages().isEmpty());
    }

    @Test
    public void testResolveLocalModelsThreeWayFromFile1WithDependencyProvider() throws IOException, CoreException, URISyntaxException, InterruptedException {
        ModelSet leftModelSet = this.createProjectWithModelSet("Left");
        ModelSet rightModelSet = this.createProjectWithModelSet("Right");
        ModelSet originModelSet = this.createProjectWithModelSet("Origin");
        ThreadedModelResolver resolver = this.createModelResolverWithCustomImplicitDependencies();
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)leftModelSet.file1, (IResource)rightModelSet.file1, (IResource)originModelSet.file1, this.monitor);
        this.assertContainsAllFiles(synchronizationModel.getLeftTraversal(), leftModelSet);
        this.assertContainsAllFiles(synchronizationModel.getRightTraversal(), rightModelSet);
        this.assertContainsAllFiles(synchronizationModel.getOriginTraversal(), originModelSet);
    }

    private void assertContainsAllFiles(StorageTraversal traversal, ModelSet modelSet) {
        Assert.assertEquals((long)3L, (long)traversal.getStorages().size());
        this.assertContainsFile(traversal, modelSet.file1);
        this.assertContainsFile(traversal, modelSet.file3);
        this.assertContainsFile(traversal, modelSet.file2);
    }

    private void assertContainsFile(StorageTraversal traversal, IFile iFile) {
        Assert.assertTrue((boolean)Iterables.any((Iterable)traversal.getStorages(), ThreadedModelResolverWithCustomDependencyProviderTest.containsFile(iFile)));
    }

    private static Predicate<IStorage> containsFile(final IFile iFile) {
        return new Predicate<IStorage>(){

            public boolean apply(IStorage input) {
                return iFile.getFullPath().equals((Object)input.getFullPath());
            }
        };
    }

    private ThreadedModelResolver createModelResolver() {
        ThreadedModelResolver resolver = new ThreadedModelResolver();
        resolver.setGraph((IGraph)new Graph());
        resolver.initialize();
        return resolver;
    }

    private ThreadedModelResolver createModelResolverWithCustomImplicitDependencies() {
        ThreadedModelResolver resolver = new ThreadedModelResolver(){

            protected DefaultResolutionContext createContext(EventBus eventBus, IGraph<URI> graph) {
                return new DefaultResolutionContext(eventBus, graph, new DependencyGraphUpdater(graph, eventBus), new ResourceComputationScheduler(), new ModelResourceListener()){

                    public synchronized IImplicitDependencies getImplicitDependencies() {
                        return new IImplicitDependencies(){

                            public Set<URI> of(URI uri, URIConverter uriConverter) {
                                String uriString = uri.toPlatformString(false);
                                String baseUriString = uriString.substring(0, uriString.lastIndexOf("/"));
                                String file1UriString = String.valueOf(baseUriString) + "/" + ThreadedModelResolverWithCustomDependencyProviderTest.MODEL_FILE1;
                                String file2UriString = String.valueOf(baseUriString) + "/" + ThreadedModelResolverWithCustomDependencyProviderTest.MODEL_FILE2;
                                URI file1Uri = URI.createPlatformResourceURI((String)file1UriString, (boolean)false);
                                URI file2Uri = URI.createPlatformResourceURI((String)file2UriString, (boolean)false);
                                LinkedHashSet dependencies = Sets.newLinkedHashSet();
                                dependencies.add(uri);
                                dependencies.add(file1Uri);
                                dependencies.add(file2Uri);
                                return dependencies;
                            }
                        };
                    }
                };
            }
        };
        resolver.setGraph((IGraph)new Graph());
        resolver.initialize();
        return resolver;
    }

    private ModelSet createProjectWithModelSet() throws CoreException, IOException, URISyntaxException {
        return this.createProjectWithModelSet("Project");
    }

    private ModelSet createProjectWithModelSet(String name) throws CoreException, IOException, URISyntaxException {
        IProject iProject = new TestProject(name).getProject();
        File file1 = this.project.getOrCreateFile(iProject, MODEL_FILE1);
        File file2 = this.project.getOrCreateFile(iProject, MODEL_FILE2);
        File file3 = this.project.getOrCreateFile(iProject, MODEL_FILE3);
        Bundle bundle = Platform.getBundle((String)TEST_BUNDLE);
        URI file1Uri = this.getFileUri(bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/logical/resolver/data/case1/file1.ecore"));
        URI file2Uri = this.getFileUri(bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/logical/resolver/data/case1/file2.ecore"));
        URI file3Uri = this.getFileUri(bundle.getEntry("src/org/eclipse/emf/compare/ide/ui/tests/logical/resolver/data/case1/file3.ecore"));
        ThreadedModelResolverWithCustomDependencyProviderTest.copyFile(this.toFile(file1Uri), file1);
        ThreadedModelResolverWithCustomDependencyProviderTest.copyFile(this.toFile(file2Uri), file2);
        ThreadedModelResolverWithCustomDependencyProviderTest.copyFile(this.toFile(file3Uri), file3);
        IFile iFile1 = this.project.getIFile(iProject, file1);
        IFile iFile2 = this.project.getIFile(iProject, file2);
        IFile iFile3 = this.project.getIFile(iProject, file3);
        return new ModelSet(iFile1, iFile2, iFile3);
    }

    private URI getFileUri(URL bundleUrl) throws IOException {
        URL fileLocation = FileLocator.toFileURL((URL)bundleUrl);
        return URI.createFileURI((String)fileLocation.getPath());
    }

    private File toFile(URI fileUri) throws URISyntaxException {
        return new File(fileUri.toFileString());
    }

    private class ModelSet {
        protected IFile file1;
        protected IFile file2;
        protected IFile file3;

        public ModelSet(IFile file1, IFile file2, IFile file3) {
            this.file1 = file1;
            this.file2 = file2;
            this.file3 = file3;
        }
    }
}

