/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.compare.ide.ui.internal.logical.SimilarityComputer;
import org.junit.Assert;
import org.junit.Test;

public class SimilarityComputerTest {
    private static final String LIPSUM1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In imperdiet risus eu hendrerit facilisis. Nullam at blandit elit.";
    private static final String LIPSUM2 = "Aenean fermentum turpis sit amet auctor pretium. Maecenas dignissim nisi mi, eu fermentum eros lobortis et. Quisque rutrum neque nec.";
    public static final String PREFIX;
    public static final String PREFIX2;

    static {
        StringBuilder prefixBuilder = new StringBuilder();
        while (prefixBuilder.length() < 1024) {
            prefixBuilder.append(LIPSUM1);
            prefixBuilder.append('\n');
        }
        PREFIX = prefixBuilder.toString();
        prefixBuilder = new StringBuilder();
        while (prefixBuilder.length() < 1024) {
            prefixBuilder.append(LIPSUM2);
            prefixBuilder.append('\n');
        }
        PREFIX2 = prefixBuilder.toString();
    }

    @Test
    public void testIdentical() throws IOException {
        String a = PREFIX;
        String b = PREFIX;
        Assert.assertTrue((boolean)SimilarityComputer.isSimilar((InputStream)this.stream(a), (InputStream)this.stream(b)));
    }

    @Test
    public void testMinorAddition() throws IOException {
        String a = PREFIX;
        String b = String.valueOf(PREFIX) + "another line\n";
        Assert.assertTrue((boolean)SimilarityComputer.isSimilar((InputStream)this.stream(a), (InputStream)this.stream(b)));
    }

    @Test
    public void testMinorDeletion() throws IOException {
        String a = String.valueOf(PREFIX) + "old line\n";
        String b = PREFIX;
        Assert.assertTrue((boolean)SimilarityComputer.isSimilar((InputStream)this.stream(a), (InputStream)this.stream(b)));
    }

    @Test
    public void testMinorChange() throws IOException {
        String a = String.valueOf(PREFIX) + "old line\n";
        String b = String.valueOf(PREFIX) + "new line\n";
        Assert.assertTrue((boolean)SimilarityComputer.isSimilar((InputStream)this.stream(a), (InputStream)this.stream(b)));
    }

    @Test
    public void testMajorChange() throws IOException {
        String a = String.valueOf(PREFIX) + "old line\n";
        StringBuilder bBuilder = new StringBuilder();
        while (bBuilder.length() < a.length()) {
            bBuilder.append(LIPSUM2);
            bBuilder.append('\n');
        }
        String b = bBuilder.toString();
        Assert.assertFalse((boolean)SimilarityComputer.isSimilar((InputStream)this.stream(a), (InputStream)this.stream(b)));
    }

    @Test
    public void testTooShort() throws IOException {
        String a;
        String b = a = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In imperdiet risus eu hendrerit facilisis. Nullam at blandit elit.\nAenean fermentum turpis sit amet auctor pretium. Maecenas dignissim nisi mi, eu fermentum eros lobortis et. Quisque rutrum neque nec.";
        Assert.assertFalse((boolean)SimilarityComputer.isSimilar((InputStream)this.stream(a), (InputStream)this.stream(b)));
    }

    private InputStream stream(String string) throws IOException {
        return new ByteArrayInputStream(string.getBytes("UTF-8"));
    }
}

