/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class DynamicObject {
    private final LoadingCache<String, Field> fFieldCache;
    private final LoadingCache<MethodKey, Method> fMethodCache;
    private final Object fTarget;
    private final Class<?> fTargetClass;

    public DynamicObject(Object target) {
        this.fTarget = target;
        this.fTargetClass = target.getClass();
        this.fFieldCache = CacheBuilder.newBuilder().maximumSize(16L).build((CacheLoader)new CacheLoader<String, Field>(){

            public Field load(String key) throws Exception {
                return DynamicObject.getField(DynamicObject.this.fTargetClass, key);
            }
        });
        this.fMethodCache = CacheBuilder.newBuilder().maximumSize(16L).build((CacheLoader)new CacheLoader<MethodKey, Method>(){

            public Method load(MethodKey key) throws Exception {
                return DynamicObject.getMethod(DynamicObject.this.fTargetClass, key.methodName, key.parameterTypes);
            }
        });
    }

    public Object get(String fieldName) {
        Object ret = null;
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            ret = field.get(this.fTarget);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ret;
    }

    public void set(String fieldName, Object value) {
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            field.set(this.fTarget, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public double getDouble(String fieldName) {
        double ret = Double.NaN;
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            ret = field.getDouble(this.fTarget);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ret;
    }

    public void setDouble(String fieldName, double value) {
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            field.setDouble(this.fTarget, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int getInt(String fieldName) {
        int ret = 0;
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            ret = field.getInt(this.fTarget);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ret;
    }

    public void setInt(String fieldName, int value) {
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            field.setInt(this.fTarget, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Object invoke(String methodName, Class<?>[] parameterTypes, Object ... args) {
        Object ret = null;
        try {
            Method method = (Method)this.fMethodCache.get((Object)MethodKey.create(methodName, parameterTypes));
            ret = method.invoke(this.fTarget, args);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ret;
    }

    protected void handleException(Throwable cause) {
        Throwables.propagate((Throwable)cause);
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            DynamicObject.makeAccessible(declaredField);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return DynamicObject.getField(superClass, fieldName);
            }
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Method getMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        block7: {
            method = null;
            try {
                method = clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException nsme) {
                if (!clazz.isInterface() && (superClass = clazz.getSuperclass()) != null) {
                    method = DynamicObject.getMethod(superClass, name, parameterTypes);
                }
                if (method != null) break block7;
                var8_7 = clazz.getInterfaces();
                var7_8 = var8_7.length;
                var6_9 = 0;
                ** while (var6_9 < var7_8)
            }
lbl-1000:
            // 1 sources

            {
                superInterface = var8_7[var6_9];
                method = DynamicObject.getMethod(superInterface, name, parameterTypes);
                if (method == null) {
                    ++var6_9;
                    continue;
                }
lbl18:
                // 3 sources

                break block7;
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        if (method != null && !method.isAccessible()) {
            DynamicObject.makeAccessible(method);
        }
        return method;
    }

    private static void makeAccessible(Member member) {
        boolean instanceOfAccesibleAndNotAccessible;
        boolean bl = instanceOfAccesibleAndNotAccessible = member instanceof AccessibleObject && !((AccessibleObject)((Object)member)).isAccessible();
        if (instanceOfAccesibleAndNotAccessible || !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
            if (member instanceof AccessibleObject) {
                ((AccessibleObject)((Object)member)).setAccessible(true);
            } else {
                throw new RuntimeException("Can not set accessible " + member);
            }
        }
    }

    private static class MethodKey {
        final String methodName;
        final Class<?>[] parameterTypes;

        private MethodKey(String methodName, Class<?>[] parameterTypes) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        static MethodKey create(String methodName, Class<?>[] parameterTypes) {
            return new MethodKey(methodName, parameterTypes);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, other.parameterTypes);
        }
    }
}

