/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeRunnableImpl;
import org.eclipse.emf.compare.internal.merge.MergeDataImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBug434822 {
    private IMerger.Registry mergerRegistry;
    private Diff rightDelete;
    private Diff leftMove;

    @Before
    public void setUp() throws IOException {
        Bug434822InputData inputData = new Bug434822InputData();
        Resource left = inputData.getResource("left.nodes");
        Resource right = inputData.getResource("right.nodes");
        Resource origin = inputData.getResource("origin.nodes");
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        comparison.eAdapters().add((Object)new MergeDataImpl(true, false));
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        for (Diff diff : comparison.getDifferences()) {
            switch (diff.getKind()) {
                case MOVE: {
                    this.leftMove = diff;
                    break;
                }
                case DELETE: {
                    this.rightDelete = diff;
                }
            }
        }
    }

    @Test
    public void testMergeDataAfterAcceptingDeletion() {
        ArrayList uiDiff = Lists.newArrayList((Object[])new Diff[]{this.rightDelete});
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.ACCEPT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge((List)uiDiff, false, this.mergerRegistry);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)this.rightDelete.getState());
        Assert.assertEquals((Object)MergeMode.ACCEPT, (Object)MergeMode.getMergeMode((Diff)this.rightDelete, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.leftMove.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.leftMove, (boolean)true, (boolean)false));
    }

    @Test
    public void testMergeDataAfterAcceptingDeletionSeveral() {
        ArrayList uiDiff = Lists.newArrayList((Object[])new Diff[]{this.rightDelete, this.leftMove});
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.ACCEPT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge((List)uiDiff, false, this.mergerRegistry);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)this.rightDelete.getState());
        Assert.assertEquals((Object)MergeMode.ACCEPT, (Object)MergeMode.getMergeMode((Diff)this.rightDelete, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.leftMove.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.leftMove, (boolean)true, (boolean)false));
    }

    @Test
    public void testMergeDataAfterRejectingDeletion() {
        ArrayList uiDiff = Lists.newArrayList((Object[])new Diff[]{this.rightDelete});
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.REJECT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge((List)uiDiff, false, this.mergerRegistry);
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.rightDelete.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.rightDelete, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)this.leftMove.getState());
    }

    @Test
    public void testMergeDataAfterAcceptingMovement() {
        ArrayList uiDiff = Lists.newArrayList((Object[])new Diff[]{this.leftMove});
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.ACCEPT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge((List)uiDiff, false, this.mergerRegistry);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)this.leftMove.getState());
        Assert.assertEquals((Object)MergeMode.ACCEPT, (Object)MergeMode.getMergeMode((Diff)this.leftMove, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.rightDelete.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.rightDelete, (boolean)true, (boolean)false));
    }

    @Test
    public void testMergeDataAfterRejectingMovement() {
        ArrayList uiDiff = Lists.newArrayList((Object[])new Diff[]{this.leftMove});
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.REJECT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge((List)uiDiff, false, this.mergerRegistry);
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.leftMove.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.leftMove, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)this.rightDelete.getState());
    }

    public class Bug434822InputData
    extends AbstractInputData {
        private static final String PATH_PREFIX = "data/_434822/";

        public Resource getResource(String resourceName) throws IOException {
            StringBuilder resourceURL = new StringBuilder(PATH_PREFIX);
            resourceURL.append(resourceName);
            return this.loadFromClassLoader(resourceURL.toString());
        }
    }
}

